/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Variable;

public class SimpleFunction
implements Function {
    private Expression e;
    private Variable[] v;
    private String name;
    private double[] save;

    public SimpleFunction(Expression expression, Variable variable) {
        this(expression, new Variable[]{variable});
    }

    public SimpleFunction(Expression expression, Variable[] variableArray) {
        this.e = expression;
        this.v = variableArray;
        this.save = new double[variableArray.length];
    }

    public int getArity() {
        return this.v.length;
    }

    public double getVal(double[] dArray) {
        return this.getValueWithCases(dArray, null);
    }

    public double getValueWithCases(double[] dArray, Cases cases) {
        int n = 0;
        while (n < this.v.length) {
            this.save[n] = this.v[n].getVal();
            this.v[n].setVal(dArray[n]);
            ++n;
        }
        double d = this.e.getValueWithCases(cases);
        int n2 = 0;
        while (n2 < this.v.length) {
            this.v[n2].setVal(this.save[n2]);
            ++n2;
        }
        return d;
    }

    public Function derivative(int n) {
        if (n < 1 || n > this.v.length) {
            throw new IllegalArgumentException("Internal Error.  Function does not have an argument number  " + n);
        }
        return new SimpleFunction(this.e.derivative(this.v[n - 1]), this.v);
    }

    public Function derivative(Variable variable) {
        int n = 0;
        while (n < this.v.length) {
            if (variable == this.v[n]) {
                return new SimpleFunction((Expression)new Constant(0.0), this.v);
            }
            ++n;
        }
        return new SimpleFunction(this.e.derivative(variable), this.v);
    }

    public boolean dependsOn(Variable variable) {
        int n = 0;
        while (n < this.v.length) {
            if (variable == this.v[n]) {
                return false;
            }
            ++n;
        }
        return this.e.dependsOn(variable);
    }
}

