/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.ActionSet;
import org.freehep.util.io.ByteCountOutputStream;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;
import org.freehep.util.io.TaggedOutput;
import org.freehep.util.io.UndefinedTagException;

public abstract class TaggedOutputStream
extends ByteCountOutputStream
implements TaggedOutput {
    protected TagSet tagSet;
    protected ActionSet actionSet;

    public TaggedOutputStream(OutputStream outputStream, TagSet tagSet, ActionSet actionSet) {
        this(outputStream, tagSet, actionSet, false);
    }

    public TaggedOutputStream(OutputStream outputStream, TagSet tagSet, ActionSet actionSet, boolean bl2) {
        super(outputStream, bl2);
        this.tagSet = tagSet;
        this.actionSet = actionSet;
    }

    protected abstract void writeTagHeader(TagHeader var1) throws IOException;

    protected int getTagAlignment() {
        return 1;
    }

    public void writeTag(Tag tag) throws IOException {
        int n2;
        int n3 = tag.getTag();
        if (!this.tagSet.exists(n3)) {
            throw new UndefinedTagException(n3);
        }
        this.pushBuffer();
        tag.write(n3, this);
        int n4 = this.getTagAlignment();
        int n5 = (n4 - this.getBufferLength() % n4) % n4;
        for (n2 = 0; n2 < n5; ++n2) {
            this.write(0);
        }
        n2 = this.popBuffer();
        TagHeader tagHeader = new TagHeader(n3, n2);
        this.writeTagHeader(tagHeader);
        this.append();
    }

    protected abstract void writeActionHeader(ActionHeader var1) throws IOException;

    public void writeAction(Action action) throws IOException {
        if (action == null) {
            this.writeByte(0);
            return;
        }
        int n2 = action.getCode();
        if (!this.actionSet.exists(n2)) {
            throw new UndefinedTagException(n2);
        }
        this.pushBuffer();
        action.write(n2, this);
        int n3 = this.popBuffer();
        ActionHeader actionHeader = new ActionHeader(n2, n3);
        this.writeActionHeader(actionHeader);
        this.append();
    }
}

