/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.images;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TempImageHandler {
    private static Image brokenImage;
    private static Cursor brokenCursor;
    private static String[] imageExtensions;
    private static Hashtable imageCache;
    private static Hashtable cursorCache;
    private static Hashtable iconCache;

    protected TempImageHandler() {
    }

    public static Image getImage(String string, Class clazz) {
        Image image = (Image)imageCache.get(string);
        if (image == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (int i2 = 0; image == null && i2 < imageExtensions.length; ++i2) {
                byte[] byArray = TempImageHandler.getImageBytes(string + imageExtensions[i2], clazz);
                if (byArray == null) continue;
                image = toolkit.createImage(byArray);
            }
            if (image != null) {
                imageCache.put(string, image);
            } else {
                image = brokenImage;
            }
        }
        return image;
    }

    public static Cursor getCursor(String string, Class clazz) {
        return TempImageHandler.getCursor(string, clazz, 0, 0);
    }

    public static Cursor getCursor(String string, Class clazz, int n2, int n3) {
        Cursor cursor = (Cursor)cursorCache.get(string);
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = TempImageHandler.getImage(string, clazz);
            ImageIcon imageIcon = new ImageIcon(image);
            int n4 = imageIcon.getIconWidth();
            int n5 = imageIcon.getIconHeight();
            Dimension dimension = toolkit.getBestCursorSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            int n6 = dimension.width;
            int n7 = dimension.height;
            if (n6 < n4 || n7 < n5) {
                image = image.getScaledInstance(n6, n7, 1);
            } else if (n4 != n6 || n5 != n7) {
                BufferedImage bufferedImage = new BufferedImage(n6, n7, 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                Color color = new Color(0, 0, 0, 0);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n6, n7);
                graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
                image = bufferedImage;
            }
            if (image == brokenImage) {
                cursor = brokenCursor;
            } else if (image != null && (cursor = toolkit.createCustomCursor(image, new Point(n2, n3), "" + string)) != null) {
                cursorCache.put(string, cursor);
            }
        }
        return cursor;
    }

    public static Icon getIcon(String string, Class clazz) {
        Icon icon = (Icon)iconCache.get(string);
        if (icon == null) {
            Image image = TempImageHandler.getImage(string, clazz);
            if (image != null) {
                icon = new ImageIcon(image, string);
            }
            if (icon != null && image != brokenImage) {
                iconCache.put(string, icon);
            }
        }
        return icon;
    }

    private static byte[] getImageBytes(String string, Class clazz) {
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 10000;
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            while (n3 > 0) {
                byteArrayOutputStream.write(byArray, 0, n3);
                n3 = inputStream.read(byArray);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        Image image;
        imageExtensions = new String[]{".gif", ".png"};
        imageCache = new Hashtable();
        cursorCache = new Hashtable();
        iconCache = new Hashtable();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = TempImageHandler.getImageBytes("BrokenImage.gif", TempImageHandler.class);
        if (byArray != null) {
            brokenImage = toolkit.createImage(byArray);
        }
        if (brokenImage == null) {
            throw new RuntimeException("Could not load BrokenIcon");
        }
        byte[] byArray2 = TempImageHandler.getImageBytes("BrokenCursor.gif", TempImageHandler.class);
        if (byArray2 != null && (image = toolkit.createImage(byArray2)) != null) {
            brokenCursor = toolkit.createCustomCursor(image, new Point(0, 0), "BrokenCursor");
        }
        if (brokenCursor == null) {
            throw new RuntimeException("Could not load BrokenCursor");
        }
    }
}

