/*
 * Copyright (C) 2007 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "mapfringeregion.h"

template <>
bool MapFringeRegion<Area<FCoords> >::advance(const Map & map) throw () {
	switch (m_phase) {
	case 0:
		if (m_area.radius) {m_phase = 6; m_remaining_in_phase = m_area.radius;}
		else return false;
	case 1: map.get_trn(m_area, &m_area); break;
	case 2: map.get_tln(m_area, &m_area); break;
	case 3: map. get_ln(m_area, &m_area); break;
	case 4: map.get_bln(m_area, &m_area); break;
	case 5: map.get_brn(m_area, &m_area); break;
	case 6: map. get_rn(m_area, &m_area); break;
	}
	--m_remaining_in_phase;
	if (m_remaining_in_phase == 0)
	{m_remaining_in_phase = m_area.radius; --m_phase;}
	return m_phase;
}
