(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export jessie_why. 
Require Import floats_strict.
Require Import tactics.


(*Why type*) Definition char_P: Set.
Admitted.

(*Why type*) Definition int8: Set.
Admitted.

(*Why type*) Definition padding: Set.
Admitted.

(*Why type*) Definition void_P: Set.
Admitted.

(*Why logic*) Definition char_P_tag : (tag_id char_P).
Admitted.

(*Why axiom*) Lemma char_P_int : (int_of_tag char_P_tag) = 1.
Admitted.

(*Why logic*) Definition char_P_of_pointer_address :
  (pointer unit) -> (pointer char_P).
Admitted.

(*Why axiom*) Lemma char_P_of_pointer_address_of_pointer_addr :
  (forall (p:(pointer char_P)),
   p = (char_P_of_pointer_address (pointer_address p))).
Admitted.

(*Why axiom*) Lemma char_P_parenttag_bottom :
  (parenttag char_P_tag (@bottom_tag char_P)).
Admitted.

(*Why axiom*) Lemma char_P_tags :
  (forall (x:(pointer char_P)),
   (forall (char_P_tag_table:(tag_table char_P)),
    (instanceof char_P_tag_table x char_P_tag))).
Admitted.

(*Why logic*) Definition integer_of_int8 : int8 -> Z.
Admitted.

(*Why predicate*) Definition eq_int8  (x:int8) (y:int8)
  := (integer_of_int8 x) = (integer_of_int8 y).

(*Why logic*) Definition int8_of_integer : Z -> int8.
Admitted.

(*Why axiom*) Lemma int8_coerce :
  (forall (x:Z),
   ((-128) <= x /\ x <= 127 -> (integer_of_int8 (int8_of_integer x)) = x)).
Admitted.

(*Why axiom*) Lemma int8_range :
  (forall (x:int8), (-128) <= (integer_of_int8 x) /\ (integer_of_int8 x) <=
   127).
Admitted.

(*Why predicate*) Definition left_valid_struct_char_P  (p:(pointer char_P)) (a:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_min char_P_alloc_table p) <= a.

(*Why predicate*) Definition left_valid_struct_void_P  (p:(pointer void_P)) (a:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_min void_P_alloc_table p) <= a.

(* Why obligation from file "my_cosine.jc", line 26, characters 0-135: *)
(*Why goal*) Lemma method_error : 
  (forall (x_3:R),
   ((Rle (Rabs x_3) (1 / 32)%R) ->
    (Rle
     (Rabs
      (Rminus (Rminus (1)%R (Rmult (Rmult x_3 x_3) (05 / 10)%R)) (cos x_3)))
     (1 / 16777216)%R))).
Proof.
intros x H.
interval with (i_bisect_diff x,i_nocheck).
Save.

Dp_hint method_error.

(*Why axiom*) Lemma pointer_addr_of_char_P_of_pointer_address :
  (forall (p:(pointer unit)),
   p = (pointer_address (char_P_of_pointer_address p))).
Admitted.

(*Why logic*) Definition void_P_of_pointer_address :
  (pointer unit) -> (pointer void_P).
Admitted.

(*Why axiom*) Lemma pointer_addr_of_void_P_of_pointer_address :
  (forall (p:(pointer unit)),
   p = (pointer_address (void_P_of_pointer_address p))).
Admitted.

(*Why predicate*) Definition right_valid_struct_char_P  (p:(pointer char_P)) (b:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_max char_P_alloc_table p) >= b.

(*Why predicate*) Definition right_valid_struct_void_P  (p:(pointer void_P)) (b:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_max void_P_alloc_table p) >= b.

(*Why predicate*) Definition strict_valid_root_char_P  (p:(pointer char_P)) (a:Z) (b:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_min char_P_alloc_table p) = a /\
     (offset_max char_P_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_root_void_P  (p:(pointer void_P)) (a:Z) (b:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_min void_P_alloc_table p) = a /\
     (offset_max void_P_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_struct_char_P  (p:(pointer char_P)) (a:Z) (b:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_min char_P_alloc_table p) = a /\
     (offset_max char_P_alloc_table p) = b.

(*Why predicate*) Definition strict_valid_struct_void_P  (p:(pointer void_P)) (a:Z) (b:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_min void_P_alloc_table p) = a /\
     (offset_max void_P_alloc_table p) = b.

(*Why predicate*) Definition valid_bitvector_struct_char_P  (p:(pointer unit)) (a:Z) (b:Z) (bitvector_alloc_table:(alloc_table unit))
  := (offset_min bitvector_alloc_table p) = a /\
     (offset_max bitvector_alloc_table p) = b.

(*Why predicate*) Definition valid_bitvector_struct_void_P  (p:(pointer unit)) (a:Z) (b:Z) (bitvector_alloc_table:(alloc_table unit))
  := (offset_min bitvector_alloc_table p) = a /\
     (offset_max bitvector_alloc_table p) = b.

(*Why predicate*) Definition valid_root_char_P  (p:(pointer char_P)) (a:Z) (b:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_min char_P_alloc_table p) <= a /\
     (offset_max char_P_alloc_table p) >= b.

(*Why predicate*) Definition valid_root_void_P  (p:(pointer void_P)) (a:Z) (b:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_min void_P_alloc_table p) <= a /\
     (offset_max void_P_alloc_table p) >= b.

(*Why predicate*) Definition valid_struct_char_P  (p:(pointer char_P)) (a:Z) (b:Z) (char_P_alloc_table:(alloc_table char_P))
  := (offset_min char_P_alloc_table p) <= a /\
     (offset_max char_P_alloc_table p) >= b.

(*Why predicate*) Definition valid_struct_void_P  (p:(pointer void_P)) (a:Z) (b:Z) (void_P_alloc_table:(alloc_table void_P))
  := (offset_min void_P_alloc_table p) <= a /\
     (offset_max void_P_alloc_table p) >= b.

(*Why logic*) Definition void_P_tag : (tag_id void_P).
Admitted.

(*Why axiom*) Lemma void_P_int : (int_of_tag void_P_tag) = 1.
Admitted.

(*Why axiom*) Lemma void_P_of_pointer_address_of_pointer_addr :
  (forall (p:(pointer void_P)),
   p = (void_P_of_pointer_address (pointer_address p))).
Admitted.

(*Why axiom*) Lemma void_P_parenttag_bottom :
  (parenttag void_P_tag (@bottom_tag void_P)).
Admitted.

(*Why axiom*) Lemma void_P_tags :
  (forall (x:(pointer void_P)),
   (forall (void_P_tag_table:(tag_table void_P)),
    (instanceof void_P_tag_table x void_P_tag))).
Admitted.



(* Why obligation from file "my_cosine.c", line 13, characters 13-53: *)
(*Why goal*) Lemma my_cos1_ensures_default_po_1 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  (* JC_13 *)
  (* JC_13 *)
  (Rle
   (Rabs
    (Rminus
     (Rminus
      (1)%R (Rmult (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
     cos (single_value x_0))))
   (1 / 16777216)%R).
Proof.
intros x H.
interval with (i_bisect_diff (single_value x),i_nocheck).
Save.

(* Why obligation from file "my_cosine.c", line 10, characters 12-46: *)
(*Why goal*) Lemma my_cos1_ensures_default_po_2 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_13 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_0) (single_value x_0))) /\
                (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (__retres: single),
  forall (HW_10: __retres = result3),
  forall (why__return: single),
  forall (HW_11: why__return = __retres),
  (* JC_5 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_0))))
   (1 / 8388608)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 14, characters 16-21: *)
(*Why goal*) Lemma my_cos1_safety_po_1 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_0) (single_value x_0))).
Proof.
admit.
Save.

(* Why obligation from file "my_cosine.c", line 14, characters 16-28: *)
(*Why goal*) Lemma my_cos1_safety_po_2 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_0) (single_value x_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 14, characters 9-28: *)
(*Why goal*) Lemma my_cos1_safety_po_3 : 
  forall (x_0: single),
  forall (HW_1: (* JC_3 *) (Rle (Rabs (single_value x_0)) (1 / 32)%R)),
  forall (HW_4: (* JC_9 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_0) (single_value x_0)) (05 / 10)%R)) (
                   cos (single_value x_0))))
                 (1 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_0) (single_value x_0)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_0 x_0 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_10: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
Save.

(* Why obligation from file "my_cosine.c", line 23, characters 13-49: *)
(*Why goal*) Lemma my_cos2_ensures_default_po_1 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0))) /\
                (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (r: single),
  forall (HW_9: r = result3),
  (* JC_36 *)
  (* JC_36 *)
  (Rle (Rabs (Rminus (single_exact r) (cos (single_value x_0_0))))
   (1 / 16777216)%R).
Proof.
intros x (H1,H2).
intros r (_,(exa_r,_)).
intros r0 (_,(_,(exa_r0,_))).
intros r1 (_,(exa_r1,_)).
intros r2 (_,(_,(exa_r2,_))).
intros r3 (_,(_,(exa_r3,_))).
intros r4 r4_eq.
subst r4.
rewrite exa_r3; clear exa_r3 r3.
rewrite exa_r2; clear exa_r2 r2.
rewrite exa_r1; clear exa_r1 r1.
rewrite exa_r0; clear exa_r0 r0.
rewrite exa_r; clear exa_r r.
unfold single_round_error in H2.
assert (h:single_exact x = single_value x).
  admit. (* TODO *)
rewrite h.
interval with (i_bisect_diff (single_value x),i_nocheck).
Save.

(* Why obligation from file "my_cosine.c", line 19, characters 12-46: *)
(*Why goal*) Lemma my_cos2_ensures_default_po_2 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0))) /\
                (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (r: single),
  forall (HW_9: r = result3),
  forall (HW_10: (* JC_36 *)
                 (Rle
                  (Rabs (Rminus (single_exact r) (cos (single_value x_0_0))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_11: why__return = r),
  (* JC_25 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_0_0))))
   (1 / 8388608)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 22, characters 19-24: *)
(*Why goal*) Lemma my_cos2_safety_po_1 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_0_0) (single_value x_0_0))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 22, characters 19-31: *)
(*Why goal*) Lemma my_cos2_safety_po_2 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 22, characters 12-31: *)
(*Why goal*) Lemma my_cos2_safety_po_3 : 
  forall (x_0_0: single),
  forall (HW_1: (* JC_23 *)
                ((* JC_21 *) (Rle (Rabs (single_value x_0_0)) (1 / 32)%R) /\
                (* JC_22 *) (eq (single_round_error x_0_0) (0)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult
                               (single_value x_0_0) (single_value x_0_0)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_0_0 x_0_0 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_9: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 35, characters 13-57: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_1 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1))) /\
                (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  (* JC_60 *)
  (* JC_60 *)
  (Rle (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
   (1 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 30, characters 12-62: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_2 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1))) /\
                (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  forall (HW_10: (* JC_60 *)
                 (Rle
                  (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_11: why__return = r_0),
  (* JC_47 *)
  (* JC_45 *)
  (* JC_45 *)
  (Rle (Rabs (Rminus (single_exact why__return) (cos (single_exact x_1))))
   (1 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 31, characters 11-61: *)
(*Why goal*) Lemma my_cos3_ensures_default_po_3 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1))) /\
                (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_6: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_7: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (r_0: single),
  forall (HW_9: r_0 = result3),
  forall (HW_10: (* JC_60 *)
                 (Rle
                  (Rabs (Rminus (single_exact r_0) (cos (single_exact x_1))))
                  (1 / 16777216)%R)),
  forall (why__return: single),
  forall (HW_11: why__return = r_0),
  (* JC_47 *)
  (* JC_46 *)
  (* JC_46 *)
  (Rle (single_round_error why__return)
   (Rplus (single_round_error x_1) (3 / 16777216)%R)).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 34, characters 19-24: *)
(*Why goal*) Lemma my_cos3_safety_po_1 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_1) (single_value x_1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 34, characters 19-31: *)
(*Why goal*) Lemma my_cos3_safety_po_2 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 34, characters 12-31: *)
(*Why goal*) Lemma my_cos3_safety_po_3 : 
  forall (x_1: single),
  forall (HW_1: (* JC_43 *)
                ((* JC_41 *) (Rle (Rabs (single_exact x_1)) (1 / 32)%R) /\
                (* JC_42 *) (Rle (single_round_error x_1) (1 / 1048576)%R))),
  forall (result: single),
  forall (HW_4: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_5: (no_overflow_single
                 nearest_even (Rmult (single_value x_1) (single_value x_1)))),
  forall (result0: single),
  forall (HW_6: (mul_single_post nearest_even x_1 x_1 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_9: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 43, characters 13-55: *)
(*Why goal*) Lemma my_cos4_ensures_default_po_1 : 
  forall (x_2: single),
  forall (HW_1: (* JC_63 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  (* JC_73 *)
  (* JC_73 *)
  (Rle
   (Rabs
    (Rminus
     (Rminus
      (1)%R (Rmult (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
     cos (single_value x_2))))
   (15 / 16777216)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 40, characters 12-46: *)
(*Why goal*) Lemma my_cos4_ensures_default_po_2 : 
  forall (x_2: single),
  forall (HW_1: (* JC_63 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_73 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (result0: single),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_2) (single_value x_2))) /\
                (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_7: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (result2: single),
  forall (HW_8: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1))) /\
                (mul_single_post nearest_even result0 result1 result2)),
  forall (result3: single),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rminus
                               (single_value result) (single_value result2))) /\
                (sub_single_post nearest_even result result2 result3)),
  forall (__retres_0: single),
  forall (HW_10: __retres_0 = result3),
  forall (why__return: single),
  forall (HW_11: why__return = __retres_0),
  (* JC_65 *)
  (Rle (Rabs (Rminus (single_value why__return) (cos (single_value x_2))))
   (1 / 1048576)%R).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 44, characters 16-21: *)
(*Why goal*) Lemma my_cos4_safety_po_1 : 
  forall (x_2: single),
  forall (HW_1: (* JC_63 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_69 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value x_2) (single_value x_2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 44, characters 16-28: *)
(*Why goal*) Lemma my_cos4_safety_po_2 : 
  forall (x_2: single),
  forall (HW_1: (* JC_63 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_69 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_2) (single_value x_2)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  (no_overflow_single
   nearest_even (Rmult (single_value result0) (single_value result1))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "my_cosine.c", line 44, characters 9-28: *)
(*Why goal*) Lemma my_cos4_safety_po_3 : 
  forall (x_2: single),
  forall (HW_1: (* JC_63 *) (Rle (Rabs (single_value x_2)) (007 / 100)%R)),
  forall (HW_4: (* JC_69 *)
                (Rle
                 (Rabs
                  (Rminus
                   (Rminus
                    (1)%R (Rmult
                           (Rmult (single_value x_2) (single_value x_2)) (05 / 10)%R)) (
                   cos (single_value x_2))))
                 (15 / 16777216)%R)),
  forall (result: single),
  forall (HW_5: (eq (single_value result) (1)%R) /\
                (eq (single_exact result) (1)%R) /\
                (eq (single_model result) (1)%R)),
  forall (HW_6: (no_overflow_single
                 nearest_even (Rmult (single_value x_2) (single_value x_2)))),
  forall (result0: single),
  forall (HW_7: (mul_single_post nearest_even x_2 x_2 result0)),
  forall (result1: single),
  forall (HW_8: (eq (single_value result1) (05 / 10)%R) /\
                (eq (single_exact result1) (05 / 10)%R) /\
                (eq (single_model result1) (05 / 10)%R)),
  forall (HW_9: (no_overflow_single
                 nearest_even (Rmult
                               (single_value result0) (single_value result1)))),
  forall (result2: single),
  forall (HW_10: (mul_single_post nearest_even result0 result1 result2)),
  (no_overflow_single
   nearest_even (Rminus (single_value result) (single_value result2))).
Proof.
admit.
(* FILL PROOF HERE *)
Save.

