(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export Why.

(*Why logic*) Definition lt_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition le_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition gt_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition ge_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition eq_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition neq_real : R -> R -> Prop.
Admitted.

(*Why logic*) Definition add_real : R -> R -> R.
Admitted.

(*Why logic*) Definition sub_real : R -> R -> R.
Admitted.

(*Why logic*) Definition mul_real : R -> R -> R.
Admitted.

(*Why logic*) Definition div_real : R -> R -> R.
Admitted.

(*Why logic*) Definition neg_real : R -> R.
Admitted.

(*Why logic*) Definition real_of_int : Z -> R.
Admitted.

(*Why logic*) Definition int_of_real : R -> Z.
Admitted.

(*Why logic*) Definition lt_real_bool : R -> R -> bool.
Admitted.

(*Why logic*) Definition le_real_bool : R -> R -> bool.
Admitted.

(*Why logic*) Definition gt_real_bool : R -> R -> bool.
Admitted.

(*Why logic*) Definition ge_real_bool : R -> R -> bool.
Admitted.

(*Why logic*) Definition eq_real_bool : R -> R -> bool.
Admitted.

(*Why logic*) Definition neq_real_bool : R -> R -> bool.
Admitted.

(*Why axiom*) Lemma lt_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((lt_real_bool x y) = true <-> (Rlt x y)))).
Admitted.
Dp_hint lt_real_bool_axiom.

(*Why axiom*) Lemma le_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((le_real_bool x y) = true <-> (Rle x y)))).
Admitted.
Dp_hint le_real_bool_axiom.

(*Why axiom*) Lemma gt_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((gt_real_bool x y) = true <-> (Rgt x y)))).
Admitted.
Dp_hint gt_real_bool_axiom.

(*Why axiom*) Lemma ge_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((ge_real_bool x y) = true <-> (Rge x y)))).
Admitted.
Dp_hint ge_real_bool_axiom.

(*Why axiom*) Lemma eq_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((eq_real_bool x y) = true <-> (eq x y)))).
Admitted.
Dp_hint eq_real_bool_axiom.

(*Why axiom*) Lemma neq_real_bool_axiom :
  (forall (x:R), (forall (y:R), ((neq_real_bool x y) = true <-> ~(eq x y)))).
Admitted.
Dp_hint neq_real_bool_axiom.

(*Why logic*) Definition real_max : R -> R -> R.
Admitted.

(*Why logic*) Definition real_min : R -> R -> R.
Admitted.

(*Why axiom*) Lemma real_max_is_ge :
  (forall (x:R),
   (forall (y:R), (Rge (real_max x y) x) /\ (Rge (real_max x y) y))).
Admitted.
Dp_hint real_max_is_ge.

(*Why axiom*) Lemma real_max_is_some :
  (forall (x:R),
   (forall (y:R), (eq (real_max x y) x) \/ (eq (real_max x y) y))).
Admitted.
Dp_hint real_max_is_some.

(*Why axiom*) Lemma real_min_is_le :
  (forall (x:R),
   (forall (y:R), (Rle (real_min x y) x) /\ (Rle (real_min x y) y))).
Admitted.
Dp_hint real_min_is_le.

(*Why axiom*) Lemma real_min_is_some :
  (forall (x:R),
   (forall (y:R), (eq (real_min x y) x) \/ (eq (real_min x y) y))).
Admitted.
Dp_hint real_min_is_some.

(*Why logic*) Definition sqrt_real : R -> R.
Admitted.

(*Why logic*) Definition pow_real : R -> R -> R.
Admitted.

(*Why logic*) Definition abs_real : R -> R.
Admitted.

(*Why axiom*) Lemma abs_real_pos :
  (forall (x:R), ((Rge x (0)%R) -> (eq (Rabs x) x))).
Admitted.
Dp_hint abs_real_pos.

(*Why axiom*) Lemma abs_real_neg :
  (forall (x:R), ((Rle x (0)%R) -> (eq (Rabs x) (Ropp x)))).
Admitted.
Dp_hint abs_real_neg.

(*Why logic*) Definition exp : R -> R.
Admitted.

(*Why logic*) Definition log : R -> R.
Admitted.

(*Why logic*) Definition log10 : R -> R.
Admitted.

(*Why axiom*) Lemma log_exp : (forall (x:R), (eq (log (exp x)) x)).
Admitted.
Dp_hint log_exp.

(*Why logic*) Definition cos : R -> R.
Admitted.

(*Why logic*) Definition sin : R -> R.
Admitted.

(*Why logic*) Definition tan : R -> R.
Admitted.

(*Why logic*) Definition cosh : R -> R.
Admitted.

(*Why logic*) Definition sinh : R -> R.
Admitted.

(*Why logic*) Definition tanh : R -> R.
Admitted.

(*Why logic*) Definition acos : R -> R.
Admitted.

(*Why logic*) Definition asin : R -> R.
Admitted.

(*Why logic*) Definition atan : R -> R.
Admitted.

(*Why logic*) Definition atan2 : R -> R -> R.
Admitted.

(*Why logic*) Definition hypot : R -> R -> R.
Admitted.

(*Why axiom*) Lemma prod_pos :
  (forall (x:R),
   (forall (y:R),
    (((Rgt x (0)%R) /\ (Rgt y (0)%R) -> (Rgt (Rmult x y) (0)%R))) /\
    (((Rlt x (0)%R) /\ (Rlt y (0)%R) -> (Rgt (Rmult x y) (0)%R))))).
Admitted.
Dp_hint prod_pos.

(*Why axiom*) Lemma abs_minus :
  (forall (x:R), (eq (Rabs (Ropp x)) (Rabs x))).
Admitted.
Dp_hint abs_minus.

(*Why type*) Inductive mode : Set :=
  | nearest_even : mode
  | to_zero : mode
  | up : mode
  | down : mode
  | nearest_away : mode.
Admitted.

Admitted.

Admitted.

Admitted.

Admitted.

Admitted.

Admitted.
Dp_hint no_other_mode.

Admitted.
Dp_hint mode_distinct.

(*Why type*) Inductive float_format : Set :=
  | Single : float_format
  | Double : float_format
  | Binary80 : float_format
  | Quad : float_format.
Admitted.

Admitted.

Admitted.

Admitted.

Admitted.

(*Why type*) Definition gen_float: Set.
Admitted.

(*Why logic*) Definition round_float : float_format -> mode -> R -> R.
Admitted.

(*Why logic*) Definition gen_float_of_real_logic :
  float_format -> mode -> R -> gen_float.
Admitted.

(*Why logic*) Definition float_value : gen_float -> R.
Admitted.

(*Why logic*) Definition exact_value : gen_float -> R.
Admitted.

(*Why logic*) Definition model_value : gen_float -> R.
Admitted.

Admitted.

(*Why function*) Definition max_gen_float  (f:float_format)
  := (float_format_match
      f (33554430 * 10141204801825835211973625643008)%R (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R (36893488147419103230 * 32247736798518462797190682400943018516175543670762176328756482144039152568041578530784869838671865972235112113819199496038199562243910663703639216829515817160113666668284961240211417531345524616362428416330602972909073090642506869663645452596715605872599087734040646091573772820166659709055844941963407370586164567373226035331478682139323759030390169756949645512305687629336370321027572205368679114704513230126552642666038554179630426709583211834866442025402779192438955501011599402670474078315979195355085382566505714139685398132788514318516857572135124726246887683817431332595336004485663642818019898976640217306812561246935515065344079842840510097237727080984183495389368072338451606972939196031163096169199428295104133836032565137546925854725960037189363809577708269161078297604210091040361487260740249986383462509936056379514029238590893274747101383360270789838187035523056441182806100163231205084519320466554639512906620717463724499998301458223494983926579429691620482441269711367614363695303004564784940490808737282945526774911719814580226498373894496190363722344710426167299430387657571898023057486643921769603842100563739030336691645389445492926167601553616786810662018623358680430160062641831241724154676346446956483016401282337761290196283249206927902020112758851552032621043952751383985648183664483389113663697474518437837593333184771556767592207983004392544555790253882523577401634907110779490333277898545345116189557099744222039988799226930564811854616377334200980884800664165297389997964692737821895851412532797735108359203559095483310984658106121538922952889055685471125170175723317169593146664295809795623802089889643999415332745683386415868399386033192494319220974648757516356052320358879924313110310884292268260701379338994338108789478905916908161768521947880258489076565694006998844912795108503710046920084170185272761891078021513009632812076867050768977864194042678311369055206891516537021560300798059734220105917788064342240629479094309156746038941015397976356754789446933541512725013448273437547085806482191918607333986763432754828493535124047158138237637409295986872592429450114102485563352324125936266490688770968135131034136174587957527871860195705884826978646394753119840216174117299370924945153580348775272141051491679794666208271496285083069845671716424410676415869955363407007760984457820261218648462922790310801749176357827053037467349708500388630266544397409034371631091896035688733055939026767796894113267574863689692595743405212002418769330858650477320122610373855743251794447804031454470627265691044431863724394790157020749747541055050361466440339407757302440378131261742472589547459292823540674561003306548963849749082270981212995128117275025218442085292281511141515402115396401640539932607790670152400476588736655932035952713596437884630053601152144442487925678513707439322429603512863513937772419859052931939816470086355056926030022478683926998811371487429392139518642533641594848997510779898512138631152276001570189617571577117505003649765241953436949753578990662937482392034476147764320283391607594707828151932952800276998022501766325609849743945881184820529811657759571426179918970334290658333365861701775758750841107251261789710752326125748382152448064208818548133245897789022501048075101440658472328426420634576248281716861120935223755782204696386463154525203556339857062481846160548995002214961818560159651368345845120079053574246560180632466599839315290737648547666905885960618996553045213471557799885589510324494021059895586424571108214444983727593352510360659623694336871156982624856470568852865375380207522670830821369618815960216991366324223164204144978595243245271374275940010359033028897257400300896745451850608529102426268449369972727553520714138832750617641260586748778127838088604132276526159832635929297522815794276302150715627256492836149372994848554854698569272309146920737500425328133816423498307241515119828589935781842076654814684177765311659863765751080177655756714625693102613062094201622809620794125071255386708064848320764949530272433439273743375350030635762736423572793816319775637274418096041530332046157499910206330422447695636005413591515928110703929025624538022689370483285119600899835109936335014160851892197423917205143598214380079070972739838516200090223566115430366326479446523163497707352464003363812601636875414221683002445945525094887495651061394077679898700257734335650549937472988196339378468338812732120356422794395674496874734970810783457481759262704526738373673902304190312120953832926347769566045802798905863532547270355875796602597933585415990415455319622527795552163966597860161185787837154710170391266971001786784354270889004431725527269565131623614750206537270420868165375708343148079210039515648805899537033270890665024179796399141747260973138806486300213292018923538944420046243682707230360249726438817748989930350717709729915628184770113773134324454134693667450204984030027933986759393415283853749497928013737601928987148288)%R (10384593717069655257060992658440191 * 114566975634454816191942975937021097778425171294579514582624149966389213403920090182399142401947734882963601825946396303515227409675640983634676277452214126953271270779612795963272082855672538728563937185109732911702000601801312277187767039509635956564889226193460011741272001089579147891071801772836406636408542309529060913076672115591221366878436675154338948034314027883824743700200955506462744589784510758528855385897452926896386410893964622327936957992032699822143213101141154917678740610810376649038337087086268134824555169376440184402514637341621738380037554647889775099384252159799983569207952523699987840568370818228542571636353670224794534594670832493733966456479464825472020120048949806456885966700552004820338445640120160140707120372120044881076821530917116366627362458545072211678791117821917033788222761749637102395787839407826756409559370493981130287288959250428833205087663671986430831440342076868982131233944062094081049352206141585325465058270493406992402478441554021655741606250355618232052778505223277544706401353777351255943367286156922433059306322692486994325020896168814388353578186349480183173468511272701203404042372985534276682977035483025988990884023687838175506322216046732731490906170806263897633254403278905676306785452863043442050290892498618872082376970823079714222052587699581079722270486689248935042817810388217379926230393777981235787935630519931900023697585435325801411076203627809439016673527892108609982955118764021060559385939173102052993801027016701842233423739844130074849800320935361233889822895561249167014178541485968741891536214755318516264726618827734644304403654275488867837480463016282939745648167024979309814612802348794646769360458103821391931220049970217473586988569106226138203868108360477841991485055497811334064414866851492576879284529545422824266313855883611352162343593207687978266882179944806498673531834515653751683493994285508244641992288872570485612177862935816320565934155403155842884077591318338950389751712112539642789800903661923333990247631012409618156578566351136998657293496203960475394113748617727023166914924123493676642029699157810235385872358024258680360199813779228492674388328027300289440148162115191986333780173788436063090899410262996480621655397959487561277825808231127097495041085549503226143989727147656852006734652142779976482983389674280588583665435688355637149988372330106141749572640796758450636013529846470536577284459738365412166889200090575570090202409075085880693097080550320796996355345707949348640824363380282078648703938653611201397348748065820147814490768193672057225106710877522610166559645745848276385602482219147697409019128611237276305255367259784367788632227850594991071613748507029929223371614782967892912478909705230029347475566964187514970776066252030943573586628451708825638739787681970996553417043907478882542685133229244568702887976101077970738870051797016298624946379982527431902634913894756001412174550475717330736987511524133859496070297553686151453396808973569127605442651561567236615778688172151557500492884978186750417422542339834005203969098591275611472177411449160635505427819488066578019419991313155447536260279301012199434003114581421470172809197788592647490129480751355644877351551486586411059438880136657070711152340086303022105796949932122346099140901504828119157351488172112348931202508607740994708956640999135419871642991160664451511946169922300669267136094641160257738713567616582944941855784530936141012414696238313686192916662369574646350024313292321616673671898263524524450905603992938564856609449091553836641056103107604490444445160060634346242272907602313896516102162419642966089052277010457002057378659324481280026820888197039837825215082775291017562823190338764076846873913022878179708787842325352734916912171329287689495969831326964429943927094783980716086188268195784265561325016430965812365884592150140752765797913546266867606630205198995854906967586267102827032304111886104393618402323369940829979592769280936483731971270653139146113108890487050601567092374341959023355860265076498817471526463985527838832445781917270854231169949036691704855277506816713392447751458419721663487379459349938063275063406446070397078376571190360646958823789326803150928659476609557343345409137495035781525979658823964596927124512029388652388644102223151408509250486434189173491710610914404518984799689773608303729425293510852768924246218953122200449670473927378354299878296701665273340593651940632238147126939002908440779664995326831707353336008424523675703193062849884305630606128060593630629980579970359847882780769589371968633964114998321420438990472807410682197665288734325155569855023374096954885475098697353038677461340507868948667430760466478203725924160775697798142576310097016663543778722897243214614852559169027084374499381927464081782158247406919726368482878201325996907718792492155837399926560904461982098161503296027966792869063717592524760490611821095517851474645530266826702848)%R).

(*Why logic*) Definition min_gen_float : float_format -> R.
Admitted.

Admitted.
Dp_hint max_single.

Admitted.
Dp_hint max_double.

Admitted.
Dp_hint max_binary80.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

(*Why axiom*) Lemma min_single :
  (eq (min_gen_float Single) (1 / 713623846352979940529142984724747568191373312)%R).
Admitted.
Dp_hint min_single.

(*Why axiom*) Lemma min_double :
  (eq (min_gen_float Double) (1 / 202402253307310618352495346718917307049556649764142118356901358027430339567995346891960383701437124495187077864316811911389808737385793476867013399940738509921517424276566361364466907742093216341239767678472745068562007483424692698618103355649159556340810056512358769552333414615230502532186327508646006263307707741093494784)%R).
Admitted.
Dp_hint min_double.

(*Why predicate*) Definition no_overflow  (f:float_format) (m:mode) (x:R)
  := (Rle (Rabs (round_float f m x)) (max_gen_float f)).

(*Why function*) Definition gen_round_error  (x:gen_float)
  := (Rabs (Rminus (float_value x) (exact_value x))).

(*Why function*) Definition gen_relative_error  (x:gen_float)
  := (Rabs (Rdiv (Rminus (float_value x) (exact_value x)) (exact_value x))).

(*Why function*) Definition gen_total_error  (x:gen_float)
  := (Rabs (Rminus (float_value x) (model_value x))).

(*Why axiom*) Lemma bounded_real_no_overflow :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R), ((Rle (Rabs x) (max_gen_float f)) -> (no_overflow f m x))))).
Admitted.
Dp_hint bounded_real_no_overflow.

(*Why axiom*) Lemma round_of_zero :
  (forall (f:float_format),
   (forall (m:mode), (eq (round_float f m (0)%R) (0)%R))).
Admitted.
Dp_hint round_of_zero.

(*Why axiom*) Lemma round_greater_max :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R), (~(no_overflow f m x) -> (Rgt (Rabs x) (max_gen_float f)))))).
Admitted.
Dp_hint round_greater_max.

(*Why axiom*) Lemma round_increasing :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R),
     (forall (y:R),
      ((Rle x y) -> (Rle (round_float f m x) (round_float f m y))))))).
Admitted.
Dp_hint round_increasing.

(*Why axiom*) Lemma round_up_ge :
  (forall (f:float_format), (forall (x:R), (Rge (round_float f up x) x))).
Admitted.
Dp_hint round_up_ge.

(*Why axiom*) Lemma round_up_neg :
  (forall (f:float_format),
   (forall (x:R),
    (eq (round_float f up (Ropp x)) (Ropp (round_float f down x))))).
Admitted.
Dp_hint round_up_neg.

(*Why axiom*) Lemma round_idempotent :
  (forall (f:float_format),
   (forall (m1:mode),
    (forall (m2:mode),
     (forall (x:R),
      (eq (round_float f m1 (round_float f m2 x)) (round_float f m2 x)))))).
Admitted.
Dp_hint round_idempotent.

