# 20 "dot_lexer.mll"
 
  open Lexing
  open Dot_ast
  open Dot_parser

  let string_buf = Buffer.create 1024

  let keyword =
    let h = Hashtbl.create 17 in
    List.iter 
      (fun (s,k) -> Hashtbl.add h s k)
      [
	"strict", STRICT;
	"graph", GRAPH;
	"digraph", DIGRAPH;
	"subgraph", SUBGRAPH;
	"node", NODE;
	"edge", EDGE;
      ];
    fun s -> let s = String.lowercase s in Hashtbl.find h s


# 25 "dot_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\238\255\239\255\240\255\241\255\078\000\088\000\098\000\
    \176\000\245\255\246\255\247\255\248\255\249\255\250\255\251\255\
    \252\255\114\000\001\000\005\000\254\255\002\000\253\255\191\000\
    \244\255\211\000\221\000\157\000\002\000\255\255\032\000\054\000\
    \015\000";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\255\255\255\255\013\000\017\000\012\000\
    \017\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\017\000\017\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\013\000\013\000\255\255\002\000\255\255\255\255\255\255\
    \001\000";
  Lexing.lex_default = 
   "\001\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\021\000\255\255\000\000\021\000\000\000\255\255\
    \000\000\255\255\255\255\022\000\255\255\000\000\022\000\020\000\
    \255\255";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\019\000\019\000\020\000\020\000\019\000\019\000\019\000\
    \000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\000\000\004\000\018\000\020\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\008\000\006\000\017\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\016\000\014\000\003\000\013\000\029\000\000\000\
    \000\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\010\000\020\000\009\000\029\000\007\000\
    \032\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\012\000\026\000\011\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\022\000\000\000\000\000\000\000\
    \000\000\021\000\000\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\000\000\000\000\029\000\
    \000\000\007\000\000\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\024\000\023\000\000\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\000\000\000\000\000\000\000\000\024\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\028\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \002\000\255\255\255\255\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\022\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\018\000\021\000\000\000\019\000\019\000\
    \255\255\255\255\019\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\000\000\028\000\019\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\032\000\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\030\000\000\000\030\000\000\000\
    \031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\005\000\000\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\017\000\255\255\255\255\255\255\
    \255\255\017\000\255\255\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\255\255\255\255\027\000\
    \255\255\007\000\255\255\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\008\000\008\000\255\255\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\255\255\255\255\255\255\255\255\008\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\027\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\018\000\021\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \030\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\031\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\027\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec token lexbuf =
    __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 52 "dot_lexer.mll"
      ( token lexbuf )
# 188 "dot_lexer.ml"

  | 1 ->
# 54 "dot_lexer.mll"
      ( token lexbuf )
# 193 "dot_lexer.ml"

  | 2 ->
# 56 "dot_lexer.mll"
      ( comment lexbuf; token lexbuf )
# 198 "dot_lexer.ml"

  | 3 ->
# 58 "dot_lexer.mll"
      ( COLON )
# 203 "dot_lexer.ml"

  | 4 ->
# 60 "dot_lexer.mll"
      ( COMMA )
# 208 "dot_lexer.ml"

  | 5 ->
# 62 "dot_lexer.mll"
      ( SEMICOLON )
# 213 "dot_lexer.ml"

  | 6 ->
# 64 "dot_lexer.mll"
      ( EQUAL )
# 218 "dot_lexer.ml"

  | 7 ->
# 66 "dot_lexer.mll"
      ( LBRA )
# 223 "dot_lexer.ml"

  | 8 ->
# 68 "dot_lexer.mll"
      ( RBRA )
# 228 "dot_lexer.ml"

  | 9 ->
# 70 "dot_lexer.mll"
      ( LSQ )
# 233 "dot_lexer.ml"

  | 10 ->
# 72 "dot_lexer.mll"
      ( RSQ )
# 238 "dot_lexer.ml"

  | 11 ->
# 74 "dot_lexer.mll"
      ( EDGEOP )
# 243 "dot_lexer.ml"

  | 12 ->

  let s = Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 76 "dot_lexer.mll"
      ( try keyword s with Not_found -> ID (Ident s) )
# 250 "dot_lexer.ml"

  | 13 ->

  let s = Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 78 "dot_lexer.mll"
      ( ID (Number s) )
# 257 "dot_lexer.ml"

  | 14 ->
# 80 "dot_lexer.mll"
      ( Buffer.clear string_buf; 
	let s = string lexbuf in
	ID (String s) )
# 264 "dot_lexer.ml"

  | 15 ->
# 84 "dot_lexer.mll"
      ( Buffer.clear string_buf; 
	html lexbuf; 
	ID (Html (Buffer.contents string_buf)) )
# 271 "dot_lexer.ml"

  | 16 ->
# 88 "dot_lexer.mll"
      ( EOF )
# 276 "dot_lexer.ml"

  | 17 ->

  let c = Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 90 "dot_lexer.mll"
      ( failwith ("Dot_lexer: invalid character " ^ String.make 1 c) )
# 283 "dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and string lexbuf =
    __ocaml_lex_string_rec lexbuf 27
and __ocaml_lex_string_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 94 "dot_lexer.mll"
      ( Buffer.contents string_buf )
# 294 "dot_lexer.ml"

  | 1 ->
# 96 "dot_lexer.mll"
      ( Buffer.add_char string_buf '"';
	string lexbuf )
# 300 "dot_lexer.ml"

  | 2 ->

  let c = Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 99 "dot_lexer.mll"
      ( Buffer.add_char string_buf c;
	string lexbuf )
# 308 "dot_lexer.ml"

  | 3 ->
# 102 "dot_lexer.mll"
      ( failwith ("Dot_lexer: unterminated string literal") )
# 313 "dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_rec lexbuf __ocaml_lex_state

and html lexbuf =
    __ocaml_lex_html_rec lexbuf 30
and __ocaml_lex_html_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 106 "dot_lexer.mll"
      ( () )
# 324 "dot_lexer.ml"

  | 1 ->
# 108 "dot_lexer.mll"
      ( Buffer.add_char string_buf '<'; html lexbuf;
	Buffer.add_char string_buf '>'; html lexbuf )
# 330 "dot_lexer.ml"

  | 2 ->

  let c = Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 111 "dot_lexer.mll"
      ( Buffer.add_char string_buf c;
	html lexbuf )
# 338 "dot_lexer.ml"

  | 3 ->
# 114 "dot_lexer.mll"
      ( failwith ("Dot_lexer: unterminated html literal") )
# 343 "dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_html_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 31
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 118 "dot_lexer.mll"
      ( () )
# 354 "dot_lexer.ml"

  | 1 ->
# 120 "dot_lexer.mll"
      ( comment lexbuf )
# 359 "dot_lexer.ml"

  | 2 ->
# 122 "dot_lexer.mll"
      ( failwith "Dot_lexer: unterminated comment" )
# 364 "dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

;;

