/*
 * OutputSettingsDialog.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"
#include "OutputSettingsDialog.h"
#include "DuneApp.h"
#include "resource.h"
#include "swt.h"

OutputSettingsDialog::OutputSettingsDialog(SWND parent)
  : Dialog(parent, IDD_OUTPUT)
{
    LoadData();
}

void
OutputSettingsDialog::OnCommand(int id)
{
    if (id == IDOK) {
	SaveData();
	if (Validate()) {
	    swEndDialog(IDOK);
	}
    } else if (id == IDC_OUTPUT_DEFAULTS) {
        TheApp->OutputSetDefaults();
        LoadData();
    } else if (id == IDCANCEL) {
	swEndDialog(IDCANCEL);
    }
}

void OutputSettingsDialog::LoadData()
{
    char buf[128];
    swSetCheck(swGetDialogItem(_dlg, IDC_KEEP_URLS), TheApp->GetKeepURLs());
    snprintf(buf, 128, "%d", TheApp->GetIndent());
    swSetText(swGetDialogItem(_dlg, IDC_INDENT), buf);
    snprintf(buf, 128, "%d", TheApp->GetFloatDigits());
    swSetText(swGetDialogItem(_dlg, IDC_FLOAT_DIGITS), buf);  
    swSetCheck(swGetDialogItem(_dlg, IDC_INCLUDE_PROTOS), 
                               TheApp->GetIncludeProtos());
    swSetCheck(swGetDialogItem(_dlg, IDC_K_AND_R), TheApp->GetkrFormating());
    swSetCheck(swGetDialogItem(_dlg, IDC_COMPRESS), TheApp->GetCompress());
}

bool
OutputSettingsDialog::Validate()
{
    char buf[128];
    swGetText(swGetDialogItem(_dlg, IDC_FLOAT_DIGITS), buf, 128);
    if (atoi(buf) > 9) {
        char msg[256];
//        swLoadString("", msg, 255);
        strcpy(msg, "more than 9 digits not really supported");
        swMessageBox(TheApp->mainWnd(), msg,
                     "too much digits (not yet)", SW_MB_OK, SW_MB_WARNING);
    }
    if (atoi(buf) < 1)
        return false;
    return true;
}


void
OutputSettingsDialog::SaveData() 
{
    char buf[128];

    TheApp->SetKeepURLs(swGetCheck(swGetDialogItem(_dlg, IDC_KEEP_URLS))!=0);

    swGetText(swGetDialogItem(_dlg, IDC_INDENT), buf, 128);
    TheApp->SetIndent(atoi(buf));
    swGetText(swGetDialogItem(_dlg, IDC_FLOAT_DIGITS), buf, 128);
    TheApp->SetFloatDigits(atoi(buf));
    TheApp->SetIncludeProtos(swGetCheck(swGetDialogItem(_dlg, 
                                        IDC_INCLUDE_PROTOS))!=0);
    TheApp->SetkrFormating(swGetCheck(swGetDialogItem(_dlg, IDC_K_AND_R))!=0);
    TheApp->SetCompress(swGetCheck(swGetDialogItem(_dlg, IDC_COMPRESS))!=0);
    
}
