/*
 * NodeCoordinate.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeCoordinate.h"
#include "Proto.h"
#include "MFVec3f.h"
#include "ExposedField.h"
#include "Field.h"

ProtoCoordinate::ProtoCoordinate(Scene *scene)
  : Proto(scene, "Coordinate")
{
    ExposedField* p = new ExposedField(MFVEC3F, "point", new MFVec3f());
    p->setFlags(EIF_RECOMMENDED);
    point.set(addExposedField(p));
}

Node *
ProtoCoordinate::create(Scene *scene)
{ 
    return new NodeCoordinate(scene, this); 
}

NodeCoordinate::NodeCoordinate(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void
NodeCoordinate::setField(int index, FieldValue *value)
{
    Node::setField(index, value);
    if (hasParent())
        getParent()->update();
}

