/*
 * NodeCoordinateDeformer.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_COORDINATE_DEFORMER_H
#define _NODE_COORDINATE_DEFORMER_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoCoordinateDeformer : public Proto {
public:
		    ProtoCoordinateDeformer(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex children;
    FieldIndex controlPoint;
    FieldIndex inputCoord;
    FieldIndex inputTransform;
    FieldIndex outputCoord;
    FieldIndex weight;
    FieldIndex bboxCenter;
    FieldIndex bboxSize;
    FieldIndex uDimension;
    FieldIndex vDimension;
    FieldIndex wDimension;
    FieldIndex uKnot;
    FieldIndex vKnot;
    FieldIndex wKnot;
    FieldIndex uOrder;
    FieldIndex vOrder;
    FieldIndex wOrder;

};

class NodeCoordinateDeformer : public Node {
public:
		    NodeCoordinateDeformer(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_COORDINATE_DEFORMER; }
    virtual Node   *copy() const { return new NodeCoordinateDeformer(*this); }
    virtual int	    getNodeClass() const { return CHILD_NODE; }

    virtual void    flip(int index);

    virtual bool    showFields() { return true; }

    bool    	    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    fieldMacros(MFNode,  children,       ProtoCoordinateDeformer)
    fieldMacros(MFVec3f, controlPoint,   ProtoCoordinateDeformer)
    fieldMacros(MFNode,  inputCoord,     ProtoCoordinateDeformer)
    fieldMacros(MFNode,  inputTransform, ProtoCoordinateDeformer)
    fieldMacros(MFNode,  outputCoord,    ProtoCoordinateDeformer)
    fieldMacros(MFFloat, weight,         ProtoCoordinateDeformer)
    fieldMacros(SFVec3f, bboxCenter,     ProtoCoordinateDeformer)
    fieldMacros(SFVec3f, bboxSize,       ProtoCoordinateDeformer)
    fieldMacros(SFInt32, uDimension,     ProtoCoordinateDeformer)
    fieldMacros(SFInt32, vDimension,     ProtoCoordinateDeformer)
    fieldMacros(SFInt32, wDimension,     ProtoCoordinateDeformer)
    fieldMacros(MFFloat, uKnot,          ProtoCoordinateDeformer)
    fieldMacros(MFFloat, vKnot,          ProtoCoordinateDeformer)
    fieldMacros(MFFloat, wKnot,          ProtoCoordinateDeformer)
    fieldMacros(SFInt32, uOrder,         ProtoCoordinateDeformer)
    fieldMacros(SFInt32, vOrder,         ProtoCoordinateDeformer)
    fieldMacros(SFInt32, wOrder,         ProtoCoordinateDeformer)

};

#endif // _NODE_COORDINATE_DEFORMER_H
