/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFTCPFLAGS_H
#define _WFTCPFLAGS_H

#include <string>
#include <inttypes.h>

/* TCP flags */
#define TCP_FIN 0x01
#define TCP_SYN 0x02
#define TCP_RST 0x04
#define TCP_PSH 0x08
#define TCP_ACK 0x10
#define TCP_URG 0x20
#define TCP_ECE 0x40
#define TCP_CWR 0x80

#define TCP_MAX 0xFF /* OR of all flags */

struct wf_tcpflag {
  uint8_t flag;
  string str;
  char letter;
};

extern struct wf_tcpflag wf_tcpflag_list[];

/**
 * 
 */
class wf_tcpflags {
 public:
  wf_tcpflags();
  wf_tcpflags(const string& str);
  virtual ~wf_tcpflags() {}
  // wf_tcpflags(const wf_tcpflags&) implicit copy constructor

  bool set(const string& str);
  void setall();

  string tostr() const;
  string tostr_mini() const;

 public:
  uint8_t flags;
};

#endif
