#ifndef TEXT_CLIENT_PROTOCOL_H
#define TEXT_CLIENT_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

struct wl_client;
struct wl_resource;

struct text_model;
struct text_model_manager;
struct input_method;

extern const struct wl_interface text_model_interface;
extern const struct wl_interface text_model_manager_interface;
extern const struct wl_interface input_method_interface;

struct text_model_listener {
	/**
	 * commit_string - (none)
	 * @text: (none)
	 * @index: (none)
	 */
	void (*commit_string)(void *data,
			      struct text_model *text_model,
			      const char *text,
			      uint32_t index);
	/**
	 * preedit_string - (none)
	 * @text: (none)
	 * @index: (none)
	 */
	void (*preedit_string)(void *data,
			       struct text_model *text_model,
			       const char *text,
			       uint32_t index);
	/**
	 * preedit_styling - (none)
	 */
	void (*preedit_styling)(void *data,
				struct text_model *text_model);
	/**
	 * key - (none)
	 */
	void (*key)(void *data,
		    struct text_model *text_model);
	/**
	 * selection_replacement - (none)
	 */
	void (*selection_replacement)(void *data,
				      struct text_model *text_model);
	/**
	 * direction - (none)
	 */
	void (*direction)(void *data,
			  struct text_model *text_model);
	/**
	 * locale - (none)
	 */
	void (*locale)(void *data,
		       struct text_model *text_model);
};

static inline int
text_model_add_listener(struct text_model *text_model,
			const struct text_model_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) text_model,
				     (void (**)(void)) listener, data);
}

#define TEXT_MODEL_SET_SURROUNDING_TEXT	0
#define TEXT_MODEL_SET_CURSOR_INDEX	1
#define TEXT_MODEL_ACTIVATE	2
#define TEXT_MODEL_DEACTIVATE	3
#define TEXT_MODEL_SET_SELECTED_TEXT	4
#define TEXT_MODEL_SET_MICRO_FOCUS	5
#define TEXT_MODEL_SET_PREEDIT	6
#define TEXT_MODEL_SET_CONTENT_TYPE	7

static inline void
text_model_set_user_data(struct text_model *text_model, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) text_model, user_data);
}

static inline void *
text_model_get_user_data(struct text_model *text_model)
{
	return wl_proxy_get_user_data((struct wl_proxy *) text_model);
}

static inline void
text_model_destroy(struct text_model *text_model)
{
	wl_proxy_destroy((struct wl_proxy *) text_model);
}

static inline void
text_model_set_surrounding_text(struct text_model *text_model, const char *text)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_SURROUNDING_TEXT, text);
}

static inline void
text_model_set_cursor_index(struct text_model *text_model, uint32_t index)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_CURSOR_INDEX, index);
}

static inline void
text_model_activate(struct text_model *text_model)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_ACTIVATE);
}

static inline void
text_model_deactivate(struct text_model *text_model)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_DEACTIVATE);
}

static inline void
text_model_set_selected_text(struct text_model *text_model, const char *text, int32_t index)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_SELECTED_TEXT, text, index);
}

static inline void
text_model_set_micro_focus(struct text_model *text_model, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_MICRO_FOCUS, x, y, width, height);
}

static inline void
text_model_set_preedit(struct text_model *text_model)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_PREEDIT);
}

static inline void
text_model_set_content_type(struct text_model *text_model)
{
	wl_proxy_marshal((struct wl_proxy *) text_model,
			 TEXT_MODEL_SET_CONTENT_TYPE);
}

#define TEXT_MODEL_MANAGER_CREATE_TEXT_MODEL	0

static inline void
text_model_manager_set_user_data(struct text_model_manager *text_model_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) text_model_manager, user_data);
}

static inline void *
text_model_manager_get_user_data(struct text_model_manager *text_model_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) text_model_manager);
}

static inline void
text_model_manager_destroy(struct text_model_manager *text_model_manager)
{
	wl_proxy_destroy((struct wl_proxy *) text_model_manager);
}

static inline struct text_model *
text_model_manager_create_text_model(struct text_model_manager *text_model_manager, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_create((struct wl_proxy *) text_model_manager,
			     &text_model_interface);
	if (!id)
		return NULL;

	wl_proxy_marshal((struct wl_proxy *) text_model_manager,
			 TEXT_MODEL_MANAGER_CREATE_TEXT_MODEL, id, surface);

	return (struct text_model *) id;
}

#define INPUT_METHOD_COMMIT_STRING	0

static inline void
input_method_set_user_data(struct input_method *input_method, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) input_method, user_data);
}

static inline void *
input_method_get_user_data(struct input_method *input_method)
{
	return wl_proxy_get_user_data((struct wl_proxy *) input_method);
}

static inline void
input_method_destroy(struct input_method *input_method)
{
	wl_proxy_destroy((struct wl_proxy *) input_method);
}

static inline void
input_method_commit_string(struct input_method *input_method, const char *text, uint32_t index)
{
	wl_proxy_marshal((struct wl_proxy *) input_method,
			 INPUT_METHOD_COMMIT_STRING, text, index);
}

#ifdef  __cplusplus
}
#endif

#endif
