/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PROJECTSVIEW_H
#define PROJECTSVIEW_H

#include "view.h"

class QTreeView;
class QModelIndex;

namespace WebIssues
{

class TableItemModel;
class RowIndex;

/**
* View for displaying the tree of projects and folders.
*/
class ProjectsView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    ProjectsView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~ProjectsView();

public:
    /**
    * Called when the page containing the view is activated or disactivated.
    */
    void setPageActive( bool active );

public: // overrides
    void initialUpdate();

protected: // overrides
    void updateAccess( Access access );

    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void updateActions();

    void updateTimeout();

    void updateProjects();
    void showUsers();
    void showTypes();
    void showMembers();
    void addProject();
    void addFolder();
    void editRename();
    void editDelete();
    void editWatches();
    void openFolder();
    void findItem();
    void changePassword();

    void contextMenu( const QPoint& pos );
    void activated( const QModelIndex& index );

    void projectsTableChanged();

private:
    Access checkDataAccess();

    void updateSummary();

    void periodicUpdate( bool initial );

    QModelIndex selectedIndex();

private:
    QTreeView* m_list;
    TableItemModel* m_model;

    bool m_firstUpdateDone;

    int m_updateCounter;

    int m_selectedProjectId;
    int m_selectedFolderId;

    int m_currentProjectId;
    bool m_currentProjectAdmin;

    bool m_systemAdmin;
    bool m_anyProjectAdmin;

    bool m_pageActive;
};

}

#endif
