/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ROWFILTERS_H
#define ROWFILTERS_H

#include <QList>

#include "abstractrowfilter.h"
#include "columncondition.h"

namespace WebIssues
{

/**
* Filter for issue rows using a list of conditions.
*
* Issue rows can be filtered using a list of conditions for column values
* and a quick search string. Either of them can be empty.
*/
class IssueRowFilter : public AbstractRowFilter
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    IssueRowFilter( QObject* parent );

    /**
    * Destructor.
    */
    ~IssueRowFilter();

public:
    /**
    * Set the list of column conditions to use for filtering.
    */
    void setConditions( const QList<ColumnCondition>& conditions );

    /**
    * Return the list of column conditions used for filtering.
    */
    const QList<ColumnCondition>& conditions() const { return m_conditions; }

    /**
    * Set the string to search in issue names.
    */
    void setQuickSearch( const QString& search );

    /**
    * Return the string search in issue names.
    */
    const QString& quickSearch() const { return m_search; }

public: // overrides
    bool filterRow( int id );

private:
    QString extractValue( int id, Column column );

private:
    QList<ColumnCondition> m_conditions;
    QString m_search;
};

}

#endif
