/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef VALUEEDITORS_H
#define VALUEEDITORS_H

#include "abstractvalueeditor.h"

namespace WebIssues
{

class DefinitionInfo;

/**
* Editor delegate for <tt>TEXT</tt> attribue values.
*/
class TextValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param info Attribute definition.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    TextValueEditor( const DefinitionInfo& info, QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~TextValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();
};

/**
* Editor delegate for <tt>ENUM</tt> attribue values.
*/
class EnumValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param info Attribute definition.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    EnumValueEditor( const DefinitionInfo& info, QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~EnumValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();
};

/**
* Editor delegate for <tt>NUMERIC</tt> attribue values.
*/
class NumericValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param info Attribute definition.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    NumericValueEditor( const DefinitionInfo& info, QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~NumericValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();

private:
    int m_decimal;
};

/**
* Editor delegate for <tt>DATETIME</tt> attribue values.
*/
class DateTimeValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param info Attribute definition.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    DateTimeValueEditor( const DefinitionInfo& info, QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~DateTimeValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();

private:
    bool m_time;
};

/**
* Editor delegate for <tt>USER</tt> attribue values.
*/
class UserValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param info Attribute definition.
    *
    * @param projectId Optional project identifier for membership context.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    UserValueEditor( const DefinitionInfo& info, int projectId, QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~UserValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();
};

}

#endif
