// This is brl/bseg/bvpl/pro/processes/bvpl_create_edge3d_kernel_process.cxx
#include <bprb/bprb_func_process.h>
//:
// \file
// \brief A class for creating an volume edge kernel
//
// \author Vishal Jain 
// \date June 26, 2009
// \verbatim
//  Modifications
//  <none yet>
// \endverbatim

#include <bprb/bprb_parameters.h>
#include <brdb/brdb_value.h>
#include <bvpl/bvpl_edge3d_kernel_factory.h>


namespace bvpl_create_edge3d_kernel_process_globals
{
  //the specs of this kernel are specified as parameters
  const unsigned n_inputs_ = 0;
  const unsigned n_outputs_ = 1;
}


bool bvpl_create_edge3d_kernel_process_cons(bprb_func_process& pro)
{
  using namespace bvpl_create_edge3d_kernel_process_globals;

  vcl_vector<vcl_string> output_types_(n_outputs_);
  output_types_[0]="bvpl_kernel_sptr";

  if (!pro.set_output_types(output_types_))
    return false;

  //output has no output
  return true;
}

bool bvpl_create_edge3d_kernel_process(bprb_func_process& pro)
{
  using namespace bvpl_create_edge3d_kernel_process_globals;

  if (pro.n_inputs() < n_inputs_)
  {
    vcl_cout << pro.name() << " The input number should be " << n_inputs_<< vcl_endl;
    return false;
  }

  //get inputs:
  unsigned int height = 5;
  pro.parameters()->get_value("height", height);
  unsigned int width = 5;
  pro.parameters()->get_value("width", width);
  unsigned int length = 5;
  pro.parameters()->get_value("length", length);

  float axis_x = 1.0f;
  pro.parameters()->get_value("axis_x", axis_x);
  float axis_y = 0.0f;
  pro.parameters()->get_value("axis_y", axis_y);
  float axis_z = 0.0f;
  pro.parameters()->get_value("axis_z", axis_z);
  float angle= 0.0f;
  pro.parameters()->get_value("angle", angle);

  vnl_float_3 axis(axis_x,axis_y, axis_z);

  //Create the factory
  bvpl_edge3d_kernel_factory factory(length, width,height);
  factory.set_rotation_axis(axis);
  factory.set_angle(angle);

  bvpl_kernel_sptr kernel_sptr = new bvpl_kernel(factory.create());
  kernel_sptr->print();
  pro.set_output_val<bvpl_kernel_sptr>(0, kernel_sptr);

  return true;
}

