// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// File:        lineeditor.h - interface to line editor
//
// Created:     10 Mar 94   Michael Pichler
//
// Changed:     12 Jan 95   Michael Pichler
//
//</file>


#ifndef harmony_widgets_lineeditor_h
#define harmony_widgets_lineeditor_h

#include "libwidgets.h"

//<class>
//
// Name: LineEditor
//
// Purpose: editable string
//          does not care for displaying
//          calls to editing functions with out-of-range indices are ignored
//          "word": continous string of non-spaces
//                  (includes Umlaute and other special characters)
//
//</class>


class LineEditor
{
  public:
    LineEditor(                         // construct a line editor
      const char* str = 0               //   initial string
    );

    ~LineEditor();

    const char* string() const          // get current string, '\0'-terminated,
    { return str_; }                    // returns "" for empty string

    int length() const                  // length of current string
    { return len_; }

    void setString(                     // replace string
      const char* str                   //   by this one
    );

    void clear()                        // clear (delete) current string
    { setString(0); }

    void insertChar(                    // insert char into string
      char c,                           //   character
      int pos                           //   insertion position
    );

    void insertSubstring(               // insert a string into the string
      const char* str,                  //   the substring to be inserted
      int slen,                         //   length of the substring
      int pos                           //   position where to insert
    );

    void prepend(char c)                // prepend char to string
    { insertChar(c, 0); }

    void append(char c)                 // append char to string
    { insertChar(c, len_); }

    void overwrite(                     // overwrite one char of string
      char c,                           //   new character
      int pos                           //   position
    );

    void deleteChar(                    // delete a char of string
      int pos                           //   position of char
    );

    void deleteSubstring(               // delete part of string
      int from,                         //   index of first and
      int behind                        //   character behind last one to delete
    );                                  //   (order of from/behind irrelevant)

    void deleteBackward(int pos)        // delete backward a char of string
    { deleteChar(pos-1); }

    int wordLeft(                       // find word on left side
      int pos                           //   start index
    ) const;                            // returns index of first word char or 0

    int wordRight(                      // find word on right side
      int pos                           //   start index
    ) const;                            // returns index of first word char or length

    void findWord(                      // finds boundings of a word
      int pos,                          //   in:  index inside word to be found
      int& start,                       //   out: index of first char
      int& end                          //   out: character behind word
    ) const;

  private:
    // prevent copying (declared, but not implemented)
    LineEditor (const LineEditor&);
    LineEditor& operator = (const LineEditor&);

    char* str_;
    int len_;
    int bufsize_;  // dynamic

}; // LineEditor


#endif
