/*
etxack.c - Implement etxack transfer protocol
Copyright (C) 2000  Brad LaRonde
Copyright (C) 2001  Jeff Carneal

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include "etxack.h"
#include "port.h"
#include "vrerror.h"
#include "xmodem-load.h"

/*
 * Etxack code originally written by 
 * Brad LaRonde of Agenda Computing
 */

int ex_sendfile(int fd) {
	char c;
	int i;
	int ret;

	for(i=0; i<XML_LINES; i++) {

		port_send(fd, xmodem_load_srec[i], strlen(xmodem_load_srec[i]), NOPORTLOG);
		port_send(fd, "\x03", 1, NOPORTLOG);

		while(1) {
			if((ret = read(fd, &c, 1)) != 1) {
				vr_error("Error: ex_send read '0x%x' instead of ACK", c);
			}
			/*
			 * Mask out parity.
			 * Is this necessary?
			 * -Brad
			 */
			c &= 0x7f;

			if(c == ACK) {
				break;
			}

			if(c == EOF) {
				if(errno == EAGAIN) {
					continue;
				}

				vr_error("Error: ex_send unable to read from serial port");
				return -1;
			}

			if(c == NAK) {
				vr_error("Error:  ex_send received NAK.  Aborting");
			}
		}
	}

	return 0;
}
