/* This is the QT main interface for patinet db project. 
 * It enables the user to log in and show poatient information.
 * More interfaces and functionalities will be integrated.
 */
 
using namespace std;

#include "qt_login.h"
#include <QMessageBox>
#include <QFileInfo>
#include <netdb.h>
#include <iostream>

// external poiter to DBclient, defined before main() function
extern DBclient* dbcp;

/* Simple constructor */
db_login::db_login(QWidget *parent) 
  : QMainWindow(parent) 
{
  buildLogin();
}

/* Build login interface. */
void db_login::buildLogin()
{
  login_form.setupUi(this);
  login_form.account->setFocus();

  // set some default values on client login interface
  login_form.localDir->setText("../env/");
  login_form.serverName->setText("ajax.uphs.upenn.edu");
  login_form.portNo->setText("5556");

  connect(login_form.localButt, SIGNAL(toggled(bool)), this, SLOT(selectLocal(bool)));
  connect(login_form.remoteButt, SIGNAL(toggled(bool)), this, SLOT(selectRemote(bool)));
  connect(login_form.loginButton, SIGNAL(clicked()), this, SLOT(startLogin()));
  connect(login_form.quitButton, SIGNAL(clicked()), this, SLOT(close()));
}

// Desctructor
db_login::~db_login()
{
  if (dbcp) {
    delete dbcp;
    dbcp = NULL;
  }
}

// If local login is selected, enable local and disable remote 
void db_login::selectLocal(bool localFlag)
{
  login_form.localDir->setEnabled(localFlag);
  login_form.serverName->setDisabled(localFlag);
  login_form.portNo->setDisabled(localFlag);

  login_form.account->setEnabled(true);
  login_form.passwd->setEnabled(true);
  login_form.loginButton->setEnabled(true);
}

// If remote login is selected, enable remote and disable local
void db_login::selectRemote(bool rmtFlag)
{
  login_form.localDir->setDisabled(rmtFlag);
  login_form.serverName->setEnabled(rmtFlag);
  login_form.portNo->setEnabled(rmtFlag);

  login_form.account->setEnabled(true);
  login_form.passwd->setEnabled(true);
  login_form.loginButton->setEnabled(true);
}

// Check information in the form and submit to user database
void db_login::startLogin()
{
  if (!chkLoginFields())
    return;

  string username = loginName.toStdString();
  string passwd = login_form.passwd->text().toStdString();
  // local login
  if (login_form.localButt->isChecked()) {
    QString dirStr = login_form.localDir->text();
    if (!dirStr.endsWith('/'))
      dirStr.append('/');
    string envHome = dirStr.toStdString();
    dbcp = new localClient(username, passwd, envHome);
  }
  // remote login
  else {
    QString serverStr = login_form.serverName->text();
    QString portStr = login_form.portNo->text();
    string srvName = serverStr.toStdString();
    int srvPort = portStr.toInt();
    dbcp = new remoteClient(username, passwd, srvName, srvPort);
  }  

  if (dbcp->login()) {
    QMessageBox::critical(0, "error", QString::fromStdString(dbcp->getErrMsg()));
    return;
  }

  buildMain();
}

/* This function checks fields on login interface. */
bool db_login::chkLoginFields()
{
  QString header = "<html><body><p><span style=\" font-size:10pt; font-weight:600; color:#ff0000;\">";
  QString tail = "</span></p></body></html>";
  QString tmpStr;
  // Is account field blank?
  loginName = login_form.account->text();
  QString inputPasswd = login_form.passwd->text();

  if (login_form.localButt->isChecked()) {
    if (login_form.localDir->text().isEmpty()) {
      tmpStr = "Local database path not set.";
      login_form.info->setText(header + tmpStr + tail);
      return false;
    }
    QFileInfo dirInfo(login_form.localDir->text());
    if (!dirInfo.isDir()) {
      tmpStr = login_form.localDir->text() + "is NOT a directory.";
      login_form.info->setText(header + tmpStr + tail);
      return false;
    }
    if (!dirInfo.isReadable()) {
      tmpStr = login_form.localDir->text() + "is NOT readable.";
      login_form.info->setText(header + tmpStr + tail);
      return false;
    }
  }

  if (login_form.remoteButt->isChecked()) {
    if (login_form.serverName->text().isEmpty()) {
      tmpStr = "Remote database server name not set.";
      login_form.info->setText(header + tmpStr + tail);
      return false;
    }
    if (login_form.portNo->text().isEmpty()) {
      tmpStr = "Remote database server port number not set.";
      login_form.info->setText(header + tmpStr + tail);
      return false;
    }
  }

  if (loginName.isEmpty() && inputPasswd.isEmpty()) {
    tmpStr = "Account name and password are required.";
    login_form.info->setText(header + tmpStr + tail);
    return false;
  }

  if (loginName.isEmpty()) {
    tmpStr = "Account name is required.";
    login_form.info->setText(header + tmpStr + tail);
    return false;
  }

  if (inputPasswd.isEmpty()) {
    tmpStr = "Password is required for " + loginName + ".";
    login_form.info->setText(header + tmpStr + tail);
    login_form.passwd->setFocus();
    return false;
  }

  return true;
}

/* This function clears login form and build the main interface after usr login */
void db_login::buildMain()
{
  main_form.setupUi(this);
  QString tmpStr = "You have logged in as " + loginName + 
    ". If you are not, please log out.";
  main_form.login_info->setText(tmpStr);
  
  //   if (loginName != "admin")
  //     main_form.userAdmin->hide();

  // signal-slot pairs on main form
  connect(main_form.searchButt, SIGNAL(clicked()), this, SLOT(clickSearch()));
  //   connect(main_form.viewPatient, SIGNAL(clicked()), this, SLOT(viewPatient()));
  //   connect(main_form.viewStudy, SIGNAL(clicked()), this, SLOT(viewStudy()));
  connect(main_form.accountUpdate, SIGNAL(clicked()), this, SLOT(updateAccount()));

  //connect(main_form.editRec, SIGNAL(clicked()), this, SLOT(showEditRec()));
  QMenu *erMenu = new QMenu();
  erMenu->addAction("Add New Records");
  erMenu->addAction("Modify Records");
  erMenu->addAction("Show Records");
  main_form.editRec->setMenu(erMenu);

  connect(main_form.userAdmin, SIGNAL(clicked()), this, SLOT(showUserAdmin()));
  connect(main_form.logout, SIGNAL(clicked()), this, SLOT(logout()));
}

// This slot shows the "search database" interface. */
void db_login::clickSearch()
{
  SearchPatient *sp_form = new SearchPatient();
  sp_form->show();
}

// Send account information to the terminal
void db_login::updateAccount()
{
//   const char *c2s = "get account";
//   gnutls_record_send(session, c2s, strlen(c2s));

//   //char *s2c = 0;
//   char s2c[BUFSIZE + 1];
//   gnutls_record_recv(session, s2c, BUFSIZE);
//   userRec myInfo((void *) s2c);
//   myInfo.show();

}

/* Show the interface of "Edit record". */
void db_login::showEditRec()
{
//   QMainWindow * editRec_mw = new QMainWindow();
//   Ui_edit_record editRec_form;
//   editRec_form.setupUi(editRec_mw);
//   editRec_mw->show();

  //QMenu erMenu;
  //erMenu.addAction("test1");
  //erMenu.addAction("test2");
  //erMenu.exec(QCursor::pos());
}

/* Show the interface of "User adninistration". */
void db_login::showUserAdmin()
{
  QMainWindow * adminUser_mw = new QMainWindow();
  Ui_admin_user adminUser_form;
  adminUser_form.setupUi(adminUser_mw);
  adminUser_mw->show();
  connect(adminUser_form.addNew, SIGNAL(clicked()), this, SLOT(addNewUser()));
}

/* This slot shows "Add new User" interface. */
void db_login::addNewUser()
{
  newUser *newUser_mw = new newUser();
  newUser_mw->show();
}

/* This slot clears main interface and goes back to login form */
void db_login::logout()
{
  if (dbcp) {
    delete dbcp;
    dbcp = NULL;
  }

  buildLogin();  
  QString tmpStr = loginName + " has logged out.";
  login_form.info->setText(tmpStr);

  // remember the last login method
  //if (localLogin) {
  //  login_form.localButt->setChecked(true);
    //selectLocal(true);
  //}
  //else {
  //  login_form.remoteButt->setChecked(true);
  //  selectRemote(true);
  //}
}

