/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include <string>
#include <list>
#include <map>
/* -- */
#include "trace/values/Values.hpp"
#include "trace/ContainerType.hpp"
#include "trace/EntityValue.hpp"
#include "trace/EntityType.hpp"
/* -- */
using namespace std;

EntityType::EntityType(Name name, ContainerType *container_type, map<std::string, Value *> opt):
    _name(name), _container_type(container_type), _extra_fields(opt) {

}

void EntityType::add_value(EntityValue *value) {
    _values.push_back(value);
}

Name EntityType::get_name() const {
    return _name;
}

const ContainerType *EntityType::get_container_type() const {
    return _container_type;
}

const list<EntityValue *> *EntityType::get_values() const {
    return &_values;
}

EntityType::~EntityType(){
    // Destruction of the list _values
    // As long as everything has not been cleaned
    while (!_values.empty()) {
        delete _values.front();
        _values.pop_front();
    }

    _container_type = NULL;

    map<std::string , Value * >::iterator cur = _extra_fields.end();
   for(map<std::string, Value *>::iterator it = _extra_fields.begin();
        it != cur;
        it++){
        delete (*it).second;
    }
   _extra_fields.clear();
}

const map<std::string, Value *> *EntityType::get_extra_fields() const {
    return &_extra_fields;
}

