/*
**  This file is part of Vidalia, and is subject to the license terms in the
**  LICENSE file, found in the top level directory of this distribution. If you
**  did not receive the LICENSE file with this file, you may obtain it from the
**  Vidalia source package distributed by the Vidalia Project at
**  http://www.torproject.org/projects/vidalia.html. No part of Vidalia, 
**  including this file, may be copied, modified, propagated, or distributed 
**  except according to the terms described in the LICENSE file.
*/

/*
** \file CrashReportDialog.h
** \brief Dialog that asks the user whether they would like to
** submit the crash report, along with optional additional details
** about what they were doing at the time of the crash.
*/

#include "ui_CrashReportDialog.h"

#include <QHash>
#include <QByteArray>

class QString;


class CrashReportDialog : public QDialog
{
  Q_OBJECT

public:
  /** Default constructor.
   */
  CrashReportDialog(QWidget *parent = 0);

  /** Sets the crash <b>annotations</b> key-value pairs associated with
   * the generated minidump.
   */
  void setCrashAnnotations(const QHash<QString,QString> &annotations);

  /** Sets the <b>minidump</b> contents generated by the crashed
   * applications exception handler.
   */
  void setMinidumpFiles(const QString &minidump, const QString &annotations);

public slots:
  /** Called when the user clicks the "Restart Vidalia" button on the
   * dialog. If the "Submit my crash report..." checkbox is checked, it
   * will first attempt to submit the crash report. After that is complete,
   * it will try to restart the Vidalia process with any arguments specified
   * in the crash annotations file.
   * \sa setCrashAnnotations()
   */
  virtual void accept();

private:
  /** Minidump path
   */
  QString _minidumpPath;

  /** Minidump info path
   */
  QString _annotationsPath;

  /** Set of parsed key-value pairs generated by the crashed application's
   * exception handler and written alongside the minidump.
   */
  QHash<QString,QString> _annotations;

  /** Qt Designer created object.
   */
  Ui::CrashReportDialog ui;
};

