/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.fop.apps.FOPException;
import org.apache.fop.dom.svg.SVGAnimatedLengthImpl;
import org.apache.fop.dom.svg.SVGAnimatedStringImpl;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.dom.svg.SVGDocumentImpl;
import org.apache.fop.dom.svg.SVGElementImpl;
import org.apache.fop.dom.svg.SVGLengthImpl;
import org.apache.fop.dom.svg.SVGSVGElementImpl;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.svg.GraphicsCreator;
import org.apache.fop.svg.SVGLengthProperty;
import org.apache.fop.svg.SVGStyle;
import org.apache.fop.svg.SVGTransform;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVG
extends FObj
implements GraphicsCreator {
    FontState fs;
    float width;
    float height;

    public SVG(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "svg:svg";
    }

    public SVGElement createGraphic() {
        SVGSVGElementImpl sVGSVGElementImpl = null;
        SVGLengthImpl sVGLengthImpl = ((SVGLengthProperty)this.properties.get("width")).getSVGLength();
        SVGLengthImpl sVGLengthImpl2 = ((SVGLengthProperty)this.properties.get("height")).getSVGLength();
        sVGSVGElementImpl = new SVGSVGElementImpl();
        if (sVGLengthImpl == null) {
            sVGLengthImpl = new SVGLengthImpl();
        }
        SVGAnimatedLengthImpl sVGAnimatedLengthImpl = new SVGAnimatedLengthImpl(sVGLengthImpl);
        sVGAnimatedLengthImpl.setBaseVal(sVGLengthImpl);
        sVGSVGElementImpl.setWidth(sVGAnimatedLengthImpl);
        if (sVGLengthImpl2 == null) {
            sVGLengthImpl2 = new SVGLengthImpl();
        }
        sVGAnimatedLengthImpl = new SVGAnimatedLengthImpl(sVGLengthImpl2);
        sVGAnimatedLengthImpl.setBaseVal(sVGLengthImpl2);
        sVGSVGElementImpl.setHeight(sVGAnimatedLengthImpl);
        SVGLengthImpl sVGLengthImpl3 = ((SVGLengthProperty)this.properties.get("x")).getSVGLength();
        SVGLengthImpl sVGLengthImpl4 = sVGLengthImpl3 == null ? new SVGLengthImpl() : sVGLengthImpl3;
        sVGAnimatedLengthImpl = new SVGAnimatedLengthImpl(sVGLengthImpl4);
        sVGAnimatedLengthImpl.setBaseVal(sVGLengthImpl4);
        sVGSVGElementImpl.setX(sVGAnimatedLengthImpl);
        sVGLengthImpl3 = ((SVGLengthProperty)this.properties.get("y")).getSVGLength();
        SVGLengthImpl sVGLengthImpl5 = sVGLengthImpl3 == null ? new SVGLengthImpl() : sVGLengthImpl3;
        sVGAnimatedLengthImpl = new SVGAnimatedLengthImpl(sVGLengthImpl5);
        sVGAnimatedLengthImpl.setBaseVal(sVGLengthImpl5);
        sVGSVGElementImpl.setY(sVGAnimatedLengthImpl);
        sVGSVGElementImpl.setStyle(((SVGStyle)this.properties.get("style")).getStyle());
        sVGSVGElementImpl.setTransform(((SVGTransform)this.properties.get("transform")).getTransform());
        sVGSVGElementImpl.setId(this.properties.get("id").getString());
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            SVGElement sVGElement;
            FONode fONode = (FONode)this.children.elementAt(n2);
            if (fONode instanceof GraphicsCreator && (sVGElement = ((GraphicsCreator)((Object)fONode)).createGraphic()) != null) {
                if (sVGElement instanceof SVGElementImpl) {
                    ((SVGElementImpl)sVGElement).setClassName(new SVGAnimatedStringImpl(((FObj)fONode).getProperty("class").getString()));
                }
                sVGSVGElementImpl.appendChild((Node)sVGElement);
            }
            ++n2;
        }
        return sVGSVGElementImpl;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        Object object3;
        if (!(area instanceof ForeignObjectArea)) {
            throw new FOPException("SVG not in fo:instream-foreign-object");
        }
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            object3 = this.properties.get("id").getString();
            object2 = this.properties.get("font-family").getString();
            object = this.properties.get("font-style").getString();
            String string = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object2, (String)object, string, n, 1);
            SVGLengthImpl sVGLengthImpl = ((SVGLengthProperty)this.properties.get("width")).getSVGLength();
            if (sVGLengthImpl == null) {
                sVGLengthImpl = new SVGLengthImpl();
            }
            this.width = sVGLengthImpl.getValue();
            sVGLengthImpl = ((SVGLengthProperty)this.properties.get("height")).getSVGLength();
            if (sVGLengthImpl == null) {
                sVGLengthImpl = new SVGLengthImpl();
            }
            this.height = sVGLengthImpl.getValue();
            this.marker = 0;
        }
        object3 = new SVGArea(this.fs, this.width, this.height);
        object2 = new SVGDocumentImpl();
        ((SVGArea)object3).setSVGDocument((SVGDocument)object2);
        ((Area)object3).start();
        object = (ForeignObjectArea)area;
        ((ForeignObjectArea)object).setObject((Area)object3);
        ((ForeignObjectArea)object).setIntrinsicWidth(((SVGArea)object3).getWidth());
        ((ForeignObjectArea)object).setIntrinsicHeight(((Area)object3).getHeight());
        object2.appendChild((Node)((SVGSVGElement)this.createGraphic()));
        ((Area)object3).end();
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SVG(fObj, propertyList);
        }
    }
}

