/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontFileReader {
    private int fsize;
    private int current;
    private byte[] file;

    public FontFileReader(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(fileInputStream, (int)(file.length() + 1L), (int)(file.length() / 10L));
        fileInputStream.close();
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    private void init(InputStream inputStream, int n, int n2) throws IOException {
        this.fsize = 0;
        this.current = 0;
        this.file = new byte[n];
        int n3 = inputStream.read(this.file, 0, n);
        this.fsize += n3;
        if (n3 == n) {
            while (n3 > 0) {
                byte[] byArray = new byte[this.file.length + n2];
                System.arraycopy(this.file, 0, byArray, 0, this.file.length);
                n3 = inputStream.read(byArray, this.file.length, n2);
                this.fsize += n3;
                this.file = byArray;
                if (n3 >= n2) continue;
                n3 = 0;
            }
        }
    }

    public byte read() throws IOException {
        if (this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte by = this.file[this.current++];
        return by;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFLong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return (int)l;
    }

    public final short readTTFShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short s = (short)n;
        return s;
    }

    public final String readTTFString() throws IOException {
        int n = this.current;
        while (this.file[n++] != 0) {
            if (n <= this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n - this.current];
        System.arraycopy(this.file, this.current, byArray, 0, n - this.current);
        return new String(byArray, "ISO-8859-1");
    }

    public final String readTTFString(int n) throws IOException {
        if (n + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.file, this.current, byArray, 0, n);
        this.current += n;
        return new String(byArray, "ISO-8859-1");
    }

    public final int readTTFUByte() throws IOException {
        byte by = this.read();
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    public final long readTTFULong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return l;
    }

    public final int readTTFUShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return n;
    }

    public void seek_add(long l) throws IOException {
        this.seek_set((long)this.current + l);
    }

    public void seek_set(long l) throws IOException {
        if (l > (long)this.fsize || l < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + l);
        }
        this.current = (int)l;
    }

    public void skip(long l) throws IOException {
        this.seek_add(l);
    }
}

