/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath.function;

import com.werken.xpath.function.Function;
import com.werken.xpath.impl.Context;
import java.util.List;

public class BooleanFunction
implements Function {
    public Object call(Context context, List args) {
        if (args.size() == 1) {
            return BooleanFunction.evaluate(args.get(0));
        }
        return null;
    }

    public static Boolean evaluate(Object obj) {
        boolean result = false;
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Double) {
            if (!((Double)obj).isNaN() && (Double)obj != 0.0) {
                result = true;
            }
        } else if (obj instanceof List) {
            result = ((List)obj).size() > 0;
        } else if (obj instanceof String) {
            result = ((String)obj).length() > 0;
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }
}

