/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#define _VECTORMATH_AOS_TEST

#include "vectormath_aos.h"
#include "test.h"

int iteration = 0;

void
Vector3_methods_test()
{
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, aos_Vector3_0, aos_Vector3_1, aos_Vector3_2, aos_Vector3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2;
    VmathVector3 tmpV3_8, tmpV3_9;
    VmathPoint3 tmpP3_0;
    VmathVector3 tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13, tmpV3_14, tmpV3_15, tmpV3_16, tmpV3_17, tmpV3_18, tmpV3_19, tmpV3_20, tmpV3_21, tmpV3_22, tmpV3_23, tmpV3_24, tmpV3_25;
    float rndflt1, rndflt2, rndflt3, rndflt4, pad;
    float xyz4[12] __attribute__ ((aligned(16)));
#ifndef _VECTORMATH_SCALAR_TEST
    vec_float4 quad;
#endif
    xyz4[0] = randfloat();
    xyz4[1] = randfloat();
    xyz4[2] = randfloat();
    xyz4[3] = randfloat();
    xyz4[4] = randfloat();
    xyz4[5] = randfloat();
    xyz4[6] = randfloat();
    xyz4[7] = randfloat();
    xyz4[8] = randfloat();
    xyz4[9] = randfloat();
    xyz4[10] = randfloat();
    xyz4[11] = randfloat();
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3MakeFromScalar( &c_Vector3, 0.0f );
    vmathV3MakeFromScalar( &d_Vector3, 0.0f );
    vmathV3MakeFromScalar( &e_Vector3, 0.0f );
    vmathV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4MakeFromScalar( &c_Vector4, 0.0f );
    vmathV4MakeFromScalar( &d_Vector4, 0.0f );
    vmathV4MakeFromScalar( &e_Vector4, 0.0f );
    vmathV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3MakeFromScalar( &c_Point3, 0.0f );
    vmathP3MakeFromScalar( &d_Point3, 0.0f );
    vmathP3MakeFromScalar( &e_Point3, 0.0f );
    vmathP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQMakeFromScalar( &c_Quat, 0.0f );
    vmathQMakeFromScalar( &d_Quat, 0.0f );
    vmathQMakeFromScalar( &e_Quat, 0.0f );
    vmathQPrints( &c_Quat, "set Quat elements to zero" );
    vmathQPrints( &d_Quat, "set Quat elements to zero" );
    vmathQPrints( &e_Quat, "set Quat elements to zero" );
    vmathV3MakeFromP3( &a_Vector3, &a_Point3 );
    vmathV3Prints( &a_Vector3, "construct Vector3 with Point3" );
    vmathV3MakeFromScalar( &a_Vector3, randfloat() );
    vmathV3Prints( &a_Vector3, "set Vector3 with float" );
    vmathV3MakeFromScalar( &a_Vector3, randfloat() );
    vmathV3Prints( &a_Vector3, "set Vector3 with float" );
    vmathV3MakeFromElems( &aos_Vector3_0, 0.0f, 1.0f, 2.0f );
    vmathV3MakeFromElems( &aos_Vector3_1, 3.0f, 4.0f, 5.0f );
    vmathV3MakeFromElems( &aos_Vector3_2, 6.0f, 7.0f, 8.0f );
    vmathV3MakeFromElems( &aos_Vector3_3, 9.0f, 10.0f, 11.0f );
    vmathV3Prints( &aos_Vector3_3, "aos type 0" );
    vmathV3Prints( &aos_Vector3_2, "aos type 1" );
    vmathV3Prints( &aos_Vector3_1, "aos type 2" );
    vmathV3Prints( &aos_Vector3_0, "aos type 3" );
    vmathV3Select( &tmpV3_4, &a_Vector3, &b_Vector3, 0 );
    vmathV3Prints( &tmpV3_4, "select 0" );
    vmathV3Select( &tmpV3_5, &a_Vector3, &b_Vector3, 1 );
    vmathV3Prints( &tmpV3_5, "select 1" );
    vmathV3Select( &tmpV3_6, &a_Vector3, &b_Vector3, 0 );
    vmathV3Prints( &tmpV3_6, "select 2" );
    vmathV3Select( &tmpV3_7, &a_Vector3, &b_Vector3, (unsigned int)-1 );
    vmathV3Prints( &tmpV3_7, "select 3" );
    vmathV3MakeFromElems( &a_Vector3, xyz4[0], xyz4[1], xyz4[2] );
    vmathV3Prints( &a_Vector3, "load XYZ array" );
    xyz4[0] = -xyz4[0];
    xyz4[1] = -xyz4[1];
    xyz4[2] = -xyz4[2];
    xyz4[3] = -xyz4[3];
    xyz4[4] = -xyz4[4];
    xyz4[5] = -xyz4[5];
    xyz4[6] = -xyz4[6];
    xyz4[7] = -xyz4[7];
    xyz4[8] = -xyz4[8];
    xyz4[9] = -xyz4[9];
    xyz4[10] = -xyz4[10];
    xyz4[11] = -xyz4[11];
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
#ifndef _VECTORMATH_SCALAR_TEST
    vmathV3LoadXYZArray( &aos_Vector3_0, &aos_Vector3_1, &aos_Vector3_2, &aos_Vector3_3, (const vec_float4 *)xyz4 );
    xyz4[0] = 0;
    xyz4[1] = 1;
    xyz4[2] = 2;
    xyz4[3] = 3;
    xyz4[4] = 4;
    xyz4[5] = 5;
    xyz4[6] = 6;
    xyz4[7] = 7;
    xyz4[8] = 8;
    xyz4[9] = 9;
    xyz4[10] = 10;
    xyz4[11] = 11;
    vmathV3StoreXYZArray( &aos_Vector3_0, &aos_Vector3_1, &aos_Vector3_2, &aos_Vector3_3, (vec_float4 *)xyz4 );
#endif
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
#ifdef _VECTORMATH_SCALAR_TEST
    printf("storeXYZ:-1.0 -2.0 -3.0 0.4\n");
#else
    quad = (vec_float4){-1.0f, -2.0f, -3.0f, -4.0f};
    a_Vector3.vec128 = quad;
    quad = (vec_float4){0.1f, 0.2f, 0.3f, 0.4f};
    vmathV3StoreXYZ( &a_Vector3, &quad );
    printf("storeXYZ:%f %f %f %f\n", ((float *)&quad)[0], ((float *)&quad)[1], ((float *)&quad)[2], ((float *)&quad)[3]);
#endif
    vmathV3Copy( &a_Vector3, &b_Vector3 );
    vmathV3Prints( &a_Vector3, "assign to Vector3 from Vector3" );
    vmathV3MakeFromScalar( &a_Vector3, 0.0f );
    vmathV3Prints( &a_Vector3, "set Vector3 elements to zero" );
    vmathV3MakeXAxis( &a_Vector3 );
    vmathV3Prints( &a_Vector3, "set to x axis" );
    vmathV3MakeYAxis( &a_Vector3 );
    vmathV3Prints( &a_Vector3, "set to y axis" );
    vmathV3MakeZAxis( &a_Vector3 );
    vmathV3Prints( &a_Vector3, "set to z axis" );
    vmathV3SetElem( &a_Vector3, 0, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::set( 0, float )" );
    vmathV3SetElem( &a_Vector3, 0, randfloat() );
    vmathV3SetElem( &a_Vector3, 0, ( vmathV3GetElem( &a_Vector3, 0 ) * randfloat() ) );
    vmathV3SetElem( &a_Vector3, 0, ( vmathV3GetElem( &a_Vector3, 0 ) / randfloat() ) );
    vmathV3SetElem( &a_Vector3, 0, ( vmathV3GetElem( &a_Vector3, 0 ) + randfloat() ) );
    vmathV3SetElem( &a_Vector3, 0, ( vmathV3GetElem( &a_Vector3, 0 ) - randfloat() ) );
    vmathV3Prints( &a_Vector3, "Vector3::operator [](0)" );
    vmathV3SetX( &a_Vector3, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::setX()" );
    vmathV3SetElem( &a_Vector3, 1, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::set( 1, float )" );
    vmathV3SetElem( &a_Vector3, 1, randfloat() );
    vmathV3SetElem( &a_Vector3, 1, ( vmathV3GetElem( &a_Vector3, 1 ) * randfloat() ) );
    vmathV3SetElem( &a_Vector3, 1, ( vmathV3GetElem( &a_Vector3, 1 ) / randfloat() ) );
    vmathV3SetElem( &a_Vector3, 1, ( vmathV3GetElem( &a_Vector3, 1 ) + randfloat() ) );
    vmathV3SetElem( &a_Vector3, 1, ( vmathV3GetElem( &a_Vector3, 1 ) - randfloat() ) );
    vmathV3Prints( &a_Vector3, "Vector3::operator [](1)" );
    vmathV3SetY( &a_Vector3, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::setY()" );
    vmathV3SetElem( &a_Vector3, 2, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::set( 2, float )" );
    vmathV3SetElem( &a_Vector3, 2, randfloat() );
    vmathV3SetElem( &a_Vector3, 2, ( vmathV3GetElem( &a_Vector3, 2 ) * randfloat() ) );
    vmathV3SetElem( &a_Vector3, 2, ( vmathV3GetElem( &a_Vector3, 2 ) / randfloat() ) );
    vmathV3SetElem( &a_Vector3, 2, ( vmathV3GetElem( &a_Vector3, 2 ) + randfloat() ) );
    vmathV3SetElem( &a_Vector3, 2, ( vmathV3GetElem( &a_Vector3, 2 ) - randfloat() ) );
    vmathV3Prints( &a_Vector3, "Vector3::operator [](2)" );
    vmathV3SetZ( &a_Vector3, randfloat() );
    vmathV3Prints( &a_Vector3, "Vector3::setZ()" );
    printf("Vector3::get( 0 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 0 )) );
    printf("Vector3::operator []( 0 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 0 )) );
    printf("Vector3::getX(): %f\n", getfloat(vmathV3GetX( &a_Vector3 )) );
    printf("Vector3::get( 1 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 1 )) );
    printf("Vector3::operator []( 1 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 1 )) );
    printf("Vector3::getY(): %f\n", getfloat(vmathV3GetY( &a_Vector3 )) );
    printf("Vector3::get( 2 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 2 )) );
    printf("Vector3::operator []( 2 ): %f\n", getfloat(vmathV3GetElem( &a_Vector3, 2 )) );
    printf("Vector3::getZ(): %f\n", getfloat(vmathV3GetZ( &a_Vector3 )) );
    vmathV3Add( &tmpV3_8, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_8, "Vector3 + Vector3" );
    vmathV3Sub( &tmpV3_9, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_9, "Vector3 - Vector3" );
    vmathV3AddP3( &tmpP3_0, &a_Vector3, &b_Point3 );
    vmathP3Prints( &tmpP3_0, "Vector3 + Point3" );
    vmathV3ScalarMul( &tmpV3_10, &a_Vector3, randfloat() );
    vmathV3Prints( &tmpV3_10, "Vector3 * float" );
    vmathV3ScalarDiv( &tmpV3_11, &a_Vector3, randfloat() );
    vmathV3Prints( &tmpV3_11, "Vector3 / float" );
    vmathV3ScalarMul( &tmpV3_12, &a_Vector3, randfloat() );
    vmathV3Prints( &tmpV3_12, "float * Vector3" );
    vmathV3Neg( &tmpV3_13, &a_Vector3 );
    vmathV3Prints( &tmpV3_13, "Vector3 negate" );
    vmathV3MulPerElem( &tmpV3_14, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_14, "mulPerElem( Vector3, Vector3 )" );
    vmathV3DivPerElem( &tmpV3_15, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_15, "divPerElem( Vector3, Vector3 )" );
    vmathV3RecipPerElem( &tmpV3_16, &a_Vector3 );
    vmathV3Prints( &tmpV3_16, "Vector3 recip" );
    vmathV3AbsPerElem( &tmpV3_17, &a_Vector3 );
    vmathV3SqrtPerElem( &tmpV3_18, &tmpV3_17 );
    vmathV3Prints( &tmpV3_18, "Vector3 sqrt" );
    vmathV3AbsPerElem( &tmpV3_19, &a_Vector3 );
    vmathV3RsqrtPerElem( &tmpV3_20, &tmpV3_19 );
    vmathV3Prints( &tmpV3_20, "Vector3 rsqrt" );
    vmathV3AbsPerElem( &tmpV3_21, &a_Vector3 );
    vmathV3Prints( &tmpV3_21, "Vector3 abs" );
    vmathV3CopySignPerElem( &tmpV3_22, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_22, "Vector3 copySign" );
    vmathV3MaxPerElem( &tmpV3_23, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_23, "Vector3 maximum Vector3" );
    vmathV3MinPerElem( &tmpV3_24, &a_Vector3, &b_Vector3 );
    vmathV3Prints( &tmpV3_24, "Vector3 minimum Vector3" );
    printf("Vector3 maximum of elements: %f\n", getfloat(vmathV3MaxElem( &a_Vector3 )));
    printf("Vector3 minimum of elements: %f\n", getfloat(vmathV3MinElem( &a_Vector3 )));
    printf("Vector3 sum of elements: %f\n", getfloat(vmathV3Sum( &a_Vector3 )));
    printf("Vector3 dot Vector3: %f\n", getfloat(vmathV3Dot( &a_Vector3, &b_Vector3 )));
    printf("Vector3 lengthSqr: %f\n", getfloat(vmathV3LengthSqr( &a_Vector3 )));
    printf("Vector3 length: %f\n", getfloat(vmathV3Length( &a_Vector3 )));
    vmathV3Normalize( &tmpV3_25, &a_Vector3 );
    vmathV3Prints( &tmpV3_25, "Vector3 normalized" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &e_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV3Normalize( &b_Vector3, &b_Vector3 );
    vmathV3Normalize( &c_Vector3, &c_Vector3 );
    vmathV3Normalize( &d_Vector3, &d_Vector3 );
    vmathV3Normalize( &e_Vector3, &e_Vector3 );
    vmathV3Lerp( &a_Vector3, randfloat(), &b_Vector3, &c_Vector3 );
    vmathV3Prints( &a_Vector3, "Vector3 lerp" );
    vmathV3Slerp( &a_Vector3, randfloat(), &b_Vector3, &c_Vector3 );
    vmathV3Prints( &a_Vector3, "Vector3 slerp" );
}

void
Vector4_methods_test()
{
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2, aos_Vector4_3, tmpV4_0, tmpV4_1, tmpV4_2, tmpV4_3;
    VmathVector3 tmpV3_4;
    VmathVector4 tmpV4_4, tmpV4_5, tmpV4_6, tmpV4_7, tmpV4_8, tmpV4_9, tmpV4_10, tmpV4_11, tmpV4_12, tmpV4_13, tmpV4_14, tmpV4_15, tmpV4_16, tmpV4_17, tmpV4_18, tmpV4_19, tmpV4_20, tmpV4_21;
    float rndflt1, rndflt2, rndflt3, rndflt4, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3MakeFromScalar( &c_Vector3, 0.0f );
    vmathV3MakeFromScalar( &d_Vector3, 0.0f );
    vmathV3MakeFromScalar( &e_Vector3, 0.0f );
    vmathV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4MakeFromScalar( &c_Vector4, 0.0f );
    vmathV4MakeFromScalar( &d_Vector4, 0.0f );
    vmathV4MakeFromScalar( &e_Vector4, 0.0f );
    vmathV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3MakeFromScalar( &c_Point3, 0.0f );
    vmathP3MakeFromScalar( &d_Point3, 0.0f );
    vmathP3MakeFromScalar( &e_Point3, 0.0f );
    vmathP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQMakeFromScalar( &c_Quat, 0.0f );
    vmathQMakeFromScalar( &d_Quat, 0.0f );
    vmathQMakeFromScalar( &e_Quat, 0.0f );
    vmathQPrints( &c_Quat, "set Quat elements to zero" );
    vmathQPrints( &d_Quat, "set Quat elements to zero" );
    vmathQPrints( &e_Quat, "set Quat elements to zero" );
    vmathV4MakeFromV3Scalar( &a_Vector4, &a_Vector3, randfloat() );
    vmathV4Prints( &a_Vector4, "set Vector4 with Vector3, float" );
    vmathV4MakeFromV3( &a_Vector4, &a_Vector3 );
    vmathV4Prints( &a_Vector4, "set Vector4 with Vector3" );
    vmathV4MakeFromP3( &a_Vector4, &a_Point3 );
    vmathV4Prints( &a_Vector4, "set Vector4 with Point3" );
    vmathV4MakeFromQ( &a_Vector4, &a_Quat );
    vmathV4Prints( &a_Vector4, "construct Vector4 with Quat" );
    vmathV4MakeFromScalar( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "set Vector4 with float" );
    vmathV4MakeFromScalar( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "set Vector4 with float" );
    vmathV4MakeFromElems( &aos_Vector4_0, 0.0f, 1.0f, 2.0f, 3.0f );
    vmathV4MakeFromElems( &aos_Vector4_1, 4.0f, 5.0f, 6.0f, 7.0f );
    vmathV4MakeFromElems( &aos_Vector4_2, 8.0f, 9.0f, 10.0f, 11.0f );
    vmathV4MakeFromElems( &aos_Vector4_3, 12.0f, 13.0f, 14.0f, 15.0f );
    vmathV4Prints( &aos_Vector4_3, "aos type 0" );
    vmathV4Prints( &aos_Vector4_2, "aos type 1" );
    vmathV4Prints( &aos_Vector4_1, "aos type 2" );
    vmathV4Prints( &aos_Vector4_0, "aos type 3" );
    vmathV4Select( &tmpV4_0, &a_Vector4, &b_Vector4, 0 );
    vmathV4Prints( &tmpV4_0, "select 0" );
    vmathV4Select( &tmpV4_1, &a_Vector4, &b_Vector4, 1 );
    vmathV4Prints( &tmpV4_1, "select 1" );
    vmathV4Select( &tmpV4_2, &a_Vector4, &b_Vector4, 0 );
    vmathV4Prints( &tmpV4_2, "select 2" );
    vmathV4Select( &tmpV4_3, &a_Vector4, &b_Vector4, (unsigned int)-1 );
    vmathV4Prints( &tmpV4_3, "select 3" );
    vmathV4Copy( &a_Vector4, &b_Vector4 );
    vmathV4Prints( &a_Vector4, "assign to Vector4 from Vector4" );
    vmathV4SetXYZ( &a_Vector4, &a_Vector3 );
    vmathV4Prints( &a_Vector4, "set Vector4 xyz" );
    vmathV4GetXYZ( &tmpV3_4, &a_Vector4 );
    vmathV3Prints( &tmpV3_4, "get Vector4 xyz" );
    vmathV4MakeFromScalar( &a_Vector4, 0.0f );
    vmathV4Prints( &a_Vector4, "set Vector4 elements to zero" );
    vmathV4MakeXAxis( &a_Vector4 );
    vmathV4Prints( &a_Vector4, "set to x axis" );
    vmathV4MakeYAxis( &a_Vector4 );
    vmathV4Prints( &a_Vector4, "set to y axis" );
    vmathV4MakeZAxis( &a_Vector4 );
    vmathV4Prints( &a_Vector4, "set to z axis" );
    vmathV4MakeWAxis( &a_Vector4 );
    vmathV4Prints( &a_Vector4, "set to w axis" );
    vmathV4SetElem( &a_Vector4, 0, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::set( 0, float )" );
    vmathV4SetElem( &a_Vector4, 0, randfloat() );
    vmathV4SetElem( &a_Vector4, 0, ( vmathV4GetElem( &a_Vector4, 0 ) * randfloat() ) );
    vmathV4SetElem( &a_Vector4, 0, ( vmathV4GetElem( &a_Vector4, 0 ) / randfloat() ) );
    vmathV4SetElem( &a_Vector4, 0, ( vmathV4GetElem( &a_Vector4, 0 ) + randfloat() ) );
    vmathV4SetElem( &a_Vector4, 0, ( vmathV4GetElem( &a_Vector4, 0 ) - randfloat() ) );
    vmathV4Prints( &a_Vector4, "Vector4::operator [](0)" );
    vmathV4SetX( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::setX()" );
    vmathV4SetElem( &a_Vector4, 1, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::set( 1, float )" );
    vmathV4SetElem( &a_Vector4, 1, randfloat() );
    vmathV4SetElem( &a_Vector4, 1, ( vmathV4GetElem( &a_Vector4, 1 ) * randfloat() ) );
    vmathV4SetElem( &a_Vector4, 1, ( vmathV4GetElem( &a_Vector4, 1 ) / randfloat() ) );
    vmathV4SetElem( &a_Vector4, 1, ( vmathV4GetElem( &a_Vector4, 1 ) + randfloat() ) );
    vmathV4SetElem( &a_Vector4, 1, ( vmathV4GetElem( &a_Vector4, 1 ) - randfloat() ) );
    vmathV4Prints( &a_Vector4, "Vector4::operator [](1)" );
    vmathV4SetY( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::setY()" );
    vmathV4SetElem( &a_Vector4, 2, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::set( 2, float )" );
    vmathV4SetElem( &a_Vector4, 2, randfloat() );
    vmathV4SetElem( &a_Vector4, 2, ( vmathV4GetElem( &a_Vector4, 2 ) * randfloat() ) );
    vmathV4SetElem( &a_Vector4, 2, ( vmathV4GetElem( &a_Vector4, 2 ) / randfloat() ) );
    vmathV4SetElem( &a_Vector4, 2, ( vmathV4GetElem( &a_Vector4, 2 ) + randfloat() ) );
    vmathV4SetElem( &a_Vector4, 2, ( vmathV4GetElem( &a_Vector4, 2 ) - randfloat() ) );
    vmathV4Prints( &a_Vector4, "Vector4::operator [](2)" );
    vmathV4SetZ( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::setZ()" );
    vmathV4SetElem( &a_Vector4, 3, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::set( 3, float )" );
    vmathV4SetElem( &a_Vector4, 3, randfloat() );
    vmathV4SetElem( &a_Vector4, 3, ( vmathV4GetElem( &a_Vector4, 3 ) * randfloat() ) );
    vmathV4SetElem( &a_Vector4, 3, ( vmathV4GetElem( &a_Vector4, 3 ) / randfloat() ) );
    vmathV4SetElem( &a_Vector4, 3, ( vmathV4GetElem( &a_Vector4, 3 ) + randfloat() ) );
    vmathV4SetElem( &a_Vector4, 3, ( vmathV4GetElem( &a_Vector4, 3 ) - randfloat() ) );
    vmathV4Prints( &a_Vector4, "Vector4::operator [](3)" );
    vmathV4SetW( &a_Vector4, randfloat() );
    vmathV4Prints( &a_Vector4, "Vector4::setW()" );
    printf("Vector4::get( 0 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 0 )) );
    printf("Vector4::operator []( 0 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 0 )) );
    printf("Vector4::getX(): %f\n", getfloat(vmathV4GetX( &a_Vector4 )) );
    printf("Vector4::get( 1 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 1 )) );
    printf("Vector4::operator []( 1 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 1 )) );
    printf("Vector4::getY(): %f\n", getfloat(vmathV4GetY( &a_Vector4 )) );
    printf("Vector4::get( 2 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 2 )) );
    printf("Vector4::operator []( 2 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 2 )) );
    printf("Vector4::getZ(): %f\n", getfloat(vmathV4GetZ( &a_Vector4 )) );
    printf("Vector4::get( 3 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 3 )) );
    printf("Vector4::operator []( 3 ): %f\n", getfloat(vmathV4GetElem( &a_Vector4, 3 )) );
    printf("Vector4::getW(): %f\n", getfloat(vmathV4GetW( &a_Vector4 )) );
    vmathV4Add( &tmpV4_4, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_4, "Vector4 + Vector4" );
    vmathV4Sub( &tmpV4_5, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_5, "Vector4 - Vector4" );
    vmathV4ScalarMul( &tmpV4_6, &a_Vector4, randfloat() );
    vmathV4Prints( &tmpV4_6, "Vector4 * float" );
    vmathV4ScalarDiv( &tmpV4_7, &a_Vector4, randfloat() );
    vmathV4Prints( &tmpV4_7, "Vector4 / float" );
    vmathV4ScalarMul( &tmpV4_8, &a_Vector4, randfloat() );
    vmathV4Prints( &tmpV4_8, "float * Vector4" );
    vmathV4Neg( &tmpV4_9, &a_Vector4 );
    vmathV4Prints( &tmpV4_9, "Vector4 negate" );
    vmathV4MulPerElem( &tmpV4_10, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_10, "mulPerElem( Vector4, Vector4 )" );
    vmathV4DivPerElem( &tmpV4_11, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_11, "divPerElem( Vector4, Vector4 )" );
    vmathV4RecipPerElem( &tmpV4_12, &a_Vector4 );
    vmathV4Prints( &tmpV4_12, "Vector4 recip" );
    vmathV4AbsPerElem( &tmpV4_13, &a_Vector4 );
    vmathV4SqrtPerElem( &tmpV4_14, &tmpV4_13 );
    vmathV4Prints( &tmpV4_14, "Vector4 sqrt" );
    vmathV4AbsPerElem( &tmpV4_15, &a_Vector4 );
    vmathV4RsqrtPerElem( &tmpV4_16, &tmpV4_15 );
    vmathV4Prints( &tmpV4_16, "Vector4 rsqrt" );
    vmathV4AbsPerElem( &tmpV4_17, &a_Vector4 );
    vmathV4Prints( &tmpV4_17, "Vector4 abs" );
    vmathV4CopySignPerElem( &tmpV4_18, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_18, "Vector4 copySign" );
    vmathV4MaxPerElem( &tmpV4_19, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_19, "Vector4 maximum Vector4" );
    vmathV4MinPerElem( &tmpV4_20, &a_Vector4, &b_Vector4 );
    vmathV4Prints( &tmpV4_20, "Vector4 minimum Vector4" );
    printf("Vector4 maximum of elements: %f\n", getfloat(vmathV4MaxElem( &a_Vector4 )));
    printf("Vector4 minimum of elements: %f\n", getfloat(vmathV4MinElem( &a_Vector4 )));
    printf("Vector4 sum of elements: %f\n", getfloat(vmathV4Sum( &a_Vector4 )));
    printf("Vector4 dot Vector4: %f\n", getfloat(vmathV4Dot( &a_Vector4, &b_Vector4 )));
    printf("Vector4 lengthSqr: %f\n", getfloat(vmathV4LengthSqr( &a_Vector4 )));
    printf("Vector4 length: %f\n", getfloat(vmathV4Length( &a_Vector4 )));
    vmathV4Normalize( &tmpV4_21, &a_Vector4 );
    vmathV4Prints( &tmpV4_21, "Vector4 normalized" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &e_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Normalize( &b_Vector4, &b_Vector4 );
    vmathV4Normalize( &c_Vector4, &c_Vector4 );
    vmathV4Normalize( &d_Vector4, &d_Vector4 );
    vmathV4Normalize( &e_Vector4, &e_Vector4 );
    vmathV4Lerp( &a_Vector4, randfloat(), &b_Vector4, &c_Vector4 );
    vmathV4Prints( &a_Vector4, "Vector4 lerp" );
    vmathV4Slerp( &a_Vector4, randfloat(), &b_Vector4, &c_Vector4 );
    vmathV4Prints( &a_Vector4, "Vector4 slerp" );
}

void
Point3_methods_test()
{
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3;
    VmathPoint3 aos_Point3_0, aos_Point3_1, aos_Point3_2, aos_Point3_3, tmpP3_0, tmpP3_1, tmpP3_2, tmpP3_3;
    VmathVector4 aos_Vector4_0, aos_Vector4_1, aos_Vector4_2;
    VmathVector3 tmpV3_4;
    VmathPoint3 tmpP3_4, tmpP3_5, tmpP3_6, tmpP3_7, tmpP3_8, tmpP3_9, tmpP3_10, tmpP3_11, tmpP3_12, tmpP3_13, tmpP3_14, tmpP3_15, tmpP3_16;
    float rndflt1, rndflt2, rndflt3, rndflt4, pad;
    float xyz4[12] __attribute__ ((aligned(16)));
#ifndef _VECTORMATH_SCALAR_TEST
    vec_float4 quad;
#endif
    xyz4[0] = randfloat();
    xyz4[1] = randfloat();
    xyz4[2] = randfloat();
    xyz4[3] = randfloat();
    xyz4[4] = randfloat();
    xyz4[5] = randfloat();
    xyz4[6] = randfloat();
    xyz4[7] = randfloat();
    xyz4[8] = randfloat();
    xyz4[9] = randfloat();
    xyz4[10] = randfloat();
    xyz4[11] = randfloat();
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3MakeFromScalar( &c_Vector3, 0.0f );
    vmathV3MakeFromScalar( &d_Vector3, 0.0f );
    vmathV3MakeFromScalar( &e_Vector3, 0.0f );
    vmathV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4MakeFromScalar( &c_Vector4, 0.0f );
    vmathV4MakeFromScalar( &d_Vector4, 0.0f );
    vmathV4MakeFromScalar( &e_Vector4, 0.0f );
    vmathV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3MakeFromScalar( &c_Point3, 0.0f );
    vmathP3MakeFromScalar( &d_Point3, 0.0f );
    vmathP3MakeFromScalar( &e_Point3, 0.0f );
    vmathP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQMakeFromScalar( &c_Quat, 0.0f );
    vmathQMakeFromScalar( &d_Quat, 0.0f );
    vmathQMakeFromScalar( &e_Quat, 0.0f );
    vmathQPrints( &c_Quat, "set Quat elements to zero" );
    vmathQPrints( &d_Quat, "set Quat elements to zero" );
    vmathQPrints( &e_Quat, "set Quat elements to zero" );
    vmathP3MakeFromV3( &a_Point3, &a_Vector3 );
    vmathP3Prints( &a_Point3, "construct Point3 with Vector3" );
    vmathP3MakeFromScalar( &a_Point3, randfloat() );
    vmathP3Prints( &a_Point3, "set Point3 with float" );
    vmathP3MakeFromScalar( &a_Point3, randfloat() );
    vmathP3Prints( &a_Point3, "set Point3 with float" );
    vmathP3MakeFromElems( &aos_Point3_0, 0.0f, 1.0f, 2.0f );
    vmathP3MakeFromElems( &aos_Point3_1, 3.0f, 4.0f, 5.0f );
    vmathP3MakeFromElems( &aos_Point3_2, 6.0f, 7.0f, 8.0f );
    vmathP3MakeFromElems( &aos_Point3_3, 9.0f, 10.0f, 11.0f );
    vmathP3Prints( &aos_Point3_3, "aos type 0" );
    vmathP3Prints( &aos_Point3_2, "aos type 1" );
    vmathP3Prints( &aos_Point3_1, "aos type 2" );
    vmathP3Prints( &aos_Point3_0, "aos type 3" );
    vmathP3Select( &tmpP3_0, &a_Point3, &b_Point3, 0 );
    vmathP3Prints( &tmpP3_0, "select 0" );
    vmathP3Select( &tmpP3_1, &a_Point3, &b_Point3, 1 );
    vmathP3Prints( &tmpP3_1, "select 1" );
    vmathP3Select( &tmpP3_2, &a_Point3, &b_Point3, 0 );
    vmathP3Prints( &tmpP3_2, "select 2" );
    vmathP3Select( &tmpP3_3, &a_Point3, &b_Point3, (unsigned int)-1 );
    vmathP3Prints( &tmpP3_3, "select 3" );
    vmathP3MakeFromElems( &a_Point3, xyz4[0], xyz4[1], xyz4[2] );
    vmathP3Prints( &a_Point3, "load XYZ array" );
    xyz4[0] = -xyz4[0];
    xyz4[1] = -xyz4[1];
    xyz4[2] = -xyz4[2];
    xyz4[3] = -xyz4[3];
    xyz4[4] = -xyz4[4];
    xyz4[5] = -xyz4[5];
    xyz4[6] = -xyz4[6];
    xyz4[7] = -xyz4[7];
    xyz4[8] = -xyz4[8];
    xyz4[9] = -xyz4[9];
    xyz4[10] = -xyz4[10];
    xyz4[11] = -xyz4[11];
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
#ifndef _VECTORMATH_SCALAR_TEST
    vmathP3LoadXYZArray( &aos_Point3_0, &aos_Point3_1, &aos_Point3_2, &aos_Point3_3, (const vec_float4 *)xyz4 );
    xyz4[0] = 0;
    xyz4[1] = 1;
    xyz4[2] = 2;
    xyz4[3] = 3;
    xyz4[4] = 4;
    xyz4[5] = 5;
    xyz4[6] = 6;
    xyz4[7] = 7;
    xyz4[8] = 8;
    xyz4[9] = 9;
    xyz4[10] = 10;
    xyz4[11] = 11;
    vmathP3StoreXYZArray( &aos_Point3_0, &aos_Point3_1, &aos_Point3_2, &aos_Point3_3, (vec_float4 *)xyz4 );
#endif
    vmathV4MakeFromElems( &aos_Vector4_0, xyz4[0], xyz4[1], xyz4[2], xyz4[3] );
    vmathV4MakeFromElems( &aos_Vector4_1, xyz4[4], xyz4[5], xyz4[6], xyz4[7] );
    vmathV4MakeFromElems( &aos_Vector4_2, xyz4[8], xyz4[9], xyz4[10], xyz4[11] );
    vmathV4Prints( &aos_Vector4_0, "xyzx" );
    vmathV4Prints( &aos_Vector4_1, "yzxy" );
    vmathV4Prints( &aos_Vector4_2, "zxyz" );
#ifdef _VECTORMATH_SCALAR_TEST
    printf("storeXYZ:-1.0 -2.0 -3.0 0.4\n");
#else
    quad = (vec_float4){-1.0f, -2.0f, -3.0f, -4.0f};
    a_Point3.vec128 = quad;
    quad = (vec_float4){0.1f, 0.2f, 0.3f, 0.4f};
    vmathP3StoreXYZ( &a_Point3, &quad );
    printf("storeXYZ:%f %f %f %f\n", ((float *)&quad)[0], ((float *)&quad)[1], ((float *)&quad)[2], ((float *)&quad)[3]);
#endif
    vmathP3Copy( &a_Point3, &b_Point3 );
    vmathP3Prints( &a_Point3, "assign to Point3 from Point3" );
    vmathP3MakeFromScalar( &a_Point3, 0.0f );
    vmathP3Prints( &a_Point3, "set Point3 elements to zero" );
    vmathP3SetElem( &a_Point3, 0, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::set( 0, float )" );
    vmathP3SetElem( &a_Point3, 0, randfloat() );
    vmathP3SetElem( &a_Point3, 0, ( vmathP3GetElem( &a_Point3, 0 ) * randfloat() ) );
    vmathP3SetElem( &a_Point3, 0, ( vmathP3GetElem( &a_Point3, 0 ) / randfloat() ) );
    vmathP3SetElem( &a_Point3, 0, ( vmathP3GetElem( &a_Point3, 0 ) + randfloat() ) );
    vmathP3SetElem( &a_Point3, 0, ( vmathP3GetElem( &a_Point3, 0 ) - randfloat() ) );
    vmathP3Prints( &a_Point3, "Point3::operator [](0)" );
    vmathP3SetX( &a_Point3, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::setX()" );
    vmathP3SetElem( &a_Point3, 1, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::set( 1, float )" );
    vmathP3SetElem( &a_Point3, 1, randfloat() );
    vmathP3SetElem( &a_Point3, 1, ( vmathP3GetElem( &a_Point3, 1 ) * randfloat() ) );
    vmathP3SetElem( &a_Point3, 1, ( vmathP3GetElem( &a_Point3, 1 ) / randfloat() ) );
    vmathP3SetElem( &a_Point3, 1, ( vmathP3GetElem( &a_Point3, 1 ) + randfloat() ) );
    vmathP3SetElem( &a_Point3, 1, ( vmathP3GetElem( &a_Point3, 1 ) - randfloat() ) );
    vmathP3Prints( &a_Point3, "Point3::operator [](1)" );
    vmathP3SetY( &a_Point3, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::setY()" );
    vmathP3SetElem( &a_Point3, 2, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::set( 2, float )" );
    vmathP3SetElem( &a_Point3, 2, randfloat() );
    vmathP3SetElem( &a_Point3, 2, ( vmathP3GetElem( &a_Point3, 2 ) * randfloat() ) );
    vmathP3SetElem( &a_Point3, 2, ( vmathP3GetElem( &a_Point3, 2 ) / randfloat() ) );
    vmathP3SetElem( &a_Point3, 2, ( vmathP3GetElem( &a_Point3, 2 ) + randfloat() ) );
    vmathP3SetElem( &a_Point3, 2, ( vmathP3GetElem( &a_Point3, 2 ) - randfloat() ) );
    vmathP3Prints( &a_Point3, "Point3::operator [](2)" );
    vmathP3SetZ( &a_Point3, randfloat() );
    vmathP3Prints( &a_Point3, "Point3::setZ()" );
    printf("Point3::get( 0 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 0 )) );
    printf("Point3::operator []( 0 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 0 )) );
    printf("Point3::getX(): %f\n", getfloat(vmathP3GetX( &a_Point3 )) );
    printf("Point3::get( 1 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 1 )) );
    printf("Point3::operator []( 1 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 1 )) );
    printf("Point3::getY(): %f\n", getfloat(vmathP3GetY( &a_Point3 )) );
    printf("Point3::get( 2 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 2 )) );
    printf("Point3::operator []( 2 ): %f\n", getfloat(vmathP3GetElem( &a_Point3, 2 )) );
    printf("Point3::getZ(): %f\n", getfloat(vmathP3GetZ( &a_Point3 )) );
    vmathP3Sub( &tmpV3_4, &a_Point3, &b_Point3 );
    vmathV3Prints( &tmpV3_4, "Point3 - Point3" );
    vmathP3AddV3( &tmpP3_4, &a_Point3, &b_Vector3 );
    vmathP3Prints( &tmpP3_4, "Point3 + Vector3" );
    vmathP3SubV3( &tmpP3_5, &a_Point3, &b_Vector3 );
    vmathP3Prints( &tmpP3_5, "Point3 - Vector3" );
    vmathP3MulPerElem( &tmpP3_6, &a_Point3, &b_Point3 );
    vmathP3Prints( &tmpP3_6, "mulPerElem( Point3, Point3 )" );
    vmathP3DivPerElem( &tmpP3_7, &a_Point3, &b_Point3 );
    vmathP3Prints( &tmpP3_7, "divPerElem( Point3, Point3 )" );
    vmathP3RecipPerElem( &tmpP3_8, &a_Point3 );
    vmathP3Prints( &tmpP3_8, "Point3 recip" );
    vmathP3AbsPerElem( &tmpP3_9, &a_Point3 );
    vmathP3SqrtPerElem( &tmpP3_10, &tmpP3_9 );
    vmathP3Prints( &tmpP3_10, "Point3 sqrt" );
    vmathP3AbsPerElem( &tmpP3_11, &a_Point3 );
    vmathP3RsqrtPerElem( &tmpP3_12, &tmpP3_11 );
    vmathP3Prints( &tmpP3_12, "Point3 rsqrt" );
    vmathP3AbsPerElem( &tmpP3_13, &a_Point3 );
    vmathP3Prints( &tmpP3_13, "Point3 abs" );
    vmathP3CopySignPerElem( &tmpP3_14, &a_Point3, &b_Point3 );
    vmathP3Prints( &tmpP3_14, "Point3 copySign" );
    vmathP3MaxPerElem( &tmpP3_15, &a_Point3, &b_Point3 );
    vmathP3Prints( &tmpP3_15, "Point3 maximum Point3" );
    vmathP3MinPerElem( &tmpP3_16, &a_Point3, &b_Point3 );
    vmathP3Prints( &tmpP3_16, "Point3 minimum Point3" );
    printf("Point3 maximum of elements: %f\n", getfloat(vmathP3MaxElem( &a_Point3 )));
    printf("Point3 minimum of elements: %f\n", getfloat(vmathP3MinElem( &a_Point3 )));
    printf("Point3 sum of elements: %f\n", getfloat(vmathP3Sum( &a_Point3 )));
    printf("Point projection: %f\n", getfloat(vmathP3Projection( &a_Point3, &b_Vector3 )));
    printf("Point distSqrFromOrigin: %f\n", getfloat(vmathP3DistSqrFromOrigin( &a_Point3 )) );
    printf("Point distFromOrigin: %f\n", getfloat(vmathP3DistFromOrigin( &a_Point3 )) );
    printf("Point distSqr: %f\n", getfloat(vmathP3DistSqr( &a_Point3, &b_Point3 )) );
    printf("Point dist: %f\n", getfloat(vmathP3Dist( &a_Point3, &b_Point3 )) );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &e_Point3, rndflt1, rndflt2, rndflt3 );
    vmathP3Lerp( &a_Point3, randfloat(), &b_Point3, &c_Point3 );
    vmathP3Prints( &a_Point3, "Point3 lerp" );
}

void
Quat_methods_test()
{
    VmathVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3, e_Vector3;
    VmathVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4, e_Vector4;
    VmathPoint3 a_Point3, b_Point3, c_Point3, d_Point3, e_Point3;
    VmathQuat a_Quat, b_Quat, c_Quat, d_Quat, e_Quat;
    VmathVector4 tmpV4;
    VmathVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3;
    VmathQuat aos_Quat_0, aos_Quat_1, aos_Quat_2, aos_Quat_3, tmpQ_0, tmpQ_1, tmpQ_2, tmpQ_3;
    VmathVector3 tmpV3_4;
    VmathQuat tmpQ_4, tmpQ_5, tmpQ_6, tmpQ_7, tmpQ_8, tmpQ_9, tmpQ_10, tmpQ_11;
    VmathVector3 tmpV3_5;
    VmathQuat tmpQ_12;
    float rndflt1, rndflt2, rndflt3, rndflt4, pad;
    // set a pad value to detect invalid use of padding.
    // this will be nan for scalar/ppu implementations, max. float for spu
    union { float f; unsigned int u; } tmp;
    tmp.u = 0x7fffffff;
    pad = tmp.f;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathV3MakeFromElems( &b_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &a_Vector3, pad );
    vmathV4GetXYZ( &a_Vector3, &tmpV4 );
    vmathV4MakeFromV3Scalar( &tmpV4, &b_Vector3, pad );
    vmathV4GetXYZ( &b_Vector3, &tmpV4 );
    vmathV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathV3MakeFromScalar( &c_Vector3, 0.0f );
    vmathV3MakeFromScalar( &d_Vector3, 0.0f );
    vmathV3MakeFromScalar( &e_Vector3, 0.0f );
    vmathV3Prints( &c_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &d_Vector3, "set Vector3 elements to zero" );
    vmathV3Prints( &e_Vector3, "set Vector3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathV4MakeFromElems( &b_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathV4MakeFromScalar( &c_Vector4, 0.0f );
    vmathV4MakeFromScalar( &d_Vector4, 0.0f );
    vmathV4MakeFromScalar( &e_Vector4, 0.0f );
    vmathV4Prints( &c_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &d_Vector4, "set Vector4 elements to zero" );
    vmathV4Prints( &e_Vector4, "set Vector4 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathP3MakeFromElems( &b_Point3, rndflt1, rndflt2, rndflt3 );
    vmathV3MakeFromP3( &tmpV3_0, &a_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_0, pad );
    vmathV4GetXYZ( &tmpV3_1, &tmpV4 );
    vmathP3MakeFromV3( &a_Point3, &tmpV3_1 );
    vmathV3MakeFromP3( &tmpV3_2, &b_Point3 );
    vmathV4MakeFromV3Scalar( &tmpV4, &tmpV3_2, pad );
    vmathV4GetXYZ( &tmpV3_3, &tmpV4 );
    vmathP3MakeFromV3( &b_Point3, &tmpV3_3 );
    vmathP3Prints( &a_Point3, "set Point3 with floats" );
    vmathP3Prints( &b_Point3, "set Point3 with floats" );
    vmathP3MakeFromScalar( &c_Point3, 0.0f );
    vmathP3MakeFromScalar( &d_Point3, 0.0f );
    vmathP3MakeFromScalar( &e_Point3, 0.0f );
    vmathP3Prints( &c_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &d_Point3, "set Point3 elements to zero" );
    vmathP3Prints( &e_Point3, "set Point3 elements to zero" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQPrints( &a_Quat, "set Quat with floats" );
    vmathQPrints( &b_Quat, "set Quat with floats" );
    vmathQMakeFromScalar( &c_Quat, 0.0f );
    vmathQMakeFromScalar( &d_Quat, 0.0f );
    vmathQMakeFromScalar( &e_Quat, 0.0f );
    vmathQPrints( &c_Quat, "set Quat elements to zero" );
    vmathQPrints( &d_Quat, "set Quat elements to zero" );
    vmathQPrints( &e_Quat, "set Quat elements to zero" );
    vmathQMakeFromV3Scalar( &a_Quat, &a_Vector3, randfloat() );
    vmathQPrints( &a_Quat, "set Quat with Vector3, float" );
    vmathQMakeFromV4( &a_Quat, &a_Vector4 );
    vmathQPrints( &a_Quat, "construct Quat with Vector4" );
    vmathQMakeFromScalar( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "set Quat with float" );
    vmathQMakeFromScalar( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "set Quat with float" );
    vmathQMakeFromElems( &aos_Quat_0, 0.0f, 1.0f, 2.0f, 3.0f );
    vmathQMakeFromElems( &aos_Quat_1, 4.0f, 5.0f, 6.0f, 7.0f );
    vmathQMakeFromElems( &aos_Quat_2, 8.0f, 9.0f, 10.0f, 11.0f );
    vmathQMakeFromElems( &aos_Quat_3, 12.0f, 13.0f, 14.0f, 15.0f );
    vmathQPrints( &aos_Quat_3, "aos type 0" );
    vmathQPrints( &aos_Quat_2, "aos type 1" );
    vmathQPrints( &aos_Quat_1, "aos type 2" );
    vmathQPrints( &aos_Quat_0, "aos type 3" );
    vmathQSelect( &tmpQ_0, &a_Quat, &b_Quat, 0 );
    vmathQPrints( &tmpQ_0, "select 0" );
    vmathQSelect( &tmpQ_1, &a_Quat, &b_Quat, 1 );
    vmathQPrints( &tmpQ_1, "select 1" );
    vmathQSelect( &tmpQ_2, &a_Quat, &b_Quat, 0 );
    vmathQPrints( &tmpQ_2, "select 2" );
    vmathQSelect( &tmpQ_3, &a_Quat, &b_Quat, (unsigned int)-1 );
    vmathQPrints( &tmpQ_3, "select 3" );
    vmathQCopy( &a_Quat, &b_Quat );
    vmathQPrints( &a_Quat, "assign to Quat from Quat" );
    vmathQSetXYZ( &a_Quat, &a_Vector3 );
    vmathQPrints( &a_Quat, "set Quat xyz" );
    vmathQGetXYZ( &tmpV3_4, &a_Quat );
    vmathV3Prints( &tmpV3_4, "get Quat xyz" );
    vmathQMakeFromScalar( &a_Quat, 0.0f );
    vmathQPrints( &a_Quat, "set Quat elements to zero" );
    vmathQSetElem( &a_Quat, 0, randfloat() );
    vmathQPrints( &a_Quat, "Quat::set( 0, float )" );
    vmathQSetElem( &a_Quat, 0, randfloat() );
    vmathQSetElem( &a_Quat, 0, ( vmathQGetElem( &a_Quat, 0 ) * randfloat() ) );
    vmathQSetElem( &a_Quat, 0, ( vmathQGetElem( &a_Quat, 0 ) / randfloat() ) );
    vmathQSetElem( &a_Quat, 0, ( vmathQGetElem( &a_Quat, 0 ) + randfloat() ) );
    vmathQSetElem( &a_Quat, 0, ( vmathQGetElem( &a_Quat, 0 ) - randfloat() ) );
    vmathQPrints( &a_Quat, "Quat::operator [](0)" );
    vmathQSetX( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat::setX()" );
    vmathQSetElem( &a_Quat, 1, randfloat() );
    vmathQPrints( &a_Quat, "Quat::set( 1, float )" );
    vmathQSetElem( &a_Quat, 1, randfloat() );
    vmathQSetElem( &a_Quat, 1, ( vmathQGetElem( &a_Quat, 1 ) * randfloat() ) );
    vmathQSetElem( &a_Quat, 1, ( vmathQGetElem( &a_Quat, 1 ) / randfloat() ) );
    vmathQSetElem( &a_Quat, 1, ( vmathQGetElem( &a_Quat, 1 ) + randfloat() ) );
    vmathQSetElem( &a_Quat, 1, ( vmathQGetElem( &a_Quat, 1 ) - randfloat() ) );
    vmathQPrints( &a_Quat, "Quat::operator [](1)" );
    vmathQSetY( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat::setY()" );
    vmathQSetElem( &a_Quat, 2, randfloat() );
    vmathQPrints( &a_Quat, "Quat::set( 2, float )" );
    vmathQSetElem( &a_Quat, 2, randfloat() );
    vmathQSetElem( &a_Quat, 2, ( vmathQGetElem( &a_Quat, 2 ) * randfloat() ) );
    vmathQSetElem( &a_Quat, 2, ( vmathQGetElem( &a_Quat, 2 ) / randfloat() ) );
    vmathQSetElem( &a_Quat, 2, ( vmathQGetElem( &a_Quat, 2 ) + randfloat() ) );
    vmathQSetElem( &a_Quat, 2, ( vmathQGetElem( &a_Quat, 2 ) - randfloat() ) );
    vmathQPrints( &a_Quat, "Quat::operator [](2)" );
    vmathQSetZ( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat::setZ()" );
    vmathQSetElem( &a_Quat, 3, randfloat() );
    vmathQPrints( &a_Quat, "Quat::set( 3, float )" );
    vmathQSetElem( &a_Quat, 3, randfloat() );
    vmathQSetElem( &a_Quat, 3, ( vmathQGetElem( &a_Quat, 3 ) * randfloat() ) );
    vmathQSetElem( &a_Quat, 3, ( vmathQGetElem( &a_Quat, 3 ) / randfloat() ) );
    vmathQSetElem( &a_Quat, 3, ( vmathQGetElem( &a_Quat, 3 ) + randfloat() ) );
    vmathQSetElem( &a_Quat, 3, ( vmathQGetElem( &a_Quat, 3 ) - randfloat() ) );
    vmathQPrints( &a_Quat, "Quat::operator [](3)" );
    vmathQSetW( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat::setW()" );
    printf("Quat::get( 0 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 0 )) );
    printf("Quat::operator []( 0 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 0 )) );
    printf("Quat::getX(): %f\n", getfloat(vmathQGetX( &a_Quat )) );
    printf("Quat::get( 1 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 1 )) );
    printf("Quat::operator []( 1 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 1 )) );
    printf("Quat::getY(): %f\n", getfloat(vmathQGetY( &a_Quat )) );
    printf("Quat::get( 2 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 2 )) );
    printf("Quat::operator []( 2 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 2 )) );
    printf("Quat::getZ(): %f\n", getfloat(vmathQGetZ( &a_Quat )) );
    printf("Quat::get( 3 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 3 )) );
    printf("Quat::operator []( 3 ): %f\n", getfloat(vmathQGetElem( &a_Quat, 3 )) );
    printf("Quat::getW(): %f\n", getfloat(vmathQGetW( &a_Quat )) );
    vmathQAdd( &tmpQ_4, &a_Quat, &b_Quat );
    vmathQPrints( &tmpQ_4, "Quat + Quat" );
    vmathQSub( &tmpQ_5, &a_Quat, &b_Quat );
    vmathQPrints( &tmpQ_5, "Quat - Quat" );
    vmathQMul( &tmpQ_6, &a_Quat, &b_Quat );
    vmathQPrints( &tmpQ_6, "Quat * Quat" );
    vmathQScalarMul( &tmpQ_7, &a_Quat, randfloat() );
    vmathQPrints( &tmpQ_7, "Quat * float" );
    vmathQScalarDiv( &tmpQ_8, &a_Quat, randfloat() );
    vmathQPrints( &tmpQ_8, "Quat / float" );
    vmathQScalarMul( &tmpQ_9, &a_Quat, randfloat() );
    vmathQPrints( &tmpQ_9, "float * Quat" );
    vmathQNeg( &tmpQ_10, &a_Quat );
    vmathQPrints( &tmpQ_10, "Quat negate" );
    printf("Quat dot Quat: %f\n", getfloat(vmathQDot( &a_Quat, &b_Quat )));
    printf("Quat lengthSqr: %f\n", getfloat(vmathQNorm( &a_Quat )));
    printf("Quat length: %f\n", getfloat(vmathQLength( &a_Quat )));
    vmathQNormalize( &tmpQ_11, &a_Quat );
    vmathQPrints( &tmpQ_11, "Quat normalized" );
    vmathQMakeIdentity( &a_Quat );
    vmathQPrints( &a_Quat, "set to identity" );
    vmathQMakeRotationArc( &a_Quat, &a_Vector3, &b_Vector3 );
    vmathQPrints( &a_Quat, "Quat rotation between vectors" );
    vmathQMakeRotationAxis( &a_Quat, randfloat(), &a_Vector3 );
    vmathQPrints( &a_Quat, "Quat rotation axis angle" );
    vmathQMakeRotationX( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat rotationX" );
    vmathQMakeRotationY( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat rotationY" );
    vmathQMakeRotationZ( &a_Quat, randfloat() );
    vmathQPrints( &a_Quat, "Quat rotationZ" );
    vmathQRotate( &tmpV3_5, &a_Quat, &a_Vector3 );
    vmathV3Prints( &tmpV3_5, "Quat rotate Vector3" );
    vmathQConj( &tmpQ_12, &a_Quat );
    vmathQPrints( &tmpQ_12, "Quat conj" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &b_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathQMakeFromElems( &e_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathQNormalize( &b_Quat, &b_Quat );
    vmathQNormalize( &c_Quat, &c_Quat );
    vmathQNormalize( &d_Quat, &d_Quat );
    vmathQNormalize( &e_Quat, &e_Quat );
    vmathQLerp( &a_Quat, randfloat(), &b_Quat, &c_Quat );
    vmathQPrints( &a_Quat, "Quat lerp" );
    vmathQSlerp( &a_Quat, randfloat(), &b_Quat, &c_Quat );
    vmathQPrints( &a_Quat, "Quat slerp" );
    vmathQSquad( &a_Quat, randfloat(), &b_Quat, &c_Quat, &d_Quat, &e_Quat );
    vmathQPrints( &a_Quat, "Quat squad" );
}

int main()
{
    printf("\n __begin__ \n");
    for ( iteration = 0; iteration < 2; iteration++ ) {
        Vector3_methods_test();
        Vector4_methods_test();
        Point3_methods_test();
        Quat_methods_test();
    }
    printf("\n __end__ \n");
    return 0;
}
