/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _testvdk_main_form_h_
#define _testvdk_main_form_h_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <vdk/vdk.h>
// Testvdk FORM  CLASS
class TestvdkForm: public VDKForm
{
  // gui object declarations
 private:
  // gui object declarations
  void GUISetup(void);
  VDKObject* active;

 public:
  // some place holders for run-time constructed widgets
  VDKCustomSortedList* sortedlist_widget;
  VDKComboEntry* cbentry;
  VDKCheckButton* chbox;
  // constructor
  TestvdkForm(VDKApplication* app, char* title);
  ~TestvdkForm();
  void Setup(void);
  static VDKObject* CreateScrolled(VDKForm* owner);
  static VDKObject* CreateButtons(VDKForm* owner);
  static VDKObject* CreateSortedLists(VDKForm* owner);
  static VDKObject* CreateChart(VDKForm* owner);
  static VDKObject* CreateTree(VDKForm* owner);
  static VDKObject* CreateDnD(VDKForm* owner);
  static VDKObject* CreateCanvas(VDKForm* owner);
  static VDKObject* CreateDrawing(VDKForm* owner);
  static VDKObject* CreateImage(VDKForm* owner);
  static VDKObject* CreateCombo(VDKForm* owner);
  static VDKObject* CreateNotebook(VDKForm* owner);
  static VDKObject* CreateProgress(VDKForm* owner);
  static VDKObject* CreateTreeView(VDKForm* owner);
#ifdef USE_SIGCPLUSPLUS
  static VDKObject* CreateSigcTest(VDKForm* owner);
#endif
 protected: 
  VDKTimer* timer;
  VDKBox* hbox2;
  VDKTreeView* testlist;
  VDKFrame* testframe;
  VDKMenubar* menubar;
  VDKMenuItem* MenuItem0;
  VDKMenu* Menu0;
  VDKMenuItem* openMenu,*filechooser;
  VDKMenuItem* MenuItem2;
  VDKMenuItem* quitMenu;
  VDKLabel* introduce_vdk;
  VDKEventBox* eventbox;
 public:

  DECLARE_SIGNAL_MAP(TestvdkForm);
  bool OnfilechooserActivate(VDKObject* sender);
  bool OnquitMenuActivate(VDKObject* sender);
  bool OnopenMenuActivate(VDKObject* sender);
  bool OnTestIt(VDKObject* sender);
  bool OnSortedListSelect(VDKObject* sender);
  bool OnAddClicked(VDKObject* sender);
  bool OnAddManyClicked(VDKObject* sender);
  bool OnDelClicked(VDKObject* sender);
  bool OnReloadClicked(VDKObject* sender);
  bool CanClose();
  bool OnTimerTick(VDKObject* sender);
  void OnResize(VDKForm* form, VDKPoint& s);
  bool OnComboEntryActivated(VDKObject* sender);
  bool OnComboEntryChanged(VDKObject* sender);
  bool OnComboEntryFocusIn(VDKObject* sender);
  bool OnComboEntryFocusOut(VDKObject* sender);
  bool OnCheckBoxToggled(VDKObject* sender);
  /*
    declaring signal and events
    dynamics tables
  */
  DECLARE_SIGNAL_LIST(TestvdkForm);
  DECLARE_EVENT_LIST(TestvdkForm);
};


// Testvdk APPLICATION  CLASS
class TestvdkApp: public VDKApplication
{

 public:
  TestvdkApp(int* argc, char** argv);
  ~TestvdkApp();
  void Setup(void);
};

#endif

