/* vtgutils.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgutils.vala, do not modify */

/*
 *  vtgutils.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <valagee.h>
#include <vbf.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gedit/gedit-document.h>
#include <gtksourceview/gtksourceview.h>
#include <config.h>
#include <afrodite.h>
#include <gobject/gvaluecollector.h>


#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_CACHES (vtg_caches_get_type ())
#define VTG_CACHES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CACHES, VtgCaches))
#define VTG_CACHES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CACHES, VtgCachesClass))
#define VTG_IS_CACHES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CACHES))
#define VTG_IS_CACHES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CACHES))
#define VTG_CACHES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CACHES, VtgCachesClass))

typedef struct _VtgCaches VtgCaches;
typedef struct _VtgCachesClass VtgCachesClass;
typedef struct _VtgCachesPrivate VtgCachesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _VtgParamSpecCaches VtgParamSpecCaches;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_UTILS (vtg_utils_get_type ())
#define VTG_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_UTILS, VtgUtils))
#define VTG_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_UTILS, VtgUtilsClass))
#define VTG_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_UTILS))
#define VTG_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_UTILS))
#define VTG_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_UTILS, VtgUtilsClass))

typedef struct _VtgUtils VtgUtils;
typedef struct _VtgUtilsClass VtgUtilsClass;
typedef struct _VtgUtilsPrivate VtgUtilsPrivate;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

typedef enum  {
	VTG_PROJECT_MANAGER_ERROR_NO_BACKEND
} VtgProjectManagerError;
#define VTG_PROJECT_MANAGER_ERROR vtg_project_manager_error_quark ()
typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgCaches {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgCachesPrivate * priv;
};

struct _VtgCachesClass {
	GTypeClass parent_class;
	void (*finalize) (VtgCaches *self);
};

struct _VtgParamSpecCaches {
	GParamSpec parent_instance;
};

struct _VtgUtils {
	GObject parent_instance;
	VtgUtilsPrivate * priv;
};

struct _VtgUtilsClass {
	GObjectClass parent_class;
};


static GtkListStore* vtg_caches__build_cache;
static GtkListStore* vtg_caches__build_cache = NULL;
static GtkListStore* vtg_caches__compile_cache;
static GtkListStore* vtg_caches__compile_cache = NULL;
static GtkListStore* vtg_caches__configure_cache;
static GtkListStore* vtg_caches__configure_cache = NULL;
static GtkListStore* vtg_caches__executer_cache;
static GtkListStore* vtg_caches__executer_cache = NULL;
static gpointer vtg_caches_parent_class = NULL;
static GType vtg_caches_type_id = 0;
static gboolean vtg_utils__initialized;
static gboolean vtg_utils__initialized = FALSE;
static GtkSourceCompletionItem** vtg_utils__proposals;
static gint vtg_utils__proposals_length1;
static GtkSourceCompletionItem** vtg_utils__proposals = NULL;
static gint vtg_utils__proposals_length1 = 0;
static gint _vtg_utils__proposals_size_ = 0;
static ValaList* vtg_utils__available_packages;
static ValaList* vtg_utils__available_packages = NULL;
static GtkBuilder* vtg_utils__builder;
static GtkBuilder* vtg_utils__builder = NULL;
static char** vtg_utils__vala_keywords;
static gint vtg_utils__vala_keywords_length1;
static char** vtg_utils__vala_keywords = NULL;
static gint vtg_utils__vala_keywords_length1 = 0;
static gint _vtg_utils__vala_keywords_size_ = 0;
extern GdkPixbuf* vtg_utils_icon_generic;
GdkPixbuf* vtg_utils_icon_generic = NULL;
extern GdkPixbuf* vtg_utils_icon_field;
GdkPixbuf* vtg_utils_icon_field = NULL;
extern GdkPixbuf* vtg_utils_icon_method;
GdkPixbuf* vtg_utils_icon_method = NULL;
extern GdkPixbuf* vtg_utils_icon_class;
GdkPixbuf* vtg_utils_icon_class = NULL;
extern GdkPixbuf* vtg_utils_icon_struct;
GdkPixbuf* vtg_utils_icon_struct = NULL;
extern GdkPixbuf* vtg_utils_icon_property;
GdkPixbuf* vtg_utils_icon_property = NULL;
extern GdkPixbuf* vtg_utils_icon_signal;
GdkPixbuf* vtg_utils_icon_signal = NULL;
extern GdkPixbuf* vtg_utils_icon_iface;
GdkPixbuf* vtg_utils_icon_iface = NULL;
extern GdkPixbuf* vtg_utils_icon_const;
GdkPixbuf* vtg_utils_icon_const = NULL;
extern GdkPixbuf* vtg_utils_icon_enum;
GdkPixbuf* vtg_utils_icon_enum = NULL;
extern GdkPixbuf* vtg_utils_icon_namespace;
GdkPixbuf* vtg_utils_icon_namespace = NULL;
static gpointer vtg_utils_parent_class = NULL;
static GType vtg_utils_type_id = 0;

GQuark vtg_project_manager_error_quark (void);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
void vtg_interaction_error_message (const char* message, GError* err);
void vtg_interaction_info_message (const char* message);
gpointer vtg_caches_ref (gpointer instance);
void vtg_caches_unref (gpointer instance);
GParamSpec* vtg_param_spec_caches (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_caches (GValue* value, gpointer v_object);
void vtg_value_take_caches (GValue* value, gpointer v_object);
gpointer vtg_value_get_caches (const GValue* value);
GType vtg_caches_get_type (void) G_GNUC_CONST;
GType vtg_caches_register_type (GTypeModule * module);
enum  {
	VTG_CACHES_DUMMY_PROPERTY
};
#define VTG_CACHES_CACHE_LIMIT 20
GtkListStore* vtg_caches_get_build_cache (void);
GtkListStore* vtg_caches_get_compile_cache (void);
GtkListStore* vtg_caches_get_configure_cache (void);
GtkListStore* vtg_caches_get_executer_cache (void);
gboolean vtg_caches_cache_contains (GtkListStore* cache, const char* data);
gboolean vtg_caches_cache_remove (GtkListStore* cache, const char* data);
void vtg_caches_cache_add (GtkListStore* cache, const char* data);
gint vtg_caches_cache_count (GtkListStore* cache);
VtgCaches* vtg_caches_new (void);
VtgCaches* vtg_caches_construct (GType object_type);
static void vtg_caches_finalize (VtgCaches* obj);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
char* vtg_string_utils_replace (const char* data, const char* search, const char* replace);
char* vtg_path_utils_normalize_path (const char* name);
gint vtg_path_utils_compare_vala_filenames (const char* filea, const char* fileb);
GType vtg_utils_get_type (void) G_GNUC_CONST;
GType vtg_utils_register_type (GTypeModule * module);
enum  {
	VTG_UTILS_DUMMY_PROPERTY
};
#define VTG_UTILS_prealloc_count 500
void vtg_utils_trace (const char* format, ...);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
gboolean vtg_utils_is_vala_keyword (const char* word);
char* vtg_utils_get_document_name (GeditDocument* doc);
GtkBuilder* vtg_utils_get_builder (void);
char* vtg_utils_get_ui_path (const char* id);
GtkSourceCompletionItem** vtg_utils_get_proposal_cache (int* result_length1);
static void vtg_utils_initialize (void);
char* vtg_utils_get_image_path (const char* id);
ValaList* vtg_utils_get_available_packages (void);
static void vtg_utils_initialize_packages_cache (void);
static void _g_list_free_g_free (GList* self);
GdkPixbuf* vtg_utils_get_icon_for_type_name (const char* type_name);
char* vtg_utils_get_stock_id_for_target_type (VbfTargetTypes type);
gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb);
VtgUtils* vtg_utils_new (void);
VtgUtils* vtg_utils_construct (GType object_type);
static void vtg_utils_finalize (GObject* obj);
char* vtg_parser_utils_get_line_to_end (GtkTextIter* start);
void vtg_parser_utils_parse_line (const char* line, char** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration);
char* vtg_parser_utils_get_token (const char* line, gint* i);
gboolean vtg_parser_utils_is_eof (const char* line, gint i);
gint vtg_parser_utils_skip_spaces (const char* line, gint i);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark vtg_project_manager_error_quark (void) {
	return g_quark_from_static_string ("vtg_project_manager_error-quark");
}


GType vtg_vcs_types_get_type (void) {
	static volatile gsize vtg_vcs_types_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_vcs_types_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_VCS_TYPES_NONE, "VTG_VCS_TYPES_NONE", "none"}, {VTG_VCS_TYPES_GIT, "VTG_VCS_TYPES_GIT", "git"}, {VTG_VCS_TYPES_BZR, "VTG_VCS_TYPES_BZR", "bzr"}, {VTG_VCS_TYPES_SVN, "VTG_VCS_TYPES_SVN", "svn"}, {0, NULL, NULL}};
		GType vtg_vcs_types_type_id;
		vtg_vcs_types_type_id = g_enum_register_static ("VtgVcsTypes", values);
		g_once_init_leave (&vtg_vcs_types_type_id__volatile, vtg_vcs_types_type_id);
	}
	return vtg_vcs_types_type_id__volatile;
}


void vtg_interaction_error_message (const char* message, GError* err) {
	GtkMessageDialog* dialog;
	g_return_if_fail (message != NULL);
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, message));
	g_object_set (dialog, "secondary-text", err->message, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


void vtg_interaction_info_message (const char* message) {
	GtkMessageDialog* dialog;
	g_return_if_fail (message != NULL);
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, message));
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkListStore* vtg_caches_get_build_cache (void) {
	GtkListStore* result = NULL;
	if (vtg_caches__build_cache == NULL) {
		GtkListStore* _tmp0_;
		vtg_caches__build_cache = (_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING), _g_object_unref0 (vtg_caches__build_cache), _tmp0_);
	}
	result = _g_object_ref0 (vtg_caches__build_cache);
	return result;
}


GtkListStore* vtg_caches_get_compile_cache (void) {
	GtkListStore* result = NULL;
	if (vtg_caches__compile_cache == NULL) {
		GtkListStore* _tmp0_;
		vtg_caches__compile_cache = (_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING), _g_object_unref0 (vtg_caches__compile_cache), _tmp0_);
	}
	result = _g_object_ref0 (vtg_caches__compile_cache);
	return result;
}


GtkListStore* vtg_caches_get_configure_cache (void) {
	GtkListStore* result = NULL;
	if (vtg_caches__configure_cache == NULL) {
		GtkListStore* _tmp0_;
		vtg_caches__configure_cache = (_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING), _g_object_unref0 (vtg_caches__configure_cache), _tmp0_);
	}
	result = _g_object_ref0 (vtg_caches__configure_cache);
	return result;
}


GtkListStore* vtg_caches_get_executer_cache (void) {
	GtkListStore* result = NULL;
	if (vtg_caches__executer_cache == NULL) {
		GtkListStore* _tmp0_;
		vtg_caches__executer_cache = (_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING), _g_object_unref0 (vtg_caches__executer_cache), _tmp0_);
	}
	result = _g_object_ref0 (vtg_caches__executer_cache);
	return result;
}


gboolean vtg_caches_cache_contains (GtkListStore* cache, const char* data) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gboolean found;
	g_return_val_if_fail (cache != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	found = FALSE;
	if (gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &iter)) {
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* tmp;
				if (!_tmp0_) {
					if (!gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				tmp = NULL;
				gtk_tree_model_get ((GtkTreeModel*) cache, &iter, 0, &tmp, -1);
				if (_vala_strcmp0 (tmp, data) == 0) {
					found = TRUE;
					_g_free0 (tmp);
					break;
				}
				_g_free0 (tmp);
			}
		}
	}
	result = found;
	return result;
}


gboolean vtg_caches_cache_remove (GtkListStore* cache, const char* data) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gboolean found;
	g_return_val_if_fail (cache != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	found = FALSE;
	if (gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &iter)) {
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* tmp;
				if (!_tmp0_) {
					if (!gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				tmp = NULL;
				gtk_tree_model_get ((GtkTreeModel*) cache, &iter, 0, &tmp, -1);
				if (_vala_strcmp0 (tmp, data) == 0) {
					found = TRUE;
					gtk_list_store_remove (cache, &iter);
					_g_free0 (tmp);
					break;
				}
				_g_free0 (tmp);
			}
		}
	}
	result = found;
	return result;
}


void vtg_caches_cache_add (GtkListStore* cache, const char* data) {
	GtkTreeIter iter = {0};
	g_return_if_fail (cache != NULL);
	g_return_if_fail (data != NULL);
	if (vtg_caches_cache_count (cache) > VTG_CACHES_CACHE_LIMIT) {
		if (gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &iter)) {
			GtkTreeIter target;
			target = iter;
			while (TRUE) {
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter)) {
					break;
				}
				target = iter;
			}
			gtk_list_store_remove (cache, &target);
		}
	}
	gtk_list_store_insert (cache, &iter, 0);
	gtk_list_store_set (cache, &iter, 0, data, -1);
}


gint vtg_caches_cache_count (GtkListStore* cache) {
	gint result = 0;
	gint count;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (cache != NULL, 0);
	count = 0;
	if (gtk_tree_model_get_iter_first ((GtkTreeModel*) cache, &iter)) {
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					if (!gtk_tree_model_iter_next ((GtkTreeModel*) cache, &iter)) {
						break;
					}
				}
				_tmp0_ = FALSE;
				count++;
			}
		}
	}
	result = count;
	return result;
}


VtgCaches* vtg_caches_construct (GType object_type) {
	VtgCaches* self;
	self = (VtgCaches*) g_type_create_instance (object_type);
	return self;
}


VtgCaches* vtg_caches_new (void) {
	return vtg_caches_construct (VTG_TYPE_CACHES);
}


static void vtg_value_caches_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vtg_value_caches_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vtg_caches_unref (value->data[0].v_pointer);
	}
}


static void vtg_value_caches_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vtg_caches_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vtg_value_caches_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vtg_value_caches_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		VtgCaches* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vtg_caches_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vtg_value_caches_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VtgCaches** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vtg_caches_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vtg_param_spec_caches (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	VtgParamSpecCaches* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VTG_TYPE_CACHES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vtg_value_get_caches (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES), NULL);
	return value->data[0].v_pointer;
}


void vtg_value_set_caches (GValue* value, gpointer v_object) {
	VtgCaches* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VTG_TYPE_CACHES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vtg_caches_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vtg_caches_unref (old);
	}
}


void vtg_value_take_caches (GValue* value, gpointer v_object) {
	VtgCaches* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VTG_TYPE_CACHES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VTG_TYPE_CACHES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vtg_caches_unref (old);
	}
}


static void vtg_caches_class_init (VtgCachesClass * klass) {
	vtg_caches_parent_class = g_type_class_peek_parent (klass);
	VTG_CACHES_CLASS (klass)->finalize = vtg_caches_finalize;
}


static void vtg_caches_instance_init (VtgCaches * self) {
	self->ref_count = 1;
}


static void vtg_caches_finalize (VtgCaches* obj) {
	VtgCaches * self;
	self = VTG_CACHES (obj);
}


GType vtg_caches_get_type (void) {
	return vtg_caches_type_id;
}


GType vtg_caches_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { vtg_value_caches_init, vtg_value_caches_free_value, vtg_value_caches_copy_value, vtg_value_caches_peek_pointer, "p", vtg_value_caches_collect_value, "p", vtg_value_caches_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VtgCachesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_caches_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgCaches), 0, (GInstanceInitFunc) vtg_caches_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	vtg_caches_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VtgCaches", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vtg_caches_type_id;
}


gpointer vtg_caches_ref (gpointer instance) {
	VtgCaches* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vtg_caches_unref (gpointer instance) {
	VtgCaches* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VTG_CACHES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gboolean vtg_string_utils_is_null_or_empty (const char* data) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (data == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (data, "") == 0;
	}
	result = _tmp0_;
	return result;
}


char* vtg_string_utils_replace (const char* data, const char* search, const char* replace) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	g_return_val_if_fail (replace != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (search, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch59_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, data, (gssize) (-1), 0, replace, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch59_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally59;
	__catch59_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally59:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


char* vtg_path_utils_normalize_path (const char* name) {
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint name_parts_length1;
	gint _name_parts_size_;
	char** _tmp4_;
	char* _tmp1_;
	char** _tmp2_;
	char** _tmp3_;
	char** name_parts;
	char* last_item;
	char* target_name;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	if (name == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get_length (name) < 2;
	}
	if (_tmp0_) {
		result = g_strdup (name);
		return result;
	}
	name_parts = (_tmp4_ = (_tmp3_ = _tmp2_ = g_strsplit (_tmp1_ = string_substring (name, (glong) 1, string_get_length (name) - 1), "/", 0), _g_free0 (_tmp1_), _tmp3_), name_parts_length1 = _vala_array_length (_tmp2_), _name_parts_size_ = name_parts_length1, _tmp4_);
	last_item = NULL;
	target_name = g_strdup ("");
	{
		char** item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = name_parts;
		item_collection_length1 = name_parts_length1;
		for (item_it = 0; item_it < name_parts_length1; item_it = item_it + 1) {
			char* item;
			item = g_strdup (item_collection[item_it]);
			{
				if (_vala_strcmp0 (item, "..") != 0) {
					char* _tmp7_;
					if (last_item != NULL) {
						char* _tmp5_;
						char* _tmp6_;
						target_name = (_tmp6_ = g_strconcat (target_name, _tmp5_ = g_strconcat ("/", last_item, NULL), NULL), _g_free0 (target_name), _tmp6_);
						_g_free0 (_tmp5_);
					}
					last_item = (_tmp7_ = g_strdup (item), _g_free0 (last_item), _tmp7_);
				} else {
					char* _tmp8_;
					last_item = (_tmp8_ = NULL, _g_free0 (last_item), _tmp8_);
				}
				_g_free0 (item);
			}
		}
	}
	if (last_item != NULL) {
		_tmp9_ = _vala_strcmp0 (last_item, "..") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		char* _tmp10_;
		char* _tmp11_;
		target_name = (_tmp11_ = g_strconcat (target_name, _tmp10_ = g_strconcat ("/", last_item, NULL), NULL), _g_free0 (target_name), _tmp11_);
		_g_free0 (_tmp10_);
	}
	result = target_name;
	_g_free0 (last_item);
	name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gint vtg_path_utils_compare_vala_filenames (const char* filea, const char* fileb) {
	gint result = 0;
	char* dataa;
	char* datab;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (filea != NULL, 0);
	g_return_val_if_fail (fileb != NULL, 0);
	dataa = g_strdup (filea);
	datab = g_strdup (fileb);
	if (g_str_has_suffix (dataa, ".vala")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (dataa, ".vapi");
	}
	if (_tmp0_) {
		char* _tmp1_;
		dataa = (_tmp1_ = string_substring (dataa, (glong) 0, string_get_length (dataa) - 5), _g_free0 (dataa), _tmp1_);
	}
	if (g_str_has_suffix (datab, ".vala")) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_str_has_suffix (datab, ".vapi");
	}
	if (_tmp2_) {
		char* _tmp3_;
		datab = (_tmp3_ = string_substring (datab, (glong) 0, string_get_length (datab) - 5), _g_free0 (datab), _tmp3_);
	}
	result = g_strcmp0 (dataa, datab);
	_g_free0 (datab);
	_g_free0 (dataa);
	return result;
}


inline void vtg_utils_trace (const char* format, ...) {
	g_return_if_fail (format != NULL);
}


gboolean vtg_utils_is_vala_doc (GeditDocument* doc) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (doc != NULL, FALSE);
	if (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc) != NULL) {
		_tmp0_ = _vala_strcmp0 (gtk_source_language_get_id (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc)), "vala") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos) {
	gboolean result = FALSE;
	gboolean res;
	g_return_val_if_fail (src != NULL, FALSE);
	res = FALSE;
	if (gtk_source_buffer_iter_has_context_class (src, pos, "comment")) {
		res = TRUE;
	} else {
		gboolean _tmp0_ = FALSE;
		if (gtk_text_iter_is_end (pos)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = gtk_text_iter_get_char (pos) == '\n';
		}
		if (_tmp0_) {
			if (gtk_text_iter_backward_char (pos)) {
				if (gtk_source_buffer_iter_has_context_class (src, pos, "comment")) {
					res = TRUE;
				} else {
					gtk_text_iter_forward_char (pos);
				}
			}
		}
	}
	if (!res) {
		if (gtk_source_buffer_iter_has_context_class (src, pos, "string")) {
			gboolean _tmp1_ = FALSE;
			if (!gtk_text_iter_is_start (pos)) {
				_tmp1_ = gtk_text_iter_get_char (pos) == '"';
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				if (gtk_text_iter_backward_char (pos)) {
					if (gtk_source_buffer_iter_has_context_class (src, pos, "string")) {
						res = TRUE;
					} else {
						gtk_text_iter_forward_char (pos);
					}
				}
			}
		}
	}
	result = res;
	return result;
}


gboolean vtg_utils_is_vala_keyword (const char* word) {
	gboolean result = FALSE;
	gboolean res;
	g_return_val_if_fail (word != NULL, FALSE);
	res = FALSE;
	{
		char** keyword_collection;
		int keyword_collection_length1;
		int keyword_it;
		keyword_collection = vtg_utils__vala_keywords;
		keyword_collection_length1 = vtg_utils__vala_keywords_length1;
		for (keyword_it = 0; keyword_it < vtg_utils__vala_keywords_length1; keyword_it = keyword_it + 1) {
			char* keyword;
			keyword = g_strdup (keyword_collection[keyword_it]);
			{
				if (_vala_strcmp0 (keyword, word) == 0) {
					res = TRUE;
					_g_free0 (keyword);
					break;
				}
				_g_free0 (keyword);
			}
		}
	}
	result = res;
	return result;
}


char* vtg_utils_get_document_name (GeditDocument* doc) {
	char* result = NULL;
	char* name;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	name = g_strdup (gedit_document_get_uri (doc));
	if (name == NULL) {
		char* _tmp0_;
		name = (_tmp0_ = g_strdup (gedit_document_get_short_name_for_display (doc)), _g_free0 (name), _tmp0_);
	} else {
		{
			char* _tmp1_;
			char* _tmp2_;
			_tmp1_ = g_filename_from_uri (name, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch60_g_error;
			}
			name = (_tmp2_ = _tmp1_, _g_free0 (name), _tmp2_);
		}
		goto __finally60;
		__catch60_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgutils.vala:352: error %s converting file %s to uri", e->message, name);
				_g_error_free0 (e);
			}
		}
		__finally60:
		if (_inner_error_ != NULL) {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vtg_utils_is_vala_doc (doc)) {
		_tmp3_ = !g_str_has_suffix (name, ".vala");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		char* _tmp4_;
		name = (_tmp4_ = g_strconcat (name, ".vala", NULL), _g_free0 (name), _tmp4_);
	}
	result = name;
	return result;
}


GtkBuilder* vtg_utils_get_builder (void) {
	GtkBuilder* result = NULL;
	GError * _inner_error_ = NULL;
	if (vtg_utils__builder == NULL) {
		GtkBuilder* _tmp0_;
		vtg_utils__builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (vtg_utils__builder), _tmp0_);
		{
			char* _tmp1_;
			gtk_builder_add_from_file (vtg_utils__builder, _tmp1_ = vtg_utils_get_ui_path ("vtg.ui"), &_inner_error_);
			_g_free0 (_tmp1_);
			if (_inner_error_ != NULL) {
				goto __catch61_g_error;
			}
		}
		goto __finally61;
		__catch61_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vtgutils.vala:369: initialize_ui: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally61:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (vtg_utils__builder);
	return result;
}


GtkSourceCompletionItem** vtg_utils_get_proposal_cache (int* result_length1) {
	GtkSourceCompletionItem** result = NULL;
	GtkSourceCompletionItem** _tmp0_;
	if (!vtg_utils__initialized) {
		vtg_utils_initialize ();
	}
	result = (_tmp0_ = vtg_utils__proposals, *result_length1 = vtg_utils__proposals_length1, _tmp0_);
	return result;
}


char* vtg_utils_get_image_path (const char* id) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (id != NULL, NULL);
	_result_ = g_build_filename (PACKAGE_DATADIR, "images", id, NULL);
	result = _result_;
	return result;
}


char* vtg_utils_get_ui_path (const char* id) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (id != NULL, NULL);
	_result_ = g_build_filename (PACKAGE_DATADIR, "ui", id, NULL);
	result = _result_;
	return result;
}


static void vtg_utils_initialize (void) {
	GError * _inner_error_ = NULL;
	{
		GtkSourceCompletionItem** _tmp0_;
		GdkPixbuf* _icon_generic;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		char* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		char* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		char* _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		char* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		GdkPixbuf* _tmp20_;
		char* _tmp21_;
		GdkPixbuf* _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		char* _tmp25_;
		GdkPixbuf* _tmp26_;
		GdkPixbuf* _tmp27_;
		GdkPixbuf* _tmp28_;
		char* _tmp29_;
		GdkPixbuf* _tmp30_;
		GdkPixbuf* _tmp31_;
		GdkPixbuf* _tmp32_;
		char* _tmp33_;
		GdkPixbuf* _tmp34_;
		GdkPixbuf* _tmp35_;
		GdkPixbuf* _tmp36_;
		char* _tmp37_;
		GdkPixbuf* _tmp38_;
		GdkPixbuf* _tmp39_;
		GdkPixbuf* _tmp40_;
		char* _tmp41_;
		GdkPixbuf* _tmp42_;
		GdkPixbuf* _tmp43_;
		GdkPixbuf* _tmp44_;
		vtg_utils__proposals = (_tmp0_ = g_new0 (GtkSourceCompletionItem*, VTG_UTILS_prealloc_count + 1), vtg_utils__proposals = (_vala_array_free (vtg_utils__proposals, vtg_utils__proposals_length1, (GDestroyNotify) g_object_unref), NULL), vtg_utils__proposals_length1 = VTG_UTILS_prealloc_count, _vtg_utils__proposals_size_ = vtg_utils__proposals_length1, _tmp0_);
		_icon_generic = _g_object_ref0 (gtk_icon_theme_load_icon (gtk_icon_theme_get_default (), GTK_STOCK_FILE, 16, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error_));
		if (_inner_error_ != NULL) {
			goto __catch62_g_error;
		}
		{
			gint idx;
			idx = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					GtkSourceCompletionItem* obj;
					GtkSourceCompletionItem* _tmp2_;
					if (!_tmp1_) {
						idx++;
					}
					_tmp1_ = FALSE;
					if (!(idx < VTG_UTILS_prealloc_count)) {
						break;
					}
					obj = gtk_source_completion_item_new ("", "", _icon_generic, "");
					vtg_utils__proposals[idx] = (_tmp2_ = _g_object_ref0 (obj), _g_object_unref0 (vtg_utils__proposals[idx]), _tmp2_);
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp3_ = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (), GTK_STOCK_FILE, 16, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_generic = (_tmp4_ = _g_object_ref0 (_tmp3_), _g_object_unref0 (vtg_utils_icon_generic), _tmp4_);
		_tmp7_ = (_tmp6_ = gdk_pixbuf_new_from_file (_tmp5_ = vtg_utils_get_image_path ("element-field-16.png"), &_inner_error_), _g_free0 (_tmp5_), _tmp6_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_field = (_tmp8_ = _tmp7_, _g_object_unref0 (vtg_utils_icon_field), _tmp8_);
		_tmp11_ = (_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_ = vtg_utils_get_image_path ("element-method-16.png"), &_inner_error_), _g_free0 (_tmp9_), _tmp10_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_method = (_tmp12_ = _tmp11_, _g_object_unref0 (vtg_utils_icon_method), _tmp12_);
		_tmp15_ = (_tmp14_ = gdk_pixbuf_new_from_file (_tmp13_ = vtg_utils_get_image_path ("element-class-16.png"), &_inner_error_), _g_free0 (_tmp13_), _tmp14_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_class = (_tmp16_ = _tmp15_, _g_object_unref0 (vtg_utils_icon_class), _tmp16_);
		_tmp19_ = (_tmp18_ = gdk_pixbuf_new_from_file (_tmp17_ = vtg_utils_get_image_path ("element-structure-16.png"), &_inner_error_), _g_free0 (_tmp17_), _tmp18_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_struct = (_tmp20_ = _tmp19_, _g_object_unref0 (vtg_utils_icon_struct), _tmp20_);
		_tmp23_ = (_tmp22_ = gdk_pixbuf_new_from_file (_tmp21_ = vtg_utils_get_image_path ("element-property-16.png"), &_inner_error_), _g_free0 (_tmp21_), _tmp22_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_property = (_tmp24_ = _tmp23_, _g_object_unref0 (vtg_utils_icon_property), _tmp24_);
		_tmp27_ = (_tmp26_ = gdk_pixbuf_new_from_file (_tmp25_ = vtg_utils_get_image_path ("element-event-16.png"), &_inner_error_), _g_free0 (_tmp25_), _tmp26_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_signal = (_tmp28_ = _tmp27_, _g_object_unref0 (vtg_utils_icon_signal), _tmp28_);
		_tmp31_ = (_tmp30_ = gdk_pixbuf_new_from_file (_tmp29_ = vtg_utils_get_image_path ("element-interface-16.png"), &_inner_error_), _g_free0 (_tmp29_), _tmp30_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_iface = (_tmp32_ = _tmp31_, _g_object_unref0 (vtg_utils_icon_iface), _tmp32_);
		_tmp35_ = (_tmp34_ = gdk_pixbuf_new_from_file (_tmp33_ = vtg_utils_get_image_path ("element-enumeration-16.png"), &_inner_error_), _g_free0 (_tmp33_), _tmp34_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_enum = (_tmp36_ = _tmp35_, _g_object_unref0 (vtg_utils_icon_enum), _tmp36_);
		_tmp39_ = (_tmp38_ = gdk_pixbuf_new_from_file (_tmp37_ = vtg_utils_get_image_path ("element-literal-16.png"), &_inner_error_), _g_free0 (_tmp37_), _tmp38_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_const = (_tmp40_ = _tmp39_, _g_object_unref0 (vtg_utils_icon_const), _tmp40_);
		_tmp43_ = (_tmp42_ = gdk_pixbuf_new_from_file (_tmp41_ = vtg_utils_get_image_path ("element-namespace-16.png"), &_inner_error_), _g_free0 (_tmp41_), _tmp42_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_icon_generic);
			goto __catch62_g_error;
		}
		vtg_utils_icon_namespace = (_tmp44_ = _tmp43_, _g_object_unref0 (vtg_utils_icon_namespace), _tmp44_);
		vtg_utils__initialized = TRUE;
		_g_object_unref0 (_icon_generic);
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgutils.vala:417: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally62:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vtg_utils_get_available_packages (void) {
	ValaList* result = NULL;
	if (vtg_utils__available_packages == NULL) {
		vtg_utils_initialize_packages_cache ();
	}
	result = _vala_collection_object_ref0 (vtg_utils__available_packages);
	return result;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void vtg_utils_initialize_packages_cache (void) {
	GList* vapidirs;
	ValaList* _tmp0_;
	GError * _inner_error_ = NULL;
	vapidirs = NULL;
	vapidirs = g_list_append (vapidirs, g_strdup (VALA_VAPIDIR));
	vapidirs = g_list_append (vapidirs, g_strdup ("/usr/local/share/vala/vapi"));
	vtg_utils__available_packages = (_tmp0_ = (ValaList*) vala_array_list_new (VBF_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), _vala_collection_object_unref0 (vtg_utils__available_packages), _tmp0_);
	{
		GList* vapidir_collection;
		GList* vapidir_it;
		vapidir_collection = vapidirs;
		for (vapidir_it = vapidir_collection; vapidir_it != NULL; vapidir_it = vapidir_it->next) {
			char* vapidir;
			vapidir = g_strdup ((const char*) vapidir_it->data);
			{
				GDir* dir;
				char* filename;
				dir = NULL;
				{
					GDir* _tmp1_;
					GDir* _tmp2_;
					_tmp1_ = g_dir_open (vapidir, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch63_g_file_error;
						}
						_g_dir_close0 (dir);
						_g_free0 (vapidir);
						__g_list_free_g_free0 (vapidirs);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					dir = (_tmp2_ = _tmp1_, _g_dir_close0 (dir), _tmp2_);
				}
				goto __finally63;
				__catch63_g_file_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (err);
						_g_dir_close0 (dir);
						_g_free0 (vapidir);
						continue;
					}
				}
				__finally63:
				if (_inner_error_ != NULL) {
					_g_dir_close0 (dir);
					_g_free0 (vapidir);
					__g_list_free_g_free0 (vapidirs);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				filename = g_strdup (g_dir_read_name (dir));
				while (TRUE) {
					char* _tmp6_;
					if (!(filename != NULL)) {
						break;
					}
					if (g_str_has_suffix (filename, ".vapi")) {
						char* _tmp3_;
						char* _tmp4_;
						VbfPackage* _tmp5_;
						filename = (_tmp3_ = g_utf8_strdown (filename, -1), _g_free0 (filename), _tmp3_);
						vala_collection_add ((ValaCollection*) vtg_utils__available_packages, _tmp5_ = vbf_package_new (_tmp4_ = string_substring (filename, (glong) 0, string_get_length (filename) - 5)));
						_g_object_unref0 (_tmp5_);
						_g_free0 (_tmp4_);
					}
					filename = (_tmp6_ = g_strdup (g_dir_read_name (dir)), _g_free0 (filename), _tmp6_);
				}
				_g_free0 (filename);
				_g_dir_close0 (dir);
				_g_free0 (vapidir);
			}
		}
	}
	__g_list_free_g_free0 (vapidirs);
}


GdkPixbuf* vtg_utils_get_icon_for_type_name (const char* type_name) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (type_name != NULL, NULL);
	if (!vtg_utils__initialized) {
		vtg_utils_initialize ();
	}
	if (vtg_utils_icon_namespace != NULL) {
		_tmp0_ = _vala_strcmp0 (type_name, "Namespace") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _g_object_ref0 (vtg_utils_icon_namespace);
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (vtg_utils_icon_class != NULL) {
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (_vala_strcmp0 (type_name, "Class") == 0) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = _vala_strcmp0 (type_name, "CreationMethod") == 0;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = _vala_strcmp0 (type_name, "Destructor") == 0;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = _vala_strcmp0 (type_name, "Constructor") == 0;
			}
			if (_tmp3_) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = _vala_strcmp0 (type_name, "ErrorDomain") == 0;
			}
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = _g_object_ref0 (vtg_utils_icon_class);
			return result;
		} else {
			gboolean _tmp6_ = FALSE;
			if (vtg_utils_icon_struct != NULL) {
				_tmp6_ = _vala_strcmp0 (type_name, "Struct") == 0;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = _g_object_ref0 (vtg_utils_icon_struct);
				return result;
			} else {
				gboolean _tmp7_ = FALSE;
				if (vtg_utils_icon_iface != NULL) {
					_tmp7_ = _vala_strcmp0 (type_name, "Interface") == 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					result = _g_object_ref0 (vtg_utils_icon_iface);
					return result;
				} else {
					gboolean _tmp8_ = FALSE;
					if (vtg_utils_icon_field != NULL) {
						_tmp8_ = _vala_strcmp0 (type_name, "Field") == 0;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						result = _g_object_ref0 (vtg_utils_icon_field);
						return result;
					} else {
						gboolean _tmp9_ = FALSE;
						if (vtg_utils_icon_property != NULL) {
							_tmp9_ = _vala_strcmp0 (type_name, "Property") == 0;
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							result = _g_object_ref0 (vtg_utils_icon_property);
							return result;
						} else {
							gboolean _tmp10_ = FALSE;
							if (vtg_utils_icon_method != NULL) {
								gboolean _tmp11_ = FALSE;
								if (_vala_strcmp0 (type_name, "Method") == 0) {
									_tmp11_ = TRUE;
								} else {
									_tmp11_ = _vala_strcmp0 (type_name, "Delegate") == 0;
								}
								_tmp10_ = _tmp11_;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								result = _g_object_ref0 (vtg_utils_icon_method);
								return result;
							} else {
								gboolean _tmp12_ = FALSE;
								if (vtg_utils_icon_enum != NULL) {
									_tmp12_ = _vala_strcmp0 (type_name, "Enum") == 0;
								} else {
									_tmp12_ = FALSE;
								}
								if (_tmp12_) {
									result = _g_object_ref0 (vtg_utils_icon_enum);
									return result;
								} else {
									gboolean _tmp13_ = FALSE;
									if (vtg_utils_icon_const != NULL) {
										gboolean _tmp14_ = FALSE;
										gboolean _tmp15_ = FALSE;
										if (_vala_strcmp0 (type_name, "Constant") == 0) {
											_tmp15_ = TRUE;
										} else {
											_tmp15_ = _vala_strcmp0 (type_name, "EnumValue") == 0;
										}
										if (_tmp15_) {
											_tmp14_ = TRUE;
										} else {
											_tmp14_ = _vala_strcmp0 (type_name, "ErrorCode") == 0;
										}
										_tmp13_ = _tmp14_;
									} else {
										_tmp13_ = FALSE;
									}
									if (_tmp13_) {
										result = _g_object_ref0 (vtg_utils_icon_const);
										return result;
									} else {
										gboolean _tmp16_ = FALSE;
										if (vtg_utils_icon_signal != NULL) {
											_tmp16_ = _vala_strcmp0 (type_name, "Signal") == 0;
										} else {
											_tmp16_ = FALSE;
										}
										if (_tmp16_) {
											result = _g_object_ref0 (vtg_utils_icon_signal);
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _g_object_ref0 (vtg_utils_icon_generic);
	return result;
}


char* vtg_utils_get_stock_id_for_target_type (VbfTargetTypes type) {
	char* result = NULL;
	switch (type) {
		case VBF_TARGET_TYPES_PROGRAM:
		{
			result = g_strdup (GTK_STOCK_EXECUTE);
			return result;
		}
		case VBF_TARGET_TYPES_LIBRARY:
		{
			result = g_strdup (GTK_STOCK_EXECUTE);
			return result;
		}
		case VBF_TARGET_TYPES_DATA:
		{
			result = g_strdup (GTK_STOCK_DIRECTORY);
			return result;
		}
		case VBF_TARGET_TYPES_BUILT_SOURCES:
		{
			result = g_strdup (GTK_STOCK_EXECUTE);
			return result;
		}
		default:
		{
			result = g_strdup (GTK_STOCK_DIRECTORY);
			return result;
		}
	}
}


gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	if (vala == NULL) {
		_tmp0_ = valb == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (vala == NULL) {
			_tmp1_ = valb != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = 1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (vala != NULL) {
				_tmp2_ = valb == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = -1;
				return result;
			}
		}
	}
	if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), afrodite_symbol_get_type_name (valb)) != 0) {
		if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Constant") == 0) {
			result = -1;
			return result;
		} else {
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Constant") == 0) {
				result = 1;
				return result;
			} else {
				if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Enum") == 0) {
					result = -1;
					return result;
				} else {
					if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Enum") == 0) {
						result = 1;
						return result;
					} else {
						if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Field") == 0) {
							result = -1;
							return result;
						} else {
							if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Field") == 0) {
								result = 1;
								return result;
							} else {
								if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Property") == 0) {
									result = -1;
									return result;
								} else {
									if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Property") == 0) {
										result = 1;
										return result;
									} else {
										if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Signal") == 0) {
											result = -1;
											return result;
										} else {
											if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Signal") == 0) {
												result = 1;
												return result;
											} else {
												if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "CreationMethod") == 0) {
													result = -1;
													return result;
												} else {
													if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "CreationMethod") == 0) {
														result = 1;
														return result;
													} else {
														if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Constructor") == 0) {
															result = -1;
															return result;
														} else {
															if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Constructor") == 0) {
																result = 1;
																return result;
															} else {
																if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Method") == 0) {
																	result = -1;
																	return result;
																} else {
																	if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Method") == 0) {
																		result = 1;
																		return result;
																	} else {
																		if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "ErrorDomain") == 0) {
																			result = -1;
																			return result;
																		} else {
																			if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "ErrorDomain") == 0) {
																				result = 1;
																				return result;
																			} else {
																				if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Namespace") == 0) {
																					result = -1;
																					return result;
																				} else {
																					if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Namespace") == 0) {
																						result = 1;
																						return result;
																					} else {
																						if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Struct") == 0) {
																							result = -1;
																							return result;
																						} else {
																							if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Struct") == 0) {
																								result = 1;
																								return result;
																							} else {
																								if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Class") == 0) {
																									result = -1;
																									return result;
																								} else {
																									if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Class") == 0) {
																										result = 1;
																										return result;
																									} else {
																										if (_vala_strcmp0 (afrodite_symbol_get_type_name (vala), "Interface") == 0) {
																											result = -1;
																											return result;
																										} else {
																											if (_vala_strcmp0 (afrodite_symbol_get_type_name (valb), "Interface") == 0) {
																												result = 1;
																												return result;
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = g_strcmp0 (afrodite_symbol_get_name (vala), afrodite_symbol_get_name (valb));
	return result;
}


VtgUtils* vtg_utils_construct (GType object_type) {
	VtgUtils * self;
	self = (VtgUtils*) g_object_new (object_type, NULL);
	return self;
}


VtgUtils* vtg_utils_new (void) {
	return vtg_utils_construct (VTG_TYPE_UTILS);
}


static void vtg_utils_class_init (VtgUtilsClass * klass) {
	char** _tmp0_ = NULL;
	vtg_utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vtg_utils_finalize;
	vtg_utils__vala_keywords = (_tmp0_ = g_new0 (char*, 19 + 1), _tmp0_[0] = g_strdup ("var"), _tmp0_[1] = g_strdup ("out"), _tmp0_[2] = g_strdup ("ref"), _tmp0_[3] = g_strdup ("const"), _tmp0_[4] = g_strdup ("static"), _tmp0_[5] = g_strdup ("inline"), _tmp0_[6] = g_strdup ("public"), _tmp0_[7] = g_strdup ("protected"), _tmp0_[8] = g_strdup ("private"), _tmp0_[9] = g_strdup ("internal"), _tmp0_[10] = g_strdup ("this"), _tmp0_[11] = g_strdup ("base"), _tmp0_[12] = g_strdup ("if"), _tmp0_[13] = g_strdup ("while"), _tmp0_[14] = g_strdup ("do"), _tmp0_[15] = g_strdup ("else"), _tmp0_[16] = g_strdup ("return"), _tmp0_[17] = g_strdup ("try"), _tmp0_[18] = g_strdup ("catch"), _tmp0_);
	vtg_utils__vala_keywords_length1 = 19;
}


static void vtg_utils_instance_init (VtgUtils * self) {
}


static void vtg_utils_finalize (GObject* obj) {
	VtgUtils * self;
	self = VTG_UTILS (obj);
	G_OBJECT_CLASS (vtg_utils_parent_class)->finalize (obj);
}


GType vtg_utils_get_type (void) {
	return vtg_utils_type_id;
}


GType vtg_utils_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgUtils), 0, (GInstanceInitFunc) vtg_utils_instance_init, NULL };
	vtg_utils_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgUtils", &g_define_type_info, 0);
	return vtg_utils_type_id;
}


/**
 * Utility method to get the text from the start iter
 * to the end of line.
 *
 * @param start start iter from which start to get the text (this iter will not be modified)
 * @return the text from the start iter to the end of line or an empty string if the iter is already on the line end.
 */
char* vtg_parser_utils_get_line_to_end (GtkTextIter* start) {
	char* result = NULL;
	char* text;
	GtkTextIter end;
	text = g_strdup ("");
	end = *start;
	gtk_text_iter_set_line_offset (&end, 0);
	if (gtk_text_iter_forward_to_line_end (&end)) {
		char* _tmp0_;
		text = (_tmp0_ = g_strdup (gtk_text_iter_get_text (start, &end)), _g_free0 (text), _tmp0_);
	}
	result = text;
	return result;
}


void vtg_parser_utils_parse_line (const char* line, char** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration) {
	char* _tmp0_;
	gint i;
	char* tok;
	gint count;
	char* _tmp1_;
	g_return_if_fail (line != NULL);
	if (token != NULL) {
		*token = NULL;
	}
	*token = (_tmp0_ = g_strdup (""), _g_free0 (*token), _tmp0_);
	*is_assignment = FALSE;
	*is_creation = FALSE;
	*is_declaration = FALSE;
	i = ((gint) string_get_length (line)) - 1;
	tok = NULL;
	count = 0;
	*token = (_tmp1_ = vtg_parser_utils_get_token (line, &i), _g_free0 (*token), _tmp1_);
	if ((*token) != NULL) {
		char* last_token;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		count = 1;
		last_token = g_strdup (*token);
		while (TRUE) {
			char* _tmp2_;
			char* _tmp3_;
			if (!((tok = (_tmp2_ = vtg_parser_utils_get_token (line, &i), _g_free0 (tok), _tmp2_)) != NULL)) {
				break;
			}
			count++;
			if (_vala_strcmp0 (tok, "=") == 0) {
				*is_assignment = TRUE;
			} else {
				if (_vala_strcmp0 (tok, "new") == 0) {
					*is_creation = TRUE;
				}
			}
			last_token = (_tmp3_ = g_strdup (tok), _g_free0 (last_token), _tmp3_);
		}
		if (!(*is_assignment)) {
			_tmp5_ = !(*is_creation);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = count == 2;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp6_ = FALSE;
			if (_vala_strcmp0 (last_token, "var") == 0) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!vtg_utils_is_vala_keyword (last_token)) {
					_tmp8_ = !g_str_has_prefix (last_token, "\"");
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_tmp7_ = !g_str_has_prefix (last_token, "'");
				} else {
					_tmp7_ = FALSE;
				}
				_tmp6_ = _tmp7_;
			}
			if (_tmp6_) {
				*is_declaration = TRUE;
			}
		}
		if (g_str_has_suffix (*token, ".")) {
			char* _tmp9_;
			*token = (_tmp9_ = string_substring (*token, (glong) 0, string_get_length (*token) - 1), _g_free0 (*token), _tmp9_);
		}
		_g_free0 (last_token);
	}
	vtg_utils_trace ("vtgutils.vala:634: parse line new: '%s'. is_assignment: %d is_creation" \
": %d is_declaration: %d token: '%s'", line, (gint) (*is_assignment), (gint) (*is_creation), (gint) (*is_declaration), *token);
	_g_free0 (tok);
}


static char* g_unichar_to_string (gunichar self) {
	char* result = NULL;
	char* str;
	str = (char*) g_new0 (gchar, 7);
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


char* vtg_parser_utils_get_token (const char* line, gint* i) {
	char* result = NULL;
	char* tok;
	gint skip_lev;
	gboolean in_string;
	gboolean should_skip_spaces;
	const char* _tmp18_;
	g_return_val_if_fail (line != NULL, NULL);
	tok = g_strdup ("");
	skip_lev = 0;
	in_string = FALSE;
	should_skip_spaces = TRUE;
	while (TRUE) {
		if (!(!vtg_parser_utils_is_eof (line, *i))) {
			break;
		}
		if (should_skip_spaces) {
			*i = vtg_parser_utils_skip_spaces (line, *i);
			should_skip_spaces = FALSE;
		}
		if (!vtg_parser_utils_is_eof (line, *i)) {
			gunichar ch;
			ch = g_utf8_get_char (g_utf8_offset_to_pointer (line, *i));
			if (skip_lev == 0) {
				gboolean _tmp0_ = FALSE;
				if (ch == '"') {
					_tmp0_ = TRUE;
				} else {
					_tmp0_ = ch == '\'';
				}
				if (_tmp0_) {
					char* _tmp1_;
					char* _tmp2_;
					tok = (_tmp2_ = g_strconcat (_tmp1_ = g_unichar_to_string (ch), tok, NULL), _g_free0 (tok), _tmp2_);
					_g_free0 (_tmp1_);
					if (!in_string) {
						in_string = TRUE;
					} else {
						in_string = FALSE;
					}
				} else {
					gboolean _tmp3_ = FALSE;
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
					if (ch == '_') {
						_tmp5_ = TRUE;
					} else {
						_tmp5_ = ch == '.';
					}
					if (_tmp5_) {
						_tmp4_ = TRUE;
					} else {
						gboolean _tmp6_ = FALSE;
						if (string_get_length (tok) == 0) {
							_tmp6_ = g_unichar_isalpha (ch);
						} else {
							_tmp6_ = FALSE;
						}
						_tmp4_ = _tmp6_;
					}
					if (_tmp4_) {
						_tmp3_ = TRUE;
					} else {
						gboolean _tmp7_ = FALSE;
						if (string_get_length (tok) > 0) {
							_tmp7_ = g_unichar_isalnum (ch);
						} else {
							_tmp7_ = FALSE;
						}
						_tmp3_ = _tmp7_;
					}
					if (_tmp3_) {
						char* _tmp8_;
						char* _tmp9_;
						tok = (_tmp9_ = g_strconcat (_tmp8_ = g_unichar_to_string (ch), tok, NULL), _g_free0 (tok), _tmp9_);
						_g_free0 (_tmp8_);
					} else {
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						if (ch == ' ') {
							_tmp11_ = TRUE;
						} else {
							_tmp11_ = ch == '=';
						}
						if (_tmp11_) {
							_tmp10_ = TRUE;
						} else {
							_tmp10_ = ch == '!';
						}
						if (_tmp10_) {
							if (in_string) {
								char* _tmp12_;
								char* _tmp13_;
								tok = (_tmp13_ = g_strconcat (_tmp12_ = g_unichar_to_string (ch), tok, NULL), _g_free0 (tok), _tmp13_);
								_g_free0 (_tmp12_);
							} else {
								break;
							}
						}
					}
				}
			}
			if (!in_string) {
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				if (ch == '(') {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = ch == '[';
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = ch == '{';
				}
				if (_tmp14_) {
					if (skip_lev > 0) {
						skip_lev--;
						if (skip_lev == 0) {
							should_skip_spaces = TRUE;
						}
					} else {
						break;
					}
				} else {
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					if (ch == ')') {
						_tmp17_ = TRUE;
					} else {
						_tmp17_ = ch == ']';
					}
					if (_tmp17_) {
						_tmp16_ = TRUE;
					} else {
						_tmp16_ = ch == '}';
					}
					if (_tmp16_) {
						skip_lev++;
					}
				}
			}
			(*i)--;
		}
	}
	_tmp18_ = NULL;
	if (_vala_strcmp0 (tok, "") == 0) {
		_tmp18_ = NULL;
	} else {
		_tmp18_ = tok;
	}
	result = g_strdup (_tmp18_);
	_g_free0 (tok);
	return result;
}


gint vtg_parser_utils_skip_spaces (const char* line, gint i) {
	gint result = 0;
	gunichar ch;
	g_return_val_if_fail (line != NULL, 0);
	ch = g_utf8_get_char (g_utf8_offset_to_pointer (line, i));
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!vtg_parser_utils_is_eof (line, i)) {
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			if (ch == ' ') {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = ch == '\t';
			}
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_unichar_isspace (ch);
			}
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		i--;
		ch = g_utf8_get_char (g_utf8_offset_to_pointer (line, i));
	}
	result = i;
	return result;
}


gboolean vtg_parser_utils_is_eof (const char* line, gint i) {
	gboolean result = FALSE;
	g_return_val_if_fail (line != NULL, FALSE);
	result = i < 0;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




