/* vtgsymbolcompletionprovider.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgsymbolcompletionprovider.vala, do not modify */

/*
 *  vtgsymbolcompletionprovider.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <afrodite.h>
#include <gtk/gtk.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-statusbar.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkkeysyms.h>
#include <valagee.h>
#include <vbf.h>


#define VTG_TYPE_SYMBOL_COMPLETION_PROVIDER (vtg_symbol_completion_provider_get_type ())
#define VTG_SYMBOL_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProvider))
#define VTG_SYMBOL_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderClass))
#define VTG_IS_SYMBOL_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER))
#define VTG_IS_SYMBOL_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER))
#define VTG_SYMBOL_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderClass))

typedef struct _VtgSymbolCompletionProvider VtgSymbolCompletionProvider;
typedef struct _VtgSymbolCompletionProviderClass VtgSymbolCompletionProviderClass;
typedef struct _VtgSymbolCompletionProviderPrivate VtgSymbolCompletionProviderPrivate;

#define VTG_TYPE_SYMBOL_COMPLETION (vtg_symbol_completion_get_type ())
#define VTG_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletion))
#define VTG_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))
#define VTG_IS_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_IS_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_SYMBOL_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))

typedef struct _VtgSymbolCompletion VtgSymbolCompletion;
typedef struct _VtgSymbolCompletionClass VtgSymbolCompletionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _afrodite_result_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_result_item_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _afrodite_ast_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_ast_unref (var), NULL)))
#define _afrodite_query_result_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_result_unref (var), NULL)))
#define _afrodite_query_options_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_options_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))

struct _VtgSymbolCompletionProvider {
	GObject parent_instance;
	VtgSymbolCompletionProviderPrivate * priv;
};

struct _VtgSymbolCompletionProviderClass {
	GObjectClass parent_class;
};

struct _VtgSymbolCompletionProviderPrivate {
	GdkPixbuf* _icon;
	gint _priority;
	GList* _proposals;
	AfroditeSourceItem* _sb;
	guint _timeout_id;
	guint _idle_id;
	gboolean _all_doc;
	gint _prealloc_index;
	gboolean _cache_building;
	gboolean _filter;
	guint _sb_msg_id;
	guint _sb_context_id;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
	gint _last_line;
	gboolean _doc_changed;
	VtgSymbolCompletion* _symbol_completion;
	AfroditeCompletionEngine* _completion;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	char* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	char* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


static gpointer vtg_symbol_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface* vtg_symbol_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static GType vtg_symbol_completion_provider_type_id = 0;

GType vtg_symbol_completion_provider_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_provider_register_type (GTypeModule * module);
GType vtg_symbol_completion_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_register_type (GTypeModule * module);
#define VTG_SYMBOL_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderPrivate))
enum  {
	VTG_SYMBOL_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
VtgSymbolCompletionProvider* vtg_symbol_completion_provider_new (VtgSymbolCompletion* symbol_completion);
VtgSymbolCompletionProvider* vtg_symbol_completion_provider_construct (GType object_type, VtgSymbolCompletion* symbol_completion);
GeditView* vtg_symbol_completion_get_view (VtgSymbolCompletion* self);
char* vtg_utils_get_document_name (GeditDocument* doc);
void vtg_utils_trace (const char* format, ...);
static gboolean vtg_symbol_completion_provider_on_view_key_press (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean vtg_symbol_completion_provider_on_view_focus_out (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventFocus* event);
static gboolean _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void vtg_symbol_completion_provider_on_completion_window_hide (VtgSymbolCompletionProvider* self, GtkSourceCompletion* sender);
static void _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show (GtkSourceCompletion* _sender, gpointer self);
static void vtg_symbol_completion_provider_on_text_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec);
static void _vtg_symbol_completion_provider_on_text_changed_g_object_notify (GeditDocument* _sender, GParamSpec* pspec, gpointer self);
static void vtg_symbol_completion_provider_on_cursor_position_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec);
static void _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify (GeditDocument* _sender, GParamSpec* pspec, gpointer self);
static void vtg_symbol_completion_provider_on_document_saved (GeditDocument* doc, void* arg1, VtgSymbolCompletionProvider* self);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
VtgPluginInstance* vtg_symbol_completion_get_plugin_instance (VtgSymbolCompletion* self);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_symbol_completion_provider_on_completion_engine_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec);
static void _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
AfroditeCompletionEngine* vtg_symbol_completion_get_completion_engine (VtgSymbolCompletion* self);
static char* vtg_symbol_completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static gint vtg_symbol_completion_provider_real_get_priority (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
static void vtg_symbol_completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
void vtg_parser_utils_parse_line (const char* line, char** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration);
static void vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (VtgSymbolCompletionProvider* self, const char* word, AfroditeCompareMode mode);
static void vtg_symbol_completion_provider_complete_current_word (VtgSymbolCompletionProvider* self);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
static GdkPixbuf* vtg_symbol_completion_provider_real_get_icon (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static GtkSourceCompletionActivation vtg_symbol_completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static GtkWidget* vtg_symbol_completion_provider_real_get_info_widget (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal);
static gint vtg_symbol_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void vtg_symbol_completion_provider_real_update_info (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkSourceCompletionInfo* info);
static void vtg_symbol_completion_provider_hide_calltip (VtgSymbolCompletionProvider* self);
static void vtg_symbol_completion_provider_schedule_reparse (VtgSymbolCompletionProvider* self);
static gint vtg_symbol_completion_provider_get_current_line_index (VtgSymbolCompletionProvider* self, GeditDocument* doc);
static gboolean vtg_symbol_completion_provider_on_timeout_parse (VtgSymbolCompletionProvider* self);
static gboolean _vtg_symbol_completion_provider_on_timeout_parse_gsource_func (gpointer self);
static void vtg_symbol_completion_provider_parse (VtgSymbolCompletionProvider* self, GeditDocument* doc);
static void vtg_symbol_completion_provider_show_calltip (VtgSymbolCompletionProvider* self);
AfroditeSymbol* vtg_symbol_completion_provider_get_current_symbol_item (VtgSymbolCompletionProvider* self, gint retry_count);
static void vtg_symbol_completion_provider_show_calltip_info (VtgSymbolCompletionProvider* self, const char* markup_text);
static void vtg_symbol_completion_provider_initialize_calltip_window (VtgSymbolCompletionProvider* self);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
static gint vtg_symbol_completion_provider_autoadd_packages (VtgSymbolCompletionProvider* self, GeditDocument* doc, VtgProjectManager* project_manager);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
static char* vtg_symbol_completion_provider_get_document_text (VtgSymbolCompletionProvider* self, GeditDocument* doc, gboolean all_doc);
static gboolean vtg_symbol_completion_provider_proposal_list_contains_name (VtgSymbolCompletionProvider* self, const char* name);
static void vtg_symbol_completion_provider_append_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, ValaList* symbols, gboolean include_private_symbols);
GtkSourceCompletionItem** vtg_utils_get_proposal_cache (int* result_length1);
GdkPixbuf* vtg_utils_get_icon_for_type_name (const char* type_name);
#define VTG_UTILS_prealloc_count 500
static gint vtg_symbol_completion_provider_proposal_sort (void* a, void* b);
static gint _vtg_symbol_completion_provider_proposal_sort_gcompare_func (void* a, void* b);
static void vtg_symbol_completion_provider_transform_result (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeQueryResult* _result_);
static void vtg_symbol_completion_provider_append_base_type_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeSymbol* symbol, ValaList* visited_interfaces);
static void vtg_symbol_completion_provider_get_current_line_and_column (VtgSymbolCompletionProvider* self, gint* line, gint* column);
static char* vtg_symbol_completion_provider_get_current_line_text (VtgSymbolCompletionProvider* self, gboolean align_to_right_word);
static gboolean vtg_symbol_completion_provider_is_vala_keyword (VtgSymbolCompletionProvider* self, const char* keyword);
static AfroditeQueryOptions* vtg_symbol_completion_provider_get_options_for_line (VtgSymbolCompletionProvider* self, const char* line, gboolean is_assignment, gboolean is_creation);
static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeAst* ast, const char* word, const char* whole_line, gint line, gint column);
static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_type_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeAst* ast, const char* word, const char* whole_line, gint line, gint column);
static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_children (VtgSymbolCompletionProvider* self, const char* symbol_name, AfroditeSymbol* parent);
static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (VtgSymbolCompletionProvider* self, const char* symbol_name, AfroditeSymbol* parent);
static gboolean vtg_symbol_completion_provider_on_hide_calltip_timeout (VtgSymbolCompletionProvider* self);
static gboolean _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func (gpointer self);
static void vtg_symbol_completion_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_view_key_press (self, _sender, event);
	return result;
}


static gboolean _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_view_focus_out (self, _sender, event);
	return result;
}


static void _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show (GtkSourceCompletion* _sender, gpointer self) {
	vtg_symbol_completion_provider_on_completion_window_hide (self, _sender);
}


static void _vtg_symbol_completion_provider_on_text_changed_g_object_notify (GeditDocument* _sender, GParamSpec* pspec, gpointer self) {
	vtg_symbol_completion_provider_on_text_changed (self, _sender, pspec);
}


static void _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify (GeditDocument* _sender, GParamSpec* pspec, gpointer self) {
	vtg_symbol_completion_provider_on_cursor_position_changed (self, _sender, pspec);
}


static void _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_symbol_completion_provider_on_completion_engine_changed (self, _sender, pspec);
}


VtgSymbolCompletionProvider* vtg_symbol_completion_provider_construct (GType object_type, VtgSymbolCompletion* symbol_completion) {
	VtgSymbolCompletionProvider * self;
	GdkPixbuf* _tmp0_;
	GeditDocument* doc;
	char* name;
	AfroditeSourceItem* _tmp1_;
	char* _tmp2_;
	char* _tmp3_ = NULL;
	char* _tmp4_;
	GeditStatusbar* status_bar;
	g_return_val_if_fail (symbol_completion != NULL, NULL);
	self = (VtgSymbolCompletionProvider*) g_object_new (object_type, NULL);
	self->priv->_icon = (_tmp0_ = _g_object_ref0 (gtk_source_completion_provider_get_icon ((GtkSourceCompletionProvider*) self)), _g_object_unref0 (self->priv->_icon), _tmp0_);
	self->priv->_symbol_completion = symbol_completion;
	doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion))));
	name = vtg_utils_get_document_name (doc);
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:67: initializing provider for documen" \
"t: %s", name);
	self->priv->_sb = (_tmp1_ = afrodite_source_item_new (), _afrodite_source_item_unref0 (self->priv->_sb), _tmp1_);
	self->priv->_sb->path = (_tmp2_ = g_strdup (name), _g_free0 (self->priv->_sb->path), _tmp2_);
	self->priv->_sb->content = (_tmp4_ = (g_object_get ((GtkTextBuffer*) doc, "text", &_tmp3_, NULL), _tmp3_), _g_free0 (self->priv->_sb->content), _tmp4_);
	g_signal_connect_object ((GtkWidget*) vtg_symbol_completion_get_view (self->priv->_symbol_completion), "key-press-event", (GCallback) _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) vtg_symbol_completion_get_view (self->priv->_symbol_completion), "focus-out-event", (GCallback) _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object (gtk_source_view_get_completion ((GtkSourceView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion)), "show", (GCallback) _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show, self, 0);
	g_signal_connect_object ((GObject*) doc, "notify::text", (GCallback) _vtg_symbol_completion_provider_on_text_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) doc, "notify::cursor-position", (GCallback) _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify, self, 0);
	g_signal_connect (doc, "saved", (GCallback) vtg_symbol_completion_provider_on_document_saved, self);
	status_bar = _g_object_ref0 (GEDIT_STATUSBAR (gedit_window_get_statusbar (vtg_plugin_instance_get_window (vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion)))));
	self->priv->_sb_context_id = gtk_statusbar_get_context_id ((GtkStatusbar*) status_bar, "symbol status");
	self->priv->_cache_building = TRUE;
	self->priv->_all_doc = TRUE;
	g_signal_connect_object ((GObject*) self->priv->_symbol_completion, "notify::completion-engine", (GCallback) _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify, self, 0);
	self->priv->_completion = vtg_symbol_completion_get_completion_engine (self->priv->_symbol_completion);
	_g_object_unref0 (status_bar);
	_g_free0 (name);
	_g_object_unref0 (doc);
	return self;
}


VtgSymbolCompletionProvider* vtg_symbol_completion_provider_new (VtgSymbolCompletion* symbol_completion) {
	return vtg_symbol_completion_provider_construct (VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, symbol_completion);
}


static char* vtg_symbol_completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	char* result = NULL;
	self = (VtgSymbolCompletionProvider*) base;
	result = g_strdup (_ ("Vala Toys Completion Provider"));
	return result;
}


static gint vtg_symbol_completion_provider_real_get_priority (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	gint result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = self->priv->_priority;
	return result;
}


static char* g_unichar_to_string (gunichar self) {
	char* result = NULL;
	char* str;
	str = (char*) g_new0 (gchar, 7);
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	GtkSourceBuffer* src;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	GtkTextIter pos;
	gboolean _result_;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	src = _g_object_ref0 (GTK_SOURCE_BUFFER (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion))));
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) src));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &start, mark);
	pos = start;
	_result_ = !vtg_utils_is_inside_comment_or_literal (src, &pos);
	if (_result_) {
		gint line;
		gunichar ch;
		pos = start;
		line = gtk_text_iter_get_line (&pos);
		ch = gtk_text_iter_get_char (&pos);
		if (gtk_text_iter_backward_char (&pos)) {
			if (gtk_text_iter_get_line (&pos) == line) {
				gunichar prev_ch;
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				prev_ch = gtk_text_iter_get_char (&pos);
				if (prev_ch == '(') {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = ch == '(';
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = prev_ch == '[';
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = ch == '[';
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = prev_ch == ' ';
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = prev_ch == ')';
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = prev_ch == ']';
				}
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = prev_ch == ';';
				}
				if (_tmp4_) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = prev_ch == '?';
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = prev_ch == '/';
				}
				if (_tmp2_) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = ch == '/';
				}
				if (_tmp1_) {
					_tmp0_ = TRUE;
				} else {
					_tmp0_ = prev_ch == ',';
				}
				if (_tmp0_) {
					char* _tmp11_;
					char* _tmp12_;
					_result_ = FALSE;
					vtg_utils_trace ("vtgsymbolcompletionprovider.vala:149: not match current char: '%s', pr" \
"evious: '%s'", _tmp11_ = g_unichar_to_string (ch), _tmp12_ = g_unichar_to_string (prev_ch));
					_g_free0 (_tmp12_);
					_g_free0 (_tmp11_);
				} else {
					char* _tmp13_;
					char* _tmp14_;
					vtg_utils_trace ("vtgsymbolcompletionprovider.vala:151: match current char: '%s', previo" \
"us: '%s'", _tmp13_ = g_unichar_to_string (ch), _tmp14_ = g_unichar_to_string (prev_ch));
					_g_free0 (_tmp14_);
					_g_free0 (_tmp13_);
				}
			}
		}
	}
	result = _result_;
	_g_object_unref0 (src);
	return result;
}


static void vtg_symbol_completion_provider_on_completion_window_hide (VtgSymbolCompletionProvider* self, GtkSourceCompletion* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_filter = FALSE;
}


static void vtg_symbol_completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	VtgSymbolCompletionProvider * self;
	GtkSourceCompletion* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkSourceCompletion* _tmp3_ = NULL;
	GtkSourceCompletion* _tmp4_;
	GtkSourceCompletion* _tmp5_ = NULL;
	GtkSourceCompletion* _tmp6_;
	char* text;
	gunichar prev_ch;
	gboolean symbols_in_scope_mode;
	char* word;
	gboolean _tmp7_ = FALSE;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:167: populate");
	mark = (_tmp2_ = GTK_TEXT_MARK (gtk_text_buffer_get_insert (gtk_text_view_get_buffer ((GtkTextView*) gtk_source_completion_get_view (_tmp1_ = (g_object_get (context, "completion", &_tmp0_, NULL), _tmp0_))))), _g_object_unref0 (_tmp1_), _tmp2_);
	gtk_text_buffer_get_iter_at_mark (gtk_text_view_get_buffer ((GtkTextView*) gtk_source_completion_get_view (_tmp4_ = (g_object_get (context, "completion", &_tmp3_, NULL), _tmp3_))), &start, mark);
	_g_object_unref0 (_tmp4_);
	gtk_text_buffer_get_iter_at_mark (gtk_text_view_get_buffer ((GtkTextView*) gtk_source_completion_get_view (_tmp6_ = (g_object_get (context, "completion", &_tmp5_, NULL), _tmp5_))), &end, mark);
	_g_object_unref0 (_tmp6_);
	if (!gtk_text_iter_starts_line (&start)) {
		gtk_text_iter_set_line_offset (&start, 0);
	}
	text = g_strdup (gtk_text_iter_get_text (&start, &end));
	prev_ch = (gunichar) 'a';
	if (gtk_text_iter_backward_char (&end)) {
		prev_ch = gtk_text_iter_get_char (&end);
		gtk_text_iter_forward_char (&end);
	}
	symbols_in_scope_mode = FALSE;
	word = g_strdup ("");
	self->priv->_filter = TRUE;
	if (g_str_has_suffix (text, ".")) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		if (prev_ch != '_') {
			_tmp8_ = !g_unichar_isalnum (prev_ch);
		} else {
			_tmp8_ = FALSE;
		}
		_tmp7_ = _tmp8_;
	}
	if (_tmp7_) {
		self->priv->_filter = FALSE;
	} else {
		gboolean dummy = FALSE;
		gboolean is_declaration = FALSE;
		char* _tmp9_ = NULL;
		char* _tmp10_;
		gboolean _tmp11_ = FALSE;
		vtg_parser_utils_parse_line (text, &_tmp9_, &dummy, &dummy, &is_declaration);
		word = (_tmp10_ = _tmp9_, _g_free0 (word), _tmp10_);
		if (!is_declaration) {
			_tmp11_ = g_strrstr (word, ".") == NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			symbols_in_scope_mode = TRUE;
			self->priv->_filter = FALSE;
		}
	}
	if (!self->priv->_filter) {
		GList* _tmp12_;
		self->priv->_proposals = (_tmp12_ = NULL, __g_list_free_g_object_unref0 (self->priv->_proposals), _tmp12_);
		if (symbols_in_scope_mode) {
			vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (self, word, AFRODITE_COMPARE_MODE_START_WITH);
		} else {
			vtg_symbol_completion_provider_complete_current_word (self);
		}
		gtk_source_completion_context_add_proposals (context, self, self->priv->_proposals, TRUE);
	} else {
		gint tmp_length1;
		gint _tmp_size_;
		char** _tmp14_;
		char** _tmp13_;
		char** tmp;
		char* last_part;
		tmp = (_tmp14_ = _tmp13_ = g_strsplit (word, ".", 0), tmp_length1 = _vala_array_length (_tmp13_), _tmp_size_ = tmp_length1, _tmp14_);
		last_part = g_strdup ("");
		if (tmp_length1 > 0) {
			char* _tmp15_;
			last_part = (_tmp15_ = g_strdup (tmp[tmp_length1 - 1]), _g_free0 (last_part), _tmp15_);
		}
		vtg_utils_trace ("vtgsymbolcompletionprovider.vala:215: filtering with: '%s' - '%s'", word, last_part);
		if (!vtg_string_utils_is_null_or_empty (last_part)) {
			GList* filtered_proposals;
			gboolean _tmp16_ = FALSE;
			filtered_proposals = NULL;
			{
				GList* proposal_collection;
				GList* proposal_it;
				proposal_collection = self->priv->_proposals;
				for (proposal_it = proposal_collection; proposal_it != NULL; proposal_it = proposal_it->next) {
					GtkSourceCompletionItem* proposal;
					proposal = _g_object_ref0 ((GtkSourceCompletionItem*) proposal_it->data);
					{
						if (g_str_has_prefix (gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) proposal), last_part)) {
							filtered_proposals = g_list_append (filtered_proposals, _g_object_ref0 (proposal));
						}
						_g_object_unref0 (proposal);
					}
				}
			}
			if (g_list_length (self->priv->_proposals) > 0) {
				_tmp16_ = g_list_length (filtered_proposals) == 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				GtkSourceCompletionItem* dummy_proposal;
				dummy_proposal = gtk_source_completion_item_new (_ ("No matching proposal"), "", NULL, NULL);
				filtered_proposals = g_list_append (filtered_proposals, _g_object_ref0 (dummy_proposal));
				_g_object_unref0 (dummy_proposal);
			}
			gtk_source_completion_context_add_proposals (context, self, filtered_proposals, TRUE);
			__g_list_free_g_object_unref0 (filtered_proposals);
		} else {
			gtk_source_completion_context_add_proposals (context, self, self->priv->_proposals, TRUE);
		}
		_g_free0 (last_part);
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (word);
	_g_free0 (text);
}


static GdkPixbuf* vtg_symbol_completion_provider_real_get_icon (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
	self = (VtgSymbolCompletionProvider*) base;
	if (self->priv->_icon == NULL) {
		{
			GtkIconTheme* theme;
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
			theme = _g_object_ref0 (gtk_icon_theme_get_default ());
			_tmp0_ = gtk_icon_theme_load_icon (theme, GTK_STOCK_DIALOG_INFO, 16, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch4_g_error;
			}
			self->priv->_icon = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (self->priv->_icon), _tmp1_);
			_g_object_unref0 (theme);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("vtgsymbolcompletionprovider.vala:245: error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = self->priv->_icon;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	self->priv->_filter = FALSE;
	result = FALSE;
	return result;
}


static GtkSourceCompletionActivation vtg_symbol_completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE | GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}


static GtkWidget* vtg_symbol_completion_provider_real_get_info_widget (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal) {
	VtgSymbolCompletionProvider * self;
	GtkWidget* result = NULL;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, NULL);
	result = NULL;
	return result;
}


static gint vtg_symbol_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	gint result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = 10;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_real_update_info (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkSourceCompletionInfo* info) {
	VtgSymbolCompletionProvider * self;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (info != NULL);
}


static gboolean vtg_symbol_completion_provider_on_view_focus_out (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventFocus* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	vtg_symbol_completion_provider_hide_calltip (self);
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_on_document_saved (GeditDocument* doc, void* arg1, VtgSymbolCompletionProvider* self) {
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	self->priv->_doc_changed = TRUE;
	self->priv->_all_doc = TRUE;
	if ((_tmp1_ = _vala_strcmp0 (self->priv->_sb->path, _tmp0_ = vtg_utils_get_document_name (doc)) != 0, _g_free0 (_tmp0_), _tmp1_)) {
		char* _tmp2_;
		self->priv->_sb->path = (_tmp2_ = vtg_utils_get_document_name (doc), _g_free0 (self->priv->_sb->path), _tmp2_);
	}
	vtg_symbol_completion_provider_schedule_reparse (self);
}


static void vtg_symbol_completion_provider_on_completion_engine_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->_completion = vtg_symbol_completion_get_completion_engine (self->priv->_symbol_completion);
}


static gint vtg_symbol_completion_provider_get_current_line_index (VtgSymbolCompletionProvider* self, GeditDocument* doc) {
	gint result = 0;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	g_return_val_if_fail (self != NULL, 0);
	if (doc == NULL) {
		doc = GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion)));
	}
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) doc));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &start, mark);
	result = gtk_text_iter_get_line (&start);
	return result;
}


static gboolean _vtg_symbol_completion_provider_on_timeout_parse_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_timeout_parse (self);
	return result;
}


static void vtg_symbol_completion_provider_schedule_reparse (VtgSymbolCompletionProvider* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_timeout_id == 0) {
		_tmp0_ = self->priv->_doc_changed;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _vtg_symbol_completion_provider_on_timeout_parse_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void vtg_symbol_completion_provider_on_text_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->_doc_changed = TRUE;
	if (self->priv->_last_line == (-1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_last_line != vtg_symbol_completion_provider_get_current_line_index (self, NULL);
	}
	if (_tmp0_) {
		self->priv->_all_doc = TRUE;
		vtg_symbol_completion_provider_schedule_reparse (self);
	}
}


static void vtg_symbol_completion_provider_on_cursor_position_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	if (self->priv->_last_line == (-1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_last_line != vtg_symbol_completion_provider_get_current_line_index (self, NULL);
	}
	if (_tmp0_) {
		self->priv->_all_doc = TRUE;
		vtg_symbol_completion_provider_schedule_reparse (self);
	}
}


static gboolean vtg_symbol_completion_provider_on_timeout_parse (VtgSymbolCompletionProvider* self) {
	gboolean result = FALSE;
	GeditDocument* doc;
	g_return_val_if_fail (self != NULL, FALSE);
	doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion))));
	vtg_symbol_completion_provider_parse (self, doc);
	self->priv->_timeout_id = (guint) 0;
	self->priv->_last_line = vtg_symbol_completion_provider_get_current_line_index (self, doc);
	result = FALSE;
	_g_object_unref0 (doc);
	return result;
}


static gboolean vtg_symbol_completion_provider_on_view_key_press (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	gunichar ch;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	ch = (gunichar) gdk_keyval_to_unicode ((*evt).keyval);
	if (ch == '(') {
		vtg_symbol_completion_provider_show_calltip (self);
	} else {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if ((*evt).keyval == GDK_Escape) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == ')';
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = ch == ';';
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ch == '{';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp4_ = FALSE;
			if ((*evt).keyval == GDK_Return) {
				_tmp4_ = ((*evt).state & GDK_SHIFT_MASK) != 0;
			} else {
				_tmp4_ = FALSE;
			}
			_tmp0_ = _tmp4_;
		}
		if (_tmp0_) {
			vtg_symbol_completion_provider_hide_calltip (self);
		}
	}
	if ((*evt).keyval == GDK_Return) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = ch == ';';
	}
	if (_tmp5_) {
		self->priv->_all_doc = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		if (g_unichar_isprint (ch)) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = (*evt).keyval == GDK_Delete;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = (*evt).keyval == GDK_BackSpace;
		}
		if (_tmp6_) {
			self->priv->_all_doc = FALSE;
			self->priv->_doc_changed = TRUE;
		}
	}
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_show_calltip (VtgSymbolCompletionProvider* self) {
	AfroditeSymbol* completion_result;
	g_return_if_fail (self != NULL);
	completion_result = vtg_symbol_completion_provider_get_current_symbol_item (self, 0);
	if (completion_result != NULL) {
		vtg_symbol_completion_provider_show_calltip_info (self, afrodite_symbol_get_info (completion_result));
	}
	_g_object_unref0 (completion_result);
}


static void vtg_symbol_completion_provider_show_calltip_info (VtgSymbolCompletionProvider* self, const char* markup_text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup_text != NULL);
	if (self->priv->_calltip_window == NULL) {
		vtg_symbol_completion_provider_initialize_calltip_window (self);
	}
	if (markup_text != NULL) {
		gtk_label_set_markup (self->priv->_calltip_window_label, markup_text);
		gtk_source_completion_info_move_to_iter (self->priv->_calltip_window, (GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion), NULL);
		gtk_widget_show_all ((GtkWidget*) self->priv->_calltip_window);
		gtk_widget_show ((GtkWidget*) self->priv->_calltip_window);
	}
}


static void vtg_symbol_completion_provider_hide_calltip (VtgSymbolCompletionProvider* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_calltip_window == NULL) {
		return;
	}
	gtk_widget_hide ((GtkWidget*) self->priv->_calltip_window);
}


static void vtg_symbol_completion_provider_initialize_calltip_window (VtgSymbolCompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_calltip_window = (_tmp0_ = g_object_ref_sink (gtk_source_completion_info_new ()), _g_object_unref0 (self->priv->_calltip_window), _tmp0_);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_calltip_window, (GtkWindow*) vtg_plugin_instance_get_window (vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion)));
	gtk_source_completion_info_set_sizing (self->priv->_calltip_window, 800, 400, TRUE, TRUE);
	self->priv->_calltip_window_label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->_calltip_window_label), _tmp1_);
	gtk_source_completion_info_set_widget (self->priv->_calltip_window, (GtkWidget*) self->priv->_calltip_window_label);
}


static void vtg_symbol_completion_provider_parse (VtgSymbolCompletionProvider* self, GeditDocument* doc) {
	VtgProjectManager* current_project;
	char* buffer;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	current_project = _g_object_ref0 (vtg_project_view_get_current_project (vtg_plugin_instance_get_project_view (vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion))));
	if (current_project->is_default) {
		if (vtg_symbol_completion_provider_autoadd_packages (self, doc, current_project) > 0) {
			vbf_project_update (vtg_project_manager_get_project (current_project));
		}
	}
	buffer = vtg_symbol_completion_provider_get_document_text (self, doc, self->priv->_all_doc);
	self->priv->_sb->content = (_tmp0_ = g_strdup (buffer), _g_free0 (self->priv->_sb->content), _tmp0_);
	afrodite_completion_engine_queue_source (self->priv->_completion, self->priv->_sb);
	self->priv->_doc_changed = FALSE;
	_g_free0 (buffer);
	_g_object_unref0 (current_project);
}


static gint vtg_symbol_completion_provider_autoadd_packages (VtgSymbolCompletionProvider* self, GeditDocument* doc, VtgProjectManager* project_manager) {
	gint result = 0;
	gint added_count;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (doc != NULL, 0);
	g_return_val_if_fail (project_manager != NULL, 0);
	added_count = 0;
	{
		char* text;
		GRegex* regex;
		text = vtg_symbol_completion_provider_get_document_text (self, doc, TRUE);
		regex = g_regex_new ("^\\s*(using)\\s+(\\w\\S*)\\s*;.*$", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			goto __catch5_g_error;
		}
		{
			char** _tmp0_;
			char** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = _tmp0_ = g_strsplit (text, "\n", 0);
			line_collection_length1 = _vala_array_length (_tmp0_);
			for (line_it = 0; line_it < _vala_array_length (_tmp0_); line_it = line_it + 1) {
				char* line;
				line = g_strdup (line_collection[line_it]);
				{
					GMatchInfo* match;
					GMatchInfo* _tmp1_ = NULL;
					GMatchInfo* _tmp2_;
					match = NULL;
					g_regex_match (regex, line, G_REGEX_MATCH_NEWLINE_ANY, &_tmp1_);
					match = (_tmp2_ = _tmp1_, _g_match_info_free0 (match), _tmp2_);
					while (TRUE) {
						char* using_name;
						char* _tmp3_;
						gboolean _tmp4_;
						char* package_name;
						char* _tmp8_;
						if (!g_match_info_matches (match)) {
							break;
						}
						using_name = NULL;
						if ((_tmp4_ = _vala_strcmp0 (_tmp3_ = g_match_info_fetch (match, 2), "GLib") == 0, _g_free0 (_tmp3_), _tmp4_)) {
							if (project_manager->is_default) {
								char* _tmp5_;
								using_name = (_tmp5_ = g_strdup ("gio"), _g_free0 (using_name), _tmp5_);
							}
						} else {
							char* _tmp6_;
							using_name = (_tmp6_ = g_match_info_fetch (match, 2), _g_free0 (using_name), _tmp6_);
						}
						package_name = NULL;
						if (using_name != NULL) {
							char* _tmp7_;
							package_name = (_tmp7_ = vbf_utils_guess_package_vapi (using_name, NULL, 0), _g_free0 (package_name), _tmp7_);
						}
						vtg_utils_trace ("vtgsymbolcompletionprovider.vala:457: guessing name of using clause %s" \
" for package %s: %s", _tmp8_ = g_match_info_fetch (match, 2), using_name, package_name);
						_g_free0 (_tmp8_);
						if (package_name != NULL) {
							VbfGroup* group;
							VbfTarget* target;
							group = vbf_project_get_group (vtg_project_manager_get_project (project_manager), "Sources");
							target = vbf_group_get_target_for_id (group, "Default");
							if (!vbf_target_contains_package (target, package_name)) {
								VbfPackage* _tmp9_;
								vbf_target_add_package (target, _tmp9_ = vbf_package_new (package_name));
								_g_object_unref0 (_tmp9_);
								added_count++;
							}
							_g_object_unref0 (target);
							_g_object_unref0 (group);
						}
						g_match_info_next (match, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_free0 (package_name);
							_g_free0 (using_name);
							_g_match_info_free0 (match);
							_g_free0 (line);
							line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
							_g_regex_unref0 (regex);
							_g_free0 (text);
							goto __catch5_g_error;
						}
						_g_free0 (package_name);
						_g_free0 (using_name);
					}
					_g_match_info_free0 (match);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_regex_unref0 (regex);
		_g_free0 (text);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vtgsymbolcompletionprovider.vala:471: error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = added_count;
	return result;
}


static gboolean vtg_symbol_completion_provider_proposal_list_contains_name (VtgSymbolCompletionProvider* self, const char* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GList* proposal_collection;
		GList* proposal_it;
		proposal_collection = self->priv->_proposals;
		for (proposal_it = proposal_collection; proposal_it != NULL; proposal_it = proposal_it->next) {
			GtkSourceCompletionItem* proposal;
			proposal = _g_object_ref0 ((GtkSourceCompletionItem*) proposal_it->data);
			{
				if (_vala_strcmp0 (gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) proposal), name) == 0) {
					result = TRUE;
					_g_object_unref0 (proposal);
					return result;
				}
				_g_object_unref0 (proposal);
			}
		}
	}
	result = FALSE;
	return result;
}


static gint _vtg_symbol_completion_provider_proposal_sort_gcompare_func (void* a, void* b) {
	gint result;
	result = vtg_symbol_completion_provider_proposal_sort (a, b);
	return result;
}


static void vtg_symbol_completion_provider_append_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, ValaList* symbols, gboolean include_private_symbols) {
	gint proposals_length1;
	gint _proposals_size_;
	GtkSourceCompletionItem** _tmp1_;
	gint _tmp0_;
	GtkSourceCompletionItem** proposals;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	proposals = (_tmp1_ = vtg_utils_get_proposal_cache (&_tmp0_), proposals_length1 = _tmp0_, _proposals_size_ = proposals_length1, _tmp1_);
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) symbols);
		while (TRUE) {
			AfroditeSymbol* symbol;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			char* name;
			gboolean _tmp9_ = FALSE;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
			if (!include_private_symbols) {
				_tmp4_ = afrodite_symbol_get_access (symbol) == AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = _vala_strcmp0 (afrodite_symbol_get_name (symbol), "new") == 0;
			}
			if (_tmp3_) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp5_ = FALSE;
				if (options != NULL) {
					_tmp5_ = !afrodite_symbol_check_options (symbol, options);
				} else {
					_tmp5_ = FALSE;
				}
				_tmp2_ = _tmp5_;
			}
			if (_tmp2_) {
				_g_object_unref0 (symbol);
				continue;
			}
			name = NULL;
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "CreationMethod") == 0) {
				char* _tmp6_;
				name = (_tmp6_ = g_strdup (afrodite_symbol_get_name (symbol)), _g_free0 (name), _tmp6_);
			} else {
				const char* _tmp7_;
				char* _tmp8_;
				_tmp7_ = NULL;
				if (afrodite_symbol_get_display_name (symbol) != NULL) {
					_tmp7_ = afrodite_symbol_get_display_name (symbol);
				} else {
					_tmp7_ = "<null>";
				}
				name = (_tmp8_ = g_strdup (_tmp7_), _g_free0 (name), _tmp8_);
			}
			if (!symbol->overrides) {
				_tmp9_ = TRUE;
			} else {
				gboolean _tmp10_ = FALSE;
				if (symbol->overrides) {
					_tmp10_ = !vtg_symbol_completion_provider_proposal_list_contains_name (self, name);
				} else {
					_tmp10_ = FALSE;
				}
				_tmp9_ = _tmp10_;
			}
			if (_tmp9_) {
				GtkSourceCompletionItem* proposal;
				const char* _tmp11_;
				char* info;
				GdkPixbuf* icon;
				proposal = NULL;
				_tmp11_ = NULL;
				if (afrodite_symbol_get_info (symbol) != NULL) {
					_tmp11_ = afrodite_symbol_get_info (symbol);
				} else {
					_tmp11_ = "";
				}
				info = g_strdup (_tmp11_);
				icon = vtg_utils_get_icon_for_type_name (afrodite_symbol_get_type_name (symbol));
				if (self->priv->_prealloc_index < VTG_UTILS_prealloc_count) {
					GtkSourceCompletionItem* _tmp12_;
					proposal = (_tmp12_ = _g_object_ref0 (proposals[self->priv->_prealloc_index]), _g_object_unref0 (proposal), _tmp12_);
					self->priv->_prealloc_index++;
					g_object_set (proposal, "label", name, NULL);
					g_object_set (proposal, "text", name, NULL);
					g_object_set (proposal, "info", info, NULL);
					g_object_set (proposal, "icon", icon, NULL);
				} else {
					GtkSourceCompletionItem* _tmp13_;
					proposal = (_tmp13_ = gtk_source_completion_item_new (name, name, icon, info), _g_object_unref0 (proposal), _tmp13_);
				}
				self->priv->_proposals = g_list_append (self->priv->_proposals, _g_object_ref0 (proposal));
				_g_object_unref0 (icon);
				_g_free0 (info);
				_g_object_unref0 (proposal);
			}
			_g_free0 (name);
			_g_object_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	self->priv->_proposals = g_list_sort (self->priv->_proposals, _vtg_symbol_completion_provider_proposal_sort_gcompare_func);
}


static gint vtg_symbol_completion_provider_proposal_sort (void* a, void* b) {
	gint result = 0;
	GtkSourceCompletionItem* pa;
	GtkSourceCompletionItem* pb;
	pa = _g_object_ref0 (GTK_SOURCE_COMPLETION_ITEM (a));
	pb = _g_object_ref0 (GTK_SOURCE_COMPLETION_ITEM (b));
	result = g_strcmp0 (gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) pa), gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) pb));
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}


static void vtg_symbol_completion_provider_transform_result (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeQueryResult* _result_) {
	GList* _tmp0_;
	ValaArrayList* visited_interfaces;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->_prealloc_index = 0;
	self->priv->_proposals = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->_proposals), _tmp0_);
	visited_interfaces = vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	if (_result_ != NULL) {
		_tmp1_ = !afrodite_query_result_get_is_empty (_result_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		afrodite_query_options_dump_settings (options);
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) afrodite_query_result_get_children (_result_));
			while (TRUE) {
				AfroditeResultItem* item;
				AfroditeSymbol* symbol;
				gboolean _tmp2_ = FALSE;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeResultItem*) vala_iterator_get (_item_it);
				symbol = _g_object_ref0 (afrodite_result_item_get_symbol (item));
				if (options == NULL) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = afrodite_symbol_check_options (symbol, options);
				}
				if (_tmp2_) {
					if (afrodite_symbol_get_has_children (symbol)) {
						vtg_symbol_completion_provider_append_symbols (self, options, afrodite_symbol_get_children (symbol), TRUE);
					}
					vtg_symbol_completion_provider_append_base_type_symbols (self, options, symbol, (ValaList*) visited_interfaces);
				}
				_g_object_unref0 (symbol);
				_afrodite_result_item_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	_vala_collection_object_unref0 (visited_interfaces);
}


static void vtg_symbol_completion_provider_append_base_type_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeSymbol* symbol, ValaList* visited_interfaces) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (visited_interfaces != NULL);
	if (afrodite_symbol_get_has_base_types (symbol)) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (_vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Class") == 0) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Interface") == 0;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Struct") == 0;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (symbol));
			while (TRUE) {
				AfroditeDataType* type;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				vtg_utils_trace ("vtgsymbolcompletionprovider.vala:569: visiting base type: %s", afrodite_data_type_get_type_name (type));
				if (!afrodite_data_type_get_unresolved (type)) {
					_tmp5_ = afrodite_symbol_get_has_children (afrodite_data_type_get_symbol (type));
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gboolean _tmp6_ = FALSE;
					if (options == NULL) {
						_tmp6_ = TRUE;
					} else {
						_tmp6_ = afrodite_symbol_check_options (afrodite_data_type_get_symbol (type), options);
					}
					_tmp4_ = _tmp6_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gboolean _tmp7_ = FALSE;
					gboolean _tmp8_ = FALSE;
					if (_vala_strcmp0 (afrodite_symbol_get_type_name (afrodite_data_type_get_symbol (type)), "Class") == 0) {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = _vala_strcmp0 (afrodite_symbol_get_type_name (afrodite_data_type_get_symbol (type)), "Interface") == 0;
					}
					if (_tmp8_) {
						_tmp7_ = TRUE;
					} else {
						_tmp7_ = _vala_strcmp0 (afrodite_symbol_get_type_name (afrodite_data_type_get_symbol (type)), "Struct") == 0;
					}
					_tmp3_ = _tmp7_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					if (!vala_collection_contains ((ValaCollection*) visited_interfaces, afrodite_data_type_get_symbol (type))) {
						vala_collection_add ((ValaCollection*) visited_interfaces, afrodite_data_type_get_symbol (type));
						vtg_symbol_completion_provider_append_symbols (self, options, afrodite_symbol_get_children (afrodite_data_type_get_symbol (type)), FALSE);
						vtg_symbol_completion_provider_append_base_type_symbols (self, options, afrodite_data_type_get_symbol (type), visited_interfaces);
					}
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
	} else {
		vtg_utils_trace ("vtgsymbolcompletionprovider.vala:583: NO base type for %s-%s", afrodite_symbol_get_name (symbol), afrodite_symbol_get_type_name (symbol));
	}
}


static void vtg_symbol_completion_provider_get_current_line_and_column (VtgSymbolCompletionProvider* self, gint* line, gint* column) {
	GeditDocument* doc;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	g_return_if_fail (self != NULL);
	doc = GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion)));
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) doc));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &start, mark);
	*line = gtk_text_iter_get_line (&start);
	*column = gtk_text_iter_get_line_offset (&start);
}


static char* vtg_symbol_completion_provider_get_current_line_text (VtgSymbolCompletionProvider* self, gboolean align_to_right_word) {
	char* result = NULL;
	GeditDocument* doc;
	GtkTextMark* mark;
	GtkTextIter end = {0};
	GtkTextIter start = {0};
	gunichar ch = 0U;
	gint line;
	g_return_val_if_fail (self != NULL, NULL);
	doc = GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion)));
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) doc));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &start, mark);
	line = gtk_text_iter_get_line (&start);
	ch = gtk_text_iter_get_char (&start);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint curr_line;
		if (g_unichar_isalnum (ch)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = ch == '_';
		}
		if (!_tmp0_) {
			break;
		}
		gtk_text_iter_forward_char (&start);
		curr_line = gtk_text_iter_get_line (&start);
		if (line != curr_line) {
			gtk_text_iter_backward_char (&start);
			break;
		}
		ch = gtk_text_iter_get_char (&start);
	}
	end = start;
	gtk_text_iter_set_line_offset (&start, 0);
	result = g_strdup (gtk_text_iter_get_text (&start, &end));
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


AfroditeSymbol* vtg_symbol_completion_provider_get_current_symbol_item (VtgSymbolCompletionProvider* self, gint retry_count) {
	AfroditeSymbol* result = NULL;
	char* text;
	char* word;
	gint line = 0;
	gint col = 0;
	gboolean is_assignment = FALSE;
	gboolean is_creation = FALSE;
	gboolean is_declaration = FALSE;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint tmp_length1;
	gint _tmp_size_;
	char** _tmp4_;
	char** _tmp3_;
	char** tmp;
	char* last_part;
	char* symbol_name;
	char* first_part;
	AfroditeAst* ast;
	AfroditeSymbol* symbol;
	AfroditeAst* _tmp7_ = NULL;
	gboolean _tmp8_;
	AfroditeAst* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	text = vtg_symbol_completion_provider_get_current_line_text (self, TRUE);
	word = NULL;
	vtg_parser_utils_parse_line (text, &_tmp0_, &is_assignment, &is_creation, &is_declaration);
	word = (_tmp1_ = _tmp0_, _g_free0 (word), _tmp1_);
	if (word == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _vala_strcmp0 (word, "") == 0;
	}
	if (_tmp2_) {
		result = NULL;
		_g_free0 (word);
		_g_free0 (text);
		return result;
	}
	vtg_symbol_completion_provider_get_current_line_and_column (self, &line, &col);
	tmp = (_tmp4_ = _tmp3_ = g_strsplit (word, ".", 0), tmp_length1 = _vala_array_length (_tmp3_), _tmp_size_ = tmp_length1, _tmp4_);
	last_part = g_strdup (tmp[tmp_length1 - 1]);
	symbol_name = g_strdup (last_part);
	if (vtg_symbol_completion_provider_is_vala_keyword (self, symbol_name)) {
		result = NULL;
		_g_free0 (symbol_name);
		_g_free0 (last_part);
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (word);
		_g_free0 (text);
		return result;
	}
	first_part = NULL;
	if (_vala_strcmp0 (word, last_part) != 0) {
		char* _tmp5_;
		first_part = (_tmp5_ = string_substring (word, (glong) 0, (string_get_length (word) - string_get_length (last_part)) - 1), _g_free0 (first_part), _tmp5_);
	} else {
		char* _tmp6_;
		first_part = (_tmp6_ = g_strdup (word), _g_free0 (first_part), _tmp6_);
	}
	ast = NULL;
	symbol = NULL;
	if ((_tmp8_ = afrodite_completion_engine_try_acquire_ast (self->priv->_completion, &_tmp7_, retry_count), ast = (_tmp9_ = _tmp7_, _afrodite_ast_unref0 (ast), _tmp9_), _tmp8_)) {
		AfroditeQueryResult* _result_;
		AfroditeQueryOptions* options;
		gboolean _tmp12_ = FALSE;
		_result_ = NULL;
		options = vtg_symbol_completion_provider_get_options_for_line (self, text, is_assignment, is_creation);
		if (_vala_strcmp0 (word, symbol_name) == 0) {
			AfroditeQueryResult* _tmp10_;
			_result_ = (_tmp10_ = vtg_symbol_completion_provider_get_symbol_for_name (self, options, ast, first_part, NULL, line, col), _afrodite_query_result_unref0 (_result_), _tmp10_);
		} else {
			AfroditeQueryResult* _tmp11_;
			_result_ = (_tmp11_ = vtg_symbol_completion_provider_get_symbol_type_for_name (self, options, ast, first_part, NULL, line, col), _afrodite_query_result_unref0 (_result_), _tmp11_);
		}
		if (_result_ != NULL) {
			_tmp12_ = !afrodite_query_result_get_is_empty (_result_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			AfroditeResultItem* first;
			first = (AfroditeResultItem*) vala_list_get (afrodite_query_result_get_children (_result_), 0);
			if (_vala_strcmp0 (word, symbol_name) == 0) {
				AfroditeSymbol* _tmp13_;
				symbol = (_tmp13_ = _g_object_ref0 (afrodite_result_item_get_symbol (first)), _g_object_unref0 (symbol), _tmp13_);
			} else {
				AfroditeSymbol* _tmp14_;
				symbol = (_tmp14_ = vtg_symbol_completion_provider_get_symbol_for_name_in_children (self, symbol_name, afrodite_result_item_get_symbol (first)), _g_object_unref0 (symbol), _tmp14_);
				if (symbol == NULL) {
					AfroditeSymbol* _tmp15_;
					symbol = (_tmp15_ = vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (self, symbol_name, afrodite_result_item_get_symbol (first)), _g_object_unref0 (symbol), _tmp15_);
				}
			}
			_afrodite_result_item_unref0 (first);
		}
		afrodite_completion_engine_release_ast (self->priv->_completion, ast);
		_afrodite_query_options_unref0 (options);
		_afrodite_query_result_unref0 (_result_);
	}
	result = symbol;
	_afrodite_ast_unref0 (ast);
	_g_free0 (first_part);
	_g_free0 (symbol_name);
	_g_free0 (last_part);
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (word);
	_g_free0 (text);
	return result;
}


static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_children (VtgSymbolCompletionProvider* self, const char* symbol_name, AfroditeSymbol* parent) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (afrodite_symbol_get_has_children (parent)) {
		{
			ValaIterator* _symbol_it;
			_symbol_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (parent));
			while (TRUE) {
				AfroditeSymbol* symbol;
				if (!vala_iterator_next (_symbol_it)) {
					break;
				}
				symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
				if (_vala_strcmp0 (afrodite_symbol_get_name (symbol), symbol_name) == 0) {
					result = symbol;
					_vala_collection_object_unref0 (_symbol_it);
					return result;
				}
				_g_object_unref0 (symbol);
			}
			_vala_collection_object_unref0 (_symbol_it);
		}
	}
	result = NULL;
	return result;
}


static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (VtgSymbolCompletionProvider* self, const char* symbol_name, AfroditeSymbol* parent) {
	AfroditeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (afrodite_symbol_get_has_base_types (parent)) {
		{
			ValaIterator* _t_it;
			_t_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (parent));
			while (TRUE) {
				AfroditeDataType* t;
				if (!vala_iterator_next (_t_it)) {
					break;
				}
				t = (AfroditeDataType*) vala_iterator_get (_t_it);
				if (afrodite_data_type_get_symbol (t) != NULL) {
					AfroditeSymbol* base_symbol;
					base_symbol = vtg_symbol_completion_provider_get_symbol_for_name_in_children (self, symbol_name, afrodite_data_type_get_symbol (t));
					if (base_symbol == NULL) {
						AfroditeSymbol* _tmp0_;
						base_symbol = (_tmp0_ = vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (self, symbol_name, afrodite_data_type_get_symbol (t)), _g_object_unref0 (base_symbol), _tmp0_);
					}
					if (base_symbol != NULL) {
						result = base_symbol;
						_afrodite_data_type_unref0 (t);
						_vala_collection_object_unref0 (_t_it);
						return result;
					}
					_g_object_unref0 (base_symbol);
				}
				_afrodite_data_type_unref0 (t);
			}
			_vala_collection_object_unref0 (_t_it);
		}
	}
	result = NULL;
	return result;
}


static AfroditeQueryOptions* vtg_symbol_completion_provider_get_options_for_line (VtgSymbolCompletionProvider* self, const char* line, gboolean is_assignment, gboolean is_creation) {
	AfroditeQueryOptions* result = NULL;
	AfroditeQueryOptions* options;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	options = NULL;
	if (is_creation) {
		AfroditeQueryOptions* _tmp0_;
		options = (_tmp0_ = afrodite_query_options_creation_methods (), _afrodite_query_options_unref0 (options), _tmp0_);
	} else {
		gboolean _tmp1_ = FALSE;
		if (is_assignment) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (line != NULL) {
				_tmp2_ = g_strrstr (line, ":") != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		if (_tmp1_) {
			AfroditeQueryOptions* _tmp3_;
			options = (_tmp3_ = afrodite_query_options_standard (), _afrodite_query_options_unref0 (options), _tmp3_);
			options->binding = options->binding | AFRODITE_MEMBER_BINDING_STATIC;
		} else {
			gboolean _tmp4_ = FALSE;
			if (line != NULL) {
				gboolean _tmp5_ = FALSE;
				if (strstr (line, "throws ") != NULL) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = strstr (line, "throw ") != NULL;
				}
				_tmp4_ = _tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				AfroditeQueryOptions* _tmp6_;
				options = (_tmp6_ = afrodite_query_options_error_domains (), _afrodite_query_options_unref0 (options), _tmp6_);
			}
		}
	}
	if (options == NULL) {
		AfroditeQueryOptions* _tmp7_;
		options = (_tmp7_ = afrodite_query_options_standard (), _afrodite_query_options_unref0 (options), _tmp7_);
	}
	options->access = (AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC;
	options->auto_member_binding_mode = TRUE;
	options->compare_mode = AFRODITE_COMPARE_MODE_EXACT;
	result = options;
	return result;
}


static gboolean _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_hide_calltip_timeout (self);
	return result;
}


static void vtg_symbol_completion_provider_complete_current_word (VtgSymbolCompletionProvider* self) {
	char* text;
	char* word;
	gboolean is_assignment = FALSE;
	gboolean is_creation = FALSE;
	gboolean is_declaration = FALSE;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	AfroditeAst* ast;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	text = vtg_symbol_completion_provider_get_current_line_text (self, FALSE);
	word = NULL;
	vtg_parser_utils_parse_line (text, &_tmp0_, &is_assignment, &is_creation, &is_declaration);
	word = (_tmp1_ = _tmp0_, _g_free0 (word), _tmp1_);
	ast = NULL;
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:758: completing word: '%s'", word);
	if (!vtg_string_utils_is_null_or_empty (word)) {
		AfroditeAst* _tmp3_ = NULL;
		gboolean _tmp4_;
		AfroditeAst* _tmp5_;
		_tmp2_ = (_tmp4_ = afrodite_completion_engine_try_acquire_ast (self->priv->_completion, &_tmp3_, -1), ast = (_tmp5_ = _tmp3_, _afrodite_ast_unref0 (ast), _tmp5_), _tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		AfroditeQueryOptions* options;
		AfroditeQueryResult* _result_;
		gint line = 0;
		gint col = 0;
		gboolean _tmp6_ = FALSE;
		AfroditeQueryResult* _tmp10_;
		options = vtg_symbol_completion_provider_get_options_for_line (self, text, is_assignment, is_creation);
		_result_ = NULL;
		vtg_symbol_completion_provider_get_current_line_and_column (self, &line, &col);
		if (g_str_has_prefix (word, "\"")) {
			_tmp6_ = g_str_has_suffix (word, "\"");
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			char* _tmp7_;
			word = (_tmp7_ = g_strdup ("string"), _g_free0 (word), _tmp7_);
		} else {
			gboolean _tmp8_ = FALSE;
			if (g_str_has_prefix (word, "\'")) {
				_tmp8_ = g_str_has_suffix (word, "\'");
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				char* _tmp9_;
				word = (_tmp9_ = g_strdup ("unichar"), _g_free0 (word), _tmp9_);
			}
		}
		_result_ = (_tmp10_ = vtg_symbol_completion_provider_get_symbol_type_for_name (self, options, ast, word, text, line, col), _afrodite_query_result_unref0 (_result_), _tmp10_);
		vtg_symbol_completion_provider_transform_result (self, options, _result_);
		afrodite_completion_engine_release_ast (self->priv->_completion, ast);
		_afrodite_query_result_unref0 (_result_);
		_afrodite_query_options_unref0 (options);
	} else {
		if (!vtg_string_utils_is_null_or_empty (word)) {
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:778: build_proposal_item_list: couldn" \
"'t acquire ast lock");
			vtg_symbol_completion_provider_show_calltip_info (self, _ ("<i>source symbol cache is still updating...</i>"));
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func, g_object_ref (self), g_object_unref);
			g_signal_emit_by_name (self, "completion-lock-failed");
		}
		vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
	}
	_afrodite_ast_unref0 (ast);
	_g_free0 (word);
	_g_free0 (text);
}


static void vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (VtgSymbolCompletionProvider* self, const char* word, AfroditeCompareMode mode) {
	AfroditeAst* ast;
	const char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (word != NULL);
	ast = NULL;
	_tmp0_ = NULL;
	if (mode == AFRODITE_COMPARE_MODE_EXACT) {
		_tmp0_ = "exact";
	} else {
		_tmp0_ = "start-with";
	}
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:790: lookup_all_symbols_in_scope: mod" \
"e: %s word:'%s' ", _tmp0_, word);
	if (!vtg_string_utils_is_null_or_empty (word)) {
		AfroditeAst* _tmp2_ = NULL;
		gboolean _tmp3_;
		AfroditeAst* _tmp4_;
		_tmp1_ = (_tmp3_ = afrodite_completion_engine_try_acquire_ast (self->priv->_completion, &_tmp2_, 0), ast = (_tmp4_ = _tmp2_, _afrodite_ast_unref0 (ast), _tmp4_), _tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaList* results;
		GeditDocument* doc;
		char* _tmp5_;
		AfroditeSourceFile* _tmp6_;
		AfroditeSourceFile* source;
		results = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
		doc = GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion)));
		source = (_tmp6_ = afrodite_ast_lookup_source_file (ast, _tmp5_ = vtg_utils_get_document_name (doc)), _g_free0 (_tmp5_), _tmp6_);
		if (source != NULL) {
			gint line = 0;
			gint column = 0;
			AfroditeSymbol* s;
			vtg_symbol_completion_provider_get_current_line_and_column (self, &line, &column);
			s = afrodite_ast_get_symbol_for_source_and_position (ast, source, line, column);
			if (s != NULL) {
				ValaList* _tmp7_;
				results = (_tmp7_ = afrodite_ast_lookup_visible_symbols_from_symbol (ast, s, word, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE), _vala_collection_object_unref0 (results), _tmp7_);
			}
			_g_object_unref0 (s);
		} else {
			char* _tmp8_;
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:809: no source file for: %s", _tmp8_ = vtg_utils_get_document_name (doc));
			_g_free0 (_tmp8_);
		}
		if (vala_collection_get_size ((ValaCollection*) results) == 0) {
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:813: no symbol visible");
			vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
		} else {
			GList* _tmp9_;
			self->priv->_proposals = (_tmp9_ = NULL, __g_list_free_g_object_unref0 (self->priv->_proposals), _tmp9_);
			vtg_symbol_completion_provider_append_symbols (self, NULL, results, TRUE);
		}
		afrodite_completion_engine_release_ast (self->priv->_completion, ast);
		_afrodite_source_file_unref0 (source);
		_vala_collection_object_unref0 (results);
	} else {
		if (!vtg_string_utils_is_null_or_empty (word)) {
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:822: build_proposal_item_list: couldn" \
"'t acquire ast lock");
			g_signal_emit_by_name (self, "completion-lock-failed");
		}
		vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
	}
	_afrodite_ast_unref0 (ast);
}


static gboolean vtg_symbol_completion_provider_on_hide_calltip_timeout (VtgSymbolCompletionProvider* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	vtg_symbol_completion_provider_hide_calltip (self);
	result = FALSE;
	return result;
}


static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_type_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeAst* ast, const char* word, const char* whole_line, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	AfroditeQueryResult* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (ast != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_result_ = NULL;
	_result_ = (_tmp0_ = afrodite_ast_get_symbol_type_for_name_and_path (ast, options, word, self->priv->_sb->path, line, column), _afrodite_query_result_unref0 (_result_), _tmp0_);
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:839: symbol matched %d", vala_collection_get_size ((ValaCollection*) afrodite_query_result_get_children (_result_)));
	result = _result_;
	return result;
}


static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeAst* ast, const char* word, const char* whole_line, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	AfroditeQueryResult* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (ast != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_result_ = NULL;
	_result_ = (_tmp0_ = afrodite_ast_get_symbol_for_name_and_path (ast, options, word, self->priv->_sb->path, line, column), _afrodite_query_result_unref0 (_result_), _tmp0_);
	result = _result_;
	return result;
}


static gboolean vtg_symbol_completion_provider_is_vala_keyword (VtgSymbolCompletionProvider* self, const char* keyword) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyword != NULL, FALSE);
	if (_vala_strcmp0 (keyword, "if") == 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _vala_strcmp0 (keyword, "for") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _vala_strcmp0 (keyword, "foreach") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (keyword, "while") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (keyword, "switch") == 0;
	}
	result = _tmp0_;
	return result;
}


static char* vtg_symbol_completion_provider_get_document_text (VtgSymbolCompletionProvider* self, GeditDocument* doc, gboolean all_doc) {
	char* result = NULL;
	GtkTextMark* mark;
	GtkTextIter end = {0};
	GtkTextIter start = {0};
	char* doc_text;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	mark = GTK_TEXT_MARK (gtk_text_buffer_get_insert ((GtkTextBuffer*) doc));
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &start, mark);
	doc_text = NULL;
	if (all_doc) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gedit_document_is_untouched (doc);
	}
	if (_tmp0_) {
		char* _tmp1_;
		end = start;
		gtk_text_iter_set_line_offset (&start, 0);
		while (TRUE) {
			if (!gtk_text_iter_backward_line (&start)) {
				break;
			}
			;
		}
		while (TRUE) {
			if (!gtk_text_iter_forward_line (&end)) {
				break;
			}
			;
		}
		doc_text = (_tmp1_ = g_strdup (gtk_text_iter_get_text (&start, &end)), _g_free0 (doc_text), _tmp1_);
	} else {
		char* text1;
		char* text2;
		char* _tmp3_;
		end = start;
		gtk_text_iter_set_line_offset (&end, 0);
		while (TRUE) {
			if (!gtk_text_iter_backward_line (&start)) {
				break;
			}
			;
		}
		text1 = g_strdup (gtk_text_iter_get_text (&start, &end));
		text2 = g_strdup ("");
		if (gtk_text_iter_forward_line (&end)) {
			char* _tmp2_;
			gtk_text_iter_set_line_offset (&end, 0);
			start = end;
			while (TRUE) {
				if (!gtk_text_iter_forward_line (&end)) {
					break;
				}
				;
			}
			text2 = (_tmp2_ = g_strdup (gtk_text_iter_get_text (&start, &end)), _g_free0 (text2), _tmp2_);
		}
		doc_text = (_tmp3_ = g_strdup_printf ("%s\n%s", text1, text2), _g_free0 (doc_text), _tmp3_);
		_g_free0 (text2);
		_g_free0 (text1);
	}
	result = doc_text;
	return result;
}


static void vtg_symbol_completion_provider_class_init (VtgSymbolCompletionProviderClass * klass) {
	vtg_symbol_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSymbolCompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_symbol_completion_provider_finalize;
	g_signal_new ("completion_lock_failed", VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_symbol_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	vtg_symbol_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = vtg_symbol_completion_provider_real_get_name;
	iface->get_priority = vtg_symbol_completion_provider_real_get_priority;
	iface->match = vtg_symbol_completion_provider_real_match;
	iface->populate = vtg_symbol_completion_provider_real_populate;
	iface->get_icon = vtg_symbol_completion_provider_real_get_icon;
	iface->activate_proposal = vtg_symbol_completion_provider_real_activate_proposal;
	iface->get_activation = vtg_symbol_completion_provider_real_get_activation;
	iface->get_info_widget = vtg_symbol_completion_provider_real_get_info_widget;
	iface->get_interactive_delay = vtg_symbol_completion_provider_real_get_interactive_delay;
	iface->get_start_iter = vtg_symbol_completion_provider_real_get_start_iter;
	iface->update_info = vtg_symbol_completion_provider_real_update_info;
}


static void vtg_symbol_completion_provider_instance_init (VtgSymbolCompletionProvider * self) {
	self->priv = VTG_SYMBOL_COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->_priority = 1;
	self->priv->_sb = NULL;
	self->priv->_timeout_id = (guint) 0;
	self->priv->_idle_id = (guint) 0;
	self->priv->_all_doc = FALSE;
	self->priv->_prealloc_index = 0;
	self->priv->_cache_building = FALSE;
	self->priv->_filter = FALSE;
	self->priv->_sb_msg_id = (guint) 0;
	self->priv->_sb_context_id = (guint) 0;
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
	self->priv->_last_line = -1;
	self->priv->_doc_changed = FALSE;
	self->priv->_symbol_completion = NULL;
	self->priv->_completion = NULL;
}


static void vtg_symbol_completion_provider_finalize (GObject* obj) {
	VtgSymbolCompletionProvider * self;
	self = VTG_SYMBOL_COMPLETION_PROVIDER (obj);
	{
		guint _tmp0_;
		guint _tmp1_;
		GeditDocument* doc;
		guint _tmp2_;
		GQuark _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		guint _tmp6_;
		GQuark _tmp7_;
		if (self->priv->_timeout_id != 0) {
			g_source_remove (self->priv->_timeout_id);
		}
		if (self->priv->_idle_id != 0) {
			g_source_remove (self->priv->_idle_id);
		}
		g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) vtg_symbol_completion_get_view (self->priv->_symbol_completion), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event, self);
		g_signal_parse_name ("focus-out-event", GTK_TYPE_WIDGET, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) vtg_symbol_completion_get_view (self->priv->_symbol_completion), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event, self);
		doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (self->priv->_symbol_completion))));
		g_signal_parse_name ("notify::completion-engine", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->_symbol_completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify, self);
		g_signal_parse_name ("notify::text", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) doc, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _vtg_symbol_completion_provider_on_text_changed_g_object_notify, self);
		g_signal_parse_name ("notify::cursor-position", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) doc, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify, self);
		g_signal_handlers_disconnect_by_func (doc, (void*) vtg_symbol_completion_provider_on_document_saved, self);
		if (self->priv->_sb_msg_id != 0) {
			GeditStatusbar* status_bar;
			status_bar = _g_object_ref0 (GEDIT_STATUSBAR (gedit_window_get_statusbar (vtg_plugin_instance_get_window (vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion)))));
			gtk_statusbar_remove ((GtkStatusbar*) status_bar, self->priv->_sb_context_id, self->priv->_sb_msg_id);
			_g_object_unref0 (status_bar);
		}
		_g_object_unref0 (doc);
	}
	_g_object_unref0 (self->priv->_icon);
	__g_list_free_g_object_unref0 (self->priv->_proposals);
	_afrodite_source_item_unref0 (self->priv->_sb);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	G_OBJECT_CLASS (vtg_symbol_completion_provider_parent_class)->finalize (obj);
}


GType vtg_symbol_completion_provider_get_type (void) {
	return vtg_symbol_completion_provider_type_id;
}


GType vtg_symbol_completion_provider_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSymbolCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_symbol_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSymbolCompletionProvider), 0, (GInstanceInitFunc) vtg_symbol_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) vtg_symbol_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vtg_symbol_completion_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSymbolCompletionProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, vtg_symbol_completion_provider_type_id, GTK_TYPE_SOURCE_COMPLETION_PROVIDER, &gtk_source_completion_provider_info);
	return vtg_symbol_completion_provider_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




