/* vtgplugininstance.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgplugininstance.vala, do not modify */

/*
 *  vtgplugininstance.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNaESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-window.h>
#include <valagee.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <vbf.h>
#include <gedit/gedit-plugin.h>
#include <gedit/gedit-tab.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <afrodite.h>
#include <gedit/gedit-encodings.h>
#include <gedit/gedit-app.h>


#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
typedef struct _VtgPluginInstancePrivate VtgPluginInstancePrivate;

#define VTG_TYPE_PROJECT_MANAGER_UI (vtg_project_manager_ui_get_type ())
#define VTG_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUi))
#define VTG_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))
#define VTG_IS_PROJECT_MANAGER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_IS_PROJECT_MANAGER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER_UI))
#define VTG_PROJECT_MANAGER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER_UI, VtgProjectManagerUiClass))

typedef struct _VtgProjectManagerUi VtgProjectManagerUi;
typedef struct _VtgProjectManagerUiClass VtgProjectManagerUiClass;

#define VTG_TYPE_SOURCE_OUTLINER (vtg_source_outliner_get_type ())
#define VTG_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutliner))
#define VTG_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))
#define VTG_IS_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_IS_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_SOURCE_OUTLINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))

typedef struct _VtgSourceOutliner VtgSourceOutliner;
typedef struct _VtgSourceOutlinerClass VtgSourceOutlinerClass;

#define VTG_TYPE_OUTPUT_VIEW (vtg_output_view_get_type ())
#define VTG_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputView))
#define VTG_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))
#define VTG_IS_OUTPUT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_OUTPUT_VIEW))
#define VTG_IS_OUTPUT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_OUTPUT_VIEW))
#define VTG_OUTPUT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_OUTPUT_VIEW, VtgOutputViewClass))

typedef struct _VtgOutputView VtgOutputView;
typedef struct _VtgOutputViewClass VtgOutputViewClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_SOURCE_BOOKMARKS (vtg_source_bookmarks_get_type ())
#define VTG_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarks))
#define VTG_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))
#define VTG_IS_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_IS_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_SOURCE_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))

typedef struct _VtgSourceBookmarks VtgSourceBookmarks;
typedef struct _VtgSourceBookmarksClass VtgSourceBookmarksClass;

#define VTG_TYPE_SYMBOL_COMPLETION (vtg_symbol_completion_get_type ())
#define VTG_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletion))
#define VTG_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))
#define VTG_IS_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_IS_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_SYMBOL_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))

typedef struct _VtgSymbolCompletion VtgSymbolCompletion;
typedef struct _VtgSymbolCompletionClass VtgSymbolCompletionClass;

#define VTG_TYPE_BRACKET_COMPLETION (vtg_bracket_completion_get_type ())
#define VTG_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletion))
#define VTG_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))
#define VTG_IS_BRACKET_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_IS_BRACKET_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_BRACKET_COMPLETION))
#define VTG_BRACKET_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_BRACKET_COMPLETION, VtgBracketCompletionClass))

typedef struct _VtgBracketCompletion VtgBracketCompletion;
typedef struct _VtgBracketCompletionClass VtgBracketCompletionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_SOURCE_BOOKMARK (vtg_source_bookmark_get_type ())
#define VTG_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmark))
#define VTG_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))
#define VTG_IS_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_IS_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_SOURCE_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))

typedef struct _VtgSourceBookmark VtgSourceBookmark;
typedef struct _VtgSourceBookmarkClass VtgSourceBookmarkClass;
typedef struct _VtgSourceBookmarkPrivate VtgSourceBookmarkPrivate;
#define _vtg_source_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (vtg_source_bookmark_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VtgPluginInstance {
	GObject parent_instance;
	VtgPluginInstancePrivate * priv;
};

struct _VtgPluginInstanceClass {
	GObjectClass parent_class;
};

struct _VtgPluginInstancePrivate {
	GeditWindow* _window;
	VtgProjectManagerUi* _project_manager_ui;
	VtgSourceOutliner* _source_outliner;
	VtgOutputView* _output_view;
	VtgProjectView* _project_view;
	VtgSourceBookmarks* _bookmarks;
	ValaList* _scs;
	ValaList* _bcs;
	GeditView* _last_created_view;
	gulong _tab_add_sig_id;
	gulong _tab_removed_sig_id;
	ValaHashMap* open_docs;
};

struct _VtgSourceBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgSourceBookmarkPrivate * priv;
	char* uri;
	gint line;
	gint column;
};

struct _VtgSourceBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (VtgSourceBookmark *self);
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	char* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	char* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_plugin_instance_parent_class = NULL;
static GType vtg_plugin_instance_type_id = 0;

GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_project_manager_ui_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_ui_register_type (GTypeModule * module);
GType vtg_source_outliner_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_register_type (GTypeModule * module);
GType vtg_output_view_get_type (void) G_GNUC_CONST;
GType vtg_output_view_register_type (GTypeModule * module);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
GType vtg_source_bookmarks_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmarks_register_type (GTypeModule * module);
GType vtg_symbol_completion_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_register_type (GTypeModule * module);
GType vtg_bracket_completion_get_type (void) G_GNUC_CONST;
GType vtg_bracket_completion_register_type (GTypeModule * module);
#define VTG_PLUGIN_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstancePrivate))
enum  {
	VTG_PLUGIN_INSTANCE_DUMMY_PROPERTY,
	VTG_PLUGIN_INSTANCE_OUTPUT_VIEW,
	VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI,
	VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER,
	VTG_PLUGIN_INSTANCE_PROJECT_VIEW,
	VTG_PLUGIN_INSTANCE_WINDOW,
	VTG_PLUGIN_INSTANCE_BOOKMARKS
};
VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window);
VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window);
VtgProjectView* vtg_project_view_new (VtgPluginInstance* plugin_instance);
VtgProjectView* vtg_project_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
VtgProjects* vtg_plugin_get_projects (VtgPlugin* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
ValaList* vtg_projects_get_project_managers (VtgProjects* self);
void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance);
VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance);
static void vtg_plugin_instance_on_current_bookmark_changed (VtgPluginInstance* self, VtgSourceBookmarks* sender);
static void _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed (VtgSourceBookmarks* _sender, gpointer self);
static void vtg_plugin_instance_on_tab_added (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance);
static void vtg_plugin_instance_on_tab_removed (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance);
VtgOutputView* vtg_output_view_new (VtgPluginInstance* plugin_instance);
VtgOutputView* vtg_output_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
VtgProjectManagerUi* vtg_project_manager_ui_new (VtgPluginInstance* plugin_instance);
VtgProjectManagerUi* vtg_project_manager_ui_construct (GType object_type, VtgPluginInstance* plugin_instance);
void vtg_plugin_instance_initialize_views (VtgPluginInstance* self);
void vtg_plugin_instance_initialize_document (VtgPluginInstance* self, GeditDocument* doc);
gpointer vtg_source_bookmark_ref (gpointer instance);
void vtg_source_bookmark_unref (gpointer instance);
GParamSpec* vtg_param_spec_source_bookmark (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_source_bookmark (GValue* value, gpointer v_object);
void vtg_value_take_source_bookmark (GValue* value, gpointer v_object);
gpointer vtg_value_get_source_bookmark (const GValue* value);
GType vtg_source_bookmark_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmark_register_type (GTypeModule * module);
VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self);
GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const char* uri, gint line, gint col);
static void vtg_plugin_instance_check_vala_source_for_add (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
char* vtg_utils_get_document_name (GeditDocument* doc);
static void vtg_plugin_instance_check_vala_source_for_remove (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document);
void vtg_plugin_instance_initialize_view (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view);
VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self);
void vtg_utils_trace (const char* format, ...);
void vtg_source_outliner_set_active_view (VtgSourceOutliner* self, GeditView* value);
void vtg_plugin_instance_uninitialize_view (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_uninitialize_document (VtgPluginInstance* self, GeditDocument* doc);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self);
void vtg_plugin_instance_activate_sourcecode_outliner (VtgPluginInstance* self);
gboolean vtg_configuration_get_symbol_enabled (VtgConfiguration* self);
gboolean vtg_plugin_instance_scs_contains (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_activate_symbol (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view);
gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self);
gboolean vtg_plugin_instance_bcs_contains (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_activate_bracket (VtgPluginInstance* self, GeditView* view);
static void vtg_plugin_instance_on_notify_language (GeditDocument* sender, GParamSpec* pspec, VtgPluginInstance* instance);
static void vtg_plugin_instance_on_document_saved (GeditDocument* doc, void* arg1, VtgPluginInstance* self);
VtgSymbolCompletion* vtg_plugin_instance_scs_find_from_view (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_deactivate_symbol (VtgPluginInstance* self, VtgSymbolCompletion* sc);
VtgBracketCompletion* vtg_plugin_instance_bcs_find_from_view (VtgPluginInstance* self, GeditView* view);
void vtg_plugin_instance_deactivate_bracket (VtgPluginInstance* self, VtgBracketCompletion* bc);
VtgSourceOutliner* vtg_source_outliner_new (VtgPluginInstance* plugin_instance);
VtgSourceOutliner* vtg_source_outliner_construct (GType object_type, VtgPluginInstance* plugin_instance);
void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self);
VtgBracketCompletion* vtg_bracket_completion_new (VtgPluginInstance* plugin_instance, GeditView* view);
VtgBracketCompletion* vtg_bracket_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view);
void vtg_bracket_completion_deactivate (VtgBracketCompletion* self);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_target (VtgProjectManager* self, VbfTarget* target);
AfroditeCompletionEngine* vtg_project_manager_get_completion_for_file (VtgProjectManager* self, const char* uri);
VtgSymbolCompletion* vtg_symbol_completion_new (VtgPluginInstance* plugin_instance, GeditView* view, AfroditeCompletionEngine* completion_engine);
VtgSymbolCompletion* vtg_symbol_completion_construct (GType object_type, VtgPluginInstance* plugin_instance, GeditView* view, AfroditeCompletionEngine* completion_engine);
void vtg_symbol_completion_deactivate (VtgSymbolCompletion* self);
void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self);
GeditView* vtg_bracket_completion_get_view (VtgBracketCompletion* self);
GeditView* vtg_symbol_completion_get_view (VtgSymbolCompletion* self);
gboolean vtg_plugin_instance_on_idle_cursor_mode (VtgPluginInstance* self);
static gboolean _vtg_plugin_instance_on_idle_cursor_mode_gsource_func (gpointer self);
void vtg_plugin_instance_activate_display_name (VtgPluginInstance* self, const char* display_name, gint line, gint col);
void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine);
AfroditeCompletionEngine* vtg_symbol_completion_get_completion_engine (VtgSymbolCompletion* self);
void vtg_symbol_completion_set_completion_engine (VtgSymbolCompletion* self, AfroditeCompletionEngine* value);
void vtg_source_outliner_cleanup_completion_engine (VtgSourceOutliner* self, AfroditeCompletionEngine* engine);
void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine);
VbfTarget* vtg_projects_get_target_for_document (VtgProjects* self, GeditDocument* document);
GeditView* vtg_source_outliner_get_active_view (VtgSourceOutliner* self);
void vtg_source_outliner_setup_completion_engine (VtgSourceOutliner* self, AfroditeCompletionEngine* engine);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self);
VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
VtgSourceBookmarks* vtg_plugin_instance_get_bookmarks (VtgPluginInstance* self);
static void vtg_plugin_instance_finalize (GObject* obj);
static void vtg_plugin_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed (VtgSourceBookmarks* _sender, gpointer self) {
	vtg_plugin_instance_on_current_bookmark_changed (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window) {
	VtgPluginInstance * self;
	VtgProjectView* _tmp0_;
	VtgSourceBookmarks* _tmp1_;
	VtgOutputView* _tmp2_;
	VtgProjectManagerUi* _tmp3_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (VtgPluginInstance*) g_object_new (object_type, NULL);
	self->priv->_window = window;
	self->priv->_project_view = (_tmp0_ = vtg_project_view_new (self), _g_object_unref0 (self->priv->_project_view), _tmp0_);
	{
		ValaIterator* _prj_it;
		_prj_it = vala_iterable_iterator ((ValaIterable*) vtg_projects_get_project_managers (vtg_plugin_get_projects (vtg_plugin_main_instance)));
		while (TRUE) {
			VtgProjectManager* prj;
			if (!vala_iterator_next (_prj_it)) {
				break;
			}
			prj = (VtgProjectManager*) vala_iterator_get (_prj_it);
			vtg_project_view_add_project (self->priv->_project_view, vtg_project_manager_get_project (prj));
			_g_object_unref0 (prj);
		}
		_vala_collection_object_unref0 (_prj_it);
	}
	self->priv->_bookmarks = (_tmp1_ = vtg_source_bookmarks_new (self), _g_object_unref0 (self->priv->_bookmarks), _tmp1_);
	g_signal_connect_object (self->priv->_bookmarks, "current-bookmark-changed", (GCallback) _vtg_plugin_instance_on_current_bookmark_changed_vtg_source_bookmarks_current_bookmark_changed, self, 0);
	self->priv->_tab_add_sig_id = g_signal_connect_after (self->priv->_window, "tab-added", (GCallback) vtg_plugin_instance_on_tab_added, self);
	self->priv->_tab_removed_sig_id = g_signal_connect (self->priv->_window, "tab-removed", (GCallback) vtg_plugin_instance_on_tab_removed, self);
	self->priv->_output_view = (_tmp2_ = vtg_output_view_new (self), _g_object_unref0 (self->priv->_output_view), _tmp2_);
	self->priv->_project_manager_ui = (_tmp3_ = vtg_project_manager_ui_new (self), _g_object_unref0 (self->priv->_project_manager_ui), _tmp3_);
	vtg_plugin_instance_initialize_views (self);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = gedit_window_get_documents (self->priv->_window);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* doc;
			doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
			{
				vtg_plugin_instance_initialize_document (self, doc);
				_g_object_unref0 (doc);
			}
		}
	}
	return self;
}


VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window) {
	return vtg_plugin_instance_construct (VTG_TYPE_PLUGIN_INSTANCE, window);
}


static void vtg_plugin_instance_on_current_bookmark_changed (VtgPluginInstance* self, VtgSourceBookmarks* sender) {
	VtgSourceBookmark* book;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	book = vtg_source_bookmarks_get_current_bookmark (sender);
	if (book != NULL) {
		GeditTab* _tmp0_;
		_tmp0_ = vtg_plugin_instance_activate_uri (self, book->uri, book->line, book->column);
		_g_object_unref0 (_tmp0_);
	}
	_vtg_source_bookmark_unref0 (book);
}


static void vtg_plugin_instance_check_vala_source_for_add (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc) {
	g_return_if_fail (instance != NULL);
	g_return_if_fail (project_manager != NULL);
	g_return_if_fail (doc != NULL);
	if (vtg_utils_is_vala_doc (doc)) {
		VbfGroup* group;
		VbfTarget* target;
		char* _tmp0_;
		VbfSource* _tmp1_;
		VbfSource* source;
		group = vbf_project_get_group (vtg_project_manager_get_project (project_manager), "Sources");
		target = vbf_group_get_target_for_id (group, "Default");
		source = (_tmp1_ = vbf_target_get_source (target, _tmp0_ = vtg_utils_get_document_name (doc)), _g_free0 (_tmp0_), _tmp1_);
		if (source == NULL) {
			char* _tmp2_;
			VbfSource* _tmp3_;
			source = (_tmp3_ = vbf_source_new_with_type (target, _tmp2_ = vtg_utils_get_document_name (doc), VBF_FILE_TYPES_VALA_SOURCE), _g_object_unref0 (source), _tmp3_);
			_g_free0 (_tmp2_);
			if (gedit_document_get_uri (doc) == NULL) {
				char* _tmp4_;
				((VbfFile*) source)->filename = (_tmp4_ = vtg_utils_get_document_name (doc), _g_free0 (((VbfFile*) source)->filename), _tmp4_);
			}
			vbf_target_add_source (target, source);
			vala_map_set ((ValaMap*) instance->priv->open_docs, doc, source);
			vbf_project_update (vtg_project_manager_get_project (project_manager));
		}
		_g_object_unref0 (source);
		_g_object_unref0 (target);
		_g_object_unref0 (group);
	}
}


static void vtg_plugin_instance_check_vala_source_for_remove (VtgPluginInstance* instance, VtgProjectManager* project_manager, GeditDocument* doc) {
	VbfGroup* group;
	VbfTarget* target;
	char* _tmp0_;
	VbfSource* _tmp1_;
	VbfSource* source;
	g_return_if_fail (instance != NULL);
	g_return_if_fail (project_manager != NULL);
	g_return_if_fail (doc != NULL);
	group = vbf_project_get_group (vtg_project_manager_get_project (project_manager), "Sources");
	target = vbf_group_get_target_for_id (group, "Default");
	source = (_tmp1_ = vbf_target_get_source (target, _tmp0_ = vtg_utils_get_document_name (doc)), _g_free0 (_tmp0_), _tmp1_);
	if (source != NULL) {
		vbf_target_remove_source (target, source);
		vbf_project_update (vtg_project_manager_get_project (project_manager));
	}
	if (vala_map_contains ((ValaMap*) instance->priv->open_docs, doc)) {
		vala_map_remove ((ValaMap*) instance->priv->open_docs, doc);
	}
	_g_object_unref0 (source);
	_g_object_unref0 (target);
	_g_object_unref0 (group);
}


static void vtg_plugin_instance_on_tab_added (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance) {
	GeditDocument* doc;
	VtgProjectManager* project_manager;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	doc = _g_object_ref0 (gedit_tab_get_document (tab));
	project_manager = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc);
	if (project_manager != NULL) {
		_tmp0_ = _vala_strcmp0 (vtg_project_manager_get_project (project_manager)->id, "vtg-default-project") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vtg_plugin_instance_check_vala_source_for_add (instance, project_manager, doc);
	}
	if (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc) != NULL) {
		_tmp1_ = _vala_strcmp0 (gtk_source_language_get_id (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc)), "vala") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeditView* view;
		view = _g_object_ref0 (gedit_tab_get_view (tab));
		vtg_plugin_instance_initialize_view (instance, project_manager, view);
		if (vtg_plugin_instance_get_source_outliner (instance) != NULL) {
			char* _tmp2_;
			vtg_utils_trace ("vtgplugininstance.vala:182: setup outliner for %s", _tmp2_ = vtg_utils_get_document_name (doc));
			_g_free0 (_tmp2_);
			vtg_source_outliner_set_active_view (vtg_plugin_instance_get_source_outliner (instance), view);
		}
		_g_object_unref0 (view);
	}
	vtg_plugin_instance_initialize_document (instance, doc);
	_g_object_unref0 (project_manager);
	_g_object_unref0 (doc);
}


static void vtg_plugin_instance_on_tab_removed (GeditWindow* sender, GeditTab* tab, VtgPluginInstance* instance) {
	GeditView* view;
	GeditDocument* doc;
	VtgProjectManager* project_manager;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	view = _g_object_ref0 (gedit_tab_get_view (tab));
	doc = _g_object_ref0 (gedit_tab_get_document (tab));
	vtg_plugin_instance_uninitialize_view (instance, view);
	vtg_plugin_instance_uninitialize_document (instance, doc);
	project_manager = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc);
	if (project_manager != NULL) {
		_tmp0_ = _vala_strcmp0 (vtg_project_manager_get_project (project_manager)->id, "vtg-default-project") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vtg_plugin_instance_check_vala_source_for_remove (instance, project_manager, doc);
	}
	_g_object_unref0 (project_manager);
	_g_object_unref0 (doc);
	_g_object_unref0 (view);
}


void vtg_plugin_instance_initialize_views (VtgPluginInstance* self) {
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = gedit_window_get_views (self->priv->_window);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			GeditView* view;
			view = _g_object_ref0 ((GeditView*) view_it->data);
			{
				GeditDocument* doc;
				gboolean _tmp0_ = FALSE;
				doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) view)));
				if (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc) != NULL) {
					_tmp0_ = _vala_strcmp0 (gtk_source_language_get_id (gtk_source_buffer_get_language ((GtkSourceBuffer*) doc)), "vala") == 0;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					VtgProjectManager* project;
					project = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc);
					vtg_plugin_instance_initialize_view (self, project, view);
					_g_object_unref0 (project);
				}
				_g_object_unref0 (doc);
				_g_object_unref0 (view);
			}
		}
	}
	if (vtg_configuration_get_sourcecode_outliner_enabled (vtg_plugin_get_config (vtg_plugin_main_instance))) {
		_tmp1_ = self->priv->_source_outliner == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		vtg_plugin_instance_activate_sourcecode_outliner (self);
	}
}


void vtg_plugin_instance_initialize_view (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (view != NULL);
	if (vtg_configuration_get_symbol_enabled (vtg_plugin_get_config (vtg_plugin_main_instance))) {
		_tmp0_ = !vtg_plugin_instance_scs_contains (self, view);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vtg_plugin_instance_activate_symbol (self, project, view);
	}
	if (vtg_configuration_get_bracket_enabled (vtg_plugin_get_config (vtg_plugin_main_instance))) {
		_tmp1_ = !vtg_plugin_instance_bcs_contains (self, view);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		vtg_plugin_instance_activate_bracket (self, view);
	}
}


void vtg_plugin_instance_initialize_document (VtgPluginInstance* self, GeditDocument* doc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_signal_connect (doc, "notify::language", (GCallback) vtg_plugin_instance_on_notify_language, self);
	g_signal_connect (doc, "saved", (GCallback) vtg_plugin_instance_on_document_saved, self);
}


void vtg_plugin_instance_uninitialize_view (VtgPluginInstance* self, GeditView* view) {
	VtgSymbolCompletion* sc;
	VtgBracketCompletion* bc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	sc = vtg_plugin_instance_scs_find_from_view (self, view);
	if (sc != NULL) {
		vtg_plugin_instance_deactivate_symbol (self, sc);
	}
	bc = vtg_plugin_instance_bcs_find_from_view (self, view);
	if (bc != NULL) {
		vtg_plugin_instance_deactivate_bracket (self, bc);
	}
	_g_object_unref0 (bc);
	_g_object_unref0 (sc);
}


void vtg_plugin_instance_activate_sourcecode_outliner (VtgPluginInstance* self) {
	VtgSourceOutliner* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_outliner = (_tmp0_ = vtg_source_outliner_new (self), _g_object_unref0 (self->priv->_source_outliner), _tmp0_);
}


void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_source_outliner != NULL) {
		VtgSourceOutliner* _tmp0_;
		self->priv->_source_outliner = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_source_outliner), _tmp0_);
	}
}


void vtg_plugin_instance_activate_bracket (VtgPluginInstance* self, GeditView* view) {
	VtgBracketCompletion* bc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	bc = vtg_bracket_completion_new (self, view);
	vala_collection_add ((ValaCollection*) self->priv->_bcs, bc);
	_g_object_unref0 (bc);
}


void vtg_plugin_instance_deactivate_bracket (VtgPluginInstance* self, VtgBracketCompletion* bc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bc != NULL);
	vtg_bracket_completion_deactivate (bc);
	vala_collection_remove ((ValaCollection*) self->priv->_bcs, bc);
}


void vtg_plugin_instance_activate_symbol (VtgPluginInstance* self, VtgProjectManager* project, GeditView* view) {
	GeditDocument* doc;
	char* file;
	AfroditeCompletionEngine* completion;
	VtgSymbolCompletion* sc;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (view != NULL);
	doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) view)));
	g_return_if_fail (doc != NULL);
	file = vtg_utils_get_document_name (doc);
	if (file == NULL) {
		_g_free0 (file);
		_g_object_unref0 (doc);
		return;
	}
	completion = NULL;
	if (project->is_default) {
		VbfGroup* group;
		VbfTarget* target;
		AfroditeCompletionEngine* _tmp0_;
		group = vbf_project_get_group (vtg_project_manager_get_project (project), "Sources");
		target = vbf_group_get_target_for_id (group, "Default");
		completion = (_tmp0_ = vtg_project_manager_get_completion_for_target (project, target), _g_object_unref0 (completion), _tmp0_);
		_g_object_unref0 (target);
		_g_object_unref0 (group);
	} else {
		{
			char* _tmp1_;
			char* _tmp2_;
			AfroditeCompletionEngine* _tmp3_;
			_tmp1_ = g_filename_to_uri (file, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch53_g_convert_error;
				}
				_g_object_unref0 (completion);
				_g_free0 (file);
				_g_object_unref0 (doc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			completion = (_tmp3_ = vtg_project_manager_get_completion_for_file (project, _tmp2_ = _tmp1_), _g_object_unref0 (completion), _tmp3_);
			_g_free0 (_tmp2_);
		}
		goto __finally53;
		__catch53_g_convert_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("vtgplugininstance.vala:291: ConvertError: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally53:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (completion);
			_g_free0 (file);
			_g_object_unref0 (doc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (completion == NULL) {
		g_warning ("vtgplugininstance.vala:295: No completion for file %s", file);
		_g_object_unref0 (completion);
		_g_free0 (file);
		_g_object_unref0 (doc);
		return;
	}
	sc = vtg_symbol_completion_new (self, view, completion);
	vala_collection_add ((ValaCollection*) self->priv->_scs, sc);
	_g_object_unref0 (sc);
	_g_object_unref0 (completion);
	_g_free0 (file);
	_g_object_unref0 (doc);
}


void vtg_plugin_instance_deactivate_symbol (VtgPluginInstance* self, VtgSymbolCompletion* sc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sc != NULL);
	vtg_symbol_completion_deactivate (sc);
	vala_collection_remove ((ValaCollection*) self->priv->_scs, sc);
}


void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self) {
	gint size;
	g_return_if_fail (self != NULL);
	size = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		VtgSymbolCompletion* _tmp1_;
		if (vala_collection_get_size ((ValaCollection*) self->priv->_scs) > 0) {
			_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_scs) != size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		size = vala_collection_get_size ((ValaCollection*) self->priv->_scs);
		vtg_plugin_instance_deactivate_symbol (self, _tmp1_ = (VtgSymbolCompletion*) vala_list_get (self->priv->_scs, 0));
		_g_object_unref0 (_tmp1_);
	}
}


void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self) {
	gint size;
	g_return_if_fail (self != NULL);
	size = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		VtgBracketCompletion* _tmp1_;
		if (vala_collection_get_size ((ValaCollection*) self->priv->_bcs) > 0) {
			_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_bcs) != size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		size = vala_collection_get_size ((ValaCollection*) self->priv->_bcs);
		vtg_plugin_instance_deactivate_bracket (self, _tmp1_ = (VtgBracketCompletion*) vala_list_get (self->priv->_bcs, 0));
		_g_object_unref0 (_tmp1_);
	}
}


gboolean vtg_plugin_instance_bcs_contains (VtgPluginInstance* self, GeditView* view) {
	gboolean result = FALSE;
	VtgBracketCompletion* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vtg_plugin_instance_bcs_find_from_view (self, view)) != NULL, _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


VtgBracketCompletion* vtg_plugin_instance_bcs_find_from_view (VtgPluginInstance* self, GeditView* view) {
	VtgBracketCompletion* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	{
		ValaIterator* _bc_it;
		_bc_it = vala_iterable_iterator ((ValaIterable*) self->priv->_bcs);
		while (TRUE) {
			VtgBracketCompletion* bc;
			if (!vala_iterator_next (_bc_it)) {
				break;
			}
			bc = (VtgBracketCompletion*) vala_iterator_get (_bc_it);
			if (vtg_bracket_completion_get_view (bc) == view) {
				result = bc;
				_vala_collection_object_unref0 (_bc_it);
				return result;
			}
			_g_object_unref0 (bc);
		}
		_vala_collection_object_unref0 (_bc_it);
	}
	result = NULL;
	return result;
}


gboolean vtg_plugin_instance_scs_contains (VtgPluginInstance* self, GeditView* view) {
	gboolean result = FALSE;
	VtgSymbolCompletion* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vtg_plugin_instance_scs_find_from_view (self, view)) != NULL, _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


VtgSymbolCompletion* vtg_plugin_instance_scs_find_from_view (VtgPluginInstance* self, GeditView* view) {
	VtgSymbolCompletion* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	{
		ValaIterator* _sc_it;
		_sc_it = vala_iterable_iterator ((ValaIterable*) self->priv->_scs);
		while (TRUE) {
			VtgSymbolCompletion* sc;
			if (!vala_iterator_next (_sc_it)) {
				break;
			}
			sc = (VtgSymbolCompletion*) vala_iterator_get (_sc_it);
			if (vtg_symbol_completion_get_view (sc) == view) {
				result = sc;
				_vala_collection_object_unref0 (_sc_it);
				return result;
			}
			_g_object_unref0 (sc);
		}
		_vala_collection_object_unref0 (_sc_it);
	}
	result = NULL;
	return result;
}


void vtg_plugin_instance_uninitialize_document (VtgPluginInstance* self, GeditDocument* doc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_signal_handlers_disconnect_by_func (doc, (void*) vtg_plugin_instance_on_notify_language, self);
	g_signal_handlers_disconnect_by_func (doc, (void*) vtg_plugin_instance_on_document_saved, self);
}


static gboolean _vtg_plugin_instance_on_idle_cursor_mode_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_plugin_instance_on_idle_cursor_mode (self);
	return result;
}


GeditTab* vtg_plugin_instance_activate_uri (VtgPluginInstance* self, const char* uri, gint line, gint col) {
	GeditTab* result = NULL;
	GeditTab* tab;
	GeditDocument* existing_doc;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	tab = NULL;
	existing_doc = NULL;
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = gedit_window_get_documents (self->priv->_window);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* doc;
			doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
			{
				if (_vala_strcmp0 (gedit_document_get_uri (doc), uri) == 0) {
					GeditTab* _tmp0_;
					GeditDocument* _tmp1_;
					tab = (_tmp0_ = _g_object_ref0 (gedit_tab_get_from_document (doc)), _g_object_unref0 (tab), _tmp0_);
					existing_doc = (_tmp1_ = _g_object_ref0 (doc), _g_object_unref0 (existing_doc), _tmp1_);
					_g_object_unref0 (doc);
					break;
				}
				_g_object_unref0 (doc);
			}
		}
	}
	if (tab == NULL) {
		GeditTab* _tmp2_;
		tab = (_tmp2_ = _g_object_ref0 (gedit_window_create_tab_from_uri (self->priv->_window, uri, gedit_encoding_get_utf8 (), line, TRUE, FALSE)), _g_object_unref0 (tab), _tmp2_);
		gedit_window_set_active_tab (self->priv->_window, tab);
		self->priv->_last_created_view = gedit_tab_get_view (tab);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _vtg_plugin_instance_on_idle_cursor_mode_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		gboolean _tmp3_ = FALSE;
		gedit_window_set_active_tab (self->priv->_window, tab);
		if (existing_doc != NULL) {
			_tmp3_ = line > 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			if (!gedit_document_goto_line_offset (existing_doc, line - 1, col - 1)) {
				gedit_document_goto_line (existing_doc, line - 1);
			}
			gedit_view_scroll_to_cursor (gedit_tab_get_view (tab));
		}
	}
	result = tab;
	_g_object_unref0 (existing_doc);
	return result;
}


gboolean vtg_plugin_instance_on_idle_cursor_mode (VtgPluginInstance* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_last_created_view != NULL) {
		gedit_view_scroll_to_cursor (self->priv->_last_created_view);
		self->priv->_last_created_view = NULL;
	}
	result = FALSE;
	return result;
}


void vtg_plugin_instance_activate_display_name (VtgPluginInstance* self, const char* display_name, gint line, gint col) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (display_name != NULL);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = gedit_window_get_documents (self->priv->_window);
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GeditDocument* doc;
			doc = _g_object_ref0 ((GeditDocument*) doc_it->data);
			{
				if (_vala_strcmp0 (gedit_document_get_short_name_for_display (doc), display_name) == 0) {
					GeditTab* tab;
					tab = _g_object_ref0 (gedit_tab_get_from_document (doc));
					gedit_window_set_active_tab (self->priv->_window, tab);
					gedit_document_goto_line (doc, line - 1);
					gedit_view_scroll_to_cursor (gedit_tab_get_view (tab));
					_g_object_unref0 (tab);
				}
				_g_object_unref0 (doc);
			}
		}
	}
}


static void vtg_plugin_instance_on_notify_language (GeditDocument* sender, GParamSpec* pspec, VtgPluginInstance* instance) {
	GeditApp* app;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	g_return_if_fail (instance != NULL);
	app = _g_object_ref0 (gedit_app_get_default ());
	{
		GList* view_collection;
		GList* view_it;
		view_collection = gedit_app_get_views (app);
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			GeditView* view;
			view = _g_object_ref0 ((GeditView*) view_it->data);
			{
				if (gtk_text_view_get_buffer ((GtkTextView*) view) == GTK_TEXT_BUFFER (sender)) {
					VtgProjectManager* project_manager;
					gboolean _tmp0_ = FALSE;
					project_manager = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), sender);
					if (gtk_source_buffer_get_language ((GtkSourceBuffer*) sender) == NULL) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = _vala_strcmp0 (gtk_source_language_get_id (gtk_source_buffer_get_language ((GtkSourceBuffer*) sender)), "vala") != 0;
					}
					if (_tmp0_) {
						gboolean _tmp1_ = FALSE;
						if (project_manager != NULL) {
							_tmp1_ = _vala_strcmp0 (vtg_project_manager_get_project (project_manager)->id, "vtg-default-project") == 0;
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							vtg_plugin_instance_check_vala_source_for_remove (instance, project_manager, sender);
						}
						vtg_plugin_instance_uninitialize_view (instance, view);
					} else {
						gboolean _tmp2_ = FALSE;
						if (project_manager != NULL) {
							_tmp2_ = _vala_strcmp0 (vtg_project_manager_get_project (project_manager)->id, "vtg-default-project") == 0;
						} else {
							_tmp2_ = FALSE;
						}
						if (_tmp2_) {
							vtg_plugin_instance_check_vala_source_for_add (instance, project_manager, sender);
						}
						vtg_plugin_instance_initialize_view (instance, project_manager, view);
					}
					_g_object_unref0 (project_manager);
					_g_object_unref0 (view);
					break;
				}
				_g_object_unref0 (view);
			}
		}
	}
	_g_object_unref0 (app);
}


void vtg_plugin_instance_unbind_completion_engine (VtgPluginInstance* self, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	{
		ValaIterator* _sc_it;
		_sc_it = vala_iterable_iterator ((ValaIterable*) self->priv->_scs);
		while (TRUE) {
			VtgSymbolCompletion* sc;
			if (!vala_iterator_next (_sc_it)) {
				break;
			}
			sc = (VtgSymbolCompletion*) vala_iterator_get (_sc_it);
			if (vtg_symbol_completion_get_completion_engine (sc) == engine) {
				vtg_symbol_completion_set_completion_engine (sc, NULL);
			}
			_g_object_unref0 (sc);
		}
		_vala_collection_object_unref0 (_sc_it);
	}
	if (self->priv->_source_outliner != NULL) {
		vtg_source_outliner_cleanup_completion_engine (self->priv->_source_outliner, engine);
	}
}


void vtg_plugin_instance_bind_completion_engine_with_target (VtgPluginInstance* self, VbfTarget* target, AfroditeCompletionEngine* engine) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (engine != NULL);
	{
		ValaIterator* _sc_it;
		_sc_it = vala_iterable_iterator ((ValaIterable*) self->priv->_scs);
		while (TRUE) {
			VtgSymbolCompletion* sc;
			GeditDocument* doc;
			VbfTarget* _tmp0_;
			gboolean _tmp1_;
			if (!vala_iterator_next (_sc_it)) {
				break;
			}
			sc = (VtgSymbolCompletion*) vala_iterator_get (_sc_it);
			doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) vtg_symbol_completion_get_view (sc))));
			if ((_tmp1_ = (_tmp0_ = vtg_projects_get_target_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc)) == target, _g_object_unref0 (_tmp0_), _tmp1_)) {
				vtg_symbol_completion_set_completion_engine (sc, engine);
			}
			_g_object_unref0 (doc);
			_g_object_unref0 (sc);
		}
		_vala_collection_object_unref0 (_sc_it);
	}
	if (self->priv->_source_outliner != NULL) {
		GeditView* view;
		view = _g_object_ref0 (vtg_source_outliner_get_active_view (self->priv->_source_outliner));
		if (view != NULL) {
			GeditDocument* doc;
			VbfTarget* _tmp2_;
			gboolean _tmp3_;
			doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) view)));
			if ((_tmp3_ = (_tmp2_ = vtg_projects_get_target_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc)) == target, _g_object_unref0 (_tmp2_), _tmp3_)) {
				vtg_source_outliner_setup_completion_engine (self->priv->_source_outliner, engine);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (view);
	}
}


static void vtg_plugin_instance_on_document_saved (GeditDocument* doc, void* arg1, VtgPluginInstance* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	vtg_utils_trace ("vtgplugininstance.vala:472: document saved: %s", gedit_document_get_uri (doc));
	{
		VtgProjectManager* project_manager;
		project_manager = vtg_projects_get_project_manager_for_document (vtg_plugin_get_projects (vtg_plugin_main_instance), doc);
		if (project_manager->is_default) {
			VbfSource* source;
			source = NULL;
			if (vala_map_contains ((ValaMap*) self->priv->open_docs, doc)) {
				VbfSource* _tmp0_;
				source = (_tmp0_ = (VbfSource*) vala_map_get ((ValaMap*) self->priv->open_docs, doc), _g_object_unref0 (source), _tmp0_);
			}
			if (source != NULL) {
				char* file;
				file = g_strdup (gedit_document_get_uri (doc));
				if (_vala_strcmp0 (((VbfFile*) source)->uri, file) != 0) {
					char* _tmp1_;
					char* _tmp2_;
					vtg_utils_trace ("vtgplugininstance.vala:485: update source info for: %s", file);
					_tmp1_ = g_filename_from_uri (gedit_document_get_uri (doc), NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (file);
						_g_object_unref0 (source);
						_g_object_unref0 (project_manager);
						goto __catch54_g_error;
					}
					vbf_file_update_file_data ((VbfFile*) source, _tmp2_ = _tmp1_);
					_g_free0 (_tmp2_);
					vbf_project_update (vtg_project_manager_get_project (vtg_project_view_get_current_project (self->priv->_project_view)));
				}
				_g_free0 (file);
			} else {
				char* _tmp3_;
				vtg_utils_trace ("vtgplugininstance.vala:490: can't find source file for: %s", _tmp3_ = vtg_utils_get_document_name (doc));
				_g_free0 (_tmp3_);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (project_manager);
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgplugininstance.vala:494: error converting file to uri: %s", gedit_document_get_uri (doc));
			_g_error_free0 (err);
		}
	}
	__finally54:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


VtgOutputView* vtg_plugin_instance_get_output_view (VtgPluginInstance* self) {
	VtgOutputView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output_view;
	return result;
}


VtgProjectManagerUi* vtg_plugin_instance_get_project_manager_ui (VtgPluginInstance* self) {
	VtgProjectManagerUi* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_manager_ui;
	return result;
}


VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self) {
	VtgSourceOutliner* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_outliner;
	return result;
}


VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self) {
	VtgProjectView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_project_view;
	return result;
}


GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self) {
	GeditWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_window;
	return result;
}


VtgSourceBookmarks* vtg_plugin_instance_get_bookmarks (VtgPluginInstance* self) {
	VtgSourceBookmarks* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_bookmarks;
	return result;
}


static void vtg_plugin_instance_class_init (VtgPluginInstanceClass * klass) {
	vtg_plugin_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgPluginInstancePrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_plugin_instance_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_plugin_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_OUTPUT_VIEW, g_param_spec_object ("output-view", "output-view", "output-view", VTG_TYPE_OUTPUT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI, g_param_spec_object ("project-manager-ui", "project-manager-ui", "project-manager-ui", VTG_TYPE_PROJECT_MANAGER_UI, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER, g_param_spec_object ("source-outliner", "source-outliner", "source-outliner", VTG_TYPE_SOURCE_OUTLINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_PROJECT_VIEW, g_param_spec_object ("project-view", "project-view", "project-view", VTG_TYPE_PROJECT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_WINDOW, g_param_spec_object ("window", "window", "window", GEDIT_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCE_BOOKMARKS, g_param_spec_object ("bookmarks", "bookmarks", "bookmarks", VTG_TYPE_SOURCE_BOOKMARKS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vtg_plugin_instance_instance_init (VtgPluginInstance * self) {
	self->priv = VTG_PLUGIN_INSTANCE_GET_PRIVATE (self);
	self->priv->_window = NULL;
	self->priv->_project_manager_ui = NULL;
	self->priv->_source_outliner = NULL;
	self->priv->_output_view = NULL;
	self->priv->_project_view = NULL;
	self->priv->_bookmarks = NULL;
	self->priv->_scs = (ValaList*) vala_array_list_new (VTG_TYPE_SYMBOL_COMPLETION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_bcs = (ValaList*) vala_array_list_new (VTG_TYPE_BRACKET_COMPLETION, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_last_created_view = NULL;
	self->priv->_tab_add_sig_id = (gulong) 0;
	self->priv->_tab_removed_sig_id = (gulong) 0;
	self->priv->open_docs = vala_hash_map_new (GEDIT_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, VBF_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
}


static void vtg_plugin_instance_finalize (GObject* obj) {
	VtgPluginInstance * self;
	self = VTG_PLUGIN_INSTANCE (obj);
	{
		VtgSourceOutliner* _tmp0_;
		VtgProjectManagerUi* _tmp1_;
		VtgOutputView* _tmp2_;
		if (self->priv->_source_outliner != NULL) {
			vtg_source_outliner_set_active_view (self->priv->_source_outliner, NULL);
		}
		self->priv->_source_outliner = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_source_outliner), _tmp0_);
		self->priv->_project_manager_ui = (_tmp1_ = NULL, _g_object_unref0 (self->priv->_project_manager_ui), _tmp1_);
		self->priv->_output_view = (_tmp2_ = NULL, _g_object_unref0 (self->priv->_output_view), _tmp2_);
		if (g_signal_handler_is_connected (self, self->priv->_tab_add_sig_id)) {
			g_signal_handler_disconnect (self, self->priv->_tab_add_sig_id);
		}
		if (g_signal_handler_is_connected (self, self->priv->_tab_removed_sig_id)) {
			g_signal_handler_disconnect (self, self->priv->_tab_removed_sig_id);
		}
		self->priv->_window = NULL;
	}
	_g_object_unref0 (self->priv->_project_manager_ui);
	_g_object_unref0 (self->priv->_source_outliner);
	_g_object_unref0 (self->priv->_output_view);
	_g_object_unref0 (self->priv->_project_view);
	_g_object_unref0 (self->priv->_bookmarks);
	_vala_collection_object_unref0 (self->priv->_scs);
	_vala_collection_object_unref0 (self->priv->_bcs);
	_vala_collection_object_unref0 (self->priv->open_docs);
	G_OBJECT_CLASS (vtg_plugin_instance_parent_class)->finalize (obj);
}


GType vtg_plugin_instance_get_type (void) {
	return vtg_plugin_instance_type_id;
}


GType vtg_plugin_instance_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPluginInstance), 0, (GInstanceInitFunc) vtg_plugin_instance_instance_init, NULL };
	vtg_plugin_instance_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgPluginInstance", &g_define_type_info, 0);
	return vtg_plugin_instance_type_id;
}


static void vtg_plugin_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgPluginInstance * self;
	self = VTG_PLUGIN_INSTANCE (object);
	switch (property_id) {
		case VTG_PLUGIN_INSTANCE_OUTPUT_VIEW:
		g_value_set_object (value, vtg_plugin_instance_get_output_view (self));
		break;
		case VTG_PLUGIN_INSTANCE_PROJECT_MANAGER_UI:
		g_value_set_object (value, vtg_plugin_instance_get_project_manager_ui (self));
		break;
		case VTG_PLUGIN_INSTANCE_SOURCE_OUTLINER:
		g_value_set_object (value, vtg_plugin_instance_get_source_outliner (self));
		break;
		case VTG_PLUGIN_INSTANCE_PROJECT_VIEW:
		g_value_set_object (value, vtg_plugin_instance_get_project_view (self));
		break;
		case VTG_PLUGIN_INSTANCE_WINDOW:
		g_value_set_object (value, vtg_plugin_instance_get_window (self));
		break;
		case VTG_PLUGIN_INSTANCE_BOOKMARKS:
		g_value_set_object (value, vtg_plugin_instance_get_bookmarks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




