/* vtgfilteredlistdialog.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgfilteredlistdialog.vala, do not modify */

/*
 *  vtgfilteredlistdialog.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <float.h>
#include <math.h>


#define VTG_TYPE_FILTERED_LIST_DIALOG_COLUMNS (vtg_filtered_list_dialog_columns_get_type ())

#define VTG_TYPE_FILTERED_LIST_DIALOG (vtg_filtered_list_dialog_get_type ())
#define VTG_FILTERED_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialog))
#define VTG_FILTERED_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogClass))
#define VTG_IS_FILTERED_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_FILTERED_LIST_DIALOG))
#define VTG_IS_FILTERED_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_FILTERED_LIST_DIALOG))
#define VTG_FILTERED_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogClass))

typedef struct _VtgFilteredListDialog VtgFilteredListDialog;
typedef struct _VtgFilteredListDialogClass VtgFilteredListDialogClass;
typedef struct _VtgFilteredListDialogPrivate VtgFilteredListDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_COLUMNS (vtg_columns_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME = 0,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE,
	VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT
} VtgFilteredListDialogColumns;

struct _VtgFilteredListDialog {
	GObject parent_instance;
	VtgFilteredListDialogPrivate * priv;
	GtkTreeIter selected_iter;
};

struct _VtgFilteredListDialogClass {
	GObjectClass parent_class;
};

struct _VtgFilteredListDialogPrivate {
	GtkDialog* _dialog;
	GtkTreeView* _treeview;
	GtkEntry* _entry;
	GtkTreeModelFilter* _filtered_model;
	GtkTreeModelSort* _sorted_model;
	GtkTreeModel* _child_model;
	GPatternSpec* _current_pattern;
	char* _current_filter;
	GtkButton* _button_ok;
};

typedef enum  {
	VTG_COLUMNS_NAME = 0,
	VTG_COLUMNS_ICON,
	VTG_COLUMNS_SYMBOL,
	VTG_COLUMNS_COLUMNS_COUNT
} VtgColumns;


static gpointer vtg_filtered_list_dialog_parent_class = NULL;
static GType vtg_filtered_list_dialog_type_id = 0;

GType vtg_filtered_list_dialog_columns_get_type (void) G_GNUC_CONST;
GType vtg_filtered_list_dialog_get_type (void) G_GNUC_CONST;
GType vtg_filtered_list_dialog_register_type (GTypeModule * module);
#define VTG_FILTERED_LIST_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_FILTERED_LIST_DIALOG, VtgFilteredListDialogPrivate))
enum  {
	VTG_FILTERED_LIST_DIALOG_DUMMY_PROPERTY
};
GtkTreeStore* vtg_filtered_list_dialog_create_model (void);
VtgFilteredListDialog* vtg_filtered_list_dialog_new (GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
VtgFilteredListDialog* vtg_filtered_list_dialog_construct (GType object_type, GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
static void vtg_filtered_list_dialog_initialize_ui (VtgFilteredListDialog* self, GtkTreeIterCompareFunc compare_func, void* compare_func_target);
char* vtg_utils_get_ui_path (const char* id);
static gboolean vtg_filtered_list_dialog_on_entry_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void vtg_filtered_list_dialog_on_entry_text_changed (VtgFilteredListDialog* self, GObject* pspec, GParamSpec* gobject);
static void _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void vtg_filtered_list_dialog_on_row_changed (VtgFilteredListDialog* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter);
static void _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
GType vtg_columns_get_type (void) G_GNUC_CONST;
static gint vtg_filtered_list_dialog_sort_model (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
static void vtg_filtered_list_dialog_on_tree_selection_changed (VtgFilteredListDialog* self, GtkTreeSelection* sender);
static void _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
gboolean vtg_filtered_list_dialog_on_treeview_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void vtg_filtered_list_dialog_on_row_activated (VtgFilteredListDialog* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
static void _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean vtg_filtered_list_dialog_can_select_current_row (VtgFilteredListDialog* self);
void vtg_filtered_list_dialog_set_transient_for (VtgFilteredListDialog* self, GtkWindow* parent);
gboolean vtg_filtered_list_dialog_run (VtgFilteredListDialog* self);
static void vtg_filtered_list_dialog_move_cursor_down (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target);
static void vtg_filtered_list_dialog_move_cursor_up (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target);
gboolean vtg_string_utils_is_null_or_empty (const char* data);
char* vtg_string_utils_replace (const char* data, const char* search, const char* replace);
static void vtg_filtered_list_dialog_filter_and_highlight_rows (VtgFilteredListDialog* self);
static gboolean vtg_filtered_list_dialog_filter_and_highlight_row (VtgFilteredListDialog* self, GtkTreeIter* iter);
static gint vtg_filtered_list_dialog_filter_and_highlight_item (VtgFilteredListDialog* self, GtkTreeIter* iter);
gint vtg_path_utils_compare_vala_filenames (const char* filea, const char* fileb);
static void vtg_filtered_list_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



GType vtg_filtered_list_dialog_columns_get_type (void) {
	static volatile gsize vtg_filtered_list_dialog_columns_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_filtered_list_dialog_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, "VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME", "name"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP, "VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP", "markup"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, "VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY", "visibility"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT, "VTG_FILTERED_LIST_DIALOG_COLUMNS_OBJECT", "object"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON, "VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON", "icon"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, "VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE", "selectable"}, {VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT, "VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT", "columns-count"}, {0, NULL, NULL}};
		GType vtg_filtered_list_dialog_columns_type_id;
		vtg_filtered_list_dialog_columns_type_id = g_enum_register_static ("VtgFilteredListDialogColumns", values);
		g_once_init_leave (&vtg_filtered_list_dialog_columns_type_id__volatile, vtg_filtered_list_dialog_columns_type_id);
	}
	return vtg_filtered_list_dialog_columns_type_id__volatile;
}


GtkTreeStore* vtg_filtered_list_dialog_create_model (void) {
	GtkTreeStore* result = NULL;
	result = gtk_tree_store_new ((gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_OBJECT, GDK_TYPE_PIXBUF, G_TYPE_BOOLEAN);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


VtgFilteredListDialog* vtg_filtered_list_dialog_construct (GType object_type, GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	VtgFilteredListDialog * self;
	GtkTreeModel* _tmp0_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (VtgFilteredListDialog*) g_object_new (object_type, NULL);
	self->priv->_child_model = (_tmp0_ = _g_object_ref0 ((GtkTreeModel*) model), _g_object_unref0 (self->priv->_child_model), _tmp0_);
	vtg_filtered_list_dialog_initialize_ui (self, compare_func, compare_func_target);
	return self;
}


VtgFilteredListDialog* vtg_filtered_list_dialog_new (GtkTreeStore* model, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	return vtg_filtered_list_dialog_construct (VTG_TYPE_FILTERED_LIST_DIALOG, model, compare_func, compare_func_target);
}


static gboolean _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_filtered_list_dialog_on_entry_key_press (self, _sender, event);
	return result;
}


static void _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_filtered_list_dialog_on_entry_text_changed (self, _sender, pspec);
}


static void _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	vtg_filtered_list_dialog_on_row_changed (self, _sender, path, iter);
}


static gint _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_filtered_list_dialog_sort_model (self, model, a, b);
	return result;
}


static void _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	vtg_filtered_list_dialog_on_tree_selection_changed (self, _sender);
}


static gboolean _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_filtered_list_dialog_on_treeview_key_press (self, _sender, event);
	return result;
}


static void _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_filtered_list_dialog_on_row_activated (self, _sender, path, column);
}


static void vtg_filtered_list_dialog_initialize_ui (VtgFilteredListDialog* self, GtkTreeIterCompareFunc compare_func, void* compare_func_target) {
	GtkBuilder* builder;
	GtkDialog* _tmp1_;
	GtkButton* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkEntry* _tmp4_;
	GtkTreeModelFilter* _tmp5_;
	GtkTreeViewColumn* column;
	GtkCellRenderer* renderer;
	GtkCellRenderer* _tmp6_;
	GtkTreeModelSort* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	builder = gtk_builder_new ();
	{
		char* _tmp0_;
		gtk_builder_add_from_file (builder, _tmp0_ = vtg_utils_get_ui_path ("vtg.ui"), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgfilteredlistdialog.vala:77: initialize_ui: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_dialog = (_tmp1_ = _g_object_ref0 (GTK_DIALOG (gtk_builder_get_object (builder, "dialog-db"))), _g_object_unref0 (self->priv->_dialog), _tmp1_);
	g_assert (self->priv->_dialog != NULL);
	self->priv->_button_ok = (_tmp2_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button-db-ok"))), _g_object_unref0 (self->priv->_button_ok), _tmp2_);
	g_assert (self->priv->_button_ok != NULL);
	self->priv->_treeview = (_tmp3_ = _g_object_ref0 (GTK_TREE_VIEW (gtk_builder_get_object (builder, "treeview-db-docs"))), _g_object_unref0 (self->priv->_treeview), _tmp3_);
	g_assert (self->priv->_treeview != NULL);
	self->priv->_entry = (_tmp4_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry-db-filter"))), _g_object_unref0 (self->priv->_entry), _tmp4_);
	g_assert (self->priv->_entry != NULL);
	g_signal_connect_object ((GtkWidget*) self->priv->_entry, "key-press-event", (GCallback) _vtg_filtered_list_dialog_on_entry_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_entry, "notify::text", (GCallback) _vtg_filtered_list_dialog_on_entry_text_changed_g_object_notify, self, 0);
	self->priv->_filtered_model = (_tmp5_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new (self->priv->_child_model, NULL), _g_object_unref0 (self->priv->_filtered_model), _tmp5_);
	gtk_tree_model_filter_set_visible_column (self->priv->_filtered_model, (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY);
	g_signal_connect_object (self->priv->_child_model, "row-changed", (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self, 0);
	column = g_object_ref_sink (gtk_tree_view_column_new ());
	renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "pixbuf", (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_ICON);
	renderer = (_tmp6_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp6_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "markup", (gint) VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP);
	gtk_tree_view_append_column (self->priv->_treeview, column);
	self->priv->_sorted_model = (_tmp7_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) self->priv->_filtered_model), _g_object_unref0 (self->priv->_sorted_model), _tmp7_);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, GTK_SORT_ASCENDING);
	if (compare_func == NULL) {
		gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, _vtg_filtered_list_dialog_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	} else {
		gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->_sorted_model, (gint) VTG_COLUMNS_NAME, compare_func, compare_func_target, NULL);
	}
	gtk_tree_view_set_model (self->priv->_treeview, (GtkTreeModel*) self->priv->_sorted_model);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (self->priv->_treeview), GTK_SELECTION_SINGLE);
	g_signal_connect_object (gtk_tree_view_get_selection (self->priv->_treeview), "changed", (GCallback) _vtg_filtered_list_dialog_on_tree_selection_changed_gtk_tree_selection_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_treeview, "key-press-event", (GCallback) _vtg_filtered_list_dialog_on_treeview_key_press_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object (self->priv->_treeview, "row-activated", (GCallback) _vtg_filtered_list_dialog_on_row_activated_gtk_tree_view_row_activated, self, 0);
	gtk_tree_view_expand_all (self->priv->_treeview);
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_treeview), NULL, NULL)) {
		GtkTreePath* path;
		path = gtk_tree_path_new_from_indices (0, -1);
		gtk_tree_selection_select_path (gtk_tree_view_get_selection (self->priv->_treeview), path);
		_gtk_tree_path_free0 (path);
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, vtg_filtered_list_dialog_can_select_current_row (self));
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (builder);
}


void vtg_filtered_list_dialog_set_transient_for (VtgFilteredListDialog* self, GtkWindow* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_dialog, parent);
}


gboolean vtg_filtered_list_dialog_run (VtgFilteredListDialog* self) {
	gboolean result = FALSE;
	gint dialog_result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_window_set_modal ((GtkWindow*) self->priv->_dialog, TRUE);
	gtk_widget_show_all ((GtkWidget*) self->priv->_dialog);
	dialog_result = gtk_dialog_run (self->priv->_dialog);
	if (dialog_result > 0) {
		GtkTreeIter iter = {0};
		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_treeview), NULL, &iter)) {
			GtkTreeIter sort = {0};
			gtk_tree_model_sort_convert_iter_to_child_iter (self->priv->_sorted_model, &sort, &iter);
			gtk_tree_model_filter_convert_iter_to_child_iter (self->priv->_filtered_model, &self->selected_iter, &sort);
		} else {
			dialog_result = 0;
		}
	}
	gtk_object_destroy ((GtkObject*) self->priv->_dialog);
	result = dialog_result > 0;
	return result;
}


static void vtg_filtered_list_dialog_on_row_activated (VtgFilteredListDialog* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	if (vtg_filtered_list_dialog_can_select_current_row (self)) {
		gtk_dialog_response (self->priv->_dialog, 2);
	}
}


static void vtg_filtered_list_dialog_on_tree_selection_changed (VtgFilteredListDialog* self, GtkTreeSelection* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, vtg_filtered_list_dialog_can_select_current_row (self));
}


static void vtg_filtered_list_dialog_on_row_changed (VtgFilteredListDialog* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (path != NULL);
	if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_treeview), NULL, NULL)) {
		GtkTreeIter sel = {0};
		gtk_tree_model_get_iter_first (tree_model, &sel);
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->_treeview), &sel);
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, vtg_filtered_list_dialog_can_select_current_row (self));
}


static void vtg_filtered_list_dialog_move_cursor_down (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	if (gtk_tree_model_iter_has_child (model, curr)) {
		gtk_tree_model_iter_children (model, target, curr);
	} else {
		*target = *curr;
		if (!gtk_tree_model_iter_next (model, target)) {
			gtk_tree_model_iter_parent (model, target, curr);
			if (!gtk_tree_model_iter_next (model, target)) {
				*target = *curr;
			}
		}
	}
}


static void vtg_filtered_list_dialog_move_cursor_up (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* curr, GtkTreeIter* target) {
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	path = gtk_tree_model_get_path (model, curr);
	if (gtk_tree_path_prev (path)) {
		gtk_tree_model_get_iter (model, curr, path);
		if (gtk_tree_model_iter_has_child (model, curr)) {
			gint nch;
			nch = gtk_tree_model_iter_n_children (model, curr);
			gtk_tree_model_iter_nth_child (model, target, curr, nch - 1);
		} else {
			*target = *curr;
		}
	} else {
		GtkTreePath* _tmp0_;
		gboolean _tmp1_ = FALSE;
		path = (_tmp0_ = gtk_tree_model_get_path (model, curr), _gtk_tree_path_free0 (path), _tmp0_);
		if (gtk_tree_path_get_depth (path) > 1) {
			_tmp1_ = gtk_tree_path_up (path);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gtk_tree_model_get_iter (model, target, path);
		} else {
			*target = *curr;
		}
	}
	_gtk_tree_path_free0 (path);
}


static gboolean vtg_filtered_list_dialog_on_entry_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*evt).keyval == GDK_Down) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*evt).keyval == GDK_Up;
	}
	if (_tmp0_) {
		GtkTreeIter curr = {0};
		GtkTreeIter target = {0};
		GtkTreeModel* model;
		GtkTreePath* path;
		gboolean selectable;
		GtkTreeModel* _tmp1_ = NULL;
		gboolean _tmp2_;
		GtkTreeModel* _tmp3_;
		GtkTreePath* _tmp6_;
		model = NULL;
		path = NULL;
		selectable = TRUE;
		if ((_tmp2_ = gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_treeview), &_tmp1_, &curr), model = (_tmp3_ = _g_object_ref0 (_tmp1_), _g_object_unref0 (model), _tmp3_), _tmp2_)) {
			if ((*evt).keyval == GDK_Down) {
				vtg_filtered_list_dialog_move_cursor_down (self, model, &curr, &target);
				gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
				if (!selectable) {
					curr = target;
					vtg_filtered_list_dialog_move_cursor_down (self, model, &curr, &target);
				}
			} else {
				vtg_filtered_list_dialog_move_cursor_up (self, model, &curr, &target);
				gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
				if (!selectable) {
					curr = target;
					vtg_filtered_list_dialog_move_cursor_up (self, model, &curr, &target);
				}
			}
		} else {
			GtkTreeModel* _tmp4_;
			GtkTreePath* _tmp5_;
			model = (_tmp4_ = _g_object_ref0 (gtk_tree_view_get_model (self->priv->_treeview)), _g_object_unref0 (model), _tmp4_);
			gtk_tree_model_get_iter_first (model, &target);
			path = (_tmp5_ = gtk_tree_model_get_path (model, &target), _gtk_tree_path_free0 (path), _tmp5_);
			gtk_tree_model_get (model, &target, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &selectable, -1);
			if (!selectable) {
				curr = target;
				vtg_filtered_list_dialog_move_cursor_down (self, model, &curr, &target);
			}
		}
		path = (_tmp6_ = gtk_tree_model_get_path (model, &target), _gtk_tree_path_free0 (path), _tmp6_);
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->_treeview), &target);
		gtk_tree_view_scroll_to_cell (self->priv->_treeview, path, NULL, FALSE, (float) 0, (float) 0);
		result = TRUE;
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		return result;
	}
	result = FALSE;
	return result;
}


gboolean vtg_filtered_list_dialog_on_treeview_key_press (VtgFilteredListDialog* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if (((*evt).state & GDK_MOD1_MASK) == 0) {
		_tmp0_ = (*evt).keyval == GDK_Return;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (vtg_filtered_list_dialog_can_select_current_row (self)) {
			gtk_dialog_response (self->priv->_dialog, 2);
		}
	}
	result = FALSE;
	return result;
}


static void vtg_filtered_list_dialog_on_entry_text_changed (VtgFilteredListDialog* self, GObject* pspec, GParamSpec* gobject) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	g_return_if_fail (gobject != NULL);
	self->priv->_current_filter = (_tmp0_ = g_strdup (gtk_entry_get_text (self->priv->_entry)), _g_free0 (self->priv->_current_filter), _tmp0_);
	if (vtg_string_utils_is_null_or_empty (self->priv->_current_filter)) {
		GPatternSpec* _tmp1_;
		self->priv->_current_pattern = (_tmp1_ = NULL, _g_pattern_spec_free0 (self->priv->_current_pattern), _tmp1_);
	} else {
		char* _tmp2_;
		GPatternSpec* _tmp5_;
		self->priv->_current_filter = (_tmp2_ = vtg_string_utils_replace (self->priv->_current_filter, " ", "*"), _g_free0 (self->priv->_current_filter), _tmp2_);
		if (!g_str_has_suffix (self->priv->_current_filter, "*")) {
			char* _tmp3_;
			self->priv->_current_filter = (_tmp3_ = g_strconcat (self->priv->_current_filter, "*", NULL), _g_free0 (self->priv->_current_filter), _tmp3_);
		}
		if (!g_str_has_prefix (self->priv->_current_filter, "*")) {
			char* _tmp4_;
			self->priv->_current_filter = (_tmp4_ = g_strconcat ("*", self->priv->_current_filter, NULL), _g_free0 (self->priv->_current_filter), _tmp4_);
		}
		self->priv->_current_pattern = (_tmp5_ = g_pattern_spec_new (self->priv->_current_filter), _g_pattern_spec_free0 (self->priv->_current_pattern), _tmp5_);
	}
	vtg_filtered_list_dialog_filter_and_highlight_rows (self);
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->_sorted_model, 0, GTK_SORT_ASCENDING);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_button_ok, vtg_filtered_list_dialog_can_select_current_row (self));
}


static gboolean vtg_filtered_list_dialog_can_select_current_row (VtgFilteredListDialog* self) {
	gboolean result = FALSE;
	gboolean res;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	res = FALSE;
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_treeview), NULL, &iter)) {
		GtkTreeIter sort = {0};
		GtkTreeIter curr = {0};
		gtk_tree_model_sort_convert_iter_to_child_iter (self->priv->_sorted_model, &sort, &iter);
		gtk_tree_model_filter_convert_iter_to_child_iter (self->priv->_filtered_model, &curr, &sort);
		gtk_tree_model_get (self->priv->_child_model, &curr, VTG_FILTERED_LIST_DIALOG_COLUMNS_SELECTABLE, &res, -1);
	}
	result = res;
	return result;
}


static gboolean vtg_filtered_list_dialog_filter_and_highlight_row (VtgFilteredListDialog* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	char* val;
	gboolean res;
	char* markup;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	val = NULL;
	gtk_tree_model_get (self->priv->_child_model, iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &val, -1);
	res = TRUE;
	markup = NULL;
	if (self->priv->_current_pattern != NULL) {
		res = g_pattern_match_string (self->priv->_current_pattern, val);
	}
	if (res) {
		_tmp0_ = self->priv->_current_pattern != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint words_length1;
		gint _words_size_;
		char** _tmp2_;
		char** _tmp1_;
		char** words;
		char* _tmp3_;
		words = (_tmp2_ = _tmp1_ = g_strsplit (self->priv->_current_filter, "*", 0), words_length1 = _vala_array_length (_tmp1_), _words_size_ = words_length1, _tmp2_);
		markup = (_tmp3_ = g_strdup (""), _g_free0 (markup), _tmp3_);
		{
			char** word_collection;
			int word_collection_length1;
			int word_it;
			word_collection = words;
			word_collection_length1 = words_length1;
			for (word_it = 0; word_it < words_length1; word_it = word_it + 1) {
				char* word;
				word = g_strdup (word_collection[word_it]);
				{
					if (!vtg_string_utils_is_null_or_empty (word)) {
						gint pieces_length1;
						gint _pieces_size_;
						char** _tmp5_;
						char** _tmp4_;
						char** pieces;
						char* _tmp6_;
						gboolean _tmp7_ = FALSE;
						pieces = (_tmp5_ = _tmp4_ = g_strsplit (val, word, 2), pieces_length1 = _vala_array_length (_tmp4_), _pieces_size_ = pieces_length1, _tmp5_);
						markup = (_tmp6_ = g_strconcat (markup, pieces[0], NULL), _g_free0 (markup), _tmp6_);
						if (pieces_length1 == 2) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = g_str_has_suffix (val, word);
						}
						if (_tmp7_) {
							char* _tmp8_;
							markup = (_tmp8_ = g_strconcat (markup, "<b>", word, "</b>", NULL), _g_free0 (markup), _tmp8_);
							if (pieces_length1 == 2) {
								char* _tmp9_;
								val = (_tmp9_ = g_strdup (pieces[1]), _g_free0 (val), _tmp9_);
							} else {
								char* _tmp10_;
								val = (_tmp10_ = NULL, _g_free0 (val), _tmp10_);
								pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (word);
								break;
							}
						}
						pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (word);
				}
			}
		}
		if (val != NULL) {
			char* _tmp11_;
			markup = (_tmp11_ = g_strconcat (markup, val, NULL), _g_free0 (markup), _tmp11_);
		}
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	} else {
		char* _tmp12_;
		markup = (_tmp12_ = g_strdup (val), _g_free0 (markup), _tmp12_);
	}
	gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_MARKUP, markup, -1);
	gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, res, -1);
	result = res;
	_g_free0 (markup);
	_g_free0 (val);
	return result;
}


static gint vtg_filtered_list_dialog_filter_and_highlight_item (VtgFilteredListDialog* self, GtkTreeIter* iter) {
	gint result = 0;
	gint res;
	gboolean eof;
	g_return_val_if_fail (self != NULL, 0);
	res = 0;
	eof = FALSE;
	while (TRUE) {
		if (!(!eof)) {
			break;
		}
		if (vtg_filtered_list_dialog_filter_and_highlight_row (self, iter)) {
			res++;
		}
		if (gtk_tree_model_iter_has_child (self->priv->_child_model, iter)) {
			GtkTreeIter child = {0};
			gtk_tree_model_iter_children (self->priv->_child_model, &child, iter);
			if (vtg_filtered_list_dialog_filter_and_highlight_item (self, &child) != 0) {
				res++;
				gtk_tree_store_set (GTK_TREE_STORE (self->priv->_child_model), iter, VTG_FILTERED_LIST_DIALOG_COLUMNS_VISIBILITY, TRUE, -1);
			}
		}
		eof = !gtk_tree_model_iter_next (self->priv->_child_model, iter);
	}
	result = res;
	return result;
}


static void vtg_filtered_list_dialog_filter_and_highlight_rows (VtgFilteredListDialog* self) {
	guint _tmp0_;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_child_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self);
	if (gtk_tree_model_get_iter_first (self->priv->_child_model, &iter)) {
		vtg_filtered_list_dialog_filter_and_highlight_item (self, &iter);
	}
	g_signal_connect_object (self->priv->_child_model, "row-changed", (GCallback) _vtg_filtered_list_dialog_on_row_changed_gtk_tree_model_row_changed, self, 0);
	gtk_tree_model_filter_refilter (self->priv->_filtered_model);
	gtk_tree_view_expand_all (self->priv->_treeview);
}


static gint vtg_filtered_list_dialog_sort_model (VtgFilteredListDialog* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	char* vala;
	char* valb;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	vala = NULL;
	valb = NULL;
	gtk_tree_model_get (model, a, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &vala, -1);
	gtk_tree_model_get (model, b, VTG_FILTERED_LIST_DIALOG_COLUMNS_NAME, &valb, -1);
	result = vtg_path_utils_compare_vala_filenames (vala, valb);
	_g_free0 (valb);
	_g_free0 (vala);
	return result;
}


static void vtg_filtered_list_dialog_class_init (VtgFilteredListDialogClass * klass) {
	vtg_filtered_list_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgFilteredListDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_filtered_list_dialog_finalize;
}


static void vtg_filtered_list_dialog_instance_init (VtgFilteredListDialog * self) {
	self->priv = VTG_FILTERED_LIST_DIALOG_GET_PRIVATE (self);
	self->priv->_current_pattern = NULL;
	self->priv->_current_filter = NULL;
}


static void vtg_filtered_list_dialog_finalize (GObject* obj) {
	VtgFilteredListDialog * self;
	self = VTG_FILTERED_LIST_DIALOG (obj);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_treeview);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_sorted_model);
	_g_object_unref0 (self->priv->_child_model);
	_g_pattern_spec_free0 (self->priv->_current_pattern);
	_g_free0 (self->priv->_current_filter);
	_g_object_unref0 (self->priv->_button_ok);
	G_OBJECT_CLASS (vtg_filtered_list_dialog_parent_class)->finalize (obj);
}


GType vtg_filtered_list_dialog_get_type (void) {
	return vtg_filtered_list_dialog_type_id;
}


GType vtg_filtered_list_dialog_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgFilteredListDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_filtered_list_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgFilteredListDialog), 0, (GInstanceInitFunc) vtg_filtered_list_dialog_instance_init, NULL };
	vtg_filtered_list_dialog_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgFilteredListDialog", &g_define_type_info, 0);
	return vtg_filtered_list_dialog_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




