/* astmerger.c generated by valac 0.10.0, the Vala compiler
 * generated from astmerger.vala, do not modify */

/* astmerger.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define AFRODITE_TYPE_AST_MERGER (afrodite_ast_merger_get_type ())
#define AFRODITE_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMerger))
#define AFRODITE_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))
#define AFRODITE_IS_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_IS_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_AST_MERGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))

typedef struct _AfroditeAstMerger AfroditeAstMerger;
typedef struct _AfroditeAstMergerClass AfroditeAstMergerClass;
typedef struct _AfroditeAstMergerPrivate AfroditeAstMergerPrivate;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;

#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _afrodite_ast_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_ast_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define AFRODITE_TYPE_SYMBOL_ACCESSIBILITY (afrodite_symbol_accessibility_get_type ())

#define AFRODITE_TYPE_MEMBER_BINDING (afrodite_member_binding_get_type ())
typedef struct _AfroditeSymbolPrivate AfroditeSymbolPrivate;

#define AFRODITE_TYPE_ELLIPSIS_TYPE (afrodite_ellipsis_type_get_type ())
#define AFRODITE_ELLIPSIS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisType))
#define AFRODITE_ELLIPSIS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisTypeClass))
#define AFRODITE_IS_ELLIPSIS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE))
#define AFRODITE_IS_ELLIPSIS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_ELLIPSIS_TYPE))
#define AFRODITE_ELLIPSIS_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_ELLIPSIS_TYPE, AfroditeEllipsisTypeClass))

typedef struct _AfroditeEllipsisType AfroditeEllipsisType;
typedef struct _AfroditeEllipsisTypeClass AfroditeEllipsisTypeClass;

#define AFRODITE_TYPE_COMPARE_MODE (afrodite_compare_mode_get_type ())

struct _AfroditeAstMerger {
	ValaCodeVisitor parent_instance;
	AfroditeAstMergerPrivate * priv;
};

struct _AfroditeAstMergerClass {
	ValaCodeVisitorClass parent_class;
};

struct _AfroditeAstMergerPrivate {
	AfroditeSymbol* _current;
	AfroditeDataType* _current_type;
	AfroditeSourceReference* _current_sr;
	AfroditeSourceFile* _source_file;
	AfroditeDataType* _inferred_type;
	ValaLiteral* _last_literal;
	char* _vala_symbol_fqn;
	gboolean _merge_glib;
	gint _child_count;
	AfroditeAst* _ast;
};

typedef enum  {
	AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE = 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL = 1 << 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED = 1 << 2,
	AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC = 1 << 3,
	AFRODITE_SYMBOL_ACCESSIBILITY_ANY = ((AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC
} AfroditeSymbolAccessibility;

typedef enum  {
	AFRODITE_MEMBER_BINDING_INSTANCE = 1,
	AFRODITE_MEMBER_BINDING_CLASS = 1 << 1,
	AFRODITE_MEMBER_BINDING_STATIC = 1 << 2,
	AFRODITE_MEMBER_BINDING_ANY = (AFRODITE_MEMBER_BINDING_INSTANCE | AFRODITE_MEMBER_BINDING_CLASS) | AFRODITE_MEMBER_BINDING_STATIC
} AfroditeMemberBinding;

struct _AfroditeSymbol {
	GObject parent_instance;
	AfroditeSymbolPrivate * priv;
	ValaList* resolve_targets;
	AfroditeMemberBinding binding;
	gboolean is_virtual;
	gboolean is_abstract;
	gboolean overrides;
	gint _static_child_count;
	gint _creation_method_child_count;
};

struct _AfroditeSymbolClass {
	GObjectClass parent_class;
};

typedef enum  {
	AFRODITE_COMPARE_MODE_EXACT,
	AFRODITE_COMPARE_MODE_START_WITH
} AfroditeCompareMode;


extern AfroditeEllipsisType* afrodite_symbol_ELLIPSIS;
static gpointer afrodite_ast_merger_parent_class = NULL;

GType afrodite_ast_merger_get_type (void) G_GNUC_CONST;
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
#define AFRODITE_AST_MERGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerPrivate))
enum  {
	AFRODITE_AST_MERGER_DUMMY_PROPERTY
};
AfroditeAstMerger* afrodite_ast_merger_new (AfroditeAst* ast);
AfroditeAstMerger* afrodite_ast_merger_construct (GType object_type, AfroditeAst* ast);
void afrodite_ast_merger_merge_vala_context (AfroditeAstMerger* self, ValaSourceFile* source, ValaCodeContext* context, gboolean merge_glib);
AfroditeSymbol* afrodite_ast_get_root (AfroditeAst* self);
AfroditeSourceFile* afrodite_ast_lookup_source_file (AfroditeAst* self, const char* filename);
AfroditeSourceFile* afrodite_ast_add_source_file (AfroditeAst* self, const char* filename);
AfroditeDataType* afrodite_source_file_add_using_directive (AfroditeSourceFile* self, const char* name);
void afrodite_ast_merger_remove_source_filename (AfroditeAstMerger* self, const char* filename);
gboolean afrodite_source_file_get_has_symbols (AfroditeSourceFile* self);
ValaList* afrodite_source_file_get_symbols (AfroditeSourceFile* self);
static gboolean afrodite_ast_merger_remove_symbol (AfroditeAstMerger* self, AfroditeSourceFile* source, AfroditeSymbol* symbol);
void afrodite_symbol_destroy (AfroditeSymbol* self);
void afrodite_source_file_set_symbols (AfroditeSourceFile* self, ValaList* value);
void afrodite_ast_remove_source (AfroditeAst* self, AfroditeSourceFile* source);
gboolean afrodite_symbol_get_has_source_references (AfroditeSymbol* self);
AfroditeSourceReference* afrodite_symbol_lookup_source_reference_filename (AfroditeSymbol* self, const char* filename);
const char* afrodite_source_file_get_filename (AfroditeSourceFile* self);
void afrodite_symbol_remove_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference);
gboolean afrodite_symbol_get_has_children (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_children (AfroditeSymbol* self);
void afrodite_symbol_remove_child (AfroditeSymbol* self, AfroditeSymbol* child);
const char* afrodite_symbol_get_type_name (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self);
AfroditeSourceFile* afrodite_source_reference_get_file (AfroditeSourceReference* self);
void afrodite_source_file_add_symbol (AfroditeSourceFile* self, AfroditeSymbol* symbol);
void afrodite_symbol_add_source_reference (AfroditeSymbol* self, AfroditeSourceReference* reference);
const char* afrodite_symbol_get_name (AfroditeSymbol* self);
static AfroditeSymbol* afrodite_ast_merger_visit_symbol (AfroditeAstMerger* self, ValaSymbol* s, AfroditeSourceReference** source_reference, gboolean replace);
static void afrodite_ast_merger_set_fqn (AfroditeAstMerger* self, const char* name);
AfroditeSymbol* afrodite_ast_lookup (AfroditeAst* self, const char* fully_qualified_name, AfroditeSymbol** parent);
static AfroditeSymbol* afrodite_ast_merger_add_symbol (AfroditeAstMerger* self, ValaSymbol* s, AfroditeSourceReference** source_ref, gint last_line, gint last_column);
void afrodite_symbol_add_child (AfroditeSymbol* self, AfroditeSymbol* child);
static AfroditeSourceReference* afrodite_ast_merger_create_source_reference (AfroditeAstMerger* self, ValaCodeNode* s, gint last_line, gint last_column);
AfroditeSymbol* afrodite_symbol_new (const char* fully_qualified_name, const char* type_name);
AfroditeSymbol* afrodite_symbol_construct (GType object_type, const char* fully_qualified_name, const char* type_name);
GType afrodite_symbol_accessibility_get_type (void) G_GNUC_CONST;
static AfroditeSymbolAccessibility afrodite_ast_merger_get_vala_symbol_access (AfroditeAstMerger* self, ValaSymbolAccessibility access);
void afrodite_symbol_set_access (AfroditeSymbol* self, AfroditeSymbolAccessibility value);
static AfroditeSymbol* afrodite_ast_merger_add_codenode (AfroditeAstMerger* self, const char* type_name, ValaCodeNode* c, AfroditeSourceReference** source_ref, gint last_line, gint last_column);
GType afrodite_member_binding_get_type (void) G_GNUC_CONST;
static AfroditeMemberBinding afrodite_ast_merger_get_vala_member_binding (AfroditeAstMerger* self, MemberBinding binding);
AfroditeSourceReference* afrodite_source_reference_new (void);
AfroditeSourceReference* afrodite_source_reference_construct (GType object_type);
void afrodite_source_reference_set_file (AfroditeSourceReference* self, AfroditeSourceFile* value);
void afrodite_source_reference_set_first_line (AfroditeSourceReference* self, gint value);
void afrodite_source_reference_set_first_column (AfroditeSourceReference* self, gint value);
void afrodite_source_reference_set_last_line (AfroditeSourceReference* self, gint value);
void afrodite_source_reference_set_last_column (AfroditeSourceReference* self, gint value);
gboolean afrodite_ast_merger_is_symbol_defined_current_source (AfroditeAstMerger* self, ValaSymbol* sym);
static gboolean afrodite_ast_merger_is_glib_core_vapis (AfroditeAstMerger* self, ValaNamespace* ns);
static void afrodite_ast_merger_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void afrodite_ast_merger_real_visit_class (ValaCodeVisitor* base, ValaClass* c);
static void afrodite_ast_merger_real_visit_struct (ValaCodeVisitor* base, ValaStruct* s);
static void afrodite_ast_merger_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void afrodite_ast_merger_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* e);
static void afrodite_ast_merger_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* c);
static void afrodite_ast_merger_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
AfroditeDataType* afrodite_data_type_new (const char* type_name, const char* name);
AfroditeDataType* afrodite_data_type_construct (GType object_type, const char* type_name, const char* name);
void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value);
static void afrodite_ast_merger_visit_type_for_generics (AfroditeAstMerger* self, ValaDataType* t, AfroditeDataType* ct);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
static void afrodite_ast_merger_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
void afrodite_symbol_set_display_name (AfroditeSymbol* self, const char* value);
static void afrodite_ast_merger_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* m);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
static void afrodite_ast_merger_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* m);
static void afrodite_ast_merger_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
AfroditeSymbolAccessibility afrodite_symbol_get_access (AfroditeSymbol* self);
static void afrodite_ast_merger_real_visit_enum (ValaCodeVisitor* base, ValaEnum* e);
static void afrodite_ast_merger_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void afrodite_ast_merger_real_visit_signal (ValaCodeVisitor* base, ValaSignal* s);
static void afrodite_ast_merger_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static char* afrodite_ast_merger_get_datatype_typename (AfroditeAstMerger* self, ValaDataType* type);
static void afrodite_ast_merger_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void afrodite_ast_merger_real_visit_property (ValaCodeVisitor* base, ValaProperty* p);
static void afrodite_ast_merger_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* a);
static AfroditeSymbol* afrodite_ast_merger_visit_scoped_codenode (AfroditeAstMerger* self, const char* name, ValaCodeNode* node, ValaBlock* body);
static void afrodite_ast_merger_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void afrodite_ast_merger_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static char* afrodite_ast_merger_expression_to_string (AfroditeAstMerger* self, ValaExpression* e);
char* afrodite_utils_binary_operator_to_string (ValaBinaryOperator op);
char* afrodite_utils_unary_operator_to_string (ValaUnaryOperator op);
void afrodite_utils_trace (const char* format, ...);
static void afrodite_ast_merger_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
GType afrodite_ellipsis_type_get_type (void) G_GNUC_CONST;
void afrodite_data_type_set_default_expression (AfroditeDataType* self, const char* value);
void afrodite_data_type_set_is_out (AfroditeDataType* self, gboolean value);
void afrodite_data_type_set_is_ref (AfroditeDataType* self, gboolean value);
void afrodite_symbol_add_parameter (AfroditeSymbol* self, AfroditeDataType* par);
static void afrodite_ast_merger_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
gint afrodite_source_reference_get_last_line (AfroditeSourceReference* self);
static void afrodite_ast_merger_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
void afrodite_data_type_set_type_name (AfroditeDataType* self, const char* value);
void afrodite_data_type_set_is_array (AfroditeDataType* self, gboolean value);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
void afrodite_data_type_set_source_reference (AfroditeDataType* self, AfroditeSourceReference* value);
gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self);
AfroditeDataType* afrodite_symbol_lookup_local_variable (AfroditeSymbol* self, const char* name);
const char* afrodite_data_type_get_name (AfroditeDataType* self);
void afrodite_symbol_remove_local_variable (AfroditeSymbol* self, AfroditeDataType* variable);
void afrodite_symbol_add_local_variable (AfroditeSymbol* self, AfroditeDataType* variable);
static void afrodite_ast_merger_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr);
static void afrodite_ast_merger_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
GType afrodite_compare_mode_get_type (void) G_GNUC_CONST;
AfroditeDataType* afrodite_symbol_scope_lookup_datatype_for_variable (AfroditeSymbol* self, AfroditeCompareMode mode, const char* name);
static void afrodite_ast_merger_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void afrodite_ast_merger_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void afrodite_ast_merger_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void afrodite_ast_merger_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void afrodite_ast_merger_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* lit);
static void afrodite_ast_merger_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* lit);
static void afrodite_ast_merger_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* lit);
static void afrodite_ast_merger_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* lit);
static void afrodite_ast_merger_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* lit);
static void afrodite_ast_merger_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void afrodite_ast_merger_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
void afrodite_data_type_set_is_iterator (AfroditeDataType* self, gboolean value);
static void afrodite_ast_merger_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void afrodite_ast_merger_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void afrodite_ast_merger_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void afrodite_ast_merger_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void afrodite_ast_merger_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void afrodite_ast_merger_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void afrodite_ast_merger_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void afrodite_ast_merger_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void afrodite_ast_merger_real_visit_type_parameter (ValaCodeVisitor* base, ValaTypeParameter* p);
void afrodite_symbol_add_generic_type_argument (AfroditeSymbol* self, AfroditeSymbol* sym);
static void afrodite_ast_merger_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* type);
void afrodite_data_type_add_generic_type (AfroditeDataType* self, AfroditeDataType* type);
void afrodite_symbol_add_base_type (AfroditeSymbol* self, AfroditeDataType* type);
static void afrodite_ast_merger_finalize (ValaCodeVisitor* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _afrodite_ast_ref0 (gpointer self) {
	return self ? afrodite_ast_ref (self) : NULL;
}


AfroditeAstMerger* afrodite_ast_merger_construct (GType object_type, AfroditeAst* ast) {
	AfroditeAstMerger* self;
	AfroditeAst* _tmp0_;
	g_return_val_if_fail (ast != NULL, NULL);
	self = (AfroditeAstMerger*) vala_code_visitor_construct (object_type);
	self->priv->_ast = (_tmp0_ = _afrodite_ast_ref0 (ast), _afrodite_ast_unref0 (self->priv->_ast), _tmp0_);
	return self;
}


AfroditeAstMerger* afrodite_ast_merger_new (AfroditeAst* ast) {
	return afrodite_ast_merger_construct (AFRODITE_TYPE_AST_MERGER, ast);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void afrodite_ast_merger_merge_vala_context (AfroditeAstMerger* self, ValaSourceFile* source, ValaCodeContext* context, gboolean merge_glib) {
	char* _tmp0_;
	AfroditeDataType* _tmp1_;
	AfroditeSymbol* _tmp2_;
	AfroditeSourceFile* _tmp3_;
	gboolean _tmp4_;
	AfroditeSourceFile* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (context != NULL);
	self->priv->_merge_glib = merge_glib;
	self->priv->_vala_symbol_fqn = (_tmp0_ = NULL, _g_free0 (self->priv->_vala_symbol_fqn), _tmp0_);
	self->priv->_current_type = (_tmp1_ = NULL, _afrodite_data_type_unref0 (self->priv->_current_type), _tmp1_);
	self->priv->_child_count = 0;
	self->priv->_current = (_tmp2_ = _g_object_ref0 (afrodite_ast_get_root (self->priv->_ast)), _g_object_unref0 (self->priv->_current), _tmp2_);
	if ((_tmp4_ = (_tmp3_ = afrodite_ast_lookup_source_file (self->priv->_ast, vala_source_file_get_filename (source))) != NULL, _afrodite_source_file_unref0 (_tmp3_), _tmp4_)) {
		g_critical ("astmerger.vala:55: two sources %s!", vala_source_file_get_filename (source));
	}
	self->priv->_source_file = (_tmp5_ = afrodite_ast_add_source_file (self->priv->_ast, vala_source_file_get_filename (source)), _afrodite_source_file_unref0 (self->priv->_source_file), _tmp5_);
	{
		ValaIterator* _u_it;
		_u_it = vala_iterable_iterator ((ValaIterable*) vala_source_file_get_current_using_directives (source));
		while (TRUE) {
			ValaUsingDirective* u;
			AfroditeDataType* _tmp6_;
			if (!vala_iterator_next (_u_it)) {
				break;
			}
			u = (ValaUsingDirective*) vala_iterator_get (_u_it);
			_tmp6_ = afrodite_source_file_add_using_directive (self->priv->_source_file, vala_symbol_get_name (vala_using_directive_get_namespace_symbol (u)));
			_afrodite_data_type_unref0 (_tmp6_);
			_vala_code_node_unref0 (u);
		}
		_vala_collection_object_unref0 (_u_it);
	}
	vala_code_node_accept_children ((ValaCodeNode*) vala_code_context_get_root (context), (ValaCodeVisitor*) self);
}


void afrodite_ast_merger_remove_source_filename (AfroditeAstMerger* self, const char* filename) {
	AfroditeSourceFile* source;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	source = afrodite_ast_lookup_source_file (self->priv->_ast, filename);
	if (source == NULL) {
		g_warning ("astmerger.vala:70: remove_source: file not found %s", filename);
	}
	if (afrodite_source_file_get_has_symbols (source)) {
		{
			ValaIterator* _symbol_it;
			_symbol_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_symbols (source));
			while (TRUE) {
				AfroditeSymbol* symbol;
				if (!vala_iterator_next (_symbol_it)) {
					break;
				}
				symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
				if (afrodite_ast_merger_remove_symbol (self, source, symbol)) {
					afrodite_symbol_destroy (symbol);
				}
				_g_object_unref0 (symbol);
			}
			_vala_collection_object_unref0 (_symbol_it);
		}
		afrodite_source_file_set_symbols (source, NULL);
	}
	afrodite_ast_remove_source (self->priv->_ast, source);
	_afrodite_source_file_unref0 (source);
}


static gboolean afrodite_ast_merger_remove_symbol (AfroditeAstMerger* self, AfroditeSourceFile* source, AfroditeSymbol* symbol) {
	gboolean result = FALSE;
	gboolean orphaned;
	gboolean removed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	orphaned = FALSE;
	removed = FALSE;
	if (afrodite_symbol_get_has_source_references (symbol)) {
		AfroditeSourceReference* source_ref;
		source_ref = afrodite_symbol_lookup_source_reference_filename (symbol, afrodite_source_file_get_filename (source));
		if (source_ref != NULL) {
			afrodite_symbol_remove_source_reference (symbol, source_ref);
			orphaned = !afrodite_symbol_get_has_source_references (symbol);
		}
		_afrodite_source_reference_unref0 (source_ref);
	}
	if (afrodite_symbol_get_has_children (symbol)) {
		ValaList* to_del;
		to_del = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
		{
			ValaIterator* _child_it;
			_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (symbol));
			while (TRUE) {
				AfroditeSymbol* child;
				if (!vala_iterator_next (_child_it)) {
					break;
				}
				child = (AfroditeSymbol*) vala_iterator_get (_child_it);
				if (afrodite_ast_merger_remove_symbol (self, source, child)) {
					vala_collection_add ((ValaCollection*) to_del, child);
				}
				_g_object_unref0 (child);
			}
			_vala_collection_object_unref0 (_child_it);
		}
		{
			ValaIterator* _child_it;
			_child_it = vala_iterable_iterator ((ValaIterable*) to_del);
			while (TRUE) {
				AfroditeSymbol* child;
				if (!vala_iterator_next (_child_it)) {
					break;
				}
				child = (AfroditeSymbol*) vala_iterator_get (_child_it);
				afrodite_symbol_remove_child (symbol, child);
				_g_object_unref0 (child);
			}
			_vala_collection_object_unref0 (_child_it);
		}
		_vala_collection_object_unref0 (to_del);
	}
	if (orphaned) {
		gboolean _tmp0_ = FALSE;
		if (afrodite_symbol_get_has_children (symbol)) {
			_tmp0_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Namespace") == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			AfroditeSourceReference* source_ref;
			source_ref = NULL;
			{
				ValaIterator* _child_it;
				_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (symbol));
				while (TRUE) {
					AfroditeSymbol* child;
					if (!vala_iterator_next (_child_it)) {
						break;
					}
					child = (AfroditeSymbol*) vala_iterator_get (_child_it);
					if (afrodite_symbol_get_has_source_references (child)) {
						AfroditeSourceReference* _tmp1_;
						source_ref = (_tmp1_ = (AfroditeSourceReference*) vala_list_get (afrodite_symbol_get_source_references (child), 0), _afrodite_source_reference_unref0 (source_ref), _tmp1_);
						_g_object_unref0 (child);
						break;
					}
					_g_object_unref0 (child);
				}
				_vala_collection_object_unref0 (_child_it);
			}
			if (source_ref != NULL) {
				AfroditeSourceReference* _tmp2_;
				gboolean _tmp3_;
				afrodite_source_file_add_symbol (afrodite_source_reference_get_file (source_ref), symbol);
				if ((_tmp3_ = (_tmp2_ = afrodite_symbol_lookup_source_reference_filename (symbol, afrodite_source_file_get_filename (afrodite_source_reference_get_file (source_ref)))) == NULL, _afrodite_source_reference_unref0 (_tmp2_), _tmp3_)) {
					afrodite_symbol_add_source_reference (symbol, source_ref);
				}
			} else {
				g_critical ("astmerger.vala:130: no valid source reference in child for orphaned sy" \
"mbol %s", afrodite_symbol_get_name (symbol));
			}
			_afrodite_source_reference_unref0 (source_ref);
		} else {
			gboolean _tmp4_ = FALSE;
			if (!afrodite_symbol_get_has_children (symbol)) {
				_tmp4_ = orphaned;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				removed = TRUE;
			}
		}
	}
	result = removed;
	return result;
}


static AfroditeSymbol* afrodite_ast_merger_visit_symbol (AfroditeAstMerger* self, ValaSymbol* s, AfroditeSourceReference** source_reference, gboolean replace) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* symbol;
	AfroditeSymbol* parent;
	AfroditeSymbol* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSymbol* _tmp2_;
	AfroditeSymbol* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	if (source_reference != NULL) {
		*source_reference = NULL;
	}
	symbol = NULL;
	parent = NULL;
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name (s));
	symbol = (_tmp3_ = (_tmp1_ = afrodite_ast_lookup (self->priv->_ast, self->priv->_vala_symbol_fqn, &_tmp0_), parent = (_tmp2_ = _tmp0_, _g_object_unref0 (parent), _tmp2_), _tmp1_), _g_object_unref0 (symbol), _tmp3_);
	g_assert (parent != NULL);
	if (symbol == NULL) {
		AfroditeSourceReference* _tmp4_ = NULL;
		AfroditeSymbol* _tmp5_;
		AfroditeSourceReference* _tmp6_;
		AfroditeSymbol* _tmp7_;
		symbol = (_tmp7_ = (_tmp5_ = afrodite_ast_merger_add_symbol (self, s, &_tmp4_, 0, 0), *source_reference = (_tmp6_ = _tmp4_, _afrodite_source_reference_unref0 (*source_reference), _tmp6_), _tmp5_), _g_object_unref0 (symbol), _tmp7_);
		afrodite_symbol_add_child (parent, symbol);
	} else {
		if (replace) {
			AfroditeSourceReference* _tmp8_ = NULL;
			AfroditeSymbol* _tmp9_;
			AfroditeSourceReference* _tmp10_;
			AfroditeSymbol* _tmp11_;
			afrodite_symbol_remove_child (parent, symbol);
			symbol = (_tmp11_ = (_tmp9_ = afrodite_ast_merger_add_symbol (self, s, &_tmp8_, 0, 0), *source_reference = (_tmp10_ = _tmp8_, _afrodite_source_reference_unref0 (*source_reference), _tmp10_), _tmp9_), _g_object_unref0 (symbol), _tmp11_);
			afrodite_symbol_add_child (parent, symbol);
		} else {
			if (!replace) {
				AfroditeSourceReference* _tmp12_;
				*source_reference = (_tmp12_ = afrodite_symbol_lookup_source_reference_filename (symbol, afrodite_source_file_get_filename (self->priv->_source_file)), _afrodite_source_reference_unref0 (*source_reference), _tmp12_);
				if ((*source_reference) == NULL) {
					AfroditeSourceReference* _tmp13_;
					*source_reference = (_tmp13_ = afrodite_ast_merger_create_source_reference (self, (ValaCodeNode*) s, 0, 0), _afrodite_source_reference_unref0 (*source_reference), _tmp13_);
					afrodite_symbol_add_source_reference (symbol, *source_reference);
					afrodite_source_file_add_symbol (self->priv->_source_file, symbol);
				} else {
					g_warning ("astmerger.vala:166: two sources with the same name were merged: %s", afrodite_source_file_get_filename (self->priv->_source_file));
				}
			}
		}
	}
	result = symbol;
	_g_object_unref0 (parent);
	return result;
}


static AfroditeSymbol* afrodite_ast_merger_add_symbol (AfroditeAstMerger* self, ValaSymbol* s, AfroditeSourceReference** source_ref, gint last_line, gint last_column) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* symbol;
	AfroditeSourceReference* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	if (source_ref != NULL) {
		*source_ref = NULL;
	}
	symbol = afrodite_symbol_new (self->priv->_vala_symbol_fqn, vala_code_node_get_type_name ((ValaCodeNode*) s));
	if ((_tmp1_ = (_tmp0_ = afrodite_symbol_lookup_source_reference_filename (symbol, afrodite_source_file_get_filename (self->priv->_source_file))) == NULL, _afrodite_source_reference_unref0 (_tmp0_), _tmp1_)) {
		AfroditeSourceReference* _tmp2_;
		*source_ref = (_tmp2_ = afrodite_ast_merger_create_source_reference (self, (ValaCodeNode*) s, last_line, last_column), _afrodite_source_reference_unref0 (*source_ref), _tmp2_);
		afrodite_symbol_add_source_reference (symbol, *source_ref);
	}
	afrodite_symbol_set_access (symbol, afrodite_ast_merger_get_vala_symbol_access (self, vala_symbol_get_access (s)));
	afrodite_source_file_add_symbol (self->priv->_source_file, symbol);
	result = symbol;
	return result;
}


static AfroditeSymbol* afrodite_ast_merger_add_codenode (AfroditeAstMerger* self, const char* type_name, ValaCodeNode* c, AfroditeSourceReference** source_ref, gint last_line, gint last_column) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* symbol;
	AfroditeSourceReference* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	if (source_ref != NULL) {
		*source_ref = NULL;
	}
	symbol = afrodite_symbol_new (self->priv->_vala_symbol_fqn, type_name);
	if ((_tmp1_ = (_tmp0_ = afrodite_symbol_lookup_source_reference_filename (symbol, afrodite_source_file_get_filename (self->priv->_source_file))) == NULL, _afrodite_source_reference_unref0 (_tmp0_), _tmp1_)) {
		AfroditeSourceReference* _tmp2_;
		*source_ref = (_tmp2_ = afrodite_ast_merger_create_source_reference (self, c, last_line, last_column), _afrodite_source_reference_unref0 (*source_ref), _tmp2_);
		afrodite_symbol_add_source_reference (symbol, *source_ref);
	}
	afrodite_symbol_set_access (symbol, AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE);
	afrodite_source_file_add_symbol (self->priv->_source_file, symbol);
	result = symbol;
	return result;
}


static AfroditeSymbolAccessibility afrodite_ast_merger_get_vala_symbol_access (AfroditeAstMerger* self, ValaSymbolAccessibility access) {
	AfroditeSymbolAccessibility result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (access) {
		case VALA_SYMBOL_ACCESSIBILITY_PRIVATE:
		{
			result = AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_INTERNAL:
		{
			result = AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PROTECTED:
		{
			result = AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED;
			return result;
		}
		case VALA_SYMBOL_ACCESSIBILITY_PUBLIC:
		{
			result = AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC;
			return result;
		}
		default:
		{
			g_warning ("astmerger.vala:209: Unknown vala symbol accessibility constant");
			result = AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL;
			return result;
		}
	}
}


static AfroditeMemberBinding afrodite_ast_merger_get_vala_member_binding (AfroditeAstMerger* self, MemberBinding binding) {
	AfroditeMemberBinding result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (binding) {
		case MEMBER_BINDING_INSTANCE:
		{
			result = AFRODITE_MEMBER_BINDING_INSTANCE;
			return result;
		}
		case MEMBER_BINDING_CLASS:
		{
			result = AFRODITE_MEMBER_BINDING_CLASS;
			return result;
		}
		case MEMBER_BINDING_STATIC:
		{
			result = AFRODITE_MEMBER_BINDING_STATIC;
			return result;
		}
		default:
		{
			g_warning ("astmerger.vala:224: Unknown vala member binding constant");
			result = AFRODITE_MEMBER_BINDING_INSTANCE;
			return result;
		}
	}
}


static AfroditeSourceReference* afrodite_ast_merger_create_source_reference (AfroditeAstMerger* self, ValaCodeNode* s, gint last_line, gint last_column) {
	AfroditeSourceReference* result = NULL;
	AfroditeSourceReference* source_ref;
	gint first_line;
	gint first_column;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	source_ref = afrodite_source_reference_new ();
	afrodite_source_reference_set_file (source_ref, self->priv->_source_file);
	first_line = 0;
	first_column = 0;
	if (vala_code_node_get_source_reference (s) != NULL) {
		first_line = vala_source_reference_get_first_line (vala_code_node_get_source_reference (s));
		first_column = vala_source_reference_get_first_column (vala_code_node_get_source_reference (s));
		if (last_line == 0) {
			last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference (s));
		}
		if (last_column == 0) {
			last_column = vala_source_reference_get_last_column (vala_code_node_get_source_reference (s));
		}
	}
	afrodite_source_reference_set_first_line (source_ref, first_line);
	afrodite_source_reference_set_first_column (source_ref, first_column);
	afrodite_source_reference_set_last_line (source_ref, last_line);
	afrodite_source_reference_set_last_column (source_ref, last_column);
	result = source_ref;
	return result;
}


static void afrodite_ast_merger_set_fqn (AfroditeAstMerger* self, const char* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (self->priv->_vala_symbol_fqn == NULL) {
		char* _tmp0_;
		self->priv->_vala_symbol_fqn = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->_vala_symbol_fqn), _tmp0_);
	} else {
		char* _tmp1_;
		self->priv->_vala_symbol_fqn = (_tmp1_ = g_strconcat (self->priv->_vala_symbol_fqn, ".", name, NULL), _g_free0 (self->priv->_vala_symbol_fqn), _tmp1_);
	}
}


gboolean afrodite_ast_merger_is_symbol_defined_current_source (AfroditeAstMerger* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = _vala_strcmp0 (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) sym))), afrodite_source_file_get_filename (self->priv->_source_file)) == 0;
	return result;
}


static gboolean afrodite_ast_merger_is_glib_core_vapis (AfroditeAstMerger* self, ValaNamespace* ns) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ns != NULL, FALSE);
	if (vala_code_node_get_source_reference ((ValaCodeNode*) ns) != NULL) {
		_tmp0_ = vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* filename;
		gboolean _tmp1_ = FALSE;
		filename = g_filename_display_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns))));
		if (g_str_has_prefix (filename, "glib-")) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = g_str_has_prefix (filename, "gobject-");
		}
		result = _tmp1_;
		_g_free0 (filename);
		return result;
	} else {
		g_warning ("astmerger.vala:272: old compatibility check executed for: %s", vala_symbol_get_name ((ValaSymbol*) ns));
		result = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), "GLib") == 0;
		return result;
	}
}


static gpointer _afrodite_source_reference_ref0 (gpointer self) {
	return self ? afrodite_source_reference_ref (self) : NULL;
}


static void afrodite_ast_merger_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (ns != NULL);
	if (self->priv->_merge_glib) {
		_tmp1_ = afrodite_ast_merger_is_glib_core_vapis (self, ns);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !afrodite_ast_merger_is_glib_core_vapis (self, ns);
	}
	if (_tmp0_) {
		char* prev_vala_fqn;
		AfroditeSymbol* prev;
		AfroditeSourceReference* prev_sr;
		gint prev_child_count;
		AfroditeSourceReference* _tmp2_ = NULL;
		AfroditeSymbol* _tmp3_;
		AfroditeSourceReference* _tmp4_;
		AfroditeSymbol* _tmp5_;
		gboolean _tmp6_ = FALSE;
		AfroditeSymbol* _tmp11_;
		AfroditeSourceReference* _tmp12_;
		char* _tmp13_;
		prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
		prev = _g_object_ref0 (self->priv->_current);
		prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
		prev_child_count = self->priv->_child_count;
		self->priv->_current = (_tmp5_ = (_tmp3_ = afrodite_ast_merger_visit_symbol (self, (ValaSymbol*) ns, &_tmp2_, FALSE), self->priv->_current_sr = (_tmp4_ = _tmp2_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_), _tmp3_), _g_object_unref0 (self->priv->_current), _tmp5_);
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) ns)) {
			_tmp6_ = self->priv->_child_count == prev_child_count;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			afrodite_symbol_remove_source_reference (self->priv->_current, self->priv->_current_sr);
			if (!afrodite_symbol_get_has_source_references (self->priv->_current)) {
				AfroditeSymbol* parent;
				AfroditeSymbol* _tmp7_ = NULL;
				AfroditeSymbol* _tmp8_;
				AfroditeSymbol* _tmp9_;
				AfroditeSymbol* _tmp10_;
				parent = NULL;
				_tmp10_ = (_tmp8_ = afrodite_ast_lookup (self->priv->_ast, self->priv->_vala_symbol_fqn, &_tmp7_), parent = (_tmp9_ = _tmp7_, _g_object_unref0 (parent), _tmp9_), _tmp8_);
				_g_object_unref0 (_tmp10_);
				afrodite_symbol_remove_child (parent, self->priv->_current);
				_g_object_unref0 (parent);
			}
		}
		self->priv->_child_count = prev_child_count;
		self->priv->_current = (_tmp11_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp11_);
		self->priv->_current_sr = (_tmp12_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp12_);
		self->priv->_vala_symbol_fqn = (_tmp13_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp13_);
		_afrodite_source_reference_unref0 (prev_sr);
		_g_object_unref0 (prev);
		_g_free0 (prev_vala_fqn);
	}
}


static void afrodite_ast_merger_real_visit_class (ValaCodeVisitor* base, ValaClass* c) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (c != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) c)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	self->priv->_current = (_tmp3_ = (_tmp1_ = afrodite_ast_merger_visit_symbol (self, (ValaSymbol*) c, &_tmp0_, TRUE), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_), _g_object_unref0 (self->priv->_current), _tmp3_);
	self->priv->_current->is_abstract = vala_class_get_is_abstract (c);
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_struct (ValaCodeVisitor* base, ValaStruct* s) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (s != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) s)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	self->priv->_current = (_tmp3_ = (_tmp1_ = afrodite_ast_merger_visit_symbol (self, (ValaSymbol*) s, &_tmp0_, TRUE), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_), _g_object_unref0 (self->priv->_current), _tmp3_);
	vala_code_node_accept_children ((ValaCodeNode*) s, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (iface != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) iface)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	self->priv->_current = (_tmp3_ = (_tmp1_ = afrodite_ast_merger_visit_symbol (self, (ValaSymbol*) iface, &_tmp0_, TRUE), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_), _g_object_unref0 (self->priv->_current), _tmp3_);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* e) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (e != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) e, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* c) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (c != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	gint last_line;
	gboolean _tmp0_ = FALSE;
	AfroditeSourceReference* _tmp1_ = NULL;
	AfroditeSymbol* _tmp2_;
	AfroditeSourceReference* _tmp3_;
	AfroditeSymbol* s;
	char* _tmp4_;
	AfroditeDataType* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSymbol* _tmp7_;
	AfroditeSourceReference* _tmp8_;
	char* _tmp9_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (m != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) m)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) m));
	last_line = 0;
	if (vala_method_get_body (m) != NULL) {
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) vala_method_get_body (m)) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) vala_method_get_body (m)));
	}
	s = (_tmp2_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) m, &_tmp1_, last_line, 0), self->priv->_current_sr = (_tmp3_ = _tmp1_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp3_), _tmp2_);
	afrodite_symbol_set_return_type (s, _tmp5_ = afrodite_data_type_new (_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) vala_method_get_return_type (m)), NULL));
	_afrodite_data_type_unref0 (_tmp5_);
	_g_free0 (_tmp4_);
	s->is_abstract = vala_method_get_is_abstract (m);
	s->is_virtual = vala_method_get_is_virtual (m);
	s->overrides = vala_method_get_overrides (m);
	s->binding = afrodite_ast_merger_get_vala_member_binding (self, vala_method_get_binding (m));
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp6_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp6_);
	afrodite_ast_merger_visit_type_for_generics (self, vala_method_get_return_type (m), afrodite_symbol_get_return_type (s));
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp7_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp7_);
	self->priv->_current_sr = (_tmp8_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp8_);
	self->priv->_vala_symbol_fqn = (_tmp9_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp9_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	gint last_line;
	gboolean _tmp0_ = FALSE;
	AfroditeSourceReference* _tmp1_ = NULL;
	AfroditeSymbol* _tmp2_;
	AfroditeSourceReference* _tmp3_;
	AfroditeSymbol* s;
	AfroditeSymbol* _tmp9_;
	AfroditeSymbol* _tmp10_;
	AfroditeSourceReference* _tmp11_;
	char* _tmp12_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (m != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) m));
	last_line = 0;
	if (vala_method_get_body ((ValaMethod*) m) != NULL) {
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) vala_method_get_body ((ValaMethod*) m)) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) vala_method_get_body ((ValaMethod*) m)));
	}
	s = (_tmp2_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) m, &_tmp1_, last_line, 0), self->priv->_current_sr = (_tmp3_ = _tmp1_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp3_), _tmp2_);
	if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) m), ".new") == 0) {
		char* _tmp4_;
		AfroditeDataType* _tmp5_;
		afrodite_symbol_set_return_type (s, _tmp5_ = afrodite_data_type_new (_tmp4_ = vala_code_node_to_string ((ValaCodeNode*) vala_method_get_return_type ((ValaMethod*) m)), NULL));
		_afrodite_data_type_unref0 (_tmp5_);
		_g_free0 (_tmp4_);
	} else {
		char* _tmp6_;
		AfroditeDataType* _tmp7_;
		afrodite_symbol_set_return_type (s, _tmp7_ = afrodite_data_type_new (_tmp6_ = vala_symbol_get_full_name (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), NULL));
		_afrodite_data_type_unref0 (_tmp7_);
		_g_free0 (_tmp6_);
	}
	s->is_abstract = vala_method_get_is_abstract ((ValaMethod*) m);
	s->is_virtual = vala_method_get_is_virtual ((ValaMethod*) m);
	s->overrides = vala_method_get_overrides ((ValaMethod*) m);
	if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) m), ".new") == 0) {
		afrodite_symbol_set_display_name (s, vala_creation_method_get_class_name (m));
	} else {
		char* _tmp8_;
		afrodite_symbol_set_display_name (s, _tmp8_ = g_strdup_printf ("%s.%s", vala_creation_method_get_class_name (m), vala_symbol_get_name ((ValaSymbol*) m)));
		_g_free0 (_tmp8_);
	}
	s->binding = afrodite_ast_merger_get_vala_member_binding (self, vala_method_get_binding ((ValaMethod*) m));
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp9_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp9_);
	afrodite_ast_merger_visit_type_for_generics (self, vala_method_get_return_type ((ValaMethod*) m), afrodite_symbol_get_return_type (s));
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp10_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp10_);
	self->priv->_current_sr = (_tmp11_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp11_);
	self->priv->_vala_symbol_fqn = (_tmp12_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp12_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* m) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	char* _tmp0_;
	gint last_line;
	gboolean _tmp1_ = FALSE;
	AfroditeSourceReference* _tmp2_ = NULL;
	AfroditeSymbol* _tmp3_;
	AfroditeSourceReference* _tmp4_;
	AfroditeSymbol* s;
	AfroditeDataType* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSymbol* _tmp7_;
	AfroditeSourceReference* _tmp8_;
	char* _tmp9_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (m != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, _tmp0_ = g_strdup_printf ("constructor:%s", afrodite_symbol_get_fully_qualified_name (self->priv->_current)));
	_g_free0 (_tmp0_);
	last_line = 0;
	if (vala_constructor_get_body (m) != NULL) {
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) vala_constructor_get_body (m)) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) vala_constructor_get_body (m)));
	}
	s = (_tmp3_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) m, &_tmp2_, last_line, 0), self->priv->_current_sr = (_tmp4_ = _tmp2_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_), _tmp3_);
	s->binding = afrodite_ast_merger_get_vala_member_binding (self, vala_constructor_get_binding (m));
	afrodite_symbol_set_return_type (s, _tmp5_ = afrodite_data_type_new (afrodite_symbol_get_fully_qualified_name (self->priv->_current), NULL));
	_afrodite_data_type_unref0 (_tmp5_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp6_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp6_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp7_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp7_);
	self->priv->_current_sr = (_tmp8_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp8_);
	self->priv->_vala_symbol_fqn = (_tmp9_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp9_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* m) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	char* _tmp0_;
	gint last_line;
	gboolean _tmp1_ = FALSE;
	AfroditeSourceReference* _tmp2_ = NULL;
	AfroditeSymbol* _tmp3_;
	AfroditeSourceReference* _tmp4_;
	AfroditeSymbol* s;
	char* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSymbol* _tmp7_;
	AfroditeSourceReference* _tmp8_;
	char* _tmp9_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (m != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, _tmp0_ = g_strdup_printf ("destructor:%s", afrodite_symbol_get_fully_qualified_name (self->priv->_current)));
	_g_free0 (_tmp0_);
	last_line = 0;
	if (vala_destructor_get_body (m) != NULL) {
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) vala_destructor_get_body (m)) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) vala_destructor_get_body (m)));
	}
	s = (_tmp3_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) m, &_tmp2_, last_line, 0), self->priv->_current_sr = (_tmp4_ = _tmp2_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_), _tmp3_);
	s->binding = afrodite_ast_merger_get_vala_member_binding (self, vala_destructor_get_binding (m));
	afrodite_symbol_set_display_name (s, _tmp5_ = g_strdup_printf ("~%s", afrodite_symbol_get_name (s)));
	_g_free0 (_tmp5_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp6_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp6_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp7_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp7_);
	self->priv->_current_sr = (_tmp8_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp8_);
	self->priv->_vala_symbol_fqn = (_tmp9_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp9_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* sym;
	AfroditeSymbol* _tmp3_;
	AfroditeSourceReference* _tmp4_;
	char* _tmp5_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (ev != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) ev));
	sym = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) ev, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_set_access (sym, afrodite_symbol_get_access (self->priv->_current));
	sym->binding = self->priv->_current->binding;
	afrodite_symbol_add_child (self->priv->_current, sym);
	self->priv->_current = (_tmp3_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp3_);
	self->priv->_current_sr = (_tmp4_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_);
	self->priv->_vala_symbol_fqn = (_tmp5_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp5_);
	_g_object_unref0 (sym);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_enum (ValaCodeVisitor* base, ValaEnum* e) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (e != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) e)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) e));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) e, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp3_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp3_);
	vala_code_node_accept_children ((ValaCodeNode*) e, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* sym;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (d != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) d)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) d));
	sym = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) d, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_add_child (self->priv->_current, sym);
	self->priv->_current = (_tmp3_ = _g_object_ref0 (sym), _g_object_unref0 (self->priv->_current), _tmp3_);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_g_object_unref0 (sym);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_signal (ValaCodeVisitor* base, ValaSignal* s) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* sym;
	char* _tmp3_;
	AfroditeDataType* _tmp4_;
	AfroditeSymbol* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSourceReference* _tmp7_;
	char* _tmp8_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (s != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) s)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) s));
	sym = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) s, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_set_return_type (sym, _tmp4_ = afrodite_data_type_new (_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) vala_signal_get_return_type (s)), NULL));
	_afrodite_data_type_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	sym->is_virtual = vala_signal_get_is_virtual (s);
	afrodite_symbol_add_child (self->priv->_current, sym);
	self->priv->_current = (_tmp5_ = _g_object_ref0 (sym), _g_object_unref0 (self->priv->_current), _tmp5_);
	vala_code_node_accept_children ((ValaCodeNode*) s, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp6_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp6_);
	self->priv->_current_sr = (_tmp7_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp7_);
	self->priv->_vala_symbol_fqn = (_tmp8_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp8_);
	_g_object_unref0 (sym);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	char* _tmp3_;
	AfroditeDataType* _tmp4_;
	AfroditeSymbol* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSourceReference* _tmp7_;
	char* _tmp8_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (f != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) f)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) f));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) f, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_set_return_type (s, _tmp4_ = afrodite_data_type_new (_tmp3_ = afrodite_ast_merger_get_datatype_typename (self, vala_variable_get_variable_type ((ValaVariable*) f)), NULL));
	_afrodite_data_type_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	s->binding = afrodite_ast_merger_get_vala_member_binding (self, vala_field_get_binding (f));
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp5_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp5_);
	afrodite_ast_merger_visit_type_for_generics (self, vala_variable_get_variable_type ((ValaVariable*) f), afrodite_symbol_get_return_type (s));
	self->priv->_current = (_tmp6_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp6_);
	self->priv->_current_sr = (_tmp7_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp7_);
	self->priv->_vala_symbol_fqn = (_tmp8_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp8_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	char* _tmp3_;
	AfroditeDataType* _tmp4_;
	AfroditeSymbol* _tmp5_;
	AfroditeSourceReference* _tmp6_;
	char* _tmp7_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (c != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) c)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) c));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) c, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	s->binding = AFRODITE_MEMBER_BINDING_STATIC;
	afrodite_symbol_set_return_type (s, _tmp4_ = afrodite_data_type_new (_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) vala_constant_get_type_reference (c)), NULL));
	_afrodite_data_type_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp5_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp5_);
	self->priv->_current_sr = (_tmp6_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp6_);
	self->priv->_vala_symbol_fqn = (_tmp7_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp7_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_property (ValaCodeVisitor* base, ValaProperty* p) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	char* _tmp3_;
	AfroditeDataType* _tmp4_;
	AfroditeSymbol* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSourceReference* _tmp7_;
	char* _tmp8_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (p != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) p)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) p));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) p, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_set_return_type (s, _tmp4_ = afrodite_data_type_new (_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) vala_property_get_property_type (p)), NULL));
	_afrodite_data_type_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp5_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp5_);
	afrodite_ast_merger_visit_type_for_generics (self, vala_property_get_property_type (p), afrodite_symbol_get_return_type (s));
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp6_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp6_);
	self->priv->_current_sr = (_tmp7_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp7_);
	self->priv->_vala_symbol_fqn = (_tmp8_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp8_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* a) {
	AfroditeAstMerger * self;
	const char* _tmp0_;
	AfroditeSymbol* _tmp1_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = NULL;
	if (vala_property_accessor_get_readable (a)) {
		_tmp0_ = "get";
	} else {
		_tmp0_ = "set";
	}
	_tmp1_ = afrodite_ast_merger_visit_scoped_codenode (self, _tmp0_, (ValaCodeNode*) a, vala_property_accessor_get_body (a));
	_g_object_unref0 (_tmp1_);
}


static void afrodite_ast_merger_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	AfroditeSymbol* _tmp3_;
	AfroditeSymbol* _tmp4_;
	AfroditeSourceReference* _tmp5_;
	char* _tmp6_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (ed != NULL);
	if (!afrodite_ast_merger_is_symbol_defined_current_source (self, (ValaSymbol*) ed)) {
		return;
	}
	self->priv->_child_count++;
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) ed));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) ed, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp3_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp3_);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
	self->priv->_current = (_tmp4_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp4_);
	self->priv->_current_sr = (_tmp5_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp5_);
	self->priv->_vala_symbol_fqn = (_tmp6_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp6_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	AfroditeSourceReference* _tmp0_ = NULL;
	AfroditeSymbol* _tmp1_;
	AfroditeSourceReference* _tmp2_;
	AfroditeSymbol* s;
	AfroditeSymbol* _tmp3_;
	AfroditeSourceReference* _tmp4_;
	char* _tmp5_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (ecode != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) ecode));
	s = (_tmp1_ = afrodite_ast_merger_add_symbol (self, (ValaSymbol*) ecode, &_tmp0_, 0, 0), self->priv->_current_sr = (_tmp2_ = _tmp0_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp2_), _tmp1_);
	afrodite_symbol_set_access (s, afrodite_symbol_get_access (self->priv->_current));
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp3_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp3_);
	self->priv->_current_sr = (_tmp4_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_);
	self->priv->_vala_symbol_fqn = (_tmp5_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp5_);
	_g_object_unref0 (s);
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static char* afrodite_ast_merger_expression_to_string (AfroditeAstMerger* self, ValaExpression* e) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	if (VALA_IS_LITERAL (e)) {
		result = vala_code_node_to_string ((ValaCodeNode*) e);
		return result;
	} else {
		if (VALA_IS_MEMBER_ACCESS (e)) {
			ValaMemberAccess* ma;
			ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (e));
			result = g_strdup_printf ("%s", vala_member_access_get_member_name (ma));
			_vala_code_node_unref0 (ma);
			return result;
		} else {
			if (VALA_IS_BINARY_EXPRESSION (e)) {
				ValaBinaryExpression* be;
				char* _tmp0_;
				char* _tmp1_;
				char* _tmp2_;
				char* _tmp3_;
				be = _vala_code_node_ref0 (VALA_BINARY_EXPRESSION (e));
				result = (_tmp3_ = g_strdup_printf ("%s %s %s", _tmp0_ = afrodite_ast_merger_expression_to_string (self, vala_binary_expression_get_left (be)), _tmp1_ = afrodite_utils_binary_operator_to_string (vala_binary_expression_get_operator (be)), _tmp2_ = afrodite_ast_merger_expression_to_string (self, vala_binary_expression_get_right (be))), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
				_vala_code_node_unref0 (be);
				return result;
				_vala_code_node_unref0 (be);
			} else {
				if (VALA_IS_UNARY_EXPRESSION (e)) {
					ValaUnaryExpression* ue;
					char* _tmp4_;
					char* _tmp5_;
					char* _tmp6_;
					ue = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (e));
					result = (_tmp6_ = g_strdup_printf ("%s%s", _tmp4_ = afrodite_utils_unary_operator_to_string (vala_unary_expression_get_operator (ue)), _tmp5_ = afrodite_ast_merger_expression_to_string (self, vala_unary_expression_get_inner (ue))), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
					_vala_code_node_unref0 (ue);
					return result;
					_vala_code_node_unref0 (ue);
				} else {
					afrodite_utils_trace ("astmerger.vala:709: expression_to_string, unknown expression type: %s", vala_code_node_get_type_name ((ValaCodeNode*) e));
					result = NULL;
					return result;
				}
			}
		}
	}
}


static gpointer _afrodite_data_type_ref0 (gpointer self) {
	return self ? afrodite_data_type_ref (self) : NULL;
}


static void afrodite_ast_merger_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	AfroditeAstMerger * self;
	AfroditeDataType* d;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (p != NULL);
	d = NULL;
	if (vala_formal_parameter_get_ellipsis (p)) {
		AfroditeDataType* _tmp0_;
		d = (_tmp0_ = _afrodite_data_type_ref0 ((AfroditeDataType*) afrodite_symbol_ELLIPSIS), _afrodite_data_type_unref0 (d), _tmp0_);
	} else {
		char* _tmp1_;
		AfroditeDataType* _tmp2_;
		d = (_tmp2_ = afrodite_data_type_new (_tmp1_ = afrodite_ast_merger_get_datatype_typename (self, vala_variable_get_variable_type ((ValaVariable*) p)), vala_symbol_get_name ((ValaSymbol*) p)), _afrodite_data_type_unref0 (d), _tmp2_);
		_g_free0 (_tmp1_);
		if (vala_variable_get_initializer ((ValaVariable*) p) != NULL) {
			char* _tmp3_;
			afrodite_data_type_set_default_expression (d, _tmp3_ = afrodite_ast_merger_expression_to_string (self, vala_variable_get_initializer ((ValaVariable*) p)));
			_g_free0 (_tmp3_);
		}
		switch (vala_formal_parameter_get_direction (p)) {
			case VALA_PARAMETER_DIRECTION_OUT:
			{
				afrodite_data_type_set_is_out (d, TRUE);
				break;
			}
			case VALA_PARAMETER_DIRECTION_REF:
			{
				afrodite_data_type_set_is_ref (d, TRUE);
				break;
			}
		}
	}
	afrodite_symbol_add_parameter (self->priv->_current, d);
	_afrodite_data_type_unref0 (d);
}


static void afrodite_ast_merger_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (b != NULL);
	if (self->priv->_current != NULL) {
		_tmp0_ = self->priv->_current_sr != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (vala_code_node_get_source_reference ((ValaCodeNode*) b) != NULL) {
			_tmp1_ = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) b)) > afrodite_source_reference_get_last_line (self->priv->_current_sr);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			afrodite_source_reference_set_last_line (self->priv->_current_sr, vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) b)));
		}
	}
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	AfroditeAstMerger * self;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeDataType* s;
	AfroditeSourceReference* _tmp8_;
	AfroditeSymbol* _tmp9_;
	char* _tmp10_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (local != NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	afrodite_ast_merger_set_fqn (self, vala_symbol_get_name ((ValaSymbol*) local));
	s = afrodite_data_type_new ("", vala_symbol_get_name ((ValaSymbol*) local));
	if (vala_variable_get_variable_type ((ValaVariable*) local) != NULL) {
		char* _tmp0_;
		afrodite_data_type_set_type_name (s, _tmp0_ = afrodite_ast_merger_get_datatype_typename (self, vala_variable_get_variable_type ((ValaVariable*) local)));
		_g_free0 (_tmp0_);
	} else {
		gboolean _tmp1_ = FALSE;
		if (vala_variable_get_variable_type ((ValaVariable*) local) == NULL) {
			_tmp1_ = vala_variable_get_initializer ((ValaVariable*) local) != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			AfroditeDataType* prev_inferred_type;
			AfroditeDataType* _tmp2_;
			ValaLiteral* _tmp5_;
			AfroditeDataType* _tmp6_;
			gboolean _tmp7_ = FALSE;
			prev_inferred_type = _afrodite_data_type_ref0 (self->priv->_inferred_type);
			self->priv->_inferred_type = (_tmp2_ = _afrodite_data_type_ref0 (s), _afrodite_data_type_unref0 (self->priv->_inferred_type), _tmp2_);
			if (VALA_IS_OBJECT_CREATION_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local))) {
				ValaObjectCreationExpression* obj_initializer;
				obj_initializer = _vala_code_node_ref0 (VALA_OBJECT_CREATION_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local)));
				vala_code_node_accept ((ValaCodeNode*) vala_object_creation_expression_get_member_name (obj_initializer), (ValaCodeVisitor*) self);
				_vala_code_node_unref0 (obj_initializer);
			} else {
				if (VALA_IS_METHOD_CALL (vala_variable_get_initializer ((ValaVariable*) local))) {
					vala_code_node_accept ((ValaCodeNode*) vala_method_call_get_call (VALA_METHOD_CALL (vala_variable_get_initializer ((ValaVariable*) local))), (ValaCodeVisitor*) self);
				} else {
					if (VALA_IS_BINARY_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local))) {
						vala_code_node_accept_children ((ValaCodeNode*) VALA_BINARY_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local)), (ValaCodeVisitor*) self);
					} else {
						if (VALA_IS_CAST_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local))) {
							ValaCastExpression* cast_expr;
							cast_expr = _vala_code_node_ref0 (VALA_CAST_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local)));
							vala_code_node_accept ((ValaCodeNode*) cast_expr, (ValaCodeVisitor*) self);
							if (vala_cast_expression_get_type_reference (cast_expr) != NULL) {
								char* _tmp3_;
								afrodite_data_type_set_type_name (s, _tmp3_ = afrodite_ast_merger_get_datatype_typename (self, vala_cast_expression_get_type_reference (cast_expr)));
								_g_free0 (_tmp3_);
							}
							_vala_code_node_unref0 (cast_expr);
						} else {
							if (VALA_IS_ARRAY_CREATION_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local))) {
								ValaArrayCreationExpression* ac;
								char* _tmp4_;
								ac = _vala_code_node_ref0 (VALA_ARRAY_CREATION_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) local)));
								vala_code_node_accept_children ((ValaCodeNode*) ac, (ValaCodeVisitor*) self);
								afrodite_data_type_set_is_array (s, TRUE);
								afrodite_data_type_set_type_name (s, _tmp4_ = afrodite_ast_merger_get_datatype_typename (self, vala_array_creation_expression_get_element_type (ac)));
								_g_free0 (_tmp4_);
								_vala_code_node_unref0 (ac);
							} else {
								vala_code_node_accept_children ((ValaCodeNode*) local, (ValaCodeVisitor*) self);
							}
						}
					}
				}
			}
			self->priv->_last_literal = (_tmp5_ = NULL, _vala_code_node_unref0 (self->priv->_last_literal), _tmp5_);
			self->priv->_inferred_type = (_tmp6_ = _afrodite_data_type_ref0 (prev_inferred_type), _afrodite_data_type_unref0 (self->priv->_inferred_type), _tmp6_);
			if (afrodite_data_type_get_type_name (s) != NULL) {
				_tmp7_ = g_str_has_suffix (afrodite_data_type_get_type_name (s), "Literal");
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				if (_vala_strcmp0 (afrodite_data_type_get_type_name (s), "ValaIntegerLiteral") == 0) {
					afrodite_data_type_set_type_name (s, "int");
				} else {
					if (_vala_strcmp0 (afrodite_data_type_get_type_name (s), "ValaBooleanLiteral") == 0) {
						afrodite_data_type_set_type_name (s, "bool");
					} else {
						if (_vala_strcmp0 (afrodite_data_type_get_type_name (s), "ValaCharacterLiteral") == 0) {
							afrodite_data_type_set_type_name (s, "char");
						} else {
							if (_vala_strcmp0 (afrodite_data_type_get_type_name (s), "ValaStringLiteral") == 0) {
								afrodite_data_type_set_type_name (s, "string");
							} else {
								if (_vala_strcmp0 (afrodite_data_type_get_type_name (s), "ValaRealLiteral") == 0) {
									afrodite_data_type_set_type_name (s, "double");
								}
							}
						}
					}
				}
			}
			_afrodite_data_type_unref0 (prev_inferred_type);
		}
	}
	afrodite_data_type_set_source_reference (s, _tmp8_ = afrodite_ast_merger_create_source_reference (self, (ValaCodeNode*) local, 0, 0));
	_afrodite_source_reference_unref0 (_tmp8_);
	if (afrodite_symbol_get_has_local_variables (self->priv->_current)) {
		AfroditeDataType* old_var;
		old_var = afrodite_symbol_lookup_local_variable (self->priv->_current, afrodite_data_type_get_name (s));
		if (old_var != NULL) {
			afrodite_symbol_remove_local_variable (self->priv->_current, old_var);
		}
		_afrodite_data_type_unref0 (old_var);
	}
	afrodite_symbol_add_local_variable (self->priv->_current, s);
	if (vala_variable_get_variable_type ((ValaVariable*) local) != NULL) {
		afrodite_ast_merger_visit_type_for_generics (self, vala_variable_get_variable_type ((ValaVariable*) local), s);
	}
	self->priv->_current = (_tmp9_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp9_);
	self->priv->_vala_symbol_fqn = (_tmp10_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp10_);
	_afrodite_data_type_unref0 (s);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
}


static void afrodite_ast_merger_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "lambda-section", (ValaCodeNode*) expr, NULL);
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (expr != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		afrodite_data_type_set_type_name (self->priv->_inferred_type, vala_member_access_get_member_name (expr));
	} else {
		char* member_name;
		char* _tmp3_;
		member_name = NULL;
		if (self->priv->_current != NULL) {
			AfroditeDataType* d;
			d = afrodite_symbol_scope_lookup_datatype_for_variable (self->priv->_current, AFRODITE_COMPARE_MODE_EXACT, vala_member_access_get_member_name (expr));
			if (d != NULL) {
				char* _tmp1_;
				member_name = (_tmp1_ = g_strdup (afrodite_data_type_get_type_name (d)), _g_free0 (member_name), _tmp1_);
			}
			_afrodite_data_type_unref0 (d);
		}
		if (member_name == NULL) {
			char* _tmp2_;
			member_name = (_tmp2_ = g_strdup (vala_member_access_get_member_name (expr)), _g_free0 (member_name), _tmp2_);
		}
		afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp3_ = g_strdup_printf ("%s.%s", member_name, afrodite_data_type_get_type_name (self->priv->_inferred_type)));
		_g_free0 (_tmp3_);
		_g_free0 (member_name);
	}
}


static void afrodite_ast_merger_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (expr != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) vala_object_creation_expression_get_member_name (expr), (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (list != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) list, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* lit) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (lit != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		afrodite_data_type_set_type_name (self->priv->_inferred_type, "bool");
	} else {
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "bool") != 0) {
			char* _tmp1_;
			afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp1_ = g_strdup_printf ("%s.%s", "bool", afrodite_data_type_get_type_name (self->priv->_inferred_type)));
			_g_free0 (_tmp1_);
		}
	}
}


static void afrodite_ast_merger_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* lit) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (lit != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		afrodite_data_type_set_type_name (self->priv->_inferred_type, "char");
	} else {
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "char") != 0) {
			char* _tmp1_;
			afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp1_ = g_strdup_printf ("%s.%s", "char", afrodite_data_type_get_type_name (self->priv->_inferred_type)));
			_g_free0 (_tmp1_);
		}
	}
}


static void afrodite_ast_merger_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* lit) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (lit != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		afrodite_data_type_set_type_name (self->priv->_inferred_type, vala_code_node_get_type_name ((ValaCodeNode*) lit));
	} else {
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), vala_code_node_get_type_name ((ValaCodeNode*) lit)) != 0) {
			char* _tmp1_;
			afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp1_ = g_strdup_printf ("%s.%s", vala_code_node_get_type_name ((ValaCodeNode*) lit), afrodite_data_type_get_type_name (self->priv->_inferred_type)));
			_g_free0 (_tmp1_);
		}
	}
}


static void afrodite_ast_merger_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* lit) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (lit != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		char* _tmp1_;
		afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp1_ = vala_real_literal_get_type_name (lit));
		_g_free0 (_tmp1_);
	} else {
		char* _tmp2_;
		gboolean _tmp3_;
		if ((_tmp3_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), _tmp2_ = vala_real_literal_get_type_name (lit)) != 0, _g_free0 (_tmp2_), _tmp3_)) {
			char* _tmp4_;
			char* _tmp5_;
			afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp5_ = g_strdup_printf ("%s.%s", _tmp4_ = vala_real_literal_get_type_name (lit), afrodite_data_type_get_type_name (self->priv->_inferred_type)));
			_g_free0 (_tmp5_);
			_g_free0 (_tmp4_);
		}
	}
}


static void afrodite_ast_merger_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* lit) {
	AfroditeAstMerger * self;
	gboolean _tmp0_ = FALSE;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (lit != NULL);
	if (self->priv->_inferred_type == NULL) {
		return;
	}
	if (afrodite_data_type_get_type_name (self->priv->_inferred_type) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "") == 0;
	}
	if (_tmp0_) {
		afrodite_data_type_set_type_name (self->priv->_inferred_type, "string");
	} else {
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (self->priv->_inferred_type), "string") != 0) {
			char* _tmp1_;
			afrodite_data_type_set_type_name (self->priv->_inferred_type, _tmp1_ = g_strdup_printf ("%s.%s", "string", afrodite_data_type_get_type_name (self->priv->_inferred_type)));
			_g_free0 (_tmp1_);
		}
	}
}


static void afrodite_ast_merger_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	AfroditeAstMerger * self;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void afrodite_ast_merger_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* s;
	AfroditeDataType* d;
	AfroditeSourceReference* _tmp3_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	s = afrodite_ast_merger_visit_scoped_codenode (self, "foreach", (ValaCodeNode*) stmt, vala_foreach_statement_get_body (stmt));
	d = afrodite_data_type_new ("", vala_foreach_statement_get_variable_name (stmt));
	if (vala_foreach_statement_get_type_reference (stmt) == NULL) {
		AfroditeDataType* prev_inferred_type;
		AfroditeDataType* _tmp0_;
		AfroditeDataType* _tmp1_;
		prev_inferred_type = _afrodite_data_type_ref0 (self->priv->_inferred_type);
		self->priv->_inferred_type = (_tmp0_ = _afrodite_data_type_ref0 (d), _afrodite_data_type_unref0 (self->priv->_inferred_type), _tmp0_);
		vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
		self->priv->_inferred_type = (_tmp1_ = _afrodite_data_type_ref0 (prev_inferred_type), _afrodite_data_type_unref0 (self->priv->_inferred_type), _tmp1_);
		_afrodite_data_type_unref0 (prev_inferred_type);
	} else {
		char* _tmp2_;
		afrodite_data_type_set_type_name (d, _tmp2_ = afrodite_ast_merger_get_datatype_typename (self, vala_foreach_statement_get_type_reference (stmt)));
		_g_free0 (_tmp2_);
	}
	afrodite_data_type_set_is_iterator (d, TRUE);
	afrodite_data_type_set_source_reference (d, _tmp3_ = afrodite_ast_merger_create_source_reference (self, (ValaCodeNode*) stmt, 0, 0));
	_afrodite_source_reference_unref0 (_tmp3_);
	afrodite_symbol_add_local_variable (s, d);
	_afrodite_data_type_unref0 (d);
	_g_object_unref0 (s);
}


static void afrodite_ast_merger_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "while", (ValaCodeNode*) stmt, vala_while_statement_get_body (stmt));
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "do", (ValaCodeNode*) stmt, vala_do_statement_get_body (stmt));
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "for", (ValaCodeNode*) stmt, vala_for_statement_get_body (stmt));
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "try", (ValaCodeNode*) stmt, vala_try_statement_get_body (stmt));
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	AfroditeAstMerger * self;
	AfroditeSymbol* s;
	char* _tmp0_;
	AfroditeDataType* _tmp1_;
	AfroditeDataType* d;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (clause != NULL);
	s = afrodite_ast_merger_visit_scoped_codenode (self, "catch", (ValaCodeNode*) clause, vala_catch_clause_get_body (clause));
	d = (_tmp1_ = afrodite_data_type_new (_tmp0_ = afrodite_ast_merger_get_datatype_typename (self, vala_catch_clause_get_error_type (clause)), vala_catch_clause_get_variable_name (clause)), _g_free0 (_tmp0_), _tmp1_);
	afrodite_symbol_add_local_variable (s, d);
	_afrodite_data_type_unref0 (d);
	_g_object_unref0 (s);
}


static void afrodite_ast_merger_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "if", (ValaCodeNode*) stmt, vala_if_statement_get_true_statement (stmt));
	_g_object_unref0 (_tmp0_);
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		AfroditeSymbol* _tmp1_;
		_tmp1_ = afrodite_ast_merger_visit_scoped_codenode (self, "else", (ValaCodeNode*) stmt, vala_if_statement_get_false_statement (stmt));
		_g_object_unref0 (_tmp1_);
	}
}


static void afrodite_ast_merger_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "switch", (ValaCodeNode*) stmt, NULL);
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	AfroditeAstMerger * self;
	AfroditeSymbol* _tmp0_;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (section != NULL);
	_tmp0_ = afrodite_ast_merger_visit_scoped_codenode (self, "switch-section", (ValaCodeNode*) section, (ValaBlock*) section);
	_g_object_unref0 (_tmp0_);
}


static void afrodite_ast_merger_real_visit_type_parameter (ValaCodeVisitor* base, ValaTypeParameter* p) {
	AfroditeAstMerger * self;
	AfroditeSymbol* symbol;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (p != NULL);
	symbol = afrodite_symbol_new (vala_symbol_get_name ((ValaSymbol*) p), vala_code_node_get_type_name ((ValaCodeNode*) p));
	afrodite_symbol_set_access (symbol, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	afrodite_symbol_add_generic_type_argument (self->priv->_current, symbol);
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) self);
	_g_object_unref0 (symbol);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void afrodite_ast_merger_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* type) {
	AfroditeAstMerger * self;
	char* _tmp0_;
	AfroditeDataType* _tmp1_;
	AfroditeDataType* t;
	self = (AfroditeAstMerger*) base;
	g_return_if_fail (type != NULL);
	t = (_tmp1_ = afrodite_data_type_new (_tmp0_ = afrodite_ast_merger_get_datatype_typename (self, type), NULL), _g_free0 (_tmp0_), _tmp1_);
	if (self->priv->_current_type != NULL) {
		afrodite_data_type_add_generic_type (self->priv->_current_type, t);
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->_current != NULL) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (self->priv->_current), "Class") == 0) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = _vala_strcmp0 (afrodite_symbol_get_type_name (self->priv->_current), "Interface") == 0;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = _vala_strcmp0 (afrodite_symbol_get_type_name (self->priv->_current), "Struct") == 0;
			}
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp5_ = FALSE;
			if (string_get_length (afrodite_data_type_get_type_name (t)) == 1) {
				char* _tmp6_;
				_tmp5_ = _vala_strcmp0 (_tmp6_ = g_utf8_strup (afrodite_data_type_get_type_name (t), -1), afrodite_data_type_get_type_name (t)) == 0;
				_g_free0 (_tmp6_);
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				char* _tmp7_;
				_tmp7_ = NULL;
				if (vala_data_type_get_type_parameter (type) != NULL) {
					char* _tmp8_;
					_tmp7_ = (_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) vala_data_type_get_type_parameter (type)), _g_free0 (_tmp7_), _tmp8_);
				} else {
					char* _tmp9_;
					_tmp7_ = (_tmp9_ = g_strdup ("type parameter is null"), _g_free0 (_tmp7_), _tmp9_);
				}
				afrodite_utils_trace ("astmerger.vala:1042: You should fix this hack: %s - %s: '%s' to '%s'", vala_code_node_get_type_name ((ValaCodeNode*) type), _tmp7_, afrodite_data_type_get_type_name (t), afrodite_symbol_get_fully_qualified_name (self->priv->_current));
				_g_free0 (_tmp7_);
			} else {
				afrodite_symbol_add_base_type (self->priv->_current, t);
				afrodite_ast_merger_visit_type_for_generics (self, type, t);
			}
		}
	}
	_afrodite_data_type_unref0 (t);
}


static void afrodite_ast_merger_visit_type_for_generics (AfroditeAstMerger* self, ValaDataType* t, AfroditeDataType* ct) {
	AfroditeDataType* prev_type;
	AfroditeDataType* _tmp0_;
	AfroditeDataType* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	g_return_if_fail (ct != NULL);
	prev_type = _afrodite_data_type_ref0 (self->priv->_current_type);
	self->priv->_current_type = (_tmp0_ = _afrodite_data_type_ref0 (ct), _afrodite_data_type_unref0 (self->priv->_current_type), _tmp0_);
	{
		ValaList* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _type_it;
		_type_it = (_tmp2_ = vala_iterable_iterator ((ValaIterable*) (_tmp1_ = vala_data_type_get_type_arguments (t))), _vala_collection_object_unref0 (_tmp1_), _tmp2_);
		while (TRUE) {
			ValaDataType* type;
			if (!vala_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) vala_iterator_get (_type_it);
			vala_code_node_accept ((ValaCodeNode*) type, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (type);
		}
		_vala_collection_object_unref0 (_type_it);
	}
	self->priv->_current_type = (_tmp3_ = _afrodite_data_type_ref0 (prev_type), _afrodite_data_type_unref0 (self->priv->_current_type), _tmp3_);
	_afrodite_data_type_unref0 (prev_type);
}


static AfroditeSymbol* afrodite_ast_merger_visit_scoped_codenode (AfroditeAstMerger* self, const char* name, ValaCodeNode* node, ValaBlock* body) {
	AfroditeSymbol* result = NULL;
	char* prev_vala_fqn;
	AfroditeSymbol* prev;
	AfroditeSourceReference* prev_sr;
	char* _tmp0_;
	gint last_line;
	gboolean _tmp1_ = FALSE;
	AfroditeSourceReference* _tmp2_ = NULL;
	AfroditeSymbol* _tmp3_;
	AfroditeSourceReference* _tmp4_;
	AfroditeSymbol* s;
	AfroditeSymbol* _tmp5_;
	AfroditeSymbol* _tmp6_;
	AfroditeSourceReference* _tmp7_;
	char* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	prev_vala_fqn = g_strdup (self->priv->_vala_symbol_fqn);
	prev = _g_object_ref0 (self->priv->_current);
	prev_sr = _afrodite_source_reference_ref0 (self->priv->_current_sr);
	afrodite_ast_merger_set_fqn (self, _tmp0_ = g_strdup_printf ("!%s", name));
	_g_free0 (_tmp0_);
	last_line = 0;
	if (body != NULL) {
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) body) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		last_line = vala_source_reference_get_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) body));
	}
	s = (_tmp3_ = afrodite_ast_merger_add_codenode (self, "Block", node, &_tmp2_, last_line, 0), self->priv->_current_sr = (_tmp4_ = _tmp2_, _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp4_), _tmp3_);
	afrodite_symbol_set_display_name (s, name);
	afrodite_symbol_add_child (self->priv->_current, s);
	self->priv->_current = (_tmp5_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->_current), _tmp5_);
	if (body == NULL) {
		vala_code_node_accept_children (node, (ValaCodeVisitor*) self);
	} else {
		vala_code_node_accept_children ((ValaCodeNode*) body, (ValaCodeVisitor*) self);
	}
	self->priv->_current = (_tmp6_ = _g_object_ref0 (prev), _g_object_unref0 (self->priv->_current), _tmp6_);
	self->priv->_current_sr = (_tmp7_ = _afrodite_source_reference_ref0 (prev_sr), _afrodite_source_reference_unref0 (self->priv->_current_sr), _tmp7_);
	self->priv->_vala_symbol_fqn = (_tmp8_ = g_strdup (prev_vala_fqn), _g_free0 (self->priv->_vala_symbol_fqn), _tmp8_);
	result = s;
	_afrodite_source_reference_unref0 (prev_sr);
	_g_object_unref0 (prev);
	_g_free0 (prev_vala_fqn);
	return result;
}


static char* afrodite_ast_merger_get_datatype_typename (AfroditeAstMerger* self, ValaDataType* type) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (VALA_IS_UNRESOLVED_TYPE (type)) {
		result = vala_code_node_to_string ((ValaCodeNode*) vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (type)));
		return result;
	} else {
		if (type == NULL) {
			result = g_strdup_printf ("DataType is null: %s", self->priv->_vala_symbol_fqn);
			return result;
		} else {
			result = vala_code_node_to_string ((ValaCodeNode*) type);
			return result;
		}
	}
}


static void afrodite_ast_merger_class_init (AfroditeAstMergerClass * klass) {
	afrodite_ast_merger_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = afrodite_ast_merger_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeAstMergerPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = afrodite_ast_merger_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = afrodite_ast_merger_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = afrodite_ast_merger_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = afrodite_ast_merger_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = afrodite_ast_merger_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = afrodite_ast_merger_real_visit_method_call;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = afrodite_ast_merger_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = afrodite_ast_merger_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = afrodite_ast_merger_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = afrodite_ast_merger_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = afrodite_ast_merger_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = afrodite_ast_merger_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = afrodite_ast_merger_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = afrodite_ast_merger_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = afrodite_ast_merger_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = afrodite_ast_merger_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = afrodite_ast_merger_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = afrodite_ast_merger_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = afrodite_ast_merger_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = afrodite_ast_merger_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = afrodite_ast_merger_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = afrodite_ast_merger_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = afrodite_ast_merger_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = afrodite_ast_merger_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = afrodite_ast_merger_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = afrodite_ast_merger_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression = afrodite_ast_merger_real_visit_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = afrodite_ast_merger_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = afrodite_ast_merger_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = afrodite_ast_merger_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = afrodite_ast_merger_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = afrodite_ast_merger_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = afrodite_ast_merger_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = afrodite_ast_merger_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = afrodite_ast_merger_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = afrodite_ast_merger_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = afrodite_ast_merger_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = afrodite_ast_merger_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = afrodite_ast_merger_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = afrodite_ast_merger_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = afrodite_ast_merger_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = afrodite_ast_merger_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = afrodite_ast_merger_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = afrodite_ast_merger_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_parameter = afrodite_ast_merger_real_visit_type_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_data_type = afrodite_ast_merger_real_visit_data_type;
}


static void afrodite_ast_merger_instance_init (AfroditeAstMerger * self) {
	self->priv = AFRODITE_AST_MERGER_GET_PRIVATE (self);
	self->priv->_current = NULL;
	self->priv->_current_type = NULL;
	self->priv->_current_sr = NULL;
	self->priv->_source_file = NULL;
	self->priv->_inferred_type = NULL;
	self->priv->_last_literal = NULL;
	self->priv->_vala_symbol_fqn = NULL;
	self->priv->_merge_glib = TRUE;
	self->priv->_child_count = 0;
	self->priv->_ast = NULL;
}


static void afrodite_ast_merger_finalize (ValaCodeVisitor* obj) {
	AfroditeAstMerger * self;
	self = AFRODITE_AST_MERGER (obj);
	_g_object_unref0 (self->priv->_current);
	_afrodite_data_type_unref0 (self->priv->_current_type);
	_afrodite_source_reference_unref0 (self->priv->_current_sr);
	_afrodite_source_file_unref0 (self->priv->_source_file);
	_afrodite_data_type_unref0 (self->priv->_inferred_type);
	_vala_code_node_unref0 (self->priv->_last_literal);
	_g_free0 (self->priv->_vala_symbol_fqn);
	_afrodite_ast_unref0 (self->priv->_ast);
	VALA_CODE_VISITOR_CLASS (afrodite_ast_merger_parent_class)->finalize (obj);
}


GType afrodite_ast_merger_get_type (void) {
	static volatile gsize afrodite_ast_merger_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_ast_merger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeAstMergerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_ast_merger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeAstMerger), 0, (GInstanceInitFunc) afrodite_ast_merger_instance_init, NULL };
		GType afrodite_ast_merger_type_id;
		afrodite_ast_merger_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "AfroditeAstMerger", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_ast_merger_type_id__volatile, afrodite_ast_merger_type_id);
	}
	return afrodite_ast_merger_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




