/* astdumper.c generated by valac 0.10.0, the Vala compiler
 * generated from astdumper.vala, do not modify */

/* contextdump.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define AFRODITE_TYPE_AST_DUMPER (afrodite_ast_dumper_get_type ())
#define AFRODITE_AST_DUMPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST_DUMPER, AfroditeAstDumper))
#define AFRODITE_AST_DUMPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST_DUMPER, AfroditeAstDumperClass))
#define AFRODITE_IS_AST_DUMPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST_DUMPER))
#define AFRODITE_IS_AST_DUMPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST_DUMPER))
#define AFRODITE_AST_DUMPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST_DUMPER, AfroditeAstDumperClass))

typedef struct _AfroditeAstDumper AfroditeAstDumper;
typedef struct _AfroditeAstDumperClass AfroditeAstDumperClass;
typedef struct _AfroditeAstDumperPrivate AfroditeAstDumperPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AfroditeAstDumper {
	ValaCodeVisitor parent_instance;
	AfroditeAstDumperPrivate * priv;
};

struct _AfroditeAstDumperClass {
	ValaCodeVisitorClass parent_class;
};

struct _AfroditeAstDumperPrivate {
	char* pad;
	gint level;
	gint symbols;
	gint unresolved_types;
	gint types;
};


static gpointer afrodite_ast_dumper_parent_class = NULL;

GType afrodite_ast_dumper_get_type (void) G_GNUC_CONST;
#define AFRODITE_AST_DUMPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_AST_DUMPER, AfroditeAstDumperPrivate))
enum  {
	AFRODITE_AST_DUMPER_DUMMY_PROPERTY
};
static void afrodite_ast_dumper_inc_pad (AfroditeAstDumper* self);
static void afrodite_ast_dumper_dec_pad (AfroditeAstDumper* self);
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
static void afrodite_ast_dumper_print_symbol (AfroditeAstDumper* self, AfroditeSymbol* s);
char* afrodite_ast_dumper_create_symbol_dump_info (AfroditeAstDumper* self, AfroditeSymbol* s, gboolean update_counters);
const char* afrodite_symbol_get_type_name (AfroditeSymbol* self);
char* afrodite_utils_unescape_xml_string (const char* text);
const char* afrodite_symbol_get_description (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_source_references (AfroditeSymbol* self);
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self);
gint afrodite_source_reference_get_first_line (AfroditeSourceReference* self);
gint afrodite_source_reference_get_last_line (AfroditeSourceReference* self);
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
AfroditeSourceFile* afrodite_source_reference_get_file (AfroditeSourceReference* self);
const char* afrodite_source_file_get_filename (AfroditeSourceFile* self);
gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
void afrodite_ast_dumper_dump (AfroditeAstDumper* self, AfroditeAst* ast, const char* filter_symbol);
AfroditeSymbol* afrodite_ast_get_root (AfroditeAst* self);
gboolean afrodite_symbol_get_has_children (AfroditeSymbol* self);
static void afrodite_ast_dumper_dump_symbols (AfroditeAstDumper* self, ValaList* symbols, const char* filter_symbol);
ValaList* afrodite_symbol_get_children (AfroditeSymbol* self);
gboolean afrodite_ast_get_has_source_files (AfroditeAst* self);
ValaList* afrodite_ast_get_source_files (AfroditeAst* self);
gboolean afrodite_source_file_get_has_using_directives (AfroditeSourceFile* self);
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
ValaList* afrodite_source_file_get_using_directives (AfroditeSourceFile* self);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_local_variables (AfroditeSymbol* self);
AfroditeSourceReference* afrodite_data_type_get_source_reference (AfroditeDataType* self);
char* afrodite_data_type_get_description (AfroditeDataType* self);
AfroditeAstDumper* afrodite_ast_dumper_new (void);
AfroditeAstDumper* afrodite_ast_dumper_construct (GType object_type);
static void afrodite_ast_dumper_finalize (ValaCodeVisitor* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void afrodite_ast_dumper_inc_pad (AfroditeAstDumper* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->pad == NULL) {
		char* _tmp0_;
		self->priv->pad = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->pad), _tmp0_);
		self->priv->level = 0;
	} else {
		char* _tmp1_;
		self->priv->level++;
		self->priv->pad = (_tmp1_ = g_strnfill ((gsize) self->priv->level, '\t'), _g_free0 (self->priv->pad), _tmp1_);
	}
}


static void afrodite_ast_dumper_dec_pad (AfroditeAstDumper* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->pad == NULL) {
		char* _tmp0_;
		self->priv->pad = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->pad), _tmp0_);
		self->priv->level = 0;
		g_error ("astdumper.vala:51: dec_pad call!!!");
	} else {
		if (self->priv->level == 0) {
			char* _tmp1_;
			self->priv->pad = (_tmp1_ = NULL, _g_free0 (self->priv->pad), _tmp1_);
		} else {
			char* _tmp2_;
			self->priv->level--;
			self->priv->pad = (_tmp2_ = g_strnfill ((gsize) self->priv->level, '\t'), _g_free0 (self->priv->pad), _tmp2_);
		}
	}
}


static void afrodite_ast_dumper_print_symbol (AfroditeAstDumper* self, AfroditeSymbol* s) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_print ("%s\n", _tmp0_ = afrodite_ast_dumper_create_symbol_dump_info (self, s, TRUE));
	_g_free0 (_tmp0_);
}


char* afrodite_ast_dumper_create_symbol_dump_info (AfroditeAstDumper* self, AfroditeSymbol* s, gboolean update_counters) {
	char* result = NULL;
	GString* sb;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	char* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	if (s == NULL) {
		result = g_strdup ("(empty)");
		return result;
	}
	if (self->priv->pad == NULL) {
		afrodite_ast_dumper_inc_pad (self);
	}
	sb = g_string_new ("");
	g_string_append (sb, self->priv->pad);
	if (_vala_strcmp0 (afrodite_symbol_get_type_name (s), "Namespace") == 0) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = _vala_strcmp0 (afrodite_symbol_get_type_name (s), "Class") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _vala_strcmp0 (afrodite_symbol_get_type_name (s), "Struct") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _vala_strcmp0 (afrodite_symbol_get_type_name (s), "Interface") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (afrodite_symbol_get_type_name (s), "Enum") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (afrodite_symbol_get_type_name (s), "ErrorDomain") == 0;
	}
	if (_tmp0_) {
		char* _tmp5_;
		g_string_append_printf (sb, "%s ", _tmp5_ = g_utf8_strdown (afrodite_symbol_get_type_name (s), -1));
		_g_free0 (_tmp5_);
	}
	g_string_append_printf (sb, "%s ", _tmp6_ = afrodite_utils_unescape_xml_string (afrodite_symbol_get_description (s)));
	_g_free0 (_tmp6_);
	if (afrodite_symbol_get_has_source_references (s)) {
		g_string_append (sb, "   - [");
		{
			ValaIterator* _sr_it;
			_sr_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_source_references (s));
			while (TRUE) {
				AfroditeSourceReference* sr;
				if (!vala_iterator_next (_sr_it)) {
					break;
				}
				sr = (AfroditeSourceReference*) vala_iterator_get (_sr_it);
				g_string_append_printf (sb, "(%d - %d) %s, ", afrodite_source_reference_get_first_line (sr), afrodite_source_reference_get_last_line (sr), afrodite_source_file_get_filename (afrodite_source_reference_get_file (sr)));
				_afrodite_source_reference_unref0 (sr);
			}
			_vala_collection_object_unref0 (_sr_it);
		}
		g_string_truncate (sb, (gsize) (sb->len - 2));
		g_string_append (sb, "]");
	}
	if (update_counters) {
		self->priv->symbols++;
	}
	result = g_strdup (sb->str);
	_g_string_free0 (sb);
	return result;
}


void afrodite_ast_dumper_dump (AfroditeAstDumper* self, AfroditeAst* ast, const char* filter_symbol) {
	char* _tmp0_;
	GTimer* timer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ast != NULL);
	self->priv->pad = (_tmp0_ = NULL, _g_free0 (self->priv->pad), _tmp0_);
	self->priv->level = 0;
	self->priv->symbols = 0;
	self->priv->unresolved_types = 0;
	self->priv->types = 0;
	timer = g_timer_new ();
	g_timer_start (timer);
	if (afrodite_symbol_get_has_children (afrodite_ast_get_root (ast))) {
		afrodite_ast_dumper_dump_symbols (self, afrodite_symbol_get_children (afrodite_ast_get_root (ast)), filter_symbol);
		g_print ("Dump done. Symbols %d, Types examinated %d of which unresolved %d\n" \
"\n", self->priv->symbols, self->priv->types, self->priv->unresolved_types);
	} else {
		g_print ("context empty!\n");
	}
	if (afrodite_ast_get_has_source_files (ast)) {
		g_print ("Source files:\n");
		{
			ValaIterator* _file_it;
			_file_it = vala_iterable_iterator ((ValaIterable*) afrodite_ast_get_source_files (ast));
			while (TRUE) {
				AfroditeSourceFile* file;
				if (!vala_iterator_next (_file_it)) {
					break;
				}
				file = (AfroditeSourceFile*) vala_iterator_get (_file_it);
				g_print ("\tsource: %s\n", afrodite_source_file_get_filename (file));
				if (afrodite_source_file_get_has_using_directives (file)) {
					g_print ("\t\tusing directives:\n");
					{
						ValaIterator* _d_it;
						_d_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (file));
						while (TRUE) {
							AfroditeDataType* d;
							if (!vala_iterator_next (_d_it)) {
								break;
							}
							d = (AfroditeDataType*) vala_iterator_get (_d_it);
							g_print ("\t\t\tusing: %s\n", afrodite_data_type_get_type_name (d));
							_afrodite_data_type_unref0 (d);
						}
						_vala_collection_object_unref0 (_d_it);
					}
				}
				_afrodite_source_file_unref0 (file);
			}
			_vala_collection_object_unref0 (_file_it);
		}
	}
	g_timer_stop (timer);
	g_print ("Dump done in %g\n", g_timer_elapsed (timer, NULL));
	_g_timer_destroy0 (timer);
}


static gpointer _afrodite_source_reference_ref0 (gpointer self) {
	return self ? afrodite_source_reference_ref (self) : NULL;
}


static void afrodite_ast_dumper_dump_symbols (AfroditeAstDumper* self, ValaList* symbols, const char* filter_symbol) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	afrodite_ast_dumper_inc_pad (self);
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) symbols);
		while (TRUE) {
			AfroditeSymbol* symbol;
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = (AfroditeSymbol*) vala_iterator_get (_symbol_it);
			if (_vala_strcmp0 (filter_symbol, "") == 0) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = filter_symbol == NULL;
			}
			if (_tmp1_) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = _vala_strcmp0 (filter_symbol, afrodite_symbol_get_fully_qualified_name (symbol)) == 0;
			}
			if (_tmp0_) {
				afrodite_ast_dumper_print_symbol (self, symbol);
				if (afrodite_symbol_get_has_local_variables (symbol)) {
					afrodite_ast_dumper_inc_pad (self);
					g_print ("%slocal variables\n", self->priv->pad);
					{
						ValaIterator* _local_it;
						_local_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_local_variables (symbol));
						while (TRUE) {
							AfroditeDataType* local;
							AfroditeSourceReference* sr;
							char* _tmp2_;
							char* _tmp3_;
							if (!vala_iterator_next (_local_it)) {
								break;
							}
							local = (AfroditeDataType*) vala_iterator_get (_local_it);
							sr = _afrodite_source_reference_ref0 (afrodite_data_type_get_source_reference (local));
							g_print ("%s   %s     - [(%d - %d) %s]\n", self->priv->pad, _tmp3_ = afrodite_utils_unescape_xml_string (_tmp2_ = afrodite_data_type_get_description (local)), afrodite_source_reference_get_first_line (sr), afrodite_source_reference_get_last_line (sr), afrodite_source_file_get_filename (afrodite_source_reference_get_file (sr)));
							_g_free0 (_tmp3_);
							_g_free0 (_tmp2_);
							_afrodite_source_reference_unref0 (sr);
							_afrodite_data_type_unref0 (local);
						}
						_vala_collection_object_unref0 (_local_it);
					}
					afrodite_ast_dumper_dec_pad (self);
				}
				if (afrodite_symbol_get_has_children (symbol)) {
					afrodite_ast_dumper_dump_symbols (self, afrodite_symbol_get_children (symbol), NULL);
				}
			}
			_g_object_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	afrodite_ast_dumper_dec_pad (self);
}


AfroditeAstDumper* afrodite_ast_dumper_construct (GType object_type) {
	AfroditeAstDumper* self;
	self = (AfroditeAstDumper*) vala_code_visitor_construct (object_type);
	return self;
}


AfroditeAstDumper* afrodite_ast_dumper_new (void) {
	return afrodite_ast_dumper_construct (AFRODITE_TYPE_AST_DUMPER);
}


static void afrodite_ast_dumper_class_init (AfroditeAstDumperClass * klass) {
	afrodite_ast_dumper_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = afrodite_ast_dumper_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeAstDumperPrivate));
}


static void afrodite_ast_dumper_instance_init (AfroditeAstDumper * self) {
	self->priv = AFRODITE_AST_DUMPER_GET_PRIVATE (self);
	self->priv->pad = NULL;
	self->priv->level = 0;
	self->priv->symbols = 0;
	self->priv->unresolved_types = 0;
	self->priv->types = 0;
}


static void afrodite_ast_dumper_finalize (ValaCodeVisitor* obj) {
	AfroditeAstDumper * self;
	self = AFRODITE_AST_DUMPER (obj);
	_g_free0 (self->priv->pad);
	VALA_CODE_VISITOR_CLASS (afrodite_ast_dumper_parent_class)->finalize (obj);
}


GType afrodite_ast_dumper_get_type (void) {
	static volatile gsize afrodite_ast_dumper_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_ast_dumper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeAstDumperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_ast_dumper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeAstDumper), 0, (GInstanceInitFunc) afrodite_ast_dumper_instance_init, NULL };
		GType afrodite_ast_dumper_type_id;
		afrodite_ast_dumper_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "AfroditeAstDumper", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_ast_dumper_type_id__volatile, afrodite_ast_dumper_type_id);
	}
	return afrodite_ast_dumper_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




