/* gee.vapi generated by lt-valac, do not modify. */

[CCode (cprefix = "Gee", lower_case_cprefix = "gee_")]
namespace Gee {
	[CCode (cheader_filename = "gee/arraylist.h")]
	public class ArrayList<G> : GLib.Object, Gee.Iterable<G>, Gee.Collection<G>, Gee.List<G> {
		public ArrayList (GLib.EqualFunc equal_func = GLib.direct_equal);
		public weak int size { get; }
		public weak GLib.EqualFunc equal_func { set; }
	}
	[CCode (cheader_filename = "gee/hashmap.h")]
	public class HashMap<K,V> : GLib.Object, Gee.Map<K,V> {
		public HashMap (GLib.HashFunc key_hash_func = GLib.direct_hash, GLib.EqualFunc key_equal_func = GLib.direct_equal, GLib.EqualFunc value_equal_func = GLib.direct_equal);
		public weak int size { get; }
		public weak GLib.HashFunc key_hash_func { set; }
		public weak GLib.EqualFunc key_equal_func { set; }
		public weak GLib.EqualFunc value_equal_func { set; }
	}
	[CCode (cheader_filename = "gee/hashset.h")]
	public class HashSet<G> : GLib.Object, Gee.Iterable<G>, Gee.Collection<G>, Gee.Set<G> {
		public HashSet (GLib.HashFunc hash_func = GLib.direct_hash, GLib.EqualFunc equal_func = GLib.direct_equal);
		public weak int size { get; }
		public weak GLib.HashFunc hash_func { set; }
		public weak GLib.EqualFunc equal_func { set; }
	}
	[CCode (cheader_filename = "gee/readonlycollection.h")]
	public class ReadOnlyCollection<G> : GLib.Object, Gee.Iterable<G>, Gee.Collection<G> {
		public ReadOnlyCollection (Gee.Collection<G> collection = null);
		public weak int size { get; }
		public Gee.Collection<G> collection { set; }
	}
	[CCode (cheader_filename = "gee/readonlylist.h")]
	public class ReadOnlyList<G> : GLib.Object, Gee.Iterable<G>, Gee.Collection<G>, Gee.List<G> {
		public ReadOnlyList (Gee.List<G> list = null);
		public weak int size { get; }
		public Gee.List<G> list { set; }
	}
	[CCode (cheader_filename = "gee/readonlymap.h")]
	public class ReadOnlyMap<K,V> : GLib.Object, Gee.Map<K,V> {
		public ReadOnlyMap (Gee.Map<K,V> map = null);
		public weak int size { get; }
		public Gee.Map<K,V> map { set; }
	}
	[CCode (cheader_filename = "gee/readonlyset.h")]
	public class ReadOnlySet<G> : GLib.Object, Gee.Iterable<G>, Gee.Collection<G>, Gee.Set<G> {
		public ReadOnlySet (Gee.Set<G> set = null);
		public weak int size { get; }
		public Gee.Set<G> set { set; }
	}
	[CCode (cheader_filename = "gee/collection.h")]
	public interface Collection<G> : Gee.Iterable<G> {
		public abstract bool contains (G item);
		public abstract bool add (G item);
		public abstract bool remove (G item);
		public abstract void clear ();
		public abstract weak int size { get; }
	}
	[CCode (cheader_filename = "gee/iterable.h")]
	public interface Iterable<G> : GLib.Object {
		public abstract Gee.Iterator<G> iterator ();
	}
	[CCode (cheader_filename = "gee/iterator.h")]
	public interface Iterator<G> : GLib.Object {
		public abstract bool next ();
		public abstract G get ();
	}
	[CCode (cheader_filename = "gee/list.h")]
	public interface List<G> : Gee.Collection<G> {
		public abstract G get (int index);
		public abstract void set (int index, G item);
		public abstract int index_of (G item);
		public abstract void insert (int index, G item);
		public abstract void remove_at (int index);
	}
	[CCode (cheader_filename = "gee/map.h")]
	public interface Map<K,V> : GLib.Object {
		public abstract Gee.Set<K> get_keys ();
		public abstract Gee.Collection<V> get_values ();
		public abstract bool contains (K key);
		public abstract V get (K key);
		public abstract void set (K key, V value);
		public abstract bool remove (K key);
		public abstract void clear ();
		public abstract weak int size { get; }
	}
	[CCode (cheader_filename = "gee/set.h")]
	public interface Set<G> : Gee.Collection<G> {
	}
}
/* ccode.vapi generated by lt-valac, do not modify. */

[CCode (cprefix = "Vala", lower_case_cprefix = "vala_")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_ASSIGNMENT_OPERATOR_", cheader_filename = "ccode/valaccodeassignment.h")]
	public enum CCodeAssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
	[CCode (cprefix = "VALA_CCODE_BINARY_OPERATOR_", cheader_filename = "ccode/valaccodebinaryexpression.h")]
	public enum CCodeBinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
	}
	[CCode (cprefix = "VALA_CCODE_MODIFIERS_", cheader_filename = "ccode/valaccodemodifiers.h")]
	[Flags]
	public enum CCodeModifiers {
		NONE,
		STATIC,
		REGISTER,
		EXTERN,
		INLINE,
	}
	[CCode (cprefix = "VALA_CCODE_UNARY_OPERATOR_", cheader_filename = "ccode/valaccodeunaryexpression.h")]
	public enum CCodeUnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		POINTER_INDIRECTION,
		ADDRESS_OF,
		PREFIX_INCREMENT,
		PREFIX_DECREMENT,
		POSTFIX_INCREMENT,
		POSTFIX_DECREMENT,
	}
	[CCode (cheader_filename = "ccode/valaccodeassignment.h")]
	public class CCodeAssignment : Vala.CCodeExpression {
		public CCodeAssignment (Vala.CCodeExpression l, Vala.CCodeExpression r, Vala.CCodeAssignmentOperator op = CCodeAssignmentOperator.SIMPLE);
		public Vala.CCodeExpression left { get; construct; }
		public weak Vala.CCodeAssignmentOperator operator { get; set; }
		public Vala.CCodeExpression right { get; construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodebinaryexpression.h")]
	public class CCodeBinaryExpression : Vala.CCodeExpression {
		public CCodeBinaryExpression (Vala.CCodeBinaryOperator op, Vala.CCodeExpression l, Vala.CCodeExpression r);
		public weak Vala.CCodeBinaryOperator operator { get; set; }
		public Vala.CCodeExpression left { get; set construct; }
		public Vala.CCodeExpression right { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeblock.h")]
	public class CCodeBlock : Vala.CCodeStatement {
		public void prepend_statement (Vala.CCodeNode statement);
		public void add_statement (Vala.CCodeNode statement);
		public CCodeBlock ();
		public weak bool suppress_newline { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodebreakstatement.h")]
	public class CCodeBreakStatement : Vala.CCodeStatement {
		public CCodeBreakStatement ();
	}
	[CCode (cheader_filename = "ccode/valaccodecasestatement.h")]
	public class CCodeCaseStatement : Vala.CCodeStatement {
		public CCodeCaseStatement (Vala.CCodeExpression expression);
		public void add_statement (Vala.CCodeStatement stmt);
		public Vala.CCodeExpression expression { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodecastexpression.h")]
	public class CCodeCastExpression : Vala.CCodeExpression {
		public CCodeCastExpression (Vala.CCodeExpression expr, string type);
		public Vala.CCodeExpression inner { get; set construct; }
		public string type_name { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodecommaexpression.h")]
	public class CCodeCommaExpression : Vala.CCodeExpression {
		public void append_expression (Vala.CCodeExpression expr);
		public CCodeCommaExpression ();
	}
	[CCode (cheader_filename = "ccode/valaccodecomment.h")]
	public class CCodeComment : Vala.CCodeNode {
		public CCodeComment (string _text);
		public string text { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeconditionalexpression.h")]
	public class CCodeConditionalExpression : Vala.CCodeExpression {
		public CCodeConditionalExpression (Vala.CCodeExpression cond, Vala.CCodeExpression true_expr, Vala.CCodeExpression false_expr);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeExpression true_expression { get; set construct; }
		public Vala.CCodeExpression false_expression { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeconstant.h")]
	public class CCodeConstant : Vala.CCodeExpression {
		public CCodeConstant (string _name);
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodecontinuestatement.h")]
	public class CCodeContinueStatement : Vala.CCodeStatement {
		public CCodeContinueStatement ();
	}
	[CCode (cheader_filename = "ccode/valaccodedeclaration.h")]
	public class CCodeDeclaration : Vala.CCodeStatement {
		public CCodeDeclaration (string type_name);
		public void add_declarator (Vala.CCodeDeclarator decl);
		public string type_name { get; set; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodedeclarator.h")]
	public abstract class CCodeDeclarator : Vala.CCodeNode {
		public virtual void write_initialization (Vala.CCodeWriter writer);
	}
	[CCode (cheader_filename = "ccode/valaccodedostatement.h")]
	public class CCodeDoStatement : Vala.CCodeStatement {
		public CCodeDoStatement (Vala.CCodeStatement stmt, Vala.CCodeExpression cond);
		public Vala.CCodeStatement body { get; set; }
		public Vala.CCodeExpression condition { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeemptystatement.h")]
	public class CCodeEmptyStatement : Vala.CCodeStatement {
		public CCodeEmptyStatement ();
	}
	[CCode (cheader_filename = "ccode/valaccodeenum.h")]
	public class CCodeEnum : Vala.CCodeNode {
		public CCodeEnum (string name = null);
		public void add_value (Vala.CCodeEnumValue value);
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeenumvalue.h")]
	public class CCodeEnumValue : Vala.CCodeNode {
		public CCodeEnumValue (string name, Vala.CCodeExpression value = null);
		public string name { get; set; }
		public Vala.CCodeExpression value { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeexpression.h")]
	public abstract class CCodeExpression : Vala.CCodeNode {
	}
	[CCode (cheader_filename = "ccode/valaccodeexpressionstatement.h")]
	public class CCodeExpressionStatement : Vala.CCodeStatement {
		public CCodeExpressionStatement (Vala.CCodeExpression expr);
		public Vala.CCodeExpression expression { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeformalparameter.h")]
	public class CCodeFormalParameter : Vala.CCodeNode {
		public CCodeFormalParameter (string n, string type);
		public CCodeFormalParameter.with_ellipsis ();
		public string name { get; set; }
		public string type_name { get; set; }
		public weak bool ellipsis { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeforstatement.h")]
	public class CCodeForStatement : Vala.CCodeStatement {
		public CCodeForStatement (Vala.CCodeExpression condition, Vala.CCodeStatement body = null);
		public void add_initializer (Vala.CCodeExpression expr);
		public void add_iterator (Vala.CCodeExpression expr);
		public Vala.CCodeExpression condition { get; set; }
		public Vala.CCodeStatement body { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodefragment.h")]
	public class CCodeFragment : Vala.CCodeNode {
		public void append (Vala.CCodeNode node);
		public Gee.Collection<Vala.CCodeNode> get_children ();
		public CCodeFragment ();
	}
	[CCode (cheader_filename = "ccode/valaccodefunction.h")]
	public class CCodeFunction : Vala.CCodeNode {
		public CCodeFunction (string name, string return_type);
		public void add_parameter (Vala.CCodeFormalParameter param);
		public Vala.CCodeFunction copy ();
		public string name { get; set; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
		public string return_type { get; set; }
		public Vala.CCodeBlock block { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodefunctioncall.h")]
	public class CCodeFunctionCall : Vala.CCodeExpression {
		public CCodeFunctionCall (Vala.CCodeExpression call = null);
		public void add_argument (Vala.CCodeExpression expr);
		public Gee.List<Vala.CCodeExpression> get_arguments ();
		public Vala.CCodeExpression call { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodefunctiondeclarator.h")]
	public class CCodeFunctionDeclarator : Vala.CCodeDeclarator {
		public CCodeFunctionDeclarator (string name);
		public void add_parameter (Vala.CCodeFormalParameter param);
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodegotostatement.h")]
	public class CCodeGotoStatement : Vala.CCodeStatement {
		public CCodeGotoStatement (string name);
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeidentifier.h")]
	public class CCodeIdentifier : Vala.CCodeExpression {
		public CCodeIdentifier (string _name);
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeifstatement.h")]
	public class CCodeIfStatement : Vala.CCodeStatement {
		public CCodeIfStatement (Vala.CCodeExpression cond, Vala.CCodeStatement true_stmt, Vala.CCodeStatement false_stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement true_statement { get; set construct; }
		public Vala.CCodeStatement false_statement { get; set construct; }
		public weak bool else_if { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeincludedirective.h")]
	public class CCodeIncludeDirective : Vala.CCodeNode {
		public CCodeIncludeDirective (string _filename, bool _local = false);
		public string filename { get; set construct; }
		public weak bool local { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeinitializerlist.h")]
	public class CCodeInitializerList : Vala.CCodeExpression {
		public void append (Vala.CCodeExpression expr);
		public CCodeInitializerList ();
	}
	[CCode (cheader_filename = "ccode/valaccodelabel.h")]
	public class CCodeLabel : Vala.CCodeStatement {
		public CCodeLabel (string name);
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodelinedirective.h")]
	public class CCodeLineDirective : Vala.CCodeNode {
		public CCodeLineDirective (string _filename, int _line);
		public string filename { get; set construct; }
		public weak int line { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodemacroreplacement.h")]
	public class CCodeMacroReplacement : Vala.CCodeNode {
		public CCodeMacroReplacement (string name, string replacement);
		public CCodeMacroReplacement.with_expression (string name, Vala.CCodeExpression replacement_expression);
		public string name { get; set construct; }
		public string replacement { get; set; }
		public Vala.CCodeExpression replacement_expression { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodememberaccess.h")]
	public class CCodeMemberAccess : Vala.CCodeExpression {
		public CCodeMemberAccess (Vala.CCodeExpression container, string member, bool pointer = false);
		public CCodeMemberAccess.pointer (Vala.CCodeExpression container, string member);
		public Vala.CCodeExpression inner { get; set construct; }
		public string member_name { get; set construct; }
		public weak bool is_pointer { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodenewline.h")]
	public class CCodeNewline : Vala.CCodeNode {
		public CCodeNewline ();
	}
	[CCode (cheader_filename = "ccode/valaccodenode.h")]
	public abstract class CCodeNode : GLib.Object {
		public abstract void write (Vala.CCodeWriter writer);
		public virtual void write_declaration (Vala.CCodeWriter writer);
		public virtual void write_combined (Vala.CCodeWriter writer);
		public Vala.CCodeLineDirective line { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeoncesection.h")]
	public class CCodeOnceSection : Vala.CCodeFragment {
		public CCodeOnceSection (string def);
		public string define { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodeparenthesizedexpression.h")]
	public class CCodeParenthesizedExpression : Vala.CCodeExpression {
		public CCodeParenthesizedExpression (Vala.CCodeExpression expr);
		public Vala.CCodeExpression inner { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodereturnstatement.h")]
	public class CCodeReturnStatement : Vala.CCodeStatement {
		public CCodeReturnStatement (Vala.CCodeExpression expr = null);
		public Vala.CCodeExpression return_expression { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodestatement.h")]
	public abstract class CCodeStatement : Vala.CCodeNode {
	}
	[CCode (cheader_filename = "ccode/valaccodestruct.h")]
	public class CCodeStruct : Vala.CCodeNode {
		public CCodeStruct (string name);
		public void add_declaration (Vala.CCodeDeclaration decl);
		public void add_field (string type_name, string name);
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeswitchstatement.h")]
	public class CCodeSwitchStatement : Vala.CCodeStatement {
		public CCodeSwitchStatement (Vala.CCodeExpression expression);
		public void add_case (Vala.CCodeCaseStatement case_stmt);
		public void add_default_statement (Vala.CCodeStatement stmt);
		public Vala.CCodeExpression expression { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodetypedefinition.h")]
	public class CCodeTypeDefinition : Vala.CCodeNode {
		public CCodeTypeDefinition (string type, Vala.CCodeDeclarator decl);
		public string type_name { get; set; }
		public Vala.CCodeDeclarator declarator { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodeunaryexpression.h")]
	public class CCodeUnaryExpression : Vala.CCodeExpression {
		public CCodeUnaryExpression (Vala.CCodeUnaryOperator op, Vala.CCodeExpression expr);
		public weak Vala.CCodeUnaryOperator operator { get; set; }
		public Vala.CCodeExpression inner { get; set construct; }
	}
	[CCode (cheader_filename = "ccode/valaccodevariabledeclarator.h")]
	public class CCodeVariableDeclarator : Vala.CCodeDeclarator {
		public CCodeVariableDeclarator (string _name);
		public CCodeVariableDeclarator.with_initializer (string _name, Vala.CCodeExpression init);
		public string name { get; set construct; }
		public Vala.CCodeExpression initializer { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodewhilestatement.h")]
	public class CCodeWhileStatement : Vala.CCodeStatement {
		public CCodeWhileStatement (Vala.CCodeExpression cond, Vala.CCodeStatement stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement body { get; set; }
	}
	[CCode (cheader_filename = "ccode/valaccodewriter.h")]
	public class CCodeWriter : GLib.Object {
		public CCodeWriter (string _filename);
		public void close ();
		public void write_indent (Vala.CCodeLineDirective line = null);
		public void write_string (string s);
		public void write_newline ();
		public void write_begin_block ();
		public void write_end_block ();
		public void write_comment (string text);
		public string filename { get; construct; }
		public weak bool line_directives { get; set; }
		public weak bool bol { get; }
	}
	[CCode (cheader_filename = "ccode/valaccodeelementaccess.h")]
	public class CCodeElementAccess : Vala.CCodeExpression {
		public CCodeElementAccess (Vala.CCodeExpression cont, Vala.CCodeExpression i);
		public Vala.CCodeExpression container { get; set construct; }
		public Vala.CCodeExpression index { get; set construct; }
	}
}
/* vala.vapi generated by lt-valac, do not modify. */

[CCode (cprefix = "Vala", lower_case_cprefix = "vala_")]
namespace Vala {
	[CCode (cprefix = "VALA_ASSIGNMENT_OPERATOR_", cheader_filename = "vala/valaassignment.h")]
	public enum AssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
	[CCode (cprefix = "VALA_BINARY_OPERATOR_", cheader_filename = "vala/valabinaryexpression.h")]
	public enum BinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
		IN,
	}
	[CCode (cprefix = "VALA_SOURCE_FILE_DEPENDENCY_TYPE_", cheader_filename = "vala/valasourcefile.h")]
	public enum SourceFileDependencyType {
		HEADER_FULL,
		HEADER_SHALLOW,
		SOURCE,
	}
	[CCode (cprefix = "VALA_SYMBOL_ACCESSIBILITY_", cheader_filename = "vala/valasymbol.h")]
	public enum SymbolAccessibility {
		PRIVATE,
		INTERNAL,
		PROTECTED,
		PUBLIC,
	}
	[CCode (cprefix = "VALA_UNARY_OPERATOR_", cheader_filename = "vala/valaunaryexpression.h")]
	public enum UnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		INCREMENT,
		DECREMENT,
		REF,
		OUT,
	}
	[CCode (cheader_filename = "vala/valaaddressofexpression.h")]
	public class AddressofExpression : Vala.Expression {
		public AddressofExpression (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarray.h")]
	public class Array : Vala.Typesymbol {
		public Array (Vala.Typesymbol _element_type, int _rank, Vala.SourceReference _source_reference);
		public Array.with_type_parameter (Vala.TypeParameter _element_type_parameter, int _rank, Vala.SourceReference _source_reference);
		public Vala.ArrayLengthField get_length_field ();
		public Vala.ArrayResizeMethod get_resize_method ();
		public Vala.ArrayMoveMethod get_move_method ();
		public weak Vala.Typesymbol element_type { get; set construct; }
		public weak Vala.TypeParameter element_type_parameter { get; set construct; }
		public weak int rank { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarraycreationexpression.h")]
	public class ArrayCreationExpression : Vala.Expression {
		public void append_size (Vala.Expression size);
		public Gee.List<Vala.Expression> get_sizes ();
		public ArrayCreationExpression (Vala.DataType element_type, int rank, Vala.InitializerList initializer_list, Vala.SourceReference source_reference);
		public Vala.DataType element_type { get; set; }
		public weak int rank { get; set construct; }
		public Vala.InitializerList initializer_list { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarraylengthfield.h")]
	public class ArrayLengthField : Vala.Field {
		public ArrayLengthField (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarraymovemethod.h")]
	public class ArrayMoveMethod : Vala.Method {
		public ArrayMoveMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarrayresizemethod.h")]
	public class ArrayResizeMethod : Vala.Method {
		public ArrayResizeMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarraytype.h")]
	public class ArrayType : Vala.ReferenceType {
		public ArrayType (Vala.DataType element_type);
		public weak Vala.DataType element_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valaassignment.h")]
	public class Assignment : Vala.Expression {
		public Assignment (Vala.Expression left, Vala.Expression right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference source_reference = null);
		public Vala.Expression left { get; set construct; }
		public weak Vala.AssignmentOperator operator { get; set; }
		public Vala.Expression right { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaattribute.h")]
	public class Attribute : Vala.CodeNode {
		public Gee.List<Vala.NamedArgument> args;
		public Attribute (string name, Vala.SourceReference source_reference);
		public void add_argument (Vala.NamedArgument arg);
		public bool has_argument (string name);
		public string get_string (string name);
		public int get_integer (string name);
		public bool get_bool (string name);
		public string name { get; set; }
	}
	[CCode (cheader_filename = "vala/valaattributeprocessor.h")]
	public class AttributeProcessor : Vala.CodeVisitor {
		public void process (Vala.CodeContext context);
		public AttributeProcessor ();
	}
	[CCode (cheader_filename = "vala/valabaseaccess.h")]
	public class BaseAccess : Vala.Expression {
		public BaseAccess (Vala.SourceReference source = null);
	}
	[CCode (cheader_filename = "vala/valabinaryexpression.h")]
	public class BinaryExpression : Vala.Expression {
		public BinaryExpression (Vala.BinaryOperator op, Vala.Expression _left, Vala.Expression _right, Vala.SourceReference source = null);
		public weak Vala.BinaryOperator operator { get; set; }
		public Vala.Expression left { get; set construct; }
		public Vala.Expression right { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valablock.h")]
	public class Block : Vala.Symbol, Vala.Statement {
		public Block (Vala.SourceReference source_reference = null);
		public void add_statement (Vala.Statement stmt);
		public Gee.Collection<Vala.Statement> get_statements ();
		public void add_local_variable (Vala.VariableDeclarator decl);
		public Gee.Collection<Vala.VariableDeclarator> get_local_variables ();
		public weak bool contains_jump_statement { get; set; }
	}
	[CCode (cheader_filename = "vala/valabooleanliteral.h")]
	public class BooleanLiteral : Vala.Literal {
		public BooleanLiteral (bool b, Vala.SourceReference source);
		public weak bool value { get; set; }
	}
	[CCode (cheader_filename = "vala/valabreakstatement.h")]
	public class BreakStatement : Vala.CodeNode, Vala.Statement {
		public BreakStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacastexpression.h")]
	public class CastExpression : Vala.Expression {
		public CastExpression (Vala.Expression inner, Vala.DataType type_reference, Vala.SourceReference source_reference, bool is_silent_cast);
		public Vala.Expression inner { get; set construct; }
		public Vala.DataType type_reference { get; set; }
		public weak bool is_silent_cast { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valacatchclause.h")]
	public class CatchClause : Vala.CodeNode {
		public CatchClause (Vala.DataType type_reference, string variable_name, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.DataType type_reference { get; set; }
		public string variable_name { get; set; }
		public Vala.Block body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
	}
	[CCode (cheader_filename = "vala/valacharacterliteral.h")]
	public class CharacterLiteral : Vala.Literal {
		public CharacterLiteral (string c, Vala.SourceReference source);
		public unichar get_char ();
		public string value { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaclass.h")]
	public class Class : Vala.Typesymbol {
		public Class (string name, Vala.SourceReference source_reference = null);
		public void add_base_type (Vala.DataType type);
		public Gee.Collection<Vala.DataType> get_base_types ();
		public void add_type_parameter (Vala.TypeParameter p);
		public Gee.Collection<Vala.TypeParameter> get_type_parameters ();
		public void add_constant (Vala.Constant c);
		public void add_field (Vala.Field f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_method (Vala.Method m);
		public Gee.Collection<Vala.Method> get_methods ();
		public void add_property (Vala.Property prop, bool no_field = false);
		public Gee.Collection<Vala.Property> get_properties ();
		public void add_signal (Vala.Signal sig);
		public Gee.Collection<Vala.Signal> get_signals ();
		public void add_class (Vala.Class cl);
		public void add_struct (Vala.Struct st);
		public string get_default_cname ();
		public void set_cname (string cname);
		public void process_attributes ();
		public void set_type_id (string type_id);
		public void set_ref_function (string name);
		public void set_unref_function (string name);
		public void set_dup_function (string name);
		public string get_default_free_function ();
		public void set_free_function (string name);
		public Vala.Class base_class { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_static { get; set; }
		public weak bool has_private_fields { get; }
		public Vala.Method default_construction_method { get; set; }
		public Vala.Constructor constructor { get; set; }
		public Vala.Destructor destructor { get; set; }
	}
	[CCode (cheader_filename = "vala/valaclasstype.h")]
	public class ClassType : Vala.ReferenceType {
		public ClassType (Vala.Class class_symbol);
		public weak Vala.Class class_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodebinding.h")]
	public abstract class CodeBinding : GLib.Object {
		public abstract void emit ();
	}
	[CCode (cheader_filename = "vala/valacodecontext.h")]
	public class CodeContext : GLib.Object {
		public CodeContext ();
		public static bool is_non_null_enabled ();
		public Gee.Collection<Vala.SourceFile> get_source_files ();
		public Gee.Collection<string> get_c_source_files ();
		public void add_source_file (Vala.SourceFile file);
		public void add_c_source_file (string file);
		public Gee.Collection<string> get_packages ();
		public bool has_package (string pkg);
		public void add_package (string pkg);
		public void accept (Vala.CodeVisitor visitor);
		public void find_header_cycles ();
		public void add_define (string define);
		public bool ignore_node (Vala.CodeNode node);
		public Vala.Namespace create_namespace (string name, Vala.SourceReference source_reference = null);
		public Vala.Class create_class (string name, Vala.SourceReference source_reference = null);
		public Vala.Struct create_struct (string name, Vala.SourceReference source_reference = null);
		public Vala.Interface create_interface (string name, Vala.SourceReference source_reference = null);
		public Vala.Enum create_enum (string name, Vala.SourceReference source_reference = null);
		public Vala.EnumValue create_enum_value (string name);
		public Vala.EnumValue create_enum_value_with_value (string name, Vala.Expression value);
		public Vala.Delegate create_delegate (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public Vala.Constant create_constant (string name, Vala.DataType type_reference, Vala.Expression initializer, Vala.SourceReference source_reference);
		public Vala.Field create_field (string name, Vala.DataType type_reference, Vala.Expression initializer, Vala.SourceReference source_reference = null);
		public Vala.Method create_method (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public Vala.CreationMethod create_creation_method (string type_name, string name, Vala.SourceReference source_reference = null);
		public Vala.FormalParameter create_formal_parameter (string name, Vala.DataType type_reference, Vala.SourceReference source_reference = null);
		public Vala.FormalParameter create_formal_parameter_with_ellipsis (Vala.SourceReference source_reference = null);
		public Vala.Property create_property (string name, Vala.DataType type_reference, Vala.PropertyAccessor get_accessor, Vala.PropertyAccessor set_accessor, Vala.SourceReference source_reference);
		public Vala.PropertyAccessor create_property_accessor (bool readable, bool writable, bool construction, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.Signal create_signal (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public Vala.Constructor create_constructor (Vala.SourceReference source_reference);
		public Vala.Destructor create_destructor (Vala.SourceReference source_reference = null);
		public Vala.TypeParameter create_type_parameter (string name, Vala.SourceReference source_reference);
		public Vala.Block create_block (Vala.SourceReference source_reference = null);
		public Vala.EmptyStatement create_empty_statement (Vala.SourceReference source_reference = null);
		public Vala.DeclarationStatement create_declaration_statement (Vala.LocalVariableDeclaration declaration, Vala.SourceReference source_reference);
		public Vala.LocalVariableDeclaration create_local_variable_declaration (Vala.DataType type_reference, Vala.SourceReference source_reference);
		public Vala.LocalVariableDeclaration create_local_variable_declaration_var_type (Vala.SourceReference source_reference);
		public Vala.VariableDeclarator create_variable_declarator (string name, Vala.Expression initializer = null, Vala.SourceReference source_reference = null);
		public Vala.InitializerList create_initializer_list (Vala.SourceReference source_reference);
		public Vala.ExpressionStatement create_expression_statement (Vala.Expression expression, Vala.SourceReference source_reference = null);
		public Vala.IfStatement create_if_statement (Vala.Expression condition, Vala.Block true_statement, Vala.Block false_statement, Vala.SourceReference source_reference);
		public Vala.SwitchStatement create_switch_statement (Vala.Expression expression, Vala.SourceReference source_reference);
		public Vala.SwitchSection create_switch_section (Vala.SourceReference source_reference);
		public Vala.SwitchLabel create_switch_label (Vala.Expression expression, Vala.SourceReference source_reference = null);
		public Vala.SwitchLabel create_switch_label_with_default (Vala.SourceReference source_reference = null);
		public Vala.WhileStatement create_while_statement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.DoStatement create_do_statement (Vala.Block body, Vala.Expression condition, Vala.SourceReference source_reference = null);
		public Vala.ForStatement create_for_statement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.ForeachStatement create_foreach_statement (Vala.DataType type_reference, string variable_name, Vala.Expression collection, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.BreakStatement create_break_statement (Vala.SourceReference source_reference);
		public Vala.ContinueStatement create_continue_statement (Vala.SourceReference source_reference);
		public Vala.ReturnStatement create_return_statement (Vala.Expression return_expression = null, Vala.SourceReference source_reference = null);
		public Vala.ThrowStatement create_throw_statement (Vala.Expression error_expression, Vala.SourceReference source_reference = null);
		public Vala.TryStatement create_try_statement (Vala.Block body, Vala.Block finally_body, Vala.SourceReference source_reference = null);
		public Vala.CatchClause create_catch_clause (Vala.DataType type_reference, string variable_name, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.LockStatement create_lock_statement (Vala.Expression resource, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.ArrayCreationExpression create_array_creation_expression (Vala.DataType element_type, int rank, Vala.InitializerList initializer_list, Vala.SourceReference source_reference);
		public Vala.BooleanLiteral create_boolean_literal (bool value, Vala.SourceReference source_reference);
		public Vala.CharacterLiteral create_character_literal (string value, Vala.SourceReference source_reference);
		public Vala.IntegerLiteral create_integer_literal (string value, Vala.SourceReference source_reference = null);
		public Vala.RealLiteral create_real_literal (string value, Vala.SourceReference source_reference);
		public Vala.StringLiteral create_string_literal (string value, Vala.SourceReference source_reference);
		public Vala.NullLiteral create_null_literal (Vala.SourceReference source_reference = null);
		public Vala.LiteralExpression create_literal_expression (Vala.Literal literal, Vala.SourceReference source_reference = null);
		public Vala.ParenthesizedExpression create_parenthesized_expression (Vala.Expression inner, Vala.SourceReference source_reference);
		public Vala.MemberAccess create_member_access (Vala.Expression inner, string member_name, Vala.SourceReference source_reference = null);
		public Vala.MemberAccess create_member_access_simple (string member_name, Vala.SourceReference source_reference = null);
		public Vala.MemberAccess create_member_access_pointer (Vala.Expression inner, string member_name, Vala.SourceReference source_reference = null);
		public Vala.InvocationExpression create_invocation_expression (Vala.Expression call, Vala.SourceReference source_reference = null);
		public Vala.ElementAccess create_element_access (Vala.Expression container, Vala.SourceReference source_reference);
		public Vala.BaseAccess create_base_access (Vala.SourceReference source_reference = null);
		public Vala.PostfixExpression create_postfix_expression (Vala.Expression inner, bool increment, Vala.SourceReference source_reference);
		public Vala.ObjectCreationExpression create_object_creation_expression (Vala.MemberAccess member_name, Vala.SourceReference source_reference);
		public Vala.SizeofExpression create_sizeof_expression (Vala.DataType type_reference, Vala.SourceReference source_reference);
		public Vala.TypeofExpression create_typeof_expression (Vala.DataType type_reference, Vala.SourceReference source_reference);
		public Vala.UnaryExpression create_unary_expression (Vala.UnaryOperator operator, Vala.Expression inner, Vala.SourceReference source_reference);
		public Vala.CastExpression create_cast_expression (Vala.Expression inner, Vala.DataType type_reference, Vala.SourceReference source_reference, bool is_silent_cast);
		public Vala.PointerIndirection create_pointer_indirection (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.AddressofExpression create_addressof_expression (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.ReferenceTransferExpression create_reference_transfer_expression (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.BinaryExpression create_binary_expression (Vala.BinaryOperator operator, Vala.Expression left, Vala.Expression right, Vala.SourceReference source_reference = null);
		public Vala.TypeCheck create_type_check (Vala.Expression expression, Vala.DataType type_reference, Vala.SourceReference source_reference);
		public Vala.ConditionalExpression create_conditional_expression (Vala.Expression condition, Vala.Expression true_expression, Vala.Expression false_expression, Vala.SourceReference source_reference);
		public Vala.LambdaExpression create_lambda_expression (Vala.Expression expression_body, Vala.SourceReference source_reference);
		public Vala.LambdaExpression create_lambda_expression_with_statement_body (Vala.Block statement_body, Vala.SourceReference source_reference);
		public Vala.Assignment create_assignment (Vala.Expression left, Vala.Expression right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference source_reference = null);
		public string library { get; set; }
		public weak bool memory_management { get; set; }
		public weak bool assert { get; set; }
		public weak bool checking { get; set; }
		public weak bool non_null { get; set; }
		public weak bool ccode_only { get; set; }
		public weak bool compile_only { get; set; }
		public string output { get; set; }
		public string basedir { get; set; }
		public string directory { get; set; }
		public weak bool debug { get; set; }
		public weak int optlevel { get; set; }
		public weak bool thread { get; set; }
		public Vala.Method module_init_method { get; set; }
		public weak bool save_temps { get; set; }
		public weak bool save_csources { get; }
		public weak bool save_cheaders { get; }
		public Vala.Namespace root { get; }
		public Vala.CodeGenerator codegen { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodegenerator.h")]
	public class CodeGenerator : Vala.CodeVisitor {
		public virtual void emit (Vala.CodeContext context);
		public virtual Vala.CodeBinding create_namespace_binding (Vala.Namespace node);
		public virtual Vala.CodeBinding create_class_binding (Vala.Class node);
		public virtual Vala.CodeBinding create_struct_binding (Vala.Struct node);
		public virtual Vala.CodeBinding create_interface_binding (Vala.Interface node);
		public virtual Vala.CodeBinding create_enum_binding (Vala.Enum node);
		public virtual Vala.CodeBinding create_enum_value_binding (Vala.EnumValue node);
		public virtual Vala.CodeBinding create_delegate_binding (Vala.Delegate node);
		public virtual Vala.CodeBinding create_constant_binding (Vala.Constant node);
		public virtual Vala.CodeBinding create_field_binding (Vala.Field node);
		public virtual Vala.CodeBinding create_method_binding (Vala.Method node);
		public virtual Vala.CodeBinding create_creation_method_binding (Vala.CreationMethod node);
		public virtual Vala.CodeBinding create_formal_parameter_binding (Vala.FormalParameter node);
		public virtual Vala.CodeBinding create_property_binding (Vala.Property node);
		public virtual Vala.CodeBinding create_property_accessor_binding (Vala.PropertyAccessor node);
		public virtual Vala.CodeBinding create_signal_binding (Vala.Signal node);
		public virtual Vala.CodeBinding create_constructor_binding (Vala.Constructor node);
		public virtual Vala.CodeBinding create_destructor_binding (Vala.Destructor node);
		public virtual Vala.CodeBinding create_type_parameter_binding (Vala.TypeParameter node);
		public virtual Vala.CodeBinding create_block_binding (Vala.Block node);
		public virtual Vala.CodeBinding create_empty_statement_binding (Vala.EmptyStatement node);
		public virtual Vala.CodeBinding create_declaration_statement_binding (Vala.DeclarationStatement node);
		public virtual Vala.CodeBinding create_local_variable_declaration_binding (Vala.LocalVariableDeclaration node);
		public virtual Vala.CodeBinding create_variable_declarator_binding (Vala.VariableDeclarator node);
		public virtual Vala.CodeBinding create_initializer_list_binding (Vala.InitializerList node);
		public virtual Vala.CodeBinding create_expression_statement_binding (Vala.ExpressionStatement node);
		public virtual Vala.CodeBinding create_if_statement_binding (Vala.IfStatement node);
		public virtual Vala.CodeBinding create_switch_statement_binding (Vala.SwitchStatement node);
		public virtual Vala.CodeBinding create_switch_section_binding (Vala.SwitchSection node);
		public virtual Vala.CodeBinding create_switch_label_binding (Vala.SwitchLabel node);
		public virtual Vala.CodeBinding create_while_statement_binding (Vala.WhileStatement node);
		public virtual Vala.CodeBinding create_do_statement_binding (Vala.DoStatement node);
		public virtual Vala.CodeBinding create_for_statement_binding (Vala.ForStatement node);
		public virtual Vala.CodeBinding create_foreach_statement_binding (Vala.ForeachStatement node);
		public virtual Vala.CodeBinding create_break_statement_binding (Vala.BreakStatement node);
		public virtual Vala.CodeBinding create_continue_statement_binding (Vala.ContinueStatement node);
		public virtual Vala.CodeBinding create_return_statement_binding (Vala.ReturnStatement node);
		public virtual Vala.CodeBinding create_throw_statement_binding (Vala.ThrowStatement node);
		public virtual Vala.CodeBinding create_try_statement_binding (Vala.TryStatement node);
		public virtual Vala.CodeBinding create_catch_clause_binding (Vala.CatchClause node);
		public virtual Vala.CodeBinding create_lock_statement_binding (Vala.LockStatement node);
		public virtual Vala.CodeBinding create_array_creation_expression_binding (Vala.ArrayCreationExpression node);
		public virtual Vala.CodeBinding create_boolean_literal_binding (Vala.BooleanLiteral node);
		public virtual Vala.CodeBinding create_character_literal_binding (Vala.CharacterLiteral node);
		public virtual Vala.CodeBinding create_integer_literal_binding (Vala.IntegerLiteral node);
		public virtual Vala.CodeBinding create_real_literal_binding (Vala.RealLiteral node);
		public virtual Vala.CodeBinding create_string_literal_binding (Vala.StringLiteral node);
		public virtual Vala.CodeBinding create_null_literal_binding (Vala.NullLiteral node);
		public virtual Vala.CodeBinding create_literal_expression_binding (Vala.LiteralExpression node);
		public virtual Vala.CodeBinding create_parenthesized_expression_binding (Vala.ParenthesizedExpression node);
		public virtual Vala.CodeBinding create_member_access_binding (Vala.MemberAccess node);
		public virtual Vala.CodeBinding create_member_access_simple_binding (Vala.MemberAccess node);
		public virtual Vala.CodeBinding create_invocation_expression_binding (Vala.InvocationExpression node);
		public virtual Vala.CodeBinding create_element_access_binding (Vala.ElementAccess node);
		public virtual Vala.CodeBinding create_base_access_binding (Vala.BaseAccess node);
		public virtual Vala.CodeBinding create_postfix_expression_binding (Vala.PostfixExpression node);
		public virtual Vala.CodeBinding create_object_creation_expression_binding (Vala.ObjectCreationExpression node);
		public virtual Vala.CodeBinding create_sizeof_expression_binding (Vala.SizeofExpression node);
		public virtual Vala.CodeBinding create_typeof_expression_binding (Vala.TypeofExpression node);
		public virtual Vala.CodeBinding create_unary_expression_binding (Vala.UnaryExpression node);
		public virtual Vala.CodeBinding create_cast_expression_binding (Vala.CastExpression node);
		public virtual Vala.CodeBinding create_pointer_indirection_binding (Vala.PointerIndirection node);
		public virtual Vala.CodeBinding create_addressof_expression_binding (Vala.AddressofExpression node);
		public virtual Vala.CodeBinding create_reference_transfer_expression_binding (Vala.ReferenceTransferExpression node);
		public virtual Vala.CodeBinding create_binary_expression_binding (Vala.BinaryExpression node);
		public virtual Vala.CodeBinding create_type_check_binding (Vala.TypeCheck node);
		public virtual Vala.CodeBinding create_conditional_expression_binding (Vala.ConditionalExpression node);
		public virtual Vala.CodeBinding create_lambda_expression_binding (Vala.LambdaExpression node);
		public virtual Vala.CodeBinding create_lambda_expression_with_statement_body_binding (Vala.LambdaExpression node);
		public virtual Vala.CodeBinding create_assignment_binding (Vala.Assignment node);
		public CodeGenerator ();
	}
	[CCode (cheader_filename = "vala/valacodenode.h")]
	public abstract class CodeNode : GLib.Object {
		public GLib.List<Vala.Attribute> attributes;
		public virtual void accept (Vala.CodeVisitor visitor);
		public virtual void accept_children (Vala.CodeVisitor visitor);
		public virtual void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public virtual void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Attribute get_attribute (string name);
		public virtual string to_string ();
		public weak Vala.CodeNode parent_node { get; set; }
		public Vala.SourceReference source_reference { get; set; }
		public Vala.CCodeNode ccodenode { get; set; }
		public Vala.CodeBinding code_binding { get; set; }
		public weak bool error { get; set; }
		public weak bool tree_can_fail { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodevisitor.h")]
	public abstract class CodeVisitor : GLib.Object {
		public virtual void visit_source_file (Vala.SourceFile source_file);
		public virtual void visit_namespace (Vala.Namespace ns);
		public virtual void visit_class (Vala.Class cl);
		public virtual void visit_struct (Vala.Struct st);
		public virtual void visit_interface (Vala.Interface iface);
		public virtual void visit_enum (Vala.Enum en);
		public virtual void visit_enum_value (Vala.EnumValue ev);
		public virtual void visit_delegate (Vala.Delegate d);
		public virtual void visit_member (Vala.Member m);
		public virtual void visit_constant (Vala.Constant c);
		public virtual void visit_field (Vala.Field f);
		public virtual void visit_method (Vala.Method m);
		public virtual void visit_creation_method (Vala.CreationMethod m);
		public virtual void visit_formal_parameter (Vala.FormalParameter p);
		public virtual void visit_property (Vala.Property prop);
		public virtual void visit_property_accessor (Vala.PropertyAccessor acc);
		public virtual void visit_signal (Vala.Signal sig);
		public virtual void visit_constructor (Vala.Constructor c);
		public virtual void visit_destructor (Vala.Destructor d);
		public virtual void visit_named_argument (Vala.NamedArgument n);
		public virtual void visit_type_parameter (Vala.TypeParameter p);
		public virtual void visit_namespace_reference (Vala.NamespaceReference ns);
		public virtual void visit_data_type (Vala.DataType type);
		public virtual void visit_block (Vala.Block b);
		public virtual void visit_empty_statement (Vala.EmptyStatement stmt);
		public virtual void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public virtual void visit_local_variable_declaration (Vala.LocalVariableDeclaration decl);
		public virtual void visit_variable_declarator (Vala.VariableDeclarator decl);
		public virtual void visit_initializer_list (Vala.InitializerList list);
		public virtual void visit_expression_statement (Vala.ExpressionStatement stmt);
		public virtual void visit_if_statement (Vala.IfStatement stmt);
		public virtual void visit_switch_statement (Vala.SwitchStatement stmt);
		public virtual void visit_switch_section (Vala.SwitchSection section);
		public virtual void visit_switch_label (Vala.SwitchLabel label);
		public virtual void visit_while_statement (Vala.WhileStatement stmt);
		public virtual void visit_do_statement (Vala.DoStatement stmt);
		public virtual void visit_for_statement (Vala.ForStatement stmt);
		public virtual void visit_foreach_statement (Vala.ForeachStatement stmt);
		public virtual void visit_break_statement (Vala.BreakStatement stmt);
		public virtual void visit_continue_statement (Vala.ContinueStatement stmt);
		public virtual void visit_return_statement (Vala.ReturnStatement stmt);
		public virtual void visit_throw_statement (Vala.ThrowStatement stmt);
		public virtual void visit_try_statement (Vala.TryStatement stmt);
		public virtual void visit_catch_clause (Vala.CatchClause clause);
		public virtual void visit_lock_statement (Vala.LockStatement stmt);
		public virtual void visit_array_creation_expression (Vala.ArrayCreationExpression expr);
		public virtual void visit_boolean_literal (Vala.BooleanLiteral lit);
		public virtual void visit_character_literal (Vala.CharacterLiteral lit);
		public virtual void visit_integer_literal (Vala.IntegerLiteral lit);
		public virtual void visit_real_literal (Vala.RealLiteral lit);
		public virtual void visit_string_literal (Vala.StringLiteral lit);
		public virtual void visit_null_literal (Vala.NullLiteral lit);
		public virtual void visit_literal_expression (Vala.LiteralExpression expr);
		public virtual void visit_parenthesized_expression (Vala.ParenthesizedExpression expr);
		public virtual void visit_member_access (Vala.MemberAccess expr);
		public virtual void visit_invocation_expression (Vala.InvocationExpression expr);
		public virtual void visit_element_access (Vala.ElementAccess expr);
		public virtual void visit_base_access (Vala.BaseAccess expr);
		public virtual void visit_postfix_expression (Vala.PostfixExpression expr);
		public virtual void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public virtual void visit_sizeof_expression (Vala.SizeofExpression expr);
		public virtual void visit_typeof_expression (Vala.TypeofExpression expr);
		public virtual void visit_unary_expression (Vala.UnaryExpression expr);
		public virtual void visit_cast_expression (Vala.CastExpression expr);
		public virtual void visit_pointer_indirection (Vala.PointerIndirection expr);
		public virtual void visit_addressof_expression (Vala.AddressofExpression expr);
		public virtual void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public virtual void visit_binary_expression (Vala.BinaryExpression expr);
		public virtual void visit_type_check (Vala.TypeCheck expr);
		public virtual void visit_conditional_expression (Vala.ConditionalExpression expr);
		public virtual void visit_lambda_expression (Vala.LambdaExpression expr);
		public virtual void visit_assignment (Vala.Assignment a);
		public virtual void visit_end_full_expression (Vala.Expression expr);
	}
	[CCode (cheader_filename = "vala/valaconditionalexpression.h")]
	public class ConditionalExpression : Vala.Expression {
		public ConditionalExpression (Vala.Expression cond, Vala.Expression true_expr, Vala.Expression false_expr, Vala.SourceReference source);
		public Vala.Expression condition { get; set construct; }
		public Vala.Expression true_expression { get; set construct; }
		public Vala.Expression false_expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaconstant.h")]
	public class Constant : Vala.Member, Vala.Lockable {
		public Constant (string name, Vala.DataType type_reference, Vala.Expression initializer, Vala.SourceReference source_reference);
		public string get_cname ();
		public void process_attributes ();
		public Vala.DataType type_reference { get; set; }
		public Vala.Expression initializer { get; set; }
	}
	[CCode (cheader_filename = "vala/valaconstructor.h")]
	public class Constructor : Vala.Symbol {
		public Constructor (Vala.SourceReference source);
		public Vala.Block body { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valacontinuestatement.h")]
	public class ContinueStatement : Vala.CodeNode, Vala.Statement {
		public ContinueStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacreationmethod.h")]
	public class CreationMethod : Vala.Method {
		public CreationMethod (string type_name, string name, Vala.SourceReference source_reference = null);
		public string type_name { get; set; }
		public weak int n_construction_params { get; set; }
	}
	[CCode (cheader_filename = "vala/valadatatype.h")]
	public class DataType : Vala.CodeNode {
		public DataType ();
		public void add_type_argument (Vala.DataType arg);
		public Gee.List<Vala.DataType> get_type_arguments ();
		public void remove_all_type_arguments ();
		public virtual string get_cname (bool var_type = false, bool const_type = false);
		public string get_const_cname ();
		public virtual Vala.DataType copy ();
		public bool equals (Vala.DataType type2);
		public virtual bool stricter (Vala.DataType type2);
		public virtual bool compatible (Vala.DataType target_type);
		public virtual bool is_invokable ();
		public virtual Vala.DataType get_return_type ();
		public virtual Gee.Collection<Vala.FormalParameter> get_parameters ();
		public virtual bool is_reference_type_or_type_parameter ();
		public virtual bool is_array ();
		public virtual Gee.Collection<Vala.Symbol> get_symbols ();
		public virtual Vala.Symbol get_pointer_member (string member_name);
		public weak bool transfers_ownership { get; set; }
		public weak bool takes_ownership { get; set; }
		public weak bool is_out { get; set; }
		public weak bool nullable { get; set; }
		public weak bool is_null { get; set; }
		public weak Vala.Typesymbol data_type { get; set; }
		public Vala.TypeParameter type_parameter { get; set; }
		public weak bool floating_reference { get; set; }
		public weak bool is_ref { get; set; }
	}
	[CCode (cheader_filename = "vala/valadeclarationstatement.h")]
	public class DeclarationStatement : Vala.CodeNode, Vala.Statement {
		public DeclarationStatement (Vala.LocalVariableDeclaration decl, Vala.SourceReference source);
		public Vala.LocalVariableDeclaration declaration { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valadelegate.h")]
	public class Delegate : Vala.Typesymbol {
		public Delegate (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter p);
		public void add_parameter (Vala.FormalParameter param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public bool matches_method (Vala.Method m);
		public void set_cname (string cname);
		public void process_attributes ();
		public Vala.DataType return_type { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valadelegatetype.h")]
	public class DelegateType : Vala.DataType {
		public DelegateType (Vala.Delegate delegate_symbol);
		public Vala.Delegate delegate_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valadestructor.h")]
	public class Destructor : Vala.Symbol {
		public Destructor (Vala.SourceReference source_reference = null);
		public Vala.Block body { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valadostatement.h")]
	public class DoStatement : Vala.CodeNode, Vala.Statement {
		public DoStatement (Vala.Block body, Vala.Expression condition, Vala.SourceReference source_reference = null);
		public Vala.Block body { get; set; }
		public Vala.Expression condition { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaelementaccess.h")]
	public class ElementAccess : Vala.Expression {
		public void append_index (Vala.Expression index);
		public Gee.List<Vala.Expression> get_indices ();
		public ElementAccess (Vala.Expression container, Vala.SourceReference source_reference);
		public Vala.Expression container { get; set; }
	}
	[CCode (cheader_filename = "vala/valaemptystatement.h")]
	public class EmptyStatement : Vala.CodeNode, Vala.Statement {
		public EmptyStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valaenum.h")]
	public class Enum : Vala.Typesymbol {
		public Enum (string name, Vala.SourceReference source_reference = null);
		public void add_value (Vala.EnumValue value);
		public void add_method (Vala.Method m);
		public Gee.Collection<Vala.EnumValue> get_values ();
		public Gee.Collection<Vala.Method> get_methods ();
		public string get_cprefix ();
		public void set_cprefix (string cprefix);
		public void process_attributes ();
		public weak bool is_flags { get; set; }
		public weak bool error_domain { get; set; }
	}
	[CCode (cheader_filename = "vala/valaenumvalue.h")]
	public class EnumValue : Vala.Symbol {
		public EnumValue (string name);
		public EnumValue.with_value (string name, Vala.Expression value);
		public string get_cname ();
		public Vala.Expression value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpression.h")]
	public abstract class Expression : Vala.CodeNode {
		public Gee.ArrayList<Vala.VariableDeclarator> temp_vars;
		public abstract bool is_pure ();
		public Vala.DataType static_type { get; set; }
		public Vala.DataType expected_type { get; set; }
		public weak Vala.Symbol symbol_reference { get; set; }
		public weak bool ref_leaked { get; set; }
		public weak bool ref_missing { get; set; }
		public weak bool ref_sink { get; set; }
		public weak bool can_fail { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpressionstatement.h")]
	public class ExpressionStatement : Vala.CodeNode, Vala.Statement {
		public ExpressionStatement (Vala.Expression expression, Vala.SourceReference source_reference = null);
		public Vala.Property assigned_property ();
		public Vala.Expression expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valafield.h")]
	public class Field : Vala.Member, Vala.Lockable {
		public Field (string name, Vala.DataType type_reference, Vala.Expression initializer, Vala.SourceReference source_reference = null);
		public string get_cname ();
		public string get_default_cname ();
		public void process_attributes ();
		public Vala.DataType type_reference { get; set; }
		public Vala.Expression initializer { get; set; }
		public weak bool instance { get; set; }
		public weak bool is_volatile { get; set; }
		public weak bool no_array_length { get; set; }
	}
	[CCode (cheader_filename = "vala/valaforeachstatement.h")]
	public class ForeachStatement : Vala.Block {
		public ForeachStatement (Vala.DataType type_reference, string variable_name, Vala.Expression collection, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.DataType type_reference { get; set; }
		public string variable_name { get; set construct; }
		public Vala.Expression collection { get; set construct; }
		public Vala.Block body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
		public Vala.VariableDeclarator collection_variable_declarator { get; set; }
		public Vala.VariableDeclarator iterator_variable_declarator { get; set; }
	}
	[CCode (cheader_filename = "vala/valaformalparameter.h")]
	public class FormalParameter : Vala.Symbol {
		public FormalParameter (string _name, Vala.DataType type, Vala.SourceReference source = null);
		public FormalParameter.with_ellipsis (Vala.SourceReference source = null);
		public Vala.DataType type_reference { get; set; }
		public weak bool ellipsis { get; set; }
		public Vala.Expression default_expression { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool construct_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valaforstatement.h")]
	public class ForStatement : Vala.CodeNode, Vala.Statement {
		public ForStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public void add_initializer (Vala.Expression init);
		public Gee.Collection<Vala.Expression> get_initializer ();
		public void add_iterator (Vala.Expression iter);
		public Gee.Collection<Vala.Expression> get_iterator ();
		public Vala.Expression condition { get; set construct; }
		public Vala.Block body { get; set; }
	}
	[CCode (cheader_filename = "vala/valaifstatement.h")]
	public class IfStatement : Vala.CodeNode, Vala.Statement {
		public IfStatement (Vala.Expression cond, Vala.Block true_stmt, Vala.Block false_stmt, Vala.SourceReference source);
		public Vala.Expression condition { get; set construct; }
		public Vala.Block true_statement { get; set construct; }
		public Vala.Block false_statement { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valainitializerlist.h")]
	public class InitializerList : Vala.Expression {
		public void append (Vala.Expression expr);
		public Gee.Collection<Vala.Expression> get_initializers ();
		public InitializerList (Vala.SourceReference source_reference);
		public weak int size { get; }
	}
	[CCode (cheader_filename = "vala/valainstancecast.h")]
	public class InstanceCast : Vala.CCodeFunctionCall {
		public InstanceCast (Vala.CCodeExpression expr, Vala.Typesymbol type);
		public weak Vala.Typesymbol type_reference { get; set construct; }
		public Vala.CCodeExpression inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaintegerliteral.h")]
	public class IntegerLiteral : Vala.Literal {
		public IntegerLiteral (string i, Vala.SourceReference source = null);
		public string get_type_name ();
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valainterface.h")]
	public class Interface : Vala.Typesymbol {
		public Interface (string name, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter p);
		public Gee.Collection<Vala.TypeParameter> get_type_parameters ();
		public void add_prerequisite (Vala.DataType type);
		public void prepend_prerequisite (Vala.DataType type);
		public Gee.Collection<Vala.DataType> get_prerequisites ();
		public void add_method (Vala.Method m);
		public Gee.Collection<Vala.Method> get_methods ();
		public void add_field (Vala.Field f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_property (Vala.Property prop);
		public Gee.Collection<Vala.Property> get_properties ();
		public void add_signal (Vala.Signal sig);
		public Gee.Collection<Vala.Signal> get_signals ();
		public string get_lower_case_csuffix ();
		public void set_lower_case_csuffix (string csuffix);
		public void process_attributes ();
		public string get_type_cname ();
		public void set_type_cname (string type_cname);
		public weak bool is_static { get; set; }
		public weak bool declaration_only { get; set; }
	}
	[CCode (cheader_filename = "vala/valainterfacetype.h")]
	public class InterfaceType : Vala.ReferenceType {
		public InterfaceType (Vala.Interface interface_symbol);
		public weak Vala.Interface interface_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valainterfacewriter.h")]
	public class InterfaceWriter : Vala.CodeVisitor {
		public void write_file (Vala.CodeContext context, string filename);
		public InterfaceWriter ();
	}
	[CCode (cheader_filename = "vala/valainvalidtype.h")]
	public class InvalidType : Vala.DataType {
		public InvalidType ();
	}
	[CCode (cheader_filename = "vala/valainvocationexpression.h")]
	public class InvocationExpression : Vala.Expression {
		public Vala.Expression _call;
		public InvocationExpression (Vala.Expression call, Vala.SourceReference source_reference = null);
		public void add_argument (Vala.Expression arg);
		public Gee.Collection<Vala.Expression> get_argument_list ();
		public void append_array_size (Vala.CCodeExpression size);
		public Gee.List<Vala.CCodeExpression> get_array_sizes ();
		public Vala.Expression call { get; set construct; }
		public Vala.CCodeExpression delegate_target { get; set; }
	}
	[CCode (cheader_filename = "vala/valalambdaexpression.h")]
	public class LambdaExpression : Vala.Expression {
		public LambdaExpression (Vala.Expression expression_body, Vala.SourceReference source_reference);
		public LambdaExpression.with_statement_body (Vala.Block statement_body, Vala.SourceReference source_reference);
		public void add_parameter (string param);
		public Gee.Collection<string> get_parameters ();
		public Vala.Expression expression_body { get; set; }
		public Vala.Block statement_body { get; set; }
		public Vala.Method method { get; set; }
	}
	[CCode (cheader_filename = "vala/valaliteral.h")]
	public abstract class Literal : Vala.CodeNode {
		public Vala.DataType static_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valaliteralexpression.h")]
	public class LiteralExpression : Vala.Expression {
		public LiteralExpression (Vala.Literal _literal, Vala.SourceReference source = null);
		public Vala.Literal literal { get; construct; }
	}
	[CCode (cheader_filename = "vala/valalocalvariabledeclaration.h")]
	public class LocalVariableDeclaration : Vala.CodeNode {
		public LocalVariableDeclaration (Vala.DataType type_reference, Vala.SourceReference source_reference);
		public LocalVariableDeclaration.var_type (Vala.SourceReference source_reference);
		public void add_declarator (Vala.VariableDeclarator declarator);
		public Gee.Collection<Vala.VariableDeclarator> get_variable_declarators ();
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valalockstatement.h")]
	public class LockStatement : Vala.CodeNode, Vala.Statement {
		public LockStatement (Vala.Expression resource, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.Expression resource { get; set construct; }
		public Vala.Block body { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valamember.h")]
	public class Member : Vala.Symbol {
		public void add_cheader_filename (string filename);
		public Member ();
	}
	[CCode (cheader_filename = "vala/valamemberaccess.h")]
	public class MemberAccess : Vala.Expression {
		public MemberAccess (Vala.Expression inner, string member_name, Vala.SourceReference source_reference = null);
		public MemberAccess.simple (string member_name, Vala.SourceReference source_reference = null);
		public MemberAccess.pointer (Vala.Expression inner, string member_name, Vala.SourceReference source_reference = null);
		public void add_type_argument (Vala.DataType arg);
		public Gee.Collection<Vala.DataType> get_type_arguments ();
		public Vala.Expression inner { get; set; }
		public string member_name { get; set; }
		public weak bool pointer_member_access { get; set; }
		public weak bool prototype_access { get; set; }
		public weak bool creation_member { get; set; }
	}
	[CCode (cheader_filename = "vala/valamemberinitializer.h")]
	public class MemberInitializer : Vala.CodeNode {
		public MemberInitializer (string name, Vala.Expression initializer, Vala.SourceReference source_reference = null);
		public string name { get; set; }
		public Vala.Expression initializer { get; set; }
		public weak Vala.Symbol symbol_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valamemorymanager.h")]
	public class MemoryManager : Vala.CodeVisitor {
		public void analyze (Vala.CodeContext context);
		public MemoryManager ();
	}
	[CCode (cheader_filename = "vala/valamethod.h")]
	public class Method : Vala.Member {
		public const string DEFAULT_SENTINEL;
		public Method (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public void add_parameter (Vala.FormalParameter param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public string get_cname ();
		public virtual string get_default_cname ();
		public string get_real_cname ();
		public void set_cname (string cname);
		public void process_attributes ();
		public bool equals (Vala.Method m2);
		public void add_error_domain (Vala.DataType error_domain);
		public Gee.Collection<Vala.DataType> get_error_domains ();
		public void add_precondition (Vala.Expression precondition);
		public Gee.Collection<Vala.Expression> get_preconditions ();
		public void add_postcondition (Vala.Expression postcondition);
		public Gee.Collection<Vala.Expression> get_postconditions ();
		public Vala.DataType return_type { get; set; }
		public Vala.Block body { get; set; }
		public weak bool instance { get; set; }
		public string vfunc_name { get; set; }
		public string sentinel { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak bool is_inline { get; set; }
		public weak bool returns_modified_pointer { get; set; }
		public weak bool instance_last { get; set; }
		public weak Vala.Method base_method { get; set; }
		public Vala.Method base_interface_method { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public Vala.VariableDeclarator result_var { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool printf_format { get; set; }
	}
	[CCode (cheader_filename = "vala/valamethodtype.h")]
	public class MethodType : Vala.DataType {
		public MethodType (Vala.Method method_symbol);
		public Vala.Method method_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valanamedargument.h")]
	public class NamedArgument : Vala.CodeNode {
		public NamedArgument (string _name, Vala.Expression arg, Vala.SourceReference source);
		public string name { get; set construct; }
		public Vala.Expression argument { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valanamespace.h")]
	public class Namespace : Vala.Symbol {
		public Namespace (string name, Vala.SourceReference source_reference = null);
		public void add_namespace (Vala.Namespace ns);
		public Gee.Collection<Vala.Namespace> get_namespaces ();
		public void add_class (Vala.Class cl);
		public void add_interface (Vala.Interface iface);
		public void add_struct (Vala.Struct st);
		public void add_enum (Vala.Enum en);
		public void add_delegate (Vala.Delegate d);
		public Gee.Collection<Vala.Struct> get_structs ();
		public Gee.Collection<Vala.Class> get_classes ();
		public Gee.Collection<Vala.Interface> get_interfaces ();
		public void add_constant (Vala.Constant constant);
		public void add_field (Vala.Field f);
		public void add_method (Vala.Method m);
		public Gee.List<string> get_cprefixes ();
		public void add_cprefix (string cprefix);
		public void set_lower_case_cprefix (string cprefix);
		public string get_cheader_filename ();
		public void set_cheader_filename (string cheader_filename);
		public void process_attributes ();
		public weak bool pkg { get; set; }
	}
	[CCode (cheader_filename = "vala/valanamespacereference.h")]
	public class NamespaceReference : Vala.CodeNode {
		public NamespaceReference (string name, Vala.SourceReference source_reference);
		public string name { get; set; }
		public weak Vala.Symbol namespace_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valanullliteral.h")]
	public class NullLiteral : Vala.Literal {
		public NullLiteral (Vala.SourceReference source = null);
	}
	[CCode (cheader_filename = "vala/valanulltype.h")]
	public class NullType : Vala.ReferenceType {
		public NullType ();
	}
	[CCode (cheader_filename = "vala/valaobjectcreationexpression.h")]
	public class ObjectCreationExpression : Vala.Expression {
		public ObjectCreationExpression (Vala.MemberAccess member_name, Vala.SourceReference source_reference);
		public void add_argument (Vala.Expression arg);
		public Gee.Collection<Vala.Expression> get_argument_list ();
		public void add_member_initializer (Vala.MemberInitializer init);
		public Gee.Collection<Vala.MemberInitializer> get_object_initializer ();
		public Vala.DataType type_reference { get; set; }
		public Vala.Method constructor { get; set; }
		public Vala.MemberAccess member_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valaparenthesizedexpression.h")]
	public class ParenthesizedExpression : Vala.Expression {
		public ParenthesizedExpression (Vala.Expression _inner, Vala.SourceReference source);
		public Vala.Expression inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaparser.h")]
	public class Parser : Vala.CodeVisitor {
		public void parse (Vala.CodeContext context);
		public void push_comment (string comment_item, bool file_comment);
		public string pop_comment ();
		public void parse_file (Vala.SourceFile source_file);
		public Parser ();
	}
	[CCode (cheader_filename = "vala/valapointerindirection.h")]
	public class PointerIndirection : Vala.Expression {
		public PointerIndirection (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valapointertype.h")]
	public class PointerType : Vala.DataType {
		public PointerType (Vala.DataType base_type);
		public Vala.DataType base_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valapostfixexpression.h")]
	public class PostfixExpression : Vala.Expression {
		public PostfixExpression (Vala.Expression _inner, bool inc, Vala.SourceReference source);
		public Vala.Expression inner { get; set construct; }
		public weak bool increment { get; set; }
	}
	[CCode (cheader_filename = "vala/valapropertyaccessor.h")]
	public class PropertyAccessor : Vala.CodeNode {
		public PropertyAccessor (bool readable, bool writable, bool construction, Vala.Block body, Vala.SourceReference source_reference);
		public weak Vala.Property prop { get; set; }
		public weak bool readable { get; set; }
		public weak bool writable { get; set; }
		public weak bool construction { get; set; }
		public Vala.Block body { get; set; }
		public Vala.FormalParameter value_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valaproperty.h")]
	public class Property : Vala.Member, Vala.Lockable {
		public Property (string _name, Vala.DataType type, Vala.PropertyAccessor _get_accessor, Vala.PropertyAccessor _set_accessor, Vala.SourceReference source);
		public string get_upper_case_cname ();
		public Vala.CCodeConstant get_canonical_cconstant ();
		public void process_attributes ();
		public bool equals (Vala.Property prop2);
		public Vala.DataType type_reference { get; set; }
		public Vala.PropertyAccessor get_accessor { get; set; }
		public Vala.PropertyAccessor set_accessor { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool notify { get; set; }
		public weak bool no_accessor_method { get; set; }
		public weak bool interface_only { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak Vala.Property base_property { get; set; }
		public Vala.Property base_interface_property { get; set; }
	}
	[CCode (cheader_filename = "vala/valarealliteral.h")]
	public class RealLiteral : Vala.Literal {
		public RealLiteral (string r, Vala.SourceReference source);
		public string get_type_name ();
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valareferencetransferexpression.h")]
	public class ReferenceTransferExpression : Vala.Expression {
		public ReferenceTransferExpression (Vala.Expression inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valareferencetype.h")]
	public abstract class ReferenceType : Vala.DataType {
	}
	[CCode (cheader_filename = "vala/valareport.h")]
	public static class Report {
		public static int get_warnings ();
		public static int get_errors ();
		public static void warning (Vala.SourceReference source, string message);
		public static void error (Vala.SourceReference source, string message);
	}
	[CCode (cheader_filename = "vala/valareturnstatement.h")]
	public class ReturnStatement : Vala.CodeNode, Vala.Statement {
		public ReturnStatement (Vala.Expression return_expression = null, Vala.SourceReference source_reference = null);
		public Vala.Expression return_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valascope.h")]
	public class Scope : GLib.Object {
		public Scope (Vala.Symbol owner = null);
		public void add (string name, Vala.Symbol sym);
		public Vala.Symbol lookup (string name);
		public weak Vala.Symbol owner { get; set; }
		public weak Vala.Scope parent_scope { get; set; }
	}
	[CCode (cheader_filename = "vala/valasemanticanalyzer.h")]
	public class SemanticAnalyzer : Vala.CodeVisitor {
		public SemanticAnalyzer ();
		public void add_binding_provider (Vala.BindingProvider binding_provider);
		public void analyze (Vala.CodeContext context);
		public static Vala.Symbol symbol_lookup_inherited (Vala.Symbol sym, string name);
		public static Vala.DataType get_actual_type (Vala.DataType derived_instance_type, Vala.Symbol generic_member, Vala.DataType generic_type, Vala.CodeNode node_reference);
	}
	[CCode (cheader_filename = "vala/valasignal.h")]
	public class Signal : Vala.Member, Vala.Lockable {
		public Signal (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
		public void add_parameter (Vala.FormalParameter param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.Delegate get_delegate ();
		public string get_cname ();
		public void set_cname (string cname);
		public Vala.CCodeConstant get_canonical_cconstant ();
		public void process_attributes ();
		public Vala.DataType return_type { get; set; }
		public weak bool has_emitter { get; set; }
	}
	[CCode (cheader_filename = "vala/valasignaltype.h")]
	public class SignalType : Vala.DataType {
		public SignalType (Vala.Signal signal_symbol);
		public Vala.Signal signal_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valasizeofexpression.h")]
	public class SizeofExpression : Vala.Expression {
		public SizeofExpression (Vala.DataType type, Vala.SourceReference source);
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valasourcefile.h")]
	public class SourceFile : GLib.Object {
		public SourceFile (Vala.CodeContext context, string filename, bool pkg = false);
		public void add_using_directive (Vala.NamespaceReference ns);
		public Gee.Collection<Vala.NamespaceReference> get_using_directives ();
		public void add_node (Vala.CodeNode node);
		public Gee.Collection<Vala.CodeNode> get_nodes ();
		public void accept (Vala.CodeVisitor visitor);
		public void accept_children (Vala.CodeVisitor visitor);
		public string get_cheader_filename ();
		public string get_csource_filename ();
		public string get_cinclude_filename ();
		public void add_symbol_dependency (Vala.Symbol sym, Vala.SourceFileDependencyType dep_type);
		public void add_type_dependency (Vala.DataType type, Vala.SourceFileDependencyType dep_type);
		public Gee.Collection<string> get_header_external_includes ();
		public void add_header_internal_include (string include);
		public Gee.Collection<string> get_header_internal_includes ();
		public Gee.Collection<string> get_source_external_includes ();
		public Gee.Collection<string> get_source_internal_includes ();
		public Gee.Collection<weak Vala.SourceFile> get_header_internal_full_dependencies ();
		public Gee.Collection<weak Vala.SourceFile> get_header_internal_dependencies ();
		public string filename { get; set; }
		public string comment { get; set; }
		public weak bool pkg { get; set; }
		public Vala.SourceFileCycle cycle { get; set; }
		public weak bool is_cycle_head { get; set; }
		public weak int mark { get; set; }
		public weak Vala.CodeContext context { get; set; }
	}
	[CCode (cheader_filename = "vala/valasourcefilecycle.h")]
	public class SourceFileCycle : GLib.Object {
		public Gee.List<weak Vala.SourceFile> files;
		public weak Vala.SourceFile head;
		public SourceFileCycle ();
	}
	[CCode (cheader_filename = "vala/valasourcereference.h")]
	public class SourceReference : GLib.Object {
		public SourceReference (Vala.SourceFile _file, int _first_line = 0, int _first_column = 0, int _last_line = 0, int _last_column = 0);
		public SourceReference.with_comment (Vala.SourceFile _file, int _first_line, int _first_column, int _last_line, int _last_column, string _comment);
		public string to_string ();
		public weak Vala.SourceFile file { get; set; }
		public weak int first_line { get; set; }
		public weak int first_column { get; set; }
		public weak int last_line { get; set; }
		public weak int last_column { get; set; }
		public string comment { get; set; }
	}
	[CCode (cheader_filename = "vala/valastringliteral.h")]
	public class StringLiteral : Vala.Literal {
		public StringLiteral (string s, Vala.SourceReference source);
		public string eval ();
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valastruct.h")]
	public class Struct : Vala.Typesymbol {
		public Struct (string name, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter p);
		public void add_constant (Vala.Constant c);
		public void add_field (Vala.Field f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_method (Vala.Method m);
		public Gee.Collection<Vala.Method> get_methods ();
		public bool is_integer_type ();
		public bool is_floating_type ();
		public int get_rank ();
		public void process_attributes ();
		public void set_type_id (string name);
		public void add_base_type (Vala.DataType type);
		public Gee.Collection<Vala.DataType> get_base_types ();
		public bool is_simple_type ();
		public void set_simple_type (bool simple_type);
		public Vala.Method default_construction_method { get; set; }
	}
	[CCode (cheader_filename = "vala/valaswitchlabel.h")]
	public class SwitchLabel : Vala.CodeNode {
		public SwitchLabel (Vala.Expression expr, Vala.SourceReference source = null);
		public SwitchLabel.with_default (Vala.SourceReference source = null);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valaswitchsection.h")]
	public class SwitchSection : Vala.Block {
		public SwitchSection (Vala.SourceReference source_reference);
		public void add_label (Vala.SwitchLabel label);
		public Gee.Collection<Vala.SwitchLabel> get_labels ();
		public bool has_default_label ();
		public void add_statement (Vala.Statement stmt);
		public Gee.Collection<Vala.Statement> get_statements ();
	}
	[CCode (cheader_filename = "vala/valaswitchstatement.h")]
	public class SwitchStatement : Vala.CodeNode, Vala.Statement {
		public SwitchStatement (Vala.Expression expression, Vala.SourceReference source_reference);
		public void add_section (Vala.SwitchSection section);
		public Gee.Collection<Vala.SwitchSection> get_sections ();
		public Vala.Expression expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valasymbol.h")]
	public abstract class Symbol : Vala.CodeNode {
		public bool is_internal_symbol ();
		public string get_full_name ();
		public virtual string get_cprefix ();
		public virtual string get_lower_case_cname (string infix = null);
		public virtual string get_lower_case_cprefix ();
		public virtual Gee.Collection<string> get_cheader_filenames ();
		public static string camel_case_to_lower_case (string camel_case);
		public weak Vala.Symbol parent_symbol { get; }
		public weak Vala.Scope owner { get; set; }
		public string name { get; set; }
		public weak bool active { get; set; }
		public weak Vala.SymbolAccessibility access { get; set; }
		public Vala.Scope scope { get; }
		public weak bool is_imported { get; set; }
	}
	[CCode (cheader_filename = "vala/valasymbolresolver.h")]
	public class SymbolResolver : Vala.CodeVisitor {
		public void resolve (Vala.CodeContext context);
		public SymbolResolver ();
	}
	[CCode (cheader_filename = "vala/valathrowstatement.h")]
	public class ThrowStatement : Vala.CodeNode, Vala.Statement {
		public ThrowStatement (Vala.Expression error_expression, Vala.SourceReference source_reference = null);
		public Vala.Expression error_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valatrystatement.h")]
	public class TryStatement : Vala.CodeNode, Vala.Statement {
		public TryStatement (Vala.Block body, Vala.Block finally_body, Vala.SourceReference source_reference = null);
		public void add_catch_clause (Vala.CatchClause clause);
		public Gee.Collection<Vala.CatchClause> get_catch_clauses ();
		public Vala.Block body { get; set; }
		public Vala.Block finally_body { get; set; }
	}
	[CCode (cheader_filename = "vala/valatypecheck.h")]
	public class TypeCheck : Vala.Expression {
		public TypeCheck (Vala.Expression expr, Vala.DataType type, Vala.SourceReference source);
		public Vala.Expression expression { get; set construct; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valatypeofexpression.h")]
	public class TypeofExpression : Vala.Expression {
		public TypeofExpression (Vala.DataType type, Vala.SourceReference source);
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valatypeparameter.h")]
	public class TypeParameter : Vala.Symbol {
		public weak Vala.Typesymbol type;
		public TypeParameter (string _name, Vala.SourceReference source);
		public Vala.Array get_array (int rank);
		public bool equals (Vala.TypeParameter param2);
	}
	[CCode (cheader_filename = "vala/valatypesymbol.h")]
	public abstract class Typesymbol : Vala.Symbol {
		public abstract string get_cname (bool const_type = false);
		public virtual bool is_reference_type ();
		public virtual string get_dup_function ();
		public virtual string get_free_function ();
		public virtual bool is_reference_counting ();
		public virtual string get_ref_function ();
		public virtual string get_unref_function ();
		public virtual string get_type_id ();
		public virtual string get_marshaller_type_name ();
		public virtual string get_get_value_function ();
		public virtual string get_set_value_function ();
		public virtual string get_upper_case_cname (string infix = null);
		public virtual string get_default_value ();
		public void add_cheader_filename (string filename);
		public Vala.Array get_array (int rank);
		public virtual bool is_subtype_of (Vala.Typesymbol t);
		public virtual int get_type_parameter_index (string name);
	}
	[CCode (cheader_filename = "vala/valaunaryexpression.h")]
	public class UnaryExpression : Vala.Expression {
		public UnaryExpression (Vala.UnaryOperator op, Vala.Expression _inner, Vala.SourceReference source);
		public weak Vala.UnaryOperator operator { get; set; }
		public Vala.Expression inner { get; set construct; }
		public string operator_string { get; }
	}
	[CCode (cheader_filename = "vala/valaunresolvedtype.h")]
	public class UnresolvedType : Vala.DataType {
		public UnresolvedType ();
		public UnresolvedType.from_name (string ns, string type, Vala.SourceReference source = null);
		public static Vala.UnresolvedType new_from_expression (Vala.Expression expr);
		public string namespace_name { get; set; }
		public string type_name { get; set; }
		public weak int array_rank { get; set; }
		public weak int pointer_level { get; set; }
		public weak bool transfers_ownership { get; set; }
		public weak bool takes_ownership { get; set; }
		public weak bool is_weak { get; set; }
		public weak bool is_ref { get; set; }
		public weak bool is_out { get; set; }
		public weak bool nullable { get; set; }
	}
	[CCode (cheader_filename = "vala/valavaluetype.h")]
	public class ValueType : Vala.DataType {
		public ValueType (Vala.Typesymbol type_symbol);
		public weak Vala.Typesymbol type_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valavariabledeclarator.h")]
	public class VariableDeclarator : Vala.Symbol {
		public VariableDeclarator (string name, Vala.Expression initializer = null, Vala.SourceReference source_reference = null);
		public Vala.Expression initializer { get; set; }
		public Vala.DataType type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valavoidtype.h")]
	public class VoidType : Vala.DataType {
		public VoidType ();
	}
	[CCode (cheader_filename = "vala/valawhilestatement.h")]
	public class WhileStatement : Vala.CodeNode, Vala.Statement {
		public WhileStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.Expression condition { get; set construct; }
		public Vala.Block body { get; set; }
	}
	[CCode (cheader_filename = "vala/valabindingprovider.h")]
	public interface BindingProvider : GLib.Object {
		public abstract Vala.Symbol get_binding (Vala.MemberAccess ma);
	}
	[CCode (cheader_filename = "vala/valalockable.h")]
	public interface Lockable : GLib.Object {
		public abstract bool get_lock_used ();
		public abstract void set_lock_used (bool used);
	}
	[CCode (cheader_filename = "vala/valastatement.h")]
	public interface Statement : Vala.CodeNode {
	}
}
/* gobject.vapi generated by lt-valac, do not modify. */

[CCode (cprefix = "Vala", lower_case_cprefix = "vala_")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valaccodearraycreationexpressionbinding.h")]
	public class CCodeArrayCreationExpressionBinding : Vala.CCodeExpressionBinding {
		public CCodeArrayCreationExpressionBinding (Vala.CodeGenerator codegen, Vala.ArrayCreationExpression array_creation_expression);
		public Vala.ArrayCreationExpression array_creation_expression { get; set; }
	}
	[CCode (cheader_filename = "gobject/valaccodeassignmentbinding.h")]
	public class CCodeAssignmentBinding : Vala.CCodeExpressionBinding {
		public CCodeAssignmentBinding (Vala.CodeGenerator codegen, Vala.Assignment assignment);
		public Vala.Assignment assignment { get; set; }
	}
	[CCode (cheader_filename = "gobject/valaccodebinding.h")]
	public abstract class CCodeBinding : Vala.CodeBinding {
		public Vala.CCodeGenerator codegen { get; set; }
	}
	[CCode (cheader_filename = "gobject/valaccodecompiler.h")]
	public class CCodeCompiler : GLib.Object {
		public CCodeCompiler ();
		[NoArrayLength]
		public void compile (Vala.CodeContext context, string cc_command, string[] cc_options);
	}
	[CCode (cheader_filename = "gobject/valaccodeelementaccessbinding.h")]
	public class CCodeElementAccessBinding : Vala.CCodeExpressionBinding {
		public CCodeElementAccessBinding (Vala.CodeGenerator codegen, Vala.ElementAccess element_access);
		public Vala.ElementAccess element_access { get; set; }
	}
	[CCode (cheader_filename = "gobject/valaccodeexpressionbinding.h")]
	public abstract class CCodeExpressionBinding : Vala.CCodeBinding {
		public Vala.CCodeExpression codenode { get; set; }
	}
	[CCode (cheader_filename = "gobject/valaccodegenerator.h")]
	public class CCodeGenerator : Vala.CodeGenerator {
		public Vala.Typesymbol current_type_symbol;
		public Gee.ArrayList<Vala.VariableDeclarator> temp_vars;
		public bool in_creation_method;
		public Vala.DataType bool_type;
		public Vala.DataType char_type;
		public Vala.DataType unichar_type;
		public Vala.DataType short_type;
		public Vala.DataType ushort_type;
		public Vala.DataType int_type;
		public Vala.DataType uint_type;
		public Vala.DataType long_type;
		public Vala.DataType ulong_type;
		public Vala.DataType int64_type;
		public Vala.DataType uint64_type;
		public Vala.DataType string_type;
		public Vala.DataType float_type;
		public Vala.DataType double_type;
		public Vala.Typesymbol gtypeinstance_type;
		public Vala.Typesymbol gobject_type;
		public Vala.Typesymbol gerror_type;
		public Vala.Typesymbol glist_type;
		public Vala.Typesymbol gslist_type;
		public Vala.Typesymbol gstring_type;
		public Vala.Typesymbol garray_type;
		public Vala.DataType gquark_type;
		public Vala.DataType mutex_type;
		public Vala.Typesymbol type_module_type;
		public Vala.Typesymbol iterable_type;
		public Vala.Typesymbol iterator_type;
		public Vala.Typesymbol list_type;
		public Vala.Typesymbol map_type;
		public Vala.Typesymbol connection_type;
		public CCodeGenerator ();
		public Vala.VariableDeclarator get_temp_variable_declarator (Vala.DataType type, bool takes_ownership = true, Vala.CodeNode node_reference = null);
		public Vala.CCodeExpression get_unref_expression (Vala.CCodeExpression cvar, Vala.DataType type, Vala.Expression expr);
		public Vala.CCodeExpression get_array_length_cexpression (Vala.Expression array_expr, int dim);
		public Vala.CCodeExpression get_delegate_target_cexpression (Vala.Expression delegate_expr);
		public void visit_expression (Vala.Expression expr);
		public Vala.CCodeExpression convert_from_generic_pointer (Vala.CCodeExpression cexpr, Vala.DataType actual_type);
		public Vala.CCodeExpression convert_to_generic_pointer (Vala.CCodeExpression cexpr, Vala.DataType actual_type);
		public Vala.CCodeExpression get_implicit_cast_expression (Vala.CCodeExpression cexpr, Vala.DataType expression_type, Vala.DataType target_type);
		public Vala.CCodeFunctionCall get_property_set_call (Vala.Property prop, Vala.MemberAccess ma, Vala.CCodeExpression cexpr);
		public Vala.CCodeIdentifier get_value_setter_function (Vala.DataType type_reference);
		public string get_signal_marshaller_function (Vala.Signal sig, string prefix = null);
	}
	[CCode (cheader_filename = "gobject/valaccodemethodbinding.h")]
	public class CCodeMethodBinding : Vala.CCodeBinding {
		public CCodeMethodBinding (Vala.CodeGenerator codegen, Vala.Method method);
		public static Vala.CCodeMethodBinding get (Vala.Method method);
		public Vala.Method method { get; set; }
		public weak bool has_wrapper { get; }
	}
	[CCode (cheader_filename = "gobject/valaclassregisterfunction.h")]
	public class ClassRegisterFunction : Vala.TypeRegisterFunction {
		public ClassRegisterFunction (Vala.Class cl);
		public weak Vala.Class class_reference { get; set; }
	}
	[CCode (cheader_filename = "gobject/valadbusbindingprovider.h")]
	public class DBusBindingProvider : GLib.Object, Vala.BindingProvider {
		public DBusBindingProvider ();
		public Vala.CodeContext context { set; }
	}
	[CCode (cheader_filename = "gobject/valadbusmethod.h")]
	public class DBusMethod : Vala.Method {
		public DBusMethod (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
	}
	[CCode (cheader_filename = "gobject/valadbussignal.h")]
	public class DBusSignal : Vala.Signal {
		public DBusSignal (string name, Vala.DataType return_type, Vala.SourceReference source_reference = null);
	}
	[CCode (cheader_filename = "gobject/valainterfaceregisterfunction.h")]
	public class InterfaceRegisterFunction : Vala.TypeRegisterFunction {
		public InterfaceRegisterFunction (Vala.Interface iface);
		public weak Vala.Interface interface_reference { get; set; }
	}
	[CCode (cheader_filename = "gobject/valatyperegisterfunction.h")]
	public abstract class TypeRegisterFunction : GLib.Object {
		public void init_from_type (bool plugin = false);
		public abstract Vala.Typesymbol get_type_declaration ();
		public abstract string get_type_struct_name ();
		public abstract string get_base_init_func_name ();
		public abstract string get_class_init_func_name ();
		public abstract string get_instance_struct_size ();
		public abstract string get_instance_init_func_name ();
		public abstract string get_parent_type_name ();
		public virtual string get_type_flags ();
		public virtual Vala.CCodeFragment get_type_interface_init_declaration ();
		public abstract Vala.CCodeFragment get_type_interface_init_statements ();
		public Vala.CCodeFragment get_declaration ();
		public Vala.CCodeFragment get_definition ();
		public abstract Vala.SymbolAccessibility get_accessibility ();
	}
}
