/* valainterfacetype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainterfacetype.h>
#include <vala/valadatatype.h>

struct _ValaInterfaceTypePrivate {
	ValaInterface* _interface_symbol;
};
#define VALA_INTERFACE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_TYPE, ValaInterfaceTypePrivate))
enum  {
	VALA_INTERFACE_TYPE_DUMMY_PROPERTY,
	VALA_INTERFACE_TYPE_INTERFACE_SYMBOL
};
static gpointer vala_interface_type_parent_class = NULL;
static void vala_interface_type_dispose (GObject * obj);


ValaInterfaceType* vala_interface_type_new (ValaInterface* interface_symbol) {
	ValaInterfaceType * self;
	g_return_val_if_fail (interface_symbol == NULL || VALA_IS_INTERFACE (interface_symbol), NULL);
	self = g_object_newv (VALA_TYPE_INTERFACE_TYPE, 0, NULL);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL (interface_symbol));
	vala_interface_type_set_interface_symbol (self, interface_symbol);
	return self;
}


ValaInterface* vala_interface_type_get_interface_symbol (ValaInterfaceType* self) {
	g_return_val_if_fail (VALA_IS_INTERFACE_TYPE (self), NULL);
	return self->priv->_interface_symbol;
}


void vala_interface_type_set_interface_symbol (ValaInterfaceType* self, ValaInterface* value) {
	g_return_if_fail (VALA_IS_INTERFACE_TYPE (self));
	self->priv->_interface_symbol = value;
}


static void vala_interface_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (object);
	switch (property_id) {
		case VALA_INTERFACE_TYPE_INTERFACE_SYMBOL:
		g_value_set_object (value, vala_interface_type_get_interface_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_interface_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (object);
	switch (property_id) {
		case VALA_INTERFACE_TYPE_INTERFACE_SYMBOL:
		vala_interface_type_set_interface_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_interface_type_class_init (ValaInterfaceTypeClass * klass) {
	vala_interface_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInterfaceTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_interface_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_interface_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_interface_type_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INTERFACE_TYPE_INTERFACE_SYMBOL, g_param_spec_object ("interface-symbol", "interface-symbol", "interface-symbol", VALA_TYPE_INTERFACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_interface_type_init (ValaInterfaceType * self) {
	self->priv = VALA_INTERFACE_TYPE_GET_PRIVATE (self);
}


static void vala_interface_type_dispose (GObject * obj) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (obj);
	G_OBJECT_CLASS (vala_interface_type_parent_class)->dispose (obj);
}


GType vala_interface_type_get_type (void) {
	static GType vala_interface_type_type_id = 0;
	if (G_UNLIKELY (vala_interface_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceType), 0, (GInstanceInitFunc) vala_interface_type_init };
		vala_interface_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaInterfaceType", &g_define_type_info, 0);
	}
	return vala_interface_type_type_id;
}




