/* valacontinuestatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacontinuestatement.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

enum  {
	VALA_CONTINUE_STATEMENT_DUMMY_PROPERTY
};
static void vala_continue_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_continue_statement_parent_class = NULL;
static ValaStatementIface* vala_continue_statement_vala_statement_parent_iface = NULL;


/**
 * Creates a new continue statement.
 *
 * @param source reference to source code
 * @return       newly created continue statement
 */
ValaContinueStatement* vala_continue_statement_new (ValaSourceReference* source) {
	ValaContinueStatement * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_CONTINUE_STATEMENT, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_continue_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaContinueStatement * self;
	self = VALA_CONTINUE_STATEMENT (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_continue_statement (visitor, self);
}


static void vala_continue_statement_class_init (ValaContinueStatementClass * klass) {
	vala_continue_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_continue_statement_real_accept;
}


static void vala_continue_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_continue_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_continue_statement_init (ValaContinueStatement * self) {
}


GType vala_continue_statement_get_type (void) {
	static GType vala_continue_statement_type_id = 0;
	if (G_UNLIKELY (vala_continue_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaContinueStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_continue_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaContinueStatement), 0, (GInstanceInitFunc) vala_continue_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_continue_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_continue_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaContinueStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_continue_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_continue_statement_type_id;
}




