/* mainwindow.c generated by valac, the Vala compiler
 * generated from mainwindow.vala, do not modify */

/*
 * Vala-Terminal -- a lightweight terminal program
 *
 * (C) 2007-2009 Michael 'Mickey' Lauer <mickey@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Contributions by Aapo Rantalainen:
 * - rotatable toolbar
 * - no tab-panel (tab are changed by toolbar)
 * - increased fontsize max 
 * - start with focus on textarea
 * - (workaround of commandlinebug)
 *
 * - Jump to the new created tab
 * - Starting geometry
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define VALA_TERMINAL2_TYPE_MAIN_WINDOW (vala_terminal2_main_window_get_type ())
#define VALA_TERMINAL2_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TERMINAL2_TYPE_MAIN_WINDOW, ValaTerminal2MainWindow))
#define VALA_TERMINAL2_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TERMINAL2_TYPE_MAIN_WINDOW, ValaTerminal2MainWindowClass))
#define VALA_TERMINAL2_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TERMINAL2_TYPE_MAIN_WINDOW))
#define VALA_TERMINAL2_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TERMINAL2_TYPE_MAIN_WINDOW))
#define VALA_TERMINAL2_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TERMINAL2_TYPE_MAIN_WINDOW, ValaTerminal2MainWindowClass))

typedef struct _ValaTerminal2MainWindow ValaTerminal2MainWindow;
typedef struct _ValaTerminal2MainWindowClass ValaTerminal2MainWindowClass;
typedef struct _ValaTerminal2MainWindowPrivate ValaTerminal2MainWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TERMINAL2_TYPE_MOKO_TERMINAL (vala_terminal2_moko_terminal_get_type ())
#define VALA_TERMINAL2_MOKO_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminal))
#define VALA_TERMINAL2_MOKO_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminalClass))
#define VALA_TERMINAL2_IS_MOKO_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL))
#define VALA_TERMINAL2_IS_MOKO_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TERMINAL2_TYPE_MOKO_TERMINAL))
#define VALA_TERMINAL2_MOKO_TERMINAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TERMINAL2_TYPE_MOKO_TERMINAL, ValaTerminal2MokoTerminalClass))

typedef struct _ValaTerminal2MokoTerminal ValaTerminal2MokoTerminal;
typedef struct _ValaTerminal2MokoTerminalClass ValaTerminal2MokoTerminalClass;

struct _ValaTerminal2MainWindow {
	GtkWindow parent_instance;
	ValaTerminal2MainWindowPrivate * priv;
};

struct _ValaTerminal2MainWindowClass {
	GtkWindowClass parent_class;
};

struct _ValaTerminal2MainWindowPrivate {
	GtkBox* box;
	GtkBox* toolbar;
	GtkNotebook* notebook;
	GtkToolButton* btn_new;
	GtkToolButton* btn_delete;
	GtkToolButton* btn_zoom_in;
	GtkToolButton* btn_zoom_out;
	GtkToolButton* btn_paste;
	GtkToolButton* btn_prev_tab;
	GtkToolButton* btn_next_tab;
	GtkLabel* tab_counter;
	GtkToolButton* btn_rotate;
	GtkToolButton* btn_fullscreen;
	gboolean vertical;
	gboolean fullscreen_;
};


static char* vala_terminal2_main_window_initial_command;
static char* vala_terminal2_main_window_initial_command = NULL;
static char** vala_terminal2_main_window_initial_command_line;
static gint vala_terminal2_main_window_initial_command_line_length1;
static char** vala_terminal2_main_window_initial_command_line = NULL;
static gint vala_terminal2_main_window_initial_command_line_length1 = 0;
static gint vala_terminal2_main_window_initial_command_line_size = 0;
static char* vala_terminal2_main_window_hack_command;
static char* vala_terminal2_main_window_hack_command = NULL;
extern gint vala_terminal2_moko_terminal_starting_width;
extern gint vala_terminal2_moko_terminal_starting_height;
static gpointer vala_terminal2_main_window_parent_class = NULL;

GType vala_terminal2_main_window_get_type (void);
#define VALA_TERMINAL2_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TERMINAL2_TYPE_MAIN_WINDOW, ValaTerminal2MainWindowPrivate))
enum  {
	VALA_TERMINAL2_MAIN_WINDOW_DUMMY_PROPERTY
};
static void _gtk_main_quit_gtk_object_destroy (ValaTerminal2MainWindow* _sender, gpointer self);
void vala_terminal2_main_window_setup_toolbar (ValaTerminal2MainWindow* self);
void vala_terminal2_main_window_setup_notebook (ValaTerminal2MainWindow* self);
void vala_terminal2_main_window_update_toolbar (ValaTerminal2MainWindow* self);
static void _lambda3_ (GtkNotebook* o, GtkWidget* page, guint num, ValaTerminal2MainWindow* self);
static void __lambda3__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
ValaTerminal2MainWindow* vala_terminal2_main_window_new (gboolean start_vertical, gboolean start_fullscreen);
ValaTerminal2MainWindow* vala_terminal2_main_window_construct (GType object_type, gboolean start_vertical, gboolean start_fullscreen);
void vala_terminal2_main_window_setup_command (ValaTerminal2MainWindow* self, const char* command);
static void vala_terminal2_main_window_on_new_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_new_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_delete_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_delete_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_zoom_in_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_zoom_in_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_zoom_out_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_zoom_out_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_paste_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_paste_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_prev_tab_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_prev_tab_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_next_tab_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_next_tab_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_rotate_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_rotate_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void vala_terminal2_main_window_on_fullscreen_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b);
static void _vala_terminal2_main_window_on_fullscreen_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_new (void);
ValaTerminal2MokoTerminal* vala_terminal2_moko_terminal_construct (GType object_type);
GType vala_terminal2_moko_terminal_get_type (void);
void vala_terminal2_moko_terminal_paste_command (ValaTerminal2MokoTerminal* self, const char* command);
void vala_terminal2_moko_terminal_zoom_in (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_zoom_out (ValaTerminal2MokoTerminal* self);
void vala_terminal2_moko_terminal_paste (ValaTerminal2MokoTerminal* self);
guint vala_terminal2_moko_terminal_get_font_size (ValaTerminal2MokoTerminal* self);
void vala_terminal2_main_window_run (ValaTerminal2MainWindow* self);
void vala_terminal2_moko_terminal_set_fore_color (guint r, guint g, guint b);
void vala_terminal2_moko_terminal_set_back_color (guint r, guint g, guint b);
void vala_terminal2_moko_terminal_set_font (const char* font);
void vala_terminal2_moko_terminal_set_starting_fontsize (guint size);
static gint vala_terminal2_main_window_main (char** args, int args_length1);
static void vala_terminal2_main_window_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry VALA_TERMINAL2_MAIN_WINDOW_options[] = {{"command", 'e', 0, G_OPTION_ARG_STRING, &vala_terminal2_main_window_initial_command, "Execute COMMAND inside the terminal.", "COMMAND"}, {"", 'x', 0, G_OPTION_ARG_STRING_ARRAY, &vala_terminal2_main_window_initial_command_line, "Execute remainder of command line inside the terminal.", "COMMANDS"}, {NULL}};


static void _gtk_main_quit_gtk_object_destroy (ValaTerminal2MainWindow* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _lambda3_ (GtkNotebook* o, GtkWidget* page, guint num, ValaTerminal2MainWindow* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (page != NULL);
	fprintf (stdout, "on_page_removed\n");
	if (gtk_notebook_get_n_pages (self->priv->notebook) == 0) {
		gtk_main_quit ();
	} else {
		vala_terminal2_main_window_update_toolbar (self);
	}
}


static void __lambda3__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda3_ (_sender, p0, p1, self);
}


ValaTerminal2MainWindow* vala_terminal2_main_window_construct (GType object_type, gboolean start_vertical, gboolean start_fullscreen) {
	ValaTerminal2MainWindow * self;
	self = g_object_newv (object_type, 0, NULL);
	gtk_window_set_title ((GtkWindow*) self, "Terminal");
	g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	self->priv->vertical = start_vertical;
	self->priv->fullscreen_ = start_fullscreen;
	vala_terminal2_main_window_setup_toolbar (self);
	vala_terminal2_main_window_setup_notebook (self);
	if (self->priv->vertical) {
		GtkBox* _tmp0_;
		self->priv->box = (_tmp0_ = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (self->priv->box), _tmp0_);
		gtk_box_pack_start (self->priv->box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start (self->priv->box, (GtkWidget*) self->priv->toolbar, FALSE, FALSE, (guint) 0);
	} else {
		GtkBox* _tmp1_;
		self->priv->box = (_tmp1_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (self->priv->box), _tmp1_);
		gtk_box_pack_end (self->priv->box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
		gtk_box_pack_end (self->priv->box, (GtkWidget*) self->priv->toolbar, FALSE, FALSE, (guint) 0);
	}
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->box);
	gtk_container_set_focus_child ((GtkContainer*) self->priv->box, (GtkWidget*) self->priv->notebook);
	g_signal_connect_object (self->priv->notebook, "page-removed", (GCallback) __lambda3__gtk_notebook_page_removed, self, 0);
	if (self->priv->fullscreen_) {
		gtk_window_fullscreen ((GtkWindow*) self);
	}
	vala_terminal2_main_window_update_toolbar (self);
	return self;
}


ValaTerminal2MainWindow* vala_terminal2_main_window_new (gboolean start_vertical, gboolean start_fullscreen) {
	return vala_terminal2_main_window_construct (VALA_TERMINAL2_TYPE_MAIN_WINDOW, start_vertical, start_fullscreen);
}


void vala_terminal2_main_window_setup_command (ValaTerminal2MainWindow* self, const char* command) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	vala_terminal2_main_window_initial_command = (_tmp0_ = g_strconcat (command, "\n", NULL), _g_free0 (vala_terminal2_main_window_initial_command), _tmp0_);
}


static void _vala_terminal2_main_window_on_new_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_new_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_delete_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_delete_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_zoom_in_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_zoom_in_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_zoom_out_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_zoom_out_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_paste_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_paste_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_prev_tab_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_prev_tab_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_next_tab_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_next_tab_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_rotate_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_rotate_clicked (self, _sender);
}


static void _vala_terminal2_main_window_on_fullscreen_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	vala_terminal2_main_window_on_fullscreen_clicked (self, _sender);
}


void vala_terminal2_main_window_setup_toolbar (ValaTerminal2MainWindow* self) {
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkLabel* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	g_return_if_fail (self != NULL);
	if (self->priv->vertical) {
		GtkBox* _tmp0_;
		self->priv->toolbar = (_tmp0_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (self->priv->toolbar), _tmp0_);
	} else {
		GtkBox* _tmp1_;
		self->priv->toolbar = (_tmp1_ = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (self->priv->toolbar), _tmp1_);
	}
	self->priv->btn_new = (_tmp2_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_NEW)), _g_object_unref0 (self->priv->btn_new), _tmp2_);
	g_signal_connect_object (self->priv->btn_new, "clicked", (GCallback) _vala_terminal2_main_window_on_new_clicked_gtk_tool_button_clicked, self, 0);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_new, FALSE, FALSE, (guint) 0);
	self->priv->btn_delete = (_tmp3_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_DELETE)), _g_object_unref0 (self->priv->btn_delete), _tmp3_);
	g_signal_connect_object (self->priv->btn_delete, "clicked", (GCallback) _vala_terminal2_main_window_on_delete_clicked_gtk_tool_button_clicked, self, 0);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_delete, FALSE, FALSE, (guint) 0);
	self->priv->btn_zoom_in = (_tmp4_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_ZOOM_IN)), _g_object_unref0 (self->priv->btn_zoom_in), _tmp4_);
	g_signal_connect_object (self->priv->btn_zoom_in, "clicked", (GCallback) _vala_terminal2_main_window_on_zoom_in_clicked_gtk_tool_button_clicked, self, 0);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_zoom_in, FALSE, FALSE, (guint) 0);
	self->priv->btn_zoom_out = (_tmp5_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_ZOOM_OUT)), _g_object_unref0 (self->priv->btn_zoom_out), _tmp5_);
	g_signal_connect_object (self->priv->btn_zoom_out, "clicked", (GCallback) _vala_terminal2_main_window_on_zoom_out_clicked_gtk_tool_button_clicked, self, 0);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_zoom_out, FALSE, FALSE, (guint) 0);
	self->priv->btn_paste = (_tmp6_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_PASTE)), _g_object_unref0 (self->priv->btn_paste), _tmp6_);
	g_signal_connect_object (self->priv->btn_paste, "clicked", (GCallback) _vala_terminal2_main_window_on_paste_clicked_gtk_tool_button_clicked, self, 0);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_paste, FALSE, FALSE, (guint) 0);
	self->priv->btn_prev_tab = (_tmp7_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_GO_BACK)), _g_object_unref0 (self->priv->btn_prev_tab), _tmp7_);
	g_signal_connect_object (self->priv->btn_prev_tab, "clicked", (GCallback) _vala_terminal2_main_window_on_prev_tab_clicked_gtk_tool_button_clicked, self, 0);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_prev_tab, FALSE);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_prev_tab, FALSE, FALSE, (guint) 0);
	self->priv->btn_next_tab = (_tmp8_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_GO_FORWARD)), _g_object_unref0 (self->priv->btn_next_tab), _tmp8_);
	g_signal_connect_object (self->priv->btn_next_tab, "clicked", (GCallback) _vala_terminal2_main_window_on_next_tab_clicked_gtk_tool_button_clicked, self, 0);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_next_tab, FALSE);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_next_tab, FALSE, FALSE, (guint) 0);
	self->priv->tab_counter = (_tmp9_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->tab_counter), _tmp9_);
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->tab_counter, FALSE, FALSE, (guint) 0);
	self->priv->btn_rotate = (_tmp10_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_REFRESH)), _g_object_unref0 (self->priv->btn_rotate), _tmp10_);
	g_signal_connect_object (self->priv->btn_rotate, "clicked", (GCallback) _vala_terminal2_main_window_on_rotate_clicked_gtk_tool_button_clicked, self, 0);
	gtk_tool_button_set_label (self->priv->btn_rotate, "Rotate");
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_rotate, FALSE, FALSE, (guint) 0);
	self->priv->btn_fullscreen = (_tmp11_ = g_object_ref_sink ((GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_FULLSCREEN)), _g_object_unref0 (self->priv->btn_fullscreen), _tmp11_);
	g_signal_connect_object (self->priv->btn_fullscreen, "clicked", (GCallback) _vala_terminal2_main_window_on_fullscreen_clicked_gtk_tool_button_clicked, self, 0);
	gtk_tool_button_set_label (self->priv->btn_fullscreen, "Fullscreen");
	gtk_box_pack_start (self->priv->toolbar, (GtkWidget*) self->priv->btn_fullscreen, FALSE, FALSE, (guint) 0);
}


void vala_terminal2_main_window_setup_notebook (ValaTerminal2MainWindow* self) {
	GtkNotebook* _tmp0_;
	ValaTerminal2MokoTerminal* terminal;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->notebook = (_tmp0_ = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ()), _g_object_unref0 (self->priv->notebook), _tmp0_);
	gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_BOTTOM);
	gtk_notebook_set_show_tabs (self->priv->notebook, FALSE);
	gtk_notebook_set_show_border (self->priv->notebook, FALSE);
	terminal = g_object_ref_sink (vala_terminal2_moko_terminal_new ());
	gtk_notebook_append_page (self->priv->notebook, (GtkWidget*) terminal, (GtkWidget*) (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_INDEX, GTK_ICON_SIZE_LARGE_TOOLBAR))));
	_g_object_unref0 (_tmp1_);
	gtk_container_child_set ((GtkContainer*) self->priv->notebook, (GtkWidget*) terminal, "tab-expand", TRUE, NULL, NULL);
	if (vala_terminal2_main_window_hack_command != NULL) {
		vala_terminal2_moko_terminal_paste_command (terminal, vala_terminal2_main_window_hack_command);
	}
	_g_object_unref0 (terminal);
}


static void vala_terminal2_main_window_on_new_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	ValaTerminal2MokoTerminal* terminal;
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_new_clicked\n");
	terminal = g_object_ref_sink (vala_terminal2_moko_terminal_new ());
	gtk_notebook_append_page (self->priv->notebook, (GtkWidget*) terminal, (GtkWidget*) (_tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_INDEX, GTK_ICON_SIZE_LARGE_TOOLBAR))));
	_g_object_unref0 (_tmp0_);
	gtk_container_child_set ((GtkContainer*) self->priv->notebook, (GtkWidget*) terminal, "tab-expand", TRUE, NULL, NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->notebook);
	gtk_notebook_set_current_page (self->priv->notebook, gtk_notebook_get_n_pages (self->priv->notebook) - 1);
	vala_terminal2_main_window_update_toolbar (self);
	_g_object_unref0 (terminal);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void vala_terminal2_main_window_on_delete_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_delete_clicked\n");
	page = _g_object_ref0 (gtk_notebook_get_nth_page (self->priv->notebook, gtk_notebook_get_current_page (self->priv->notebook)));
	gtk_object_destroy ((GtkObject*) page);
	_g_object_unref0 (page);
}


static void vala_terminal2_main_window_on_zoom_in_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	ValaTerminal2MokoTerminal* terminal;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_zoom_in_clicked\n");
	terminal = _g_object_ref0 (VALA_TERMINAL2_MOKO_TERMINAL (gtk_notebook_get_nth_page (self->priv->notebook, gtk_notebook_get_current_page (self->priv->notebook))));
	vala_terminal2_moko_terminal_zoom_in (terminal);
	vala_terminal2_main_window_update_toolbar (self);
	_g_object_unref0 (terminal);
}


static void vala_terminal2_main_window_on_zoom_out_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	ValaTerminal2MokoTerminal* terminal;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_zoom_out_clicked\n");
	terminal = _g_object_ref0 (VALA_TERMINAL2_MOKO_TERMINAL (gtk_notebook_get_nth_page (self->priv->notebook, gtk_notebook_get_current_page (self->priv->notebook))));
	vala_terminal2_moko_terminal_zoom_out (terminal);
	vala_terminal2_main_window_update_toolbar (self);
	_g_object_unref0 (terminal);
}


static void vala_terminal2_main_window_on_paste_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	ValaTerminal2MokoTerminal* terminal;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_paste_clicked\n");
	terminal = _g_object_ref0 (VALA_TERMINAL2_MOKO_TERMINAL (gtk_notebook_get_nth_page (self->priv->notebook, gtk_notebook_get_current_page (self->priv->notebook))));
	vala_terminal2_moko_terminal_paste (terminal);
	vala_terminal2_main_window_update_toolbar (self);
	_g_object_unref0 (terminal);
}


static void vala_terminal2_main_window_on_prev_tab_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_prev_tab_clicked\n");
	gtk_notebook_prev_page (self->priv->notebook);
	vala_terminal2_main_window_update_toolbar (self);
}


static void vala_terminal2_main_window_on_next_tab_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_next_tab_clicked\n");
	gtk_notebook_next_page (self->priv->notebook);
	vala_terminal2_main_window_update_toolbar (self);
}


static void vala_terminal2_main_window_on_rotate_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_rotate_clicked\n");
	self->priv->vertical = !self->priv->vertical;
	gtk_container_remove ((GtkContainer*) self->priv->box, (GtkWidget*) self->priv->notebook);
	gtk_container_remove ((GtkContainer*) self->priv->box, (GtkWidget*) self->priv->toolbar);
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) self->priv->box);
	vala_terminal2_main_window_setup_toolbar (self);
	if (self->priv->vertical) {
		GtkBox* _tmp0_;
		self->priv->box = (_tmp0_ = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (self->priv->box), _tmp0_);
		gtk_box_pack_start (self->priv->box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start (self->priv->box, (GtkWidget*) self->priv->toolbar, FALSE, FALSE, (guint) 0);
	} else {
		GtkBox* _tmp1_;
		self->priv->box = (_tmp1_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (self->priv->box), _tmp1_);
		gtk_box_pack_end (self->priv->box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
		gtk_box_pack_end (self->priv->box, (GtkWidget*) self->priv->toolbar, FALSE, FALSE, (guint) 0);
	}
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->box);
	gtk_container_set_focus_child ((GtkContainer*) self->priv->box, (GtkWidget*) self->priv->notebook);
	vala_terminal2_main_window_update_toolbar (self);
	gtk_widget_show_all ((GtkWidget*) self);
}


static void vala_terminal2_main_window_on_fullscreen_clicked (ValaTerminal2MainWindow* self, GtkToolButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	fprintf (stdout, "on_fullscreen_clicked\n");
	self->priv->fullscreen_ = !self->priv->fullscreen_;
	if (self->priv->fullscreen_) {
		gtk_window_fullscreen ((GtkWindow*) self);
	} else {
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


void vala_terminal2_main_window_update_toolbar (ValaTerminal2MainWindow* self) {
	ValaTerminal2MokoTerminal* terminal;
	gint current_tab;
	char* count;
	g_return_if_fail (self != NULL);
	fprintf (stdout, "update_toolbar\n");
	if (NULL == self->priv->notebook) {
		fprintf (stdout, "notebook no longer present\n");
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_delete, gtk_notebook_get_n_pages (self->priv->notebook) > 1);
	terminal = _g_object_ref0 (VALA_TERMINAL2_MOKO_TERMINAL (gtk_notebook_get_nth_page (self->priv->notebook, gtk_notebook_get_current_page (self->priv->notebook))));
	fprintf (stdout, "current font size for terminal is %u\n", vala_terminal2_moko_terminal_get_font_size (terminal));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_zoom_in, vala_terminal2_moko_terminal_get_font_size (terminal) < 20);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_zoom_out, vala_terminal2_moko_terminal_get_font_size (terminal) > 1);
	current_tab = gtk_notebook_get_current_page (self->priv->notebook);
	if (current_tab == (-1)) {
		current_tab = 0;
	}
	current_tab++;
	count = g_strdup_printf ("tab:%d/%d", current_tab, gtk_notebook_get_n_pages (self->priv->notebook));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_prev_tab, current_tab != 1);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->btn_next_tab, current_tab != gtk_notebook_get_n_pages (self->priv->notebook));
	gtk_label_set_label (self->priv->tab_counter, count);
	_g_object_unref0 (terminal);
	_g_free0 (count);
}


void vala_terminal2_main_window_run (ValaTerminal2MainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_main ();
}


static gint vala_terminal2_main_window_main (char** args, int args_length1) {
	gint result;
	guint DEFAULT_FONTSIZE;
	gboolean DEFAULT_START_VERTICAL;
	guint fontsize;
	gboolean start_vertical;
	gboolean start_fullscreen;
	gint counter;
	ValaTerminal2MainWindow* window;
	gtk_init (&args_length1, &args);
	DEFAULT_FONTSIZE = (guint) 5;
	DEFAULT_START_VERTICAL = FALSE;
	fontsize = DEFAULT_FONTSIZE;
	start_vertical = DEFAULT_START_VERTICAL;
	start_fullscreen = FALSE;
	counter = 1;
	while (TRUE) {
		if (!(counter < args_length1)) {
			break;
		}
		if (_vala_strcmp0 (args[counter], "--help") == 0) {
			const char* _tmp0_;
			fprintf (stdout, "Flag\tparameter\tmeaning\n");
			_tmp0_ = NULL;
			if (DEFAULT_START_VERTICAL) {
				_tmp0_ = "vertical";
			} else {
				_tmp0_ = "horizontal";
			}
			fprintf (stdout, " -v\t        \tStart with toolbar vertically (default=%s)\n", _tmp0_);
			fprintf (stdout, " -h\t        \tStart with toolbar horizontally\n");
			fprintf (stdout, " --fullscreen\t\tStart fullscreen\n");
			fprintf (stdout, " -fs\t   int    \tStarting fontize (default=%u)\n", DEFAULT_FONTSIZE);
			fprintf (stdout, " -f\t fontname \tUses font 'fontname'(default=LiberationMono)\n");
			fprintf (stdout, " -fc\t  r g b  \tFont color (values are between 0...65535) (default=65535 65535 65535)\n");
			fprintf (stdout, " -bc\t  r g b  \tBackground color (values are between 0...65535) (default=0 0 0)\n");
			fprintf (stdout, " -g\t  width height  \tgeometry\n");
			fprintf (stdout, " -e\tcmd [par1...]\tExecutes 'cmd' inside terminal [with parameters] (-e must be last flag)\n");
			fprintf (stdout, "\n");
			result = 0;
			return result;
		} else {
			if (_vala_strcmp0 (args[counter], "-e") == 0) {
				gint i;
				char* _tmp1_;
				char* _tmp4_;
				i = counter + 1;
				vala_terminal2_main_window_hack_command = (_tmp1_ = g_strdup (""), _g_free0 (vala_terminal2_main_window_hack_command), _tmp1_);
				while (TRUE) {
					char* _tmp3_;
					char* _tmp2_;
					if (!(args_length1 > i)) {
						break;
					}
					vala_terminal2_main_window_hack_command = (_tmp3_ = g_strconcat (vala_terminal2_main_window_hack_command, _tmp2_ = g_strconcat (args[i], " ", NULL), NULL), _g_free0 (vala_terminal2_main_window_hack_command), _tmp3_);
					_g_free0 (_tmp2_);
					i++;
				}
				vala_terminal2_main_window_hack_command = (_tmp4_ = g_strconcat (vala_terminal2_main_window_hack_command, "\n", NULL), _g_free0 (vala_terminal2_main_window_hack_command), _tmp4_);
				counter = args_length1;
			} else {
				if (_vala_strcmp0 (args[counter], "-fs") == 0) {
					if ((counter + 2) > args_length1) {
						fprintf (stdout, "USAGE: -fs int\n");
						result = 0;
						return result;
					}
					fontsize = (guint) atoi (args[counter + 1]);
					if (fontsize < 1) {
						fontsize = (guint) 1;
					}
					counter = counter + 2;
				} else {
					if (_vala_strcmp0 (args[counter], "-v") == 0) {
						start_vertical = TRUE;
						counter++;
					} else {
						if (_vala_strcmp0 (args[counter], "-h") == 0) {
							start_vertical = FALSE;
							counter++;
						} else {
							if (_vala_strcmp0 (args[counter], "--fullscreen") == 0) {
								start_fullscreen = TRUE;
								counter++;
							} else {
								if (_vala_strcmp0 (args[counter], "-fc") == 0) {
									if ((counter + 4) > args_length1) {
										fprintf (stdout, "USAGE: -fc int int int\n");
										result = 0;
										return result;
									}
									vala_terminal2_moko_terminal_set_fore_color ((guint) atoi (args[counter + 1]), (guint) atoi (args[counter + 2]), (guint) atoi (args[counter + 3]));
									counter = counter + 4;
								} else {
									if (_vala_strcmp0 (args[counter], "-bc") == 0) {
										if ((counter + 4) > args_length1) {
											fprintf (stdout, "USAGE: -bc int int int\n");
											result = 0;
											return result;
										}
										vala_terminal2_moko_terminal_set_back_color ((guint) atoi (args[counter + 1]), (guint) atoi (args[counter + 2]), (guint) atoi (args[counter + 3]));
										counter = counter + 4;
									} else {
										if (_vala_strcmp0 (args[counter], "-g") == 0) {
											if ((counter + 3) > args_length1) {
												fprintf (stdout, "USAGE: -g X Y\n");
												result = 0;
												return result;
											}
											vala_terminal2_moko_terminal_starting_width = atoi (args[counter + 1]);
											vala_terminal2_moko_terminal_starting_height = atoi (args[counter + 2]);
											counter = counter + 3;
										} else {
											if (_vala_strcmp0 (args[counter], "-f") == 0) {
												if ((counter + 2) > args_length1) {
													fprintf (stdout, "USAGE: -f fontname\n");
													result = 0;
													return result;
												}
												vala_terminal2_moko_terminal_set_font (args[counter + 1]);
												counter = counter + 2;
												;
											} else {
												fprintf (stdout, "%s: unknown flag '%s' \nUse --help\n", args[0], args[counter]);
												result = 1;
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	vala_terminal2_moko_terminal_set_starting_fontsize (fontsize);
	window = g_object_ref_sink (vala_terminal2_main_window_new (start_vertical, start_fullscreen));
	if (vala_terminal2_main_window_initial_command != NULL) {
		vala_terminal2_main_window_setup_command (window, vala_terminal2_main_window_initial_command);
	} else {
		if (vala_terminal2_main_window_initial_command_line != NULL) {
			char* _tmp5_;
			vala_terminal2_main_window_initial_command = (_tmp5_ = g_strjoinv (" ", vala_terminal2_main_window_initial_command_line), _g_free0 (vala_terminal2_main_window_initial_command), _tmp5_);
			vala_terminal2_main_window_setup_command (window, vala_terminal2_main_window_initial_command);
		}
	}
	vala_terminal2_main_window_run (window);
	result = 0;
	_g_object_unref0 (window);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_terminal2_main_window_main (argv, argc);
}


static void vala_terminal2_main_window_class_init (ValaTerminal2MainWindowClass * klass) {
	vala_terminal2_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTerminal2MainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_terminal2_main_window_finalize;
}


static void vala_terminal2_main_window_instance_init (ValaTerminal2MainWindow * self) {
	self->priv = VALA_TERMINAL2_MAIN_WINDOW_GET_PRIVATE (self);
}


static void vala_terminal2_main_window_finalize (GObject* obj) {
	ValaTerminal2MainWindow * self;
	self = VALA_TERMINAL2_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->btn_new);
	_g_object_unref0 (self->priv->btn_delete);
	_g_object_unref0 (self->priv->btn_zoom_in);
	_g_object_unref0 (self->priv->btn_zoom_out);
	_g_object_unref0 (self->priv->btn_paste);
	_g_object_unref0 (self->priv->btn_prev_tab);
	_g_object_unref0 (self->priv->btn_next_tab);
	_g_object_unref0 (self->priv->tab_counter);
	_g_object_unref0 (self->priv->btn_rotate);
	_g_object_unref0 (self->priv->btn_fullscreen);
	G_OBJECT_CLASS (vala_terminal2_main_window_parent_class)->finalize (obj);
}


GType vala_terminal2_main_window_get_type (void) {
	static GType vala_terminal2_main_window_type_id = 0;
	if (vala_terminal2_main_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTerminal2MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_terminal2_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTerminal2MainWindow), 0, (GInstanceInitFunc) vala_terminal2_main_window_instance_init, NULL };
		vala_terminal2_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ValaTerminal2MainWindow", &g_define_type_info, 0);
	}
	return vala_terminal2_main_window_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




