/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef WIRE_H
#define WIRE_H

#include <visu_pairs.h>
#include <coreTools/toolShade.h>

/**
 * initPairsWire:
 *
 * This method is used by V_Sim on startup, don't use it on your own.
 *
 * Returns: the wire pair extension.
 */
VisuPairExtension* initPairsWire();

VisuPairExtension* wireGet_static();

/**
 * wireSet_generalWidth:
 * @val: a positive integer.
 *
 * The width of line between elements can be chosen by kinds of pairs,
 * but can use a default value for all kinds of pairs when no individual value
 * is available. Use this method to set the default width.
 *
 * Returns: 1 if the calling method should call the visu_pair_build() method, 0 if not.
 */
int wireSet_generalWidth(int val);
/**
 * wireGet_generalWidth:
 *
 * Get the default width for wire pairs (see wireSet_generalWidth() to set this value).
 *
 * Returns: the default width.
 */
int wireGet_generalWidth();
/**
 * wireSet_width:
 * @data: a #VisuPairData object ;
 * @val: a positive integer.
 *
 * This method allows to change the width of line for a specific pair.
 * When a pair is rendered via with a line, it first checks if that pairs has
 * a specific width value set by this method. If not, it uses the default value.
 * If the specific value is indeed changed, the pairs OpenGl list is not
 * recreated automatically and the calling method should call the visu_pair_build() method
 * according to the return value.
 *
 * Returns: 1 if the calling method should call the visu_pair_build() method, 0 if not.
 */
int wireSet_width(VisuPairData *data, int val);
/**
 * wireGet_width:
 * @data: a #VisuPairData object.
 *
 * Get the width of the given pair @data. If the given pair has no
 * specific width, the defaul value is returned.
 *
 * Returns: the width of the given pair.
 */
int wireGet_width(VisuPairData *data);
gboolean wireSet_shade(Shade *shade);
Shade* wireGet_shade();
/**
 * wireSet_stipple:
 * @data: a #VisuPairData object ;
 * @stipple: a pattern.
 *
 * Change the line pattern of @data.
 *
 * Returns: TRUE if the value is different from previous, then call
 * the visu_pair_build() method.
 */
gboolean wireSet_stipple(VisuPairData *data, guint16 stipple);
/**
 * wireGet_stipple:
 * @data: a #VisuPairData object.
 *
 * Get the line pattern of @data.
 *
 * Returns: a line pattern (default is 65535).
 */
guint16 wireGet_stipple(VisuPairData *data);


#endif
