/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef DATANODE_H
#define DATANODE_H

#include <visu_nodes.h>
#include <visu_data.h>

/* This module is a wrapper around node properties from
   VisuData. It adds some capabilities, such as a translatable
   name, a way to go from data to strings and reverse, callbacks when
   the properties is changed... */

G_BEGIN_DECLS

/**
 * VISU_DATA_NODE_TYPE:
 *
 * return the type of #VisuDataNode.
 */
#define VISU_DATA_NODE_TYPE	     (visu_data_node_get_type ())
/**
 * VISU_DATA_NODE:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #VisuDataNode type.
 */
#define VISU_DATA_NODE(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, VISU_DATA_NODE_TYPE, VisuDataNode))
/**
 * VISU_DATA_NODE_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #VisuDataNodeClass.
 */
#define VISU_DATA_NODE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, VISU_DATA_NODE_TYPE, VisuDataNodeClass))
/**
 * IS_VISU_DATA_NODE_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #VisuDataNode object.
 */
#define IS_VISU_DATA_NODE_TYPE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, VISU_DATA_NODE_TYPE))
/**
 * IS_VISU_DATA_NODE_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #VisuDataNodeClass class.
 */
#define IS_VISU_DATA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, VISU_DATA_NODE_TYPE))
/**
 * VISU_DATA_NODE_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define VISU_DATA_NODE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, VISU_DATA_NODE_TYPE, VisuDataNodeClass))

/**
 * VisuDataNodeClass:
 *
 * An opaque structure.
 */
typedef struct _VisuDataNodeClass VisuDataNodeClass;

/**
 * VisuDataNode:
 *
 * An opaque structure.
 */
typedef struct _VisuDataNode VisuDataNode;

/**
 * VisuDataNodeFromStringFunc:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode ;
 * @labelIn: a formatted string ;
 * @labelOut: a pointer to store a string ;
 * @modify: TRUE if the values have been modified.
 *
 * If the string is correctly formatted (that means it has the same format as
 * the string returned by GetValueAsStringFunc()) the stored values are modified.
 * The resulting string is created and put into @labelOut. If the input string @labelIn
 * is unparsable, @labelOut will contain current values.
 *
 * Returns: TRUE if the string was correctly parsed (modified or not).
 */
typedef gboolean (*VisuDataNodeFromStringFunc)(VisuDataNode *data, VisuData *dataObj,
					   VisuNode *node, gchar *labelIn,
					   gchar **labelOut, gboolean *modify);
/**
 * VisuDataNodeToStringFunc:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode.
 *
 * For the given node, the values stored are printed into a string.
 *
 * Returns: a newly created string (use g_free()).
 */
typedef gchar* (*VisuDataNodeToStringFunc)(VisuDataNode *data, VisuData *dataObj,
					 VisuNode *node);

/* Maybe removed if the stuff is converted to GObject. */
/**
 * VisuDataNodeCallbackMethod:
 * @dataObj: the #VisuData object on which the callback is done ;
 * @node: the #VisuNode on which the callback is done ;
 * @data: a user defined pointer.
 *
 * Interface for callbacks methods that are called whenever a data is changed
 * on a node.
 *
 * WARNING: it may be removed later.
 */
typedef void (*VisuDataNodeCallbackMethod)(VisuData *dataObj, VisuNode *node, gpointer data);

/**
 * visu_data_node_get_type:
 *
 * This method returns the type of #VisuDataNode, use VISU_DATA_NODE_TYPE instead.
 *
 * Returns: the type of #VisuDataNode.
 */
GType visu_data_node_get_type(void);



GObject* visu_data_node_new(const gchar *name, GType type);
GObject* visu_data_node_newWithCallbacks(const gchar *name,
                                         VisuDataNodeFromStringFunc setAsString,
                                         VisuDataNodeToStringFunc getAsString);

/**
 * nodeDataGet_list:
 *
 * All registered #VisuDataNode are stored in an intern list. This method is
 * used to retrieve it.
 *
 * Returns: a #GList of all registereed #VisuDataNode (this list is owned by V_Sim).
 */
GList* nodeDataGet_list(void);

/**
 * visu_data_node_setLabel:
 * @data: a #VisuDataNode ;
 * @label: an UTF8 string (may be translated).
 *
 * A #VisuDataNode can have a label, if not its name is used.
 * Notice that @label is not copied.
 */
void visu_data_node_setLabel(VisuDataNode *data, const gchar *label);
/**
 * visu_data_node_getLabel:
 * @data: a #VisuDataNode ;
 *
 * A #VisuDataNode can have a label, if not its name is used.
 *
 * Returns: the label of the node (in UTF8), this string is owned by V_Sim.
 */
const gchar* visu_data_node_getLabel(VisuDataNode *data);

/**
 * visu_data_node_setUsed:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object ;
 * @nb: a positive or null integer.
 *
 * A #VisuDataNode stores data for each node of a given #VisuData. The number of data stored for
 * each node is set with this method. When some part wants to set a new node property
 * and wants to make it public, this method can be called. It also can be called when
 * the node property is removed (using a null @nb argument).
 * If @nb is changed for a positive value, the "propertyUsed"
 * signal is emitted with @dataObj as argument, instead if the value is changed
 * for null, the "propertyUnused" signal is triggered also with @dataObj as argument.
 */
void visu_data_node_setUsed(VisuDataNode *data, VisuData *dataObj, gint nb);
/**
 * visu_data_node_getUsed:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object.
 *
 * Access method to know if the given @dataObj has a public node property of the type
 * @data.
 *
 * Returns: TRUE if @dataObj has a node property of the given type.
 */
gboolean visu_data_node_getUsed(VisuDataNode *data, VisuData *dataObj);

/**
 * visu_data_node_setValueAsString:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode ;
 * @labelIn: a formatted string ;
 * @labelOut: a pointer to store a string.
 *
 * If the string is correctly formatted (that means it has the same format as
 * the string returned by visu_data_node_getValueAsString()) the stored values are modified.
 * The resulting string is created and put into @labelOut. If the input string @labelIn
 * is unparsable, @labelOut will contain current values. Notice that this method is
 * callable only if the @data is editable (see visu_data_node_getEditable()).
 *
 * Returns: TRUE if the string was correctly parsed.
 */
gboolean visu_data_node_setValueAsString(VisuDataNode *data, VisuData *dataObj,
				   VisuNode *node, gchar *labelIn,
				   gchar **labelOut);
/**
 * visu_data_node_getValueAsString:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object ;
 * @node: a #VisuNode.
 *
 * For the given node, the values stored are printed into a string.
 *
 * Returns: a newly created string.
 */
gchar* visu_data_node_getValueAsString(VisuDataNode *data, VisuData *dataObj, VisuNode *node);

void visu_data_node_setCallback(VisuDataNode *data, VisuDataNodeCallbackMethod callback,
                                gpointer user_data);
/**
 * visu_data_node_setEditable:
 * @data: a #VisuDataNode ;
 * @status: a boolean value.
 *
 * Set if the values are modifiable.
 */
void visu_data_node_setEditable(VisuDataNode *data, gboolean status);
/**
 * visu_data_node_getEditable:
 * @data: a #VisuDataNode.
 *
 * If some callback method has been given with visu_data_node_setCallback(), then
 * the values are considered editable.
 *
 * Returns: TRUE if values are editable.
 */
gboolean visu_data_node_getEditable(VisuDataNode *data);
/**
 * visu_data_node_emitValueChanged:
 * @data: a #VisuDataNode ;
 * @dataObj: a #VisuData object.
 *
 * Emit the 'valueChanged' signal. This method should be called after
 * all changes have been done to a node property set of nodes. Then routines
 * using this property can update itself.
 */
void visu_data_node_emitValueChanged(VisuDataNode *data, VisuData *dataObj);


G_END_DECLS

#endif
