/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef AXES_H
#define AXES_H

#include <visu_extension.h>
#include <visu_tools.h>
#include <visu_data.h>

/**
 * initExtensionAxes
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the #listInitExtensionFunc to
 * be called automatically by the initVisuExtensions() at V_Sim
 * startup.
 *
 * Returns: a pointer to the VisuExtension it created or
 * NULL otherwise.
 */
VisuExtension* initExtensionAxes();

/**
 * VISU_GLEXT_AXES_ID:
 *
 * The id used to identify this extension, see
 * visuExtensions_rebuildList() for instance.
 */
#define VISU_GLEXT_AXES_ID "Axes"

/**
 * visu_glExt_axes_setRGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #TOOL_COLOR_MASK_R, #TOOL_COLOR_MASK_G, #TOOL_COLOR_MASK_B, #TOOL_COLOR_MASK_RGBA or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter axes_color.
 *
 * Returns: TRUE if visu_glExt_axes_draw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean visu_glExt_axes_setRGBValues(float rgb[3], int mask);
/**
 * visu_glExt_axes_setLineWidth:
 * @width: value of the desired axe width.
 *
 * Method used to change the value of the parameter axes_line_width.
 *
 * Returns: TRUE if visu_glExt_axes_draw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean visu_glExt_axes_setLineWidth(float width);
/**
 * visu_glExt_axes_setLineStipple:
 * @stipple: value of the desired pattern.
 *
 * Method used to change the value of the parameter axes_line_stipple.
 *
 * Returns: TRUE if visu_glExt_axes_draw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean visu_glExt_axes_setLineStipple(guint16 stipple);
/**
 * visu_glExt_axes_setOn:
 * @value: TRUE if axes must be drawn, FALSE otherwise.
 *
 * Method used to change the value of the parameter axes_are_on.
 *
 * Returns: TRUE if visu_glExt_axes_draw() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
gboolean visu_glExt_axes_setOn(gboolean value);

/**
 * visu_glExt_axes_getRGBValues:
 *
 * Read all the colour components of axes (in [0;1]). 
 *
 * Returns: three RGB values, private from V_Sim, read only.
 */
float* visu_glExt_axes_getRGBValues();
/**
 * visu_glExt_axes_getOn:
 *
 * Read if axes are drawn or not.
 *
 * Returns: 1 if axes are drawn, 0 otherwise.
 */
int visu_glExt_axes_getOn();
/**
 * visu_glExt_axes_getLineWidth:
 *
 * Read the line width used to draw axes.
 *
 * Returns: the value of current axes width.
 */
float visu_glExt_axes_getLineWidth();
/**
 * visu_glExt_axes_getLineStipple:
 *
 * Read the line pattern used to draw axes.
 *
 * Returns: the value of current axes pattern.
 */
guint16 visu_glExt_axes_getLineStipple();
/**
 * visu_glExt_axes_draw:
 * @dataObj: the #VisuData object to build axes for.
 *
 * This method create a compile list that draw a box for the given @data.
 */
void visu_glExt_axes_draw(VisuData *dataObj);

#endif
