/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_BASIC_H
#define VISU_BASIC_H

#include <glib.h>
#include "visu_data.h"
#include "visu_tools.h"
#include "coreTools/toolFileFormat.h"
#include "coreTools/toolOptions.h"
#include "extraFunctions/surfaces.h"
#include "extraFunctions/scalarFields.h"
#include "extensions/extInfos.h"

G_BEGIN_DECLS

/* Here, basic functions that don't require GTK, are defined. */

typedef struct VisuOptionSet_struct
{
  gchar *colorFile;

  Plane **planesList;

  Surfaces **surfsList;
  GList *fieldsList;

  Shade *shade;

  gint *mapPlaneId;
  matrix_scaleflag logScale;
  guint nIsolines;
  float* isoLinesColor;

  gchar *bgImage;
} VisuOptionSet;

/**
 * visuBasicLoad_dataFromFile:
 * @data: a #VisuData object ;
 * @format: a pointer on a format (can be NULL if format is to be
 * guessed) ;
 * @nSet: an integer ;
 * @error: a pointer to store a possible error, location must be initialized to (GError*)0.
 *
 * This calls the load method of the current rendering
 * method. Some informations may be store in @error->message if the returned
 * value is FALSE.
 * The file(s) which is(are) opened is(are) stored in the
 * #VisuData. The @nSet argument is used to load a specific set of
 * nodes if the input format supports it. If @nSet is 0, then the
 * default set of nodes is loaded.
 *
 * Returns: TRUE if everithing is OK, if FALSE, the @error is set and should be freed
 *          with g_error_free().
 */
gboolean visuBasicLoad_dataFromFile(VisuData *data, FileFormat *format,
				    int nSet, GError **error);

/**
 * visuBasicInit:
 *
 * A call to this method is done at startup after having probe the locale of the file
 * system and having initialized the rendering window. It makes the following actions :
 * create the visu object to store the signals, initialize the module part (parameters,
 * and resources), initialize the dump part, the OpenGL part and its extensions, the
 * storage of elements and the 'colorize with data' part.
 */
void visuBasicInit();
/**
 * visuBasicQuit:
 * @data: a pointer to the #GMainLoop.
 *
 * A call to this method makes the #GMainLoop stop.
 *
 * Returns: FALSE, always.
 */
gboolean visuBasicQuit(gpointer data);
/**
 * visuBasicParse_configFiles:
 * 
 * Parse the parameter and the resource file. Used once at startup.
 *
 * Returns: a newly allocated #GString if some error occured.
 */
GString* visuBasicParse_configFiles();
/**
 * visuBasicApply_commandLine:
 * @data: a #VisuData object to apply the options on ;
 * @set: a table of options ;
 * @error: a location for error report.
 *
 * Call all the get methods on the command line options to tune the
 * given @data. This will create some static internal data. Use
 * visuBasicFree_commandLine() to free them after use.
 *
 * Returns: TRUE if complete without error.
 */
gboolean visuBasicApply_commandLine(VisuData *data, VisuOptionSet *set,
				    GError **error);
/**
 * visuBasicCreate_extensions:
 * @data: a #VisuData object ;
 * @set: a table of options ;
 * @rebuild: a boolean.
 *
 * Create all extensions (planes, surfaces...) for the given data. Use
 * static values read from visuBasicApply_commandLine(). This method
 * is mainly used when V_Sim run without the command panel.
 */
void visuBasicCreate_extensions(VisuData *data, VisuOptionSet *set, gboolean rebuild);
/**
 * visuBasicSet_dataFromCommandLine:
 * 
 * Read the command line option and set the filenames for a new
 * #VisuData. The object is not loaded (files are not parsed), just prepared.
 *
 * Returns: a newly allocated #VisuData if required.
 */
VisuData* visuBasicSet_dataFromCommandLine();
/**
 * visuBasicSet_extInfos:
 * @dataObj: a #VisuData object ;
 * @method: where to draw information ;
 * @nodes: a possible list of selected nodes, or NULL ;
 * @data: the information to draw.
 *
 * Create and draw possible information on nodes.  This method
 * is mainly used when V_Sim run without the command panel.
 */
void visuBasicSet_extInfos(VisuData *dataObj, DrawMethod method,
			   int *nodes, DataNode *data);
/**
 * visuBasicExport_main:
 *
 * This method is called when V_Sim is in export mode from the command line. 
 *
 * Returns: 0 if everything is normal, 1 if an error occured.
 */
int visuBasicExport_main(void);

VisuUnits visuBasicGet_preferedUnit();
gboolean visuBasicSet_preferedUnit(VisuUnits unit);


#define V_SIM_DATA_DIR           visuBasicGet_dataDir()
#define V_SIM_LEGAL_DIR          visuBasicGet_legalDir()
#define V_SIM_PIXMAPS_DIR        visuBasicGet_pixmapsDir()
#define V_SIM_LOCAL_CONF_DIR     visuBasicGet_localDir()
#define V_SIM_OLD_LOCAL_CONF_DIR visuBasicGet_oldLocalDir()
#define V_SIM_PLUGINS_DIR        visuBasicGet_pluginsDir()
#define V_SIM_LOCALE_DIR         visuBasicGet_localeDir()
/**
 * visuBasicSet_paths:
 * @exeLocation: give argv[0] which is the complete path to the executable.
 * 
 * This method sets the paths. On Unix systems, this method sets the paths
 * from macros defined by configure. On Win32 systems, it reads paths in
 * a v_sim.ini file found in the current directory or in the C:\windows.
 */
void visuBasicSet_paths();
const gchar* visuBasicGet_dataDir();
const gchar* visuBasicGet_legalDir();
const gchar* visuBasicGet_pixmapsDir();
const gchar* visuBasicGet_localDir();
const gchar* visuBasicGet_oldLocalDir();
const gchar* visuBasicGet_pluginsDir();
const gchar* visuBasicGet_localeDir();

void visuBasicFree_all();

G_END_DECLS

#endif
