/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef SCALE_H
#define SCALE_H

#include <visu_tools.h>
#include <visu_data.h>

/**
 * MASK_XYZ_X:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the x direction.
 */
#define MASK_XYZ_X (1 << 0)
/**
 * MASK_XYZ_Y:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the y direction.
 */
#define MASK_XYZ_Y (1 << 1)
/**
 * MASK_XYZ_Z:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value actually
 * correspond to the z direction.
 */
#define MASK_XYZ_Z (1 << 2)
/**
 * MASK_XYZ_ALL:
 *
 * This value can be used to create a mask for methods that
 * require one for reading xyz coordinates array. This value is a
 * shortcut for #MASK_XYZ_X | #MASK_XYZ_Y | #MASK_XYZ_Z.
 */
#define MASK_XYZ_ALL (7)

/**
 * SCALE_TYPE:
 *
 * return the type of #Scale.
 */
#define SCALE_TYPE	     (scale_get_type ())
/**
 * SCALE:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #Scale type.
 */
#define SCALE(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, SCALE_TYPE, Scale))
/**
 * SCALE_CLASS:
 * @klass: a #GClassObject to cast.
 *
 * Cast the given @klass into #ScaleClass.
 */
#define SCALE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, SCALE_TYPE, ScaleClass))
/**
 * IS_SCALE_TYPE:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #Scale object.
 */
#define IS_SCALE_TYPE(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, SCALE_TYPE))
/**
 * IS_SCALE_CLASS:
 * @klass: a #GClassObject to test.
 *
 * Test if the given @klass is of the type of #ScaleClass class.
 */
#define IS_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, SCALE_TYPE))
/**
 * SCALE_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define SCALE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, SCALE_TYPE, ScaleClass))

/**
 * ScaleClass:
 *
 * A short way to identify #ScaleClass_struct structure.
 */
typedef struct _ScaleClass ScaleClass;

/**
 * Scale:
 *
 * All fields are private, use the access routines.
 */
typedef struct _Scale Scale;

/**
 * scale_get_type:
 *
 * This method returns the type of #Scale, use SCALE_TYPE instead.
 *
 * Returns: the type of #Scale.
 */
GType scale_get_type(void);

/**
 * scaleNew:
 * @origin: the origin ;
 * @orientation: the orientation in cartesian coordinates ;
 * @length: the length of the arrow ;
 * @legend: the text going with the arrow (can be NULL).
 *
 * Create a new arrow pointing somewhere in the box with a label.
 * If @legend is NULL, then the label will be the value of the length.
 *
 * Returns: a newly created #Scale object.
 */
Scale* scaleNew(float origin[3], float orientation[3],
		float length, const gchar *legend);

/**
 * scalesSet_defaultRGBValues:
 * @rgba: a four floats array with values (0 <= values <= 1) for the
 * red, the green, the blue and the alpha color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the private parameter
 * scales_color. This affects all the drawn scales.
 *
 * Returns: TRUE if scaleDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean scalesSet_defaultRGBValues(float rgba[4], int mask);
/**
 * scalesSet_defaultLineWidth:
 * @width: value of the desired width.
 *
 * Method used to change the value of the parameter
 * scale_line_width. This affects all the drawn scales.
 *
 * Returns: TRUE if scaleDraw() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
gboolean scalesSet_defaultLineWidth(float width);
/**
 * scalesSet_areOn:
 * @value: 1 if a scale must be drawn, 0 otherwise.
 *
 * Method used to change the value of the parameter Scale_are_on.
 *
 * Returns: 1 if scaleDraw() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
gboolean scalesSet_areOn(gboolean value);

/**
 * scalesGet_defaultRGBColor:
 *
 * All the scales shared a common colour.
 *
 * Returns: a four component array.
 */
float* scalesGet_defaultRGBColor();
/**
 * scalesGet_areOn:
 *
 * The scales can be turned off or on.
 *
 * Returns: TRUE if scale are drawn, FALSE otherwise.
 */
gboolean scalesGet_areOn();
/**
 * scalesGet_defaultLineWidth:
 *
 * The scales share a line width for the stick of the arrow.
 *
 * Returns: the value of current width.
 */
float scalesGet_defaultLineWidth();
/**
 * scalesSet_defaultStipple:
 * @stipple: a pattern for line.
 *
 * The scales share a line pattern for the stick of the arrow.
 *
 * Returns: TRUE if scale are drawn, FALSE otherwise.
 */
gboolean scalesSet_defaultStipple(guint16 stipple);
/**
 * scalesGet_defaultStipple:
 *
 * The scales share a line pattern for the stick of the arrow.
 *
 * Returns: the value of current stipple pattern.
 */
guint16 scalesGet_defaultStipple();
/**
 * scalesDraw:
 * @dataObj: the #VisuData object to build axes for.
 *
 * This method create a compile list that draw a box for the given @data.
 */
void scalesDraw(VisuData *dataObj);
/**
 * scalesGet_scales:
 *
 * All the available scales can be retrieve with this method.
 *
 * Returns: a private #GList.
 */
GList* scalesGet_scales();


/**
 * scaleSet_origin:
 * @scale: the #Scale to modify ;
 * @xyz: a vector in cartesian coordinates ;
 * @mask: relevant values in @xyz.
 *
 * Routine that changes the origin of the scale.
 *
 * Returns: TRUE if scalesDraw() should be called.
 */
gboolean scaleSet_origin(Scale *scale, float xyz[3], int mask);
/**
 * scaleSet_orientation:
 * @scale: the #Scale to modify ;
 * @xyz: a vector in cartesian coordinates ;
 * @mask: relevant values in @xyz.
 *
 * Routine that changes the direction of the scale.
 *
 * Returns: TRUE if scalesDraw() should be called.
 */
gboolean scaleSet_orientation(Scale *scale, float xyz[3], int mask);
/**
 * scaleSet_length:
 * @scale: the #Scale to modify ;
 * @lg: a positive length.
 *
 * Routine that changes the length of the scale.
 *
 * Returns: TRUE if scalesDraw() should be called.
 */
gboolean scaleSet_length(Scale *scale, float lg);
/**
 * scaleSet_legend:
 * @scale: the #Scale to modify ;
 * @value: a string (can be NULL).
 *
 * Routine that changes the legend of the scale. If @value is NULL
 * then the length of the scale is printed.
 *
 * Returns: TRUE if scalesDraw() should be called.
 */
gboolean scaleSet_legend(Scale *scale, const gchar *value);

/**
 * scaleGet_legend:
 * @scale: the #Scale to poll.
 *
 * A #Scale can have a legend. This is not actualy the string printed
 * on screen but the one used to generate it.
 *
 * Returns: a string (private, do not free it).
 */
const gchar* scaleGet_legend(Scale *scale);
/**
 * scaleGet_length:
 * @scale: the #Scale to poll.
 *
 * A #Scale is characterised by its length.
 *
 * Returns: a positive floating point value.
 */
float scaleGet_length(Scale *scale);
/**
 * scaleGet_origin:
 * @scale: the #Scale to poll.
 *
 * A #Scale is characterised by its origin in cartesian coordinates.
 *
 * Returns: three floating point values.
 */
float* scaleGet_origin(Scale *scale);
/**
 * scaleGet_orientation:
 * @scale: the #Scale to poll.
 *
 * A #Scale is characterised by its orientation in cartesian coordinates.
 *
 * Returns: three floating point values.
 */
float* scaleGet_orientation(Scale *scale);


#endif
