-- UUAGC 0.9.5 (AbstractSyntax.ag)
module AbstractSyntax where

-- AbstractSyntax.ag imports
import Data.Set(Set)
import Data.Map(Map)
import Patterns    (Pattern(..),Patterns)
import Expression  (Expression(..))
import CommonTypes
-- Alternative -------------------------------------------------
{-
   alternatives:
      alternative Alternative:
         child con            : {Constructor}
         child children       : Children
         child rules          : Rules
         child typeSigs       : TypeSigs
-}
data Alternative = Alternative (Constructor) (Children) (Rules) (TypeSigs)
-- Alternatives ------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : Alternative
         child tl             : Alternatives
      alternative Nil:
-}
type Alternatives = [Alternative]
-- Child -------------------------------------------------------
{-
   alternatives:
      alternative Child:
         child name           : {Name}
         child tp             : {Type}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child higherOrder    : {Bool}
-}
data Child = Child (Name) (Type) (Attributes) (Attributes) (Bool)
-- Children ----------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : Child
         child tl             : Children
      alternative Nil:
-}
type Children = [Child]
-- Grammar -----------------------------------------------------
{-
   alternatives:
      alternative Grammar:
         child typeSyns       : {TypeSyns}
         child useMap         : {UseMap}
         child derivings      : {Derivings}
         child wrappers       : {Set Nonterminal}
         child prods          : Productions
         child pragmas        : {PragmaMap}
         child manualAttrOrderMap : {AttrOrderMap}
-}
data Grammar = Grammar (TypeSyns) (UseMap) (Derivings) (Set Nonterminal) (Productions) (PragmaMap) (AttrOrderMap)
-- Production --------------------------------------------------
{-
   alternatives:
      alternative Production:
         child nt             : {Nonterminal}
         child inh            : {Attributes}
         child syn            : {Attributes}
         child alts           : Alternatives
-}
data Production = Production (Nonterminal) (Attributes) (Attributes) (Alternatives)
-- Productions -------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : Production
         child tl             : Productions
      alternative Nil:
-}
type Productions = [Production]
-- Rule --------------------------------------------------------
{-
   alternatives:
      alternative Rule:
         child pattern        : {Pattern}
         child rhs            : {Expression}
         child owrt           : {Bool}
         child origin         : {String}
-}
data Rule = Rule (Pattern) (Expression) (Bool) (String)
-- Rules -------------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : Rule
         child tl             : Rules
      alternative Nil:
-}
type Rules = [Rule]
-- TypeSig -----------------------------------------------------
{-
   alternatives:
      alternative TypeSig:
         child name           : {Name}
         child tp             : {Type}
-}
data TypeSig = TypeSig (Name) (Type)
-- TypeSigs ----------------------------------------------------
{-
   alternatives:
      alternative Cons:
         child hd             : TypeSig
         child tl             : TypeSigs
      alternative Nil:
-}
type TypeSigs = [TypeSig]
