/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef UTOUCH_QML_UTOUCHROTATEAREA_H_
#define UTOUCH_QML_UTOUCHROTATEAREA_H_

#include "continuousgesturearea.h"

/**
 * An input-only item for receiving non-instantaneous rotate gesture events.
 */

class UTouchRotateArea : public ContinuousGestureArea {
  Q_OBJECT
  /**
   * This property holds the rotation angle of the touches.
   */
  Q_PROPERTY(GestureProperty* angle READ angle CONSTANT)

 public:
  explicit UTouchRotateArea(QDeclarativeItem* parent = 0);

  GestureProperty* angle() { return &angle_; }

  virtual bool IsGestureEventHandled(GestureEvent* event);
  virtual void HandleGestureUpdateEvent(bool end, GestureEvent* event);

 private:
  GestureProperty angle_;

  Q_DISABLE_COPY(UTouchRotateArea)
};

QML_DECLARE_TYPE(UTouchRotateArea)

#endif  // UTOUCH_QML_UTOUCHROTATEAREA_H_
