/**
 * @file utouch.h
 * @brief Public interface for the uTouch compiz plugin.
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#include <core/core.h>
#include <core/pluginclasshandler.h>


class UtouchScreen
: public ScreenInterface
, public PluginClassHandler<UtouchScreen, CompScreen>
{
public:
  UtouchScreen(CompScreen* s);

  virtual ~UtouchScreen();

private:
  CompScreen*   screen;
};


class UtouchVTable
: public CompPlugin::VTableForScreen<UtouchScreen>
{
  bool init();
};

