function UnityContextManager () {
    this.contexts = [];
}

UnityContextManager.prototype.addContext = function (context) {
    if (this.contexts.indexOf(context) >= 0) {
    	return;
    }
    this.contexts.push (context);
}

UnityContextManager.prototype.removeContext = function (context) {
    var index = this.contexts.indexOf(context);
    
    if (index == -1)
        return false;

    delete this.contexts[this.contexts.indexOf(context)];

    return true;
}

UnityContextManager.prototype.findContextByWindow = function (window) {
    var i;

    for (i in this.contexts) {
	   var context = this.contexts[i];
	
    	if (context != undefined && 
	       context != null && 
	        context.window == window) {
	       return context;
	   }
    }

    return null;
}

UnityContextManager.prototype.findContextByParent = function (parent) {
    var i;
    
    for (i in this.contexts) {
    	var context = this.contexts[i];
    	
    	if (context != undefined &&
    	    context != null &&
    	    context.parent == parent) {
    	    return context;
    	}
    }
    return null;
}

