/*
 * Copyright (C) 2012 Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Weihua Zhang <fly2high@126.com>
 * Authored by liuxing <liuxingcs@yeah.net>
 * Modified Information: 
 * 1. Add is_in_China to decide wether you are in China 
 * 2. Add MusicBaiduCollection.collection function to search China music from music.baidu.com
 */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

using GLib;


namespace Unity.MusicLens
{

public class MusicBaiduCollection : Object
{

    private const string MUSICBAIDU_BASE_URI = "http://music.baidu.com/search/";
    private static string IS_IN_CHINA = "Unknown";
    private const string ASK_IP_SERVER_URI_ONE = "http://ip.chinaz.com/";
    private const string ASK_IP_SERVER_URI_TWO = "http://www.123myip.co.uk/";

    const string SONG_MISSING_ICON_PATH = "/usr/share/unity/themes/baidu_song_missing.png";


    public MusicBaiduCollection ()
    {

    }

    private  bool is_in_China (Cancellable? cancellable = null)
    {

        if(IS_IN_CHINA == "Unknown")
        {


            File file = File.new_for_uri (ASK_IP_SERVER_URI_ONE);


            uint8[] data;
            string content;
            string etag_out;

	    
            if( file.load_contents(cancellable, out data, out etag_out))
            {

                //Convert uint8[] to string.
                content = (string) data;

                var location =  content.index_of("北京") + content.index_of("上海") + content.index_of("天津") + content.index_of("重庆") +
                                content.index_of("黑龙江") + content.index_of("吉林") + content.index_of("辽宁") + content.index_of("江苏") +
                                content.index_of("山东") + content.index_of("安徽") + content.index_of("河北") + content.index_of("河南") +
                                content.index_of("湖北") + content.index_of("湖南") + content.index_of("江西") + content.index_of("陕西") +
                                content.index_of("山西") + content.index_of("四川") + content.index_of("青海") + content.index_of("海南") +
                                content.index_of("广东") + content.index_of("贵州") + content.index_of("浙江") + content.index_of("福建") +
                                content.index_of("台湾") + content.index_of("甘肃") + content.index_of("云南") + content.index_of("内蒙古") +
                                content.index_of("宁夏") +content.index_of("新疆") + content.index_of("西藏") + content.index_of("广西") +
                                content.index_of("香港") + content.index_of("澳门");



                if(location <0 )
                {
		    //if ASK_IP_SERVER_URI_ONE server reposended failed,ask ASK_IP_SERVER_URI_TWO server. 
                    file = File.new_for_uri (ASK_IP_SERVER_URI_TWO);

                    try
                    {

                        if( file.load_contents(cancellable, out data, out etag_out))
                        {

                            //Convert uint8[] to string.
                            content = (string) data;

                            location =  content.index_of("China") ;
                            if(location > 0 )
                            {
                                IS_IN_CHINA = "Yes";
                                return true;
                            }
                        }

                    }
                    catch (Error e)
                    {
                        warning ("Error reading URL '%s': %s", file.get_uri (), e.message);
                    }
                }
                else
                {
                    IS_IN_CHINA = "Yes";
                    return true;

                }

            }

        }
        else
        {
            return true;
        }

        return false;
    }


    public async void search (LensSearch search, SearchType search_type,
                              owned List<FilterParser> filters, int max_results = -1, Cancellable cancellable) throws IOError
    {
        File song_file;
        File album_file;
        uint8[] song_data;
        uint8[] album_data;
        string uri;
        string etag_out;

        if(!is_in_China(cancellable))
        {
            warning("Error can not search music from Baidu !");
            return;
        }

        try {
            //Search the first page song from Baidu music
            uri = build_search_uri(search.search_string, filters, 0, 0);
            if(uri != null)
            {
                song_file = File.new_for_uri (uri);
                if(yield song_file.load_contents_async(cancellable, out song_data, out etag_out))
                    read_song_search_result_from_Baidu(search,song_data);
            }
            //Search the next page song from Baidu music
            uri = build_search_uri(search.search_string, filters, 0, 1);
            if(uri != null)
            {
                song_file = File.new_for_uri (uri);
                if(yield song_file.load_contents_async(cancellable, out song_data, out etag_out))
                    read_song_search_result_from_Baidu(search,song_data);
            }

            //Search the first page album from Baidu music 
            uri = build_search_uri(search.search_string, filters, 1, 0);
            if(uri != null)
            {
                album_file = File.new_for_uri (uri);
                if(yield album_file.load_contents_async(cancellable, out album_data, out etag_out))
                    read_album_search_result_from_Baidu(search,album_data);
            }
            //Search the next page album from Baidu music
            uri = build_search_uri(search.search_string, filters, 1, 1);
            if(uri != null)
            {
                album_file = File.new_for_uri (uri);
                if(yield album_file.load_contents_async(cancellable, out album_data, out etag_out))
                    read_album_search_result_from_Baidu(search,album_data);
            }

        }
        catch (Error e)
        {
            warning ("Error getting result from baidu: %s(Failed to Search music from Baidu)!", e.message);
        }

    }

    public void get_song_details (string uri, out Album album,out SList<Track> tracks,Cancellable? cancellable = null)
    {

	album = new Album ();
        tracks = new SList<Track> ();
        File song_file;
        uint8[] song_data;
        string http_uri = uri.substring (7);// strip off "song://" from the uri
        string etag_out;


        try
        {

            if(http_uri != null)
            {
                song_file = File.new_for_uri (http_uri);
                if(song_file.load_contents(cancellable, out song_data, out etag_out))
                {


                    string content;
                    //Convert uint8[] to string.
                    content = (string) song_data;

                    //Parse the contents to get results.
                    
                    var iIndex = content.index_of("<div class=\"song");
                    if( iIndex == -1)
                        return;

                    var iEnd = content.index_of("</div>");
                    string song_name = content.substring(iIndex, iEnd-iIndex);
                    iIndex=-1;
                    iEnd=-1;
                    iIndex = song_name.index_of("name") + 6;
                    iEnd = song_name.substring(iIndex).index_of("</span>");
                    if( iIndex == -1)
                        return;

                    album.title = song_name.substring(iIndex, iEnd);
                    //Maybe song name append like this '审批文号：WJXXXXX',so must deal with.
                    iEnd = album.title.index_of("审批文号");
                    if( iEnd != -1)
                        album.title = album.title.substring(0,iEnd);


                    iIndex=-1;
                    iEnd=-1;
                    iIndex = content.index_of("<span class=\"author_list");
                    if( iIndex == -1)
                        return;

                    iEnd = content.index_of("</span>");
                    content = content.substring(iIndex, iEnd-iIndex);
                    iIndex=-1;
                    iEnd=-1;
                    iIndex = content.index_of("title=") + 7;
                    iEnd = content.substring(iIndex).index_of("\"");
                    if( iIndex == -1)
                        return;
                    album.artist = content.substring(iIndex,iEnd);

                    //Because song icon_hint in Baidu no exist,so set SONG_MISSING_ICON_PATH.
                    album.artwork_path = SONG_MISSING_ICON_PATH;
                    
		    album.uri = uri;

                    var track = new Track ();
                    track.uri = uri;
                    track.title = album.title ;
                    tracks.append (track);


                }
            }
        }
        catch (Error e)
        {
            warning ("Error fetching details for '%s': %s", uri, e.message);
        }

    }

    public void get_album_details(string uri, out Album album, out SList<Track> tracks,Cancellable? cancellable = null)
    {
        album = new Album ();
        tracks = new SList<Track> ();
	File song_file;
        uint8[] song_data;
        string http_uri = uri.substring (8);// strip off "album://" from the uri

        string etag_out;


        try
        {

            if(http_uri != null)
            {
                song_file = File.new_for_uri (http_uri);
                if(song_file.load_contents(cancellable, out song_data, out etag_out))
                {


                    string content;
                    //Convert uint8[] to string.
                    content = (string) song_data;

                    //Parse the contents to get results.
                    string album_content=content;

                   
                    var iIndex = album_content.index_of("<div class=\"album-info");
                    if( iIndex == -1)
                        return;

                    var iEnd = album_content.substring(iIndex).index_of("</li>");
                    album_content = album_content.substring(iIndex, iEnd+5);
                    iIndex=-1;
                    iEnd=-1;
                    
                    iIndex = album_content.index_of("img src=") + 9;
                    iEnd = album_content.substring(iIndex).index_of("\"");
                    if( iIndex == -1)
                        return;

                    album.artwork_path = album_content.substring(iIndex,iEnd);
                    album_content= album_content.substring(iIndex);

                    
                    iIndex = album_content.index_of("album-name") + 12;
                    iEnd = album_content.substring(iIndex).index_of("</h2>");
                    if( iIndex == -1)
                        return;
                    album.title = album_content.substring(iIndex, iEnd);
                    
		    iIndex = album_content.index_of("title=") + 7;
                    iEnd = album_content.substring(iIndex).index_of("\"");
                    if( iIndex == -1)
                        return;
                    album.artist = album_content.substring(iIndex,iEnd);

                    iIndex=-1;
                    iEnd=-1;
                    iIndex = content.index_of("<li  data-songitem");
                    if( iIndex == -1)
                        return;

                    iEnd = content.last_index_of("<li  data-songitem");
                    content = content.substring(iIndex, iEnd+3500- iIndex);
                    List<string> lilist = new List<string> ();
                    var liIndex = content.index_of("</li>");
                    while(liIndex != -1)
                    {
                        lilist.append(content.substring(0,liIndex));
                        content = content.substring(liIndex+5);
                        liIndex = content.index_of("</li>");
                    }

                    
                    //Get album information.
                    foreach (string li in lilist)
                    {
			//Get album uri.
                        iIndex = li.index_of("/song");
                        iEnd = li.substring(iIndex).index_of("\"");
                        if(iIndex==-1||iEnd==-1)
                            continue;

                        var track = new Track ();
			//FIXME drag n drop uri needs to be the song:// link
                        track.uri = string.join("","song://http://music.baidu.com",li.substring(iIndex, iEnd));
                       
			//Get album title.
			li = li.substring(iIndex);
                        iIndex = li.index_of("title=") + 7;
                        iEnd = li.substring(iIndex).index_of("\"");
                        track.title = li.substring(iIndex,iEnd);
                        //Maybe song name append like this '审批文号：WJXXXXX',so must deal with.
                        iEnd = track.title.index_of("审批文号");
                        if( iEnd != -1)
                            track.title = track.title.substring(0,iEnd);

                        tracks.append (track);
                    }

                }
            }
        }
        catch (Error e)
        {
            warning ("Error fetching details for '%s': %s", uri, e.message);
        }

    }



    private void  read_song_search_result_from_Baidu(LensSearch search, uint8[] data)
    {
        var results_model = search.results_model;

	    Track track = new Track ();
            string content;
            //Convert uint8[] to string）
            content = (string) data;
            //Parse the contents to get results
            var iIndex = content.index_of("<li data-songitem");
            if( iIndex == -1)
                return;
            var iEnd = content.last_index_of("<li data-songitem");
            content = content.substring(iIndex, iEnd+3500- iIndex);

            List<string> lilist = new List<string> ();
            var liIndex = content.index_of("</li>");
            while(liIndex != -1)
            {
                lilist.append(content.substring(0,liIndex));
                content = content.substring(liIndex+5);
                liIndex = content.index_of("</li>");
            }

            //Get song information.
            foreach (string li in lilist)
            {
                iIndex = li.index_of("/song");
                iEnd = li.substring(iIndex).index_of("\"");
                if(iIndex==-1||iEnd==-1)
                    continue;
		//FIXME drag n drop uri needs to be the song:// link
                track.uri = string.join("","song://http://music.baidu.com",li.substring(iIndex, iEnd));
                
		li = li.substring(iIndex);
                iIndex = li.index_of("title=") + 7;
                iEnd = li.substring(iIndex).index_of("\"");
                track.title = li.substring(iIndex,iEnd);
                //Maybe song name append like this '审批文号：WJXXXXX',so must deal with.
                iEnd = track.title.index_of("审批文号");
                if( iEnd != -1)
                    track.title = track.title.substring(0,iEnd);
                
		li = li.substring(iIndex);
                iIndex = li.index_of("title=") + 7;
                iEnd = li.substring(iIndex).index_of("\"");
                track.artist = li.substring(iIndex,iEnd);

                li = li.substring(iIndex);
                //Maybe song album no exist,so get album name between ">"  and "<".
                //Get album-title from behind the second ">".
                iIndex = li.index_of("album-title");
                li = li.substring(iIndex);
                li = li.substring(li.index_of(">")+1);
                iIndex = li.index_of(">") + 1;
                iEnd = li.substring(iIndex).index_of("<");
                var albumMaybe = li.substring(iIndex,iEnd);
                li = li.substring(iIndex);
                if(albumMaybe == null)
                {
                    iIndex = li.index_of(">") + 1;
                    iEnd = li.substring(iIndex).index_of("</span>");
                    track.album = li.substring(iIndex,iEnd);
                    li = li.substring(iIndex);
                }
                else
                    track.album = albumMaybe;
                
                var comment = string.join("",track.artist,track.album);
              
                //Because song icon_hint in Baidu no exist,so add SONG_MISSING_ICON_PATH. 
                var icon_hint = SONG_MISSING_ICON_PATH;

                if(track.title.up().index_of(search.search_string.up()) != -1)
                {
                    results_model.append (
                        track.uri,
                        icon_hint,
                        0,
                        "text/html",
                        track.title,
                        comment,
                        track.uri);
                }
            }
    }

    private void read_album_search_result_from_Baidu(LensSearch search, uint8[] data)
    {
        var results_model = search.results_model;
        Album album = new Album ();

        string content;
        //Convert uint8[] to string.
        content = (string) data;
        //Parse the contents to get results.
       
	//Get album icon_hint. 
        var iIndex = content.index_of("<img org_src=");
        if(iIndex == -1)
            return;
        var iEnd = content.last_index_of("<img org_src=");
        content = content.substring(iIndex,iEnd+3200-iIndex);
        List<string> lilist = new List<string> ();
        var liIndex = content.index_of("</li>");
        while(liIndex != -1)
        {
            lilist.append(content.substring(0,liIndex));
            content = content.substring(liIndex+5);
            liIndex = content.index_of("</li>");
        }
        
        //Get album information.
        foreach (string li in lilist)
        {
            //Get album uri.    
            iIndex = li.index_of("img org_src=") + 13;
            iEnd = li.substring(iIndex).index_of("\"");
            var icon_hint = li.substring(iIndex,iEnd);
            li = li.substring(iIndex);
            
            iIndex = li.index_of("/album");
            iEnd = li.substring(iIndex).index_of("\"");
            // no found album
            if(iIndex==-1||iEnd==-1)
                continue;

            //FIXME drag n drop uri needs to be the u1ms:// link.
            album.uri = string.join("","album://http://music.baidu.com",li.substring(iIndex,iEnd));
            li = li.substring(iIndex);
           
	    //Get album title.
            iIndex = li.index_of("title=") + 7;
            iEnd = li.substring(iIndex).index_of("\"");
            album.title = li.substring(iIndex, iEnd);
            //Maybe album title append like this '审批文号：WJXXXXX',so must deal with.
            iEnd = album.title.index_of("审批文号");
            if(iIndex != -1)
            {
                album.title = album.title.substring(0,iEnd);
            }
            li = li.substring(iIndex);
           
	    //Get album artist. 
            iIndex = li.index_of("title=") + 7;
            iEnd = li.substring(iIndex).index_of("\"");
            album.artist = li.substring(iIndex,iEnd);
            li = li.substring(iIndex);
            
            if(album.title.up().index_of(search.search_string.up()) != -1)
            {
                results_model.append (album.uri,
                                      icon_hint,
                                      1,
                                      "audio-x-generic",
                                      album.title,
                                      album.artist,
                                      album.uri);
            }
        }
    }

    /*
       * Index = 0, songs
       * Indes = 1, albums
    */
    private string? build_search_uri (string query, List<FilterParser> filters, int index, int page)
    {

        if(query.strip() == "")
            return null;

        string musicbaidu_base_uri = MUSICBAIDU_BASE_URI;
        if (GLib.Environment.get_variable("MUSICBAIDU_URI") != null)
            musicbaidu_base_uri = GLib.Environment.get_variable("MUSICBAIDU_URI");

        StringBuilder uri = new StringBuilder (musicbaidu_base_uri);
        if (index == 0)
            uri.append ("song?key=");
        else
            uri.append ("album?key=");

        //add query key
        uri.append (Uri.escape_string (query, "", false));

        //TODO: add filters of Chinese music
        // no implement.
 
        //At this moment, Baidu doesn't release API for filter and more search results
        //20 results each time
        if(page < 0)
        {
            uri.append ("&start=0&size=20");
        }
        else
        {
            string? str="";
            str = "&start=%d&size=20".printf(page*20);
            uri.append(str);
        }

        return uri.str;
    }
}

}
