;;;
;;; Copyright (c) 2003-2011 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;;; tutcode.scm: TUT-Code for Japanese input.
;;;
;;; TUT-Code<http://www.crew.sfc.keio.ac.jp/~chk/>ϥץȡ
;;; TUT-CodeܸϤԤ
;;; TUT-CodeʳT-CodeTry-CodeϤ⡢ɽˤǽ
;;;
;;; Ѵ(ala)
;;;   ƵŪѴǽǤ
;;;   Υ르ꥺtc-2.1ΤΤǤ
;;;
;;; * ŪѴ
;;;   tc-2.3.1tc-bushu.elΰܿǤ(sort̤бǤ)
;;;   ʲΤ褦򤹤ȻѲǽˤʤޤ
;;;   (define tutcode-use-interactive-bushu-conversion? #t)
;;;   (define tutcode-bushu-index2-filename "/usr/local/share/tc/bushu.index2")
;;;   (define tutcode-bushu-expand-filename "/usr/local/share/tc/bushu.expand")
;;;   (define tutcode-interactive-bushu-start-sequence "als")
;;;   bushu.index2bushu.expandեϡ
;;;   tc-2.3.1Υ󥹥ȡ󥹥ȡ뤵եǤ
;;;
;;; ڸ򤼽Ѵ(alj)
;;;   򤼽Ѵtc2Ʊ(SKKƱͤη)Ǥ
;;; 
;;; * 򤼽Ѵ(:/usr/local/share/tc/mazegaki.dic)ؤΥ
;;;   libuim-skk.soεǽȤäƤޤ
;;;   ΤᡢؽǽSKKƱͤưˤʤޤ:
;;;     + ꤷϼѴƬޤ
;;;     + ꤷϸĿͼ(~/.mazegaki.dic)¸ޤ
;;;   γؽǽ򥪥դˤˤϡ
;;;   tutcode-enable-mazegaki-learning?ѿ#fꤷƤ
;;; ** 򤼽ѴؤϿSKKƱͤưˤʤޤ:
;;;     + ~/.mazegaki.dicؤϿ
;;;     + Ͽ: ѴκǸޤǹԤäƵŪϿ⡼ɤ˰ܹԡ
;;;             뤤ϡɤߤϸ塢|򲡤
;;;     + : 񤫤κϡ!򲡤
;;; 
;;; * ѤѴ
;;;   tutcode-mazegaki-enable-inflection?ѿ#tꤹȡѤʤ
;;;   ȤƤѴ䤬ĤʤäˡѤȤѴߤޤ
;;;   (Ѥʤθ䤬1ĤξμưϤʤʤޤ
;;;    ʸϤ򳫻Ϥгꤵޤ)
;;;   ޤǽ餫ѤȤѴϡɤߤ""դ뤫
;;;   ʲΥѴϤƤ
;;;     tutcode-postfix-mazegaki-inflection-start-sequence (ַѥή)
;;;
;;;   ɽϡ<>ˤꡢ촴(Ѹʳʬ)ο̤ǽǤ
;;;   (ɤߤϻ""դƸ촴)
;;;
;;; * ɤߤ򥫥ʤȤƳ
;;;   tutcode-katakana-commit-key˥ʳꥭꤹ
;;;   Ѳǽˤʤޤ
;;;
;;; * ѻѴ(SKK abbrev)⡼ɤɲäƤޤ(al/)
;;;   㤨СfileפϤơ֥եפѴ뵡ǽǤ
;;;
;;; ڸַѴ
;;;   uimsurrounding textطAPIȤäơ
;;;   ʸμԤޤ
;;;   Τᡢuimsurrounding text API򥵥ݡȤƤ֥å
;;;   (uim-gtk, uim-qt, uim-qt4(lineeditΤ))ǤΤ߸ַѴǽǤ
;;;
;;;   ʳΥ֥åǤַѴȤ硢
;;;   tutcode-enable-fallback-surrounding-text?#tꤹȡ
;;;   surrounding text APIѤǤʤˡ
;;;   ʸμγʸХåեԤ
;;;   ʸκ"\b"(tutcode-fallback-backspace-string)Фޤ
;;;     - \b(BS,0x08)ʸ˺ԤץǤΤư
;;;     - γʸХåե䴰ȷѤǡ
;;;       Ĺtutcode-completion-chars-max͡
;;;
;;; * ַѴϡϥtutcode-postfix-bushu-start-sequence
;;;   ꤹȻѲǽˤʤޤ
;;; * ַ򤼽ѴϡʲγϥꤹȻѲǽˤʤޤ
;;;  Ѥʤ tutcode-postfix-mazegaki-start-sequence
;;;  Ѥ   tutcode-postfix-mazegaki-inflection-start-sequence
;;;  Ѥʤ(ɤ1ʸ) tutcode-postfix-mazegaki-1-start-sequence
;;;   ...
;;;  Ѥʤ(ɤ9ʸ) tutcode-postfix-mazegaki-9-start-sequence
;;;  Ѥ(ɤ1ʸ) tutcode-postfix-mazegaki-inflection-1-start-sequence
;;;   ...
;;;  Ѥ(ɤ9ʸ) tutcode-postfix-mazegaki-inflection-9-start-sequence
;;; * ַ򤼽Ѵˤ롢ɤ/촴ο
;;;   ɽϡ<>ˤꡢɤ/촴ο̤ǽǤ
;;;   Ѥ˴ؤƤϡ촴ĹΤͥ褷Ѵޤ
;;;     :֤>֤>֤
;;;         (tutcode-mazegaki-enable-inflection?#tξ硢
;;;          ˽̤ȳѤȤѴ)
;;;        >֤>֤>֤>֤>֤>֤
;;;        (ºݤˤtc2°mazegaki.dicˡ֤פ̵Τǥå)
;;; ** ɤߤʸꤷѴϤ
;;;    Ѥ˴ؤƤϡɤߤϻꤵ줿ʸǸꤷƸ촴Τ߿̡
;;;      (֤פФ3ʸ):֤>֤>֤
;;;
;;; ڥإ׵ǽ
;;; * ۸ɽ(ɽθ䥦ɥή)
;;;   ư֤ΥǸˤϤʸɽޤ
;;;   uim-pref-gtkǤɽɽ¾ˡ
;;;   <Control>/ǰŪɽɽڤؤǽǤ
;;;   (ǤդʸϤȤɽ礬Τ)
;;;  - *դʸ:Ǹˤꡢ
;;;    ʸޤಾ۸פɽ뤳Ȥɽޤ(Ǹ)
;;;  - +դʸ:ʸǸǤ뤳Ȥɽޤ
;;;    (ϸ쥬ɤǸ)
;;;  - +׸դʸ:ϸ쥬ɤκǽǸǤ뤳Ȥɽޤ
;;; * ưإɽǽ(ɽθ䥦ɥή)
;;;   򤼽ѴѴϤʸǤɽޤ
;;;   ˡΥإפϡbushu.helpե뤬ꤵƤ
;;;   ʬõɽޤbushu.help˸ĤʤǤ⡢
;;;   ñ˴ؤƤɽǽǤ
;;;   :򤼽Ѵǡͫݵפꤷ
;;;    
;;;                                        
;;;      
;;;            b                   f       
;;;      
;;;      3                         1(ͫ)   
;;;      
;;;        d   e   2a(ݵӴ)            
;;;    
;;; ** ľɽưإפκɽ
;;;    tutcode-auto-help-redisplay-sequence˰ʲΤ褦˥󥹤
;;;    ꤹȻѲǽˤʤޤ
;;;      (define tutcode-auto-help-redisplay-sequence "al-")
;;;
;;; 䴰/ͽ¬ϡϸ쥬ɡ
;;; +䴰:ʸФơ³ʸθɽޤ
;;; +ͽ¬ϡ:򤼽ѴɤߤФơѴʸθɽޤ
;;; +ֽϸ쥬ɡ:䴰/ͽ¬ϸʸȤˡ
;;;   Ϥͽ¬ʸǸɤɽޤ('+'դɽ)
;;; * 䴰/ͽ¬ϡϸ쥬ɤȤ䥦ɥɽޤ
;;; * 䴰/ͽ¬ϵǽȤˤϡ
;;;   uim-pref-gtkΡͽ¬ϡץ롼פ꤬ɬפǤ
;;;     (a)Look-SKKͭˤmazegaki.dicμեꤹ롣
;;;        (ͽ¬)
;;;     (b)Lookͭˤñեꤹ롣(䴰)
;;;        mazegaki.dicɤߤˡȤƤäƤʤñ䴰硣
;;;        (:ֶפϤǡۡפ䴰ߤ
;;;         ֶۡפmazegaki.dicˤɤߤȤƤäƤʤΤǡ
;;;         (a)Ǥ䴰ʤ((a)ɤߤ򸡺Τ))
;;;         mazegaki.dicѴñȴФơ
;;;         䴰ñեˤϡʲΥޥɤǲǽ
;;;           awk -F'[ /]' '{for(i=3;i<=NF;i++)if(length($i)>2)print $i}' \
;;;           mazegaki.dic | sort -u > mazegaki.words
;;;     (c)Sqlite3ͭˤ롣
;;;        䴰/ͽ¬Ϥ򤷤ؽ硢־֡
;;;   ʬõΤǡ(a)(b)ΥեϥȤƤɬפޤ
;;; * 䴰/ͽ¬ϤγϤϰʲΤ줫Υߥ:
;;; ** 䴰: tutcodeξ֤tutcode-completion-chars-minʸϻ
;;; ** 䴰: tutcodeξ֤<Control>.Ǹ
;;; ** ͽ¬: 򤼽ѴɤϾ֤
;;;              tutcode-prediction-start-char-countʸϻ
;;; ** ͽ¬: 򤼽ѴɤϾ֤<Control>.Ǹ
;;; * 䴰ɽˤ<Control>.Ǹоʸ1ĸ餷ƺ䴰
;;;   Ĺʸоݤ䴰줿ˡ䴰ľǤ褦ˡ
;;; * 嵭䴰ʸ(tutcode-completion-chars-min)
;;;   ͽ¬ʸ(tutcode-prediction-start-char-count)0ꤹȡ
;;;   <Control>.ǸˤΤ䴰/ͽ¬ϸɽޤ
;;; * ϸ쥬(Ϥͽ¬ʸǸ)
;;;   䴰/ͽ¬ϸ䤫äƤޤ
;;; * ۸׾Ǥνϸ쥬ɽ
;;;   ϸ쥬ɤɽƤ+դʸб륭Ϥ硢
;;;   2ǸܰʹߤⲾ۸׾+դɽΤǡ
;;;   ɤ˽äƴϤǽǤ
;;;   ̾ϲ۸ɽξǤ⡢+դʸб륭Ϥ硢
;;;   Ū˲۸פɽˤϡ
;;;   tutcode-stroke-help-with-kanji-combination-guide'full(+դʳ
;;;   ʸɽ)'guide-only(+դʸΤɽ)ꤷƤ
;;;     :ֲгפϤ褦ȤơֲСפϸֳפǤ
;;;        ˺줷硢<Control>.䴰ϸ쥬ɤ+դΡֳפ
;;;        ɽ˽ä1,2,3Ǹϡ
;;;
;;; - (ŪˤϡǸФ餯̵䴰/ͽ¬ϸɽ
;;;    Ǥuimˤϥޤ̵ΤǡǸľɽޤ
;;;    1ʸϤ뤴ȤɽȼʤȤ¿Τǡ
;;;    ǥեȤǤ2ʸϻɽˤƤޤ:
;;;      tutcode-completion-chars-min, tutcode-prediction-start-char-count
;;;    ξǤ⡢1ʸϸ<Control>.(tutcode-begin-completion-key)
;;;    ˤ䴰/ͽ¬ϸɽǽǤ)
;;;
;;; Ѵͽ¬ϡ
;;;   Ѵ򸡺ơϤ줿󤬴ޤޤܤɽ
;;;
;;; ڵϥ⡼ɡ
;;;   <Control>_ǵϥ⡼ɤΥȥ롣
;;;   ѱѿϥ⡼ɤȤƤȤ褦ˤƤޤ
;;;
;;; 2ȥϥ⡼ɡ
;;;   ɴ기סؤ٤Ʊͤˡ2ǸǳƼε桦Ϥ⡼ɡ
;;;   ϴŪʸɽ¤Ǥޤ
;;;   (̾εϥ⡼ɤǤϡŪʸޤǤɤĤ
;;;   next-page򲿲ⲡɬפäݤʤΤ)
;;;
;;; ڴϥ⡼ɡ
;;;   ɤꤷʸϤ⡼ɡϸ她ڡ
;;;   (tutcode-begin-conv-key)򲡤ȡбʸꤵޤ
;;;   ʲ3ηǤϤǽ(DDSKK 14.2Ʊ)
;;; + Unicode(UCS): U+θ16ʿU+ΤuǤOK(:U+4E85ޤu4e85)
;;;                 (uim-tutcodeɤEUC-JP(EUC-JIS-2004)ʤ
;;;                  ǡJIS X 0213̵ʸ(:ϤU+9AD9)Բ)
;;; + ֹ(JIS X 0213): -Ƕڤä--ֹ(̶줾10ʿ)
;;;                         1̤ξ硢-Ͼάǽ(:1-48-13ޤ48-13)
;;; + JIS(ISO-2022-JP): 416ʿ(:502d)
;;;
;;; ڥҥȥϥ⡼ɡ
;;;   ǶѴ򤼽Ѵ䴰/ͽ¬ϡϡ
;;;   ϤǳꤷʸϤ⡼ɡ
;;;   tutcode-history-size1ʾꤹͭˤʤޤ
;;;
;;; 
;;; * ɽΰѹϡ㤨~/.uimǰʲΤ褦˵Ҥ롣
;;;   (require "tutcode.scm")
;;;   (tutcode-rule-set-sequences!
;;;     '(((("s" " "))(""))                ; ѹ
;;;       ((("a" "l" "i"))("Ľ"))            ; ɲ
;;;       ((("d" "l" "u"))("" ""))       ; ʤޤ
;;;       ((("d" "l" "d" "u"))("" ""))))
;;;
;;; * T-Code/Try-CodeȤ
;;;   uim-pref-gtkꤹ뤫~/.uimǰʲΤ褦ꤷƤ
;;;    (define tutcode-rule-filename "/usr/local/share/uim/tcode.scm")
;;;    ;(define tutcode-rule-filename "/usr/local/share/uim/trycode.scm")
;;;    (define tutcode-mazegaki-start-sequence "fj")
;;;    (define tutcode-bushu-start-sequence "jf")
;;;    (define tutcode-latin-conv-start-sequence "47")
;;;    (define tutcode-kana-toggle-key? (make-key-predicate '()))
;;;
;;; ڥˤĤơ
;;; generic.scm١ˤưʲѹ򤷤Ƥ롣
;;;  * Υڡͭˤʤ褦ѹ
;;;  * Ҥ餬/ʥ⡼ɤڤؤɲá
;;;  * rk̤(preedit)ʸɽ򤷤ʤ褦ˤ
;;;    (EmacsT/TUT-CodeϴĶtc2ǤɽʤΤǤ˹碌)
;;;  * 򤼽ѴǤSKKμȤΤǡ
;;;    skk.scmΤʴѴɬפʬߡ
;;;  * Ѵǽɲá
;;;  * ϥ⡼ɤɲá
;;;  * ۸ɽǽɲá
;;;  * ưإɽǽɲá
;;;  * 䴰/ͽ¬ϡϸ쥬ɵǽɲá

(require-extension (srfi 1 2 8))
(require "generic.scm")
(require "generic-predict.scm")
(require-custom "tutcode-custom.scm")
(require-custom "generic-key-custom.scm")
(require-custom "tutcode-key-custom.scm")
(require-dynlib "skk") ;SKKθ򤼽񤭼θΤlibuim-skk.so
(require "tutcode-bushudic.scm") ;Ѵ
(require "tutcode-kigoudic.scm") ;ϥ⡼Ѥεɽ
(require "tutcode-dialog.scm"); 򤼽Ѵ񤫤κǧ
(require "tutcode-bushu.scm")
(require "japanese.scm") ; for ja-wide or ja-make-kana-str{,-list}
(require "ustr.scm")

;;; user configs

;; widgets and actions

;; widgets
(define tutcode-widgets '(widget_tutcode_input_mode))

;; default activity for each widgets
(define default-widget_tutcode_input_mode 'action_tutcode_direct)

;; actions of widget_tutcode_input_mode
(define tutcode-input-mode-actions
  (if tutcode-use-kigou2-mode?
    '(action_tutcode_direct
      action_tutcode_hiragana
      action_tutcode_katakana
      action_tutcode_kigou
      action_tutcode_kigou2)
    '(action_tutcode_direct
      action_tutcode_hiragana
      action_tutcode_katakana
      action_tutcode_kigou)))

;;; Ѥ륳ɽ
;;; tutcode-context-new(tutcode-custom-load-rule!)
(define tutcode-rule ())
;;; 2ȥϥ⡼ѥɽ
(define tutcode-kigou-rule ())
;;; tutcode-rule롢հ(ǸꥹȤ)alist
;;; (ưإѤѴ両ι®Τ)
(define tutcode-reverse-rule-alist ())
;;; tutcode-kigou-rule롢հalist
(define tutcode-reverse-kigou-rule-alist ())
;;; tutcode-bushudic롢
;;; հ(ʸѤ2ʸ)alist
;;; (ưإѤѴ両ι®Τ)
(define tutcode-reverse-bushudic-alist ())
;;; stroke-helpǡ⥭Ϥ̵ɽƤalist
;;; (tutcode-ruleƤʤƺ٤
;;; ǽΥڡϸƤʤΤǡٺΤȤ)
(define tutcode-stroke-help-top-page-alist ())
;;; stroke-helpǡ⥭Ϥ̵ɽƤalist
;;; ʥ⡼ѡ
;;; (XXX:ͭξ⥭åȤ褦ˤ?
;;;  ⤷С~/.uimǲ۸ɽƤΥޥưפˤʤ)
(define tutcode-stroke-help-top-page-katakana-alist ())

;;; ɽѹ/ɲä뤿Υɽ
;;; ~/.uimtutcode-rule-set-sequences!Ͽơ
;;; tutcode-context-newȿǤ롣
(define tutcode-rule-userconfig ())

;;; 䥦ɥΥץ̾
;;; uim-ximUIM_LIBEXECDIR/uim-candwin-prog䥦ɥȤƻѡ
;;; gtk-immoduleɽ䥦ɥѤ뤫ȽǤ뤿ᡢ
;;; "uim-candwin-tbl"ǻϤޤäƤ뤫ɤåƤ롣
;;; ɽ䥦ɥcustomǤ褦ˤ뤿ᡢ
;;; 餫define
;;; XXX:tutcodeʳˤƶΤǡ¾ξ⡣
(define uim-candwin-prog "")
(if tutcode-use-table-style-candidate-window?
  (set! uim-candwin-prog "uim-candwin-tbl-gtk"))

;;; ɽθ䥦ɥγƥܥȥбɽ(138)
;;; ɽ䥦ɥȤƻѤ롣
(define uim-candwin-prog-layout ())
;;; ɽ䥦ɥΥ쥤:QWERTY(JIS)
(define uim-candwin-prog-layout-qwerty-jis
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "^" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "@" "[" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  ":" "]" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "\"" "#" "$" "%" "&" "'" "(" ")" ""   "=" "~" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "`" "{" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" "+"  "*" "}" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  "_" ""  ""))
;;; ɽ䥦ɥΥ쥤:QWERTY(US/ASCII)
(define uim-candwin-prog-layout-qwerty-us
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "=" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "[" "]" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  "'" "`" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "_" "+" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "{" "}" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" ":"  "\"" "~" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  ""  ""  ""))
;;; ɽ䥦ɥΥ쥤:DVORAK
;;; (֤줵줿Τ̵褦ʤΤǰ)
(define uim-candwin-prog-layout-dvorak
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "[" "]" "\\"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"  "/" "=" ""
    "a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"  "-" "`" ""
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "{" "}" "|"
    "\"" "<" ">" "P" "Y" "F" "G" "C" "R" "L"  "?" "+" ""
    "A" "O" "E" "U" "I"  "D" "H" "T" "N" "S"  "_" "~" ""
    ":" "Q" "J" "K" "X"  "B" "M" "W" "V" "Z"  ""  ""  ""))
;;; ɽθ䥦ɥγƥܥȥбɽꡣ
;;; (~/.uimϤθǼ¹ԤΤǡ
;;;  ~/.uimѹˤuim-candwin-prog-layout񤭤ɬפ)
(set! uim-candwin-prog-layout
  (case tutcode-candidate-window-table-layout
    ((qwerty-jis) uim-candwin-prog-layout-qwerty-jis)
    ((qwerty-us) uim-candwin-prog-layout-qwerty-us)
    ((dvorak) uim-candwin-prog-layout-dvorak)
    (else ()))) ; default

;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(JIS)ѡ
(define tutcode-table-heading-label-char-list-qwerty-jis
  '("a" "s" "d" "f" "g" "h" "j" "k" "l" ";"
    "q" "w" "e" "r" "t" "y" "u" "i" "o" "p"
    "z" "x" "c" "v" "b" "n" "m" "," "." "/"
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(US)ѡ
(define tutcode-table-heading-label-char-list-qwerty-us
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; DVORAKѡ
(define tutcode-table-heading-label-char-list-dvorak
  '("a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"
    "1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (Ǥ䤹꤫˸)
(define tutcode-table-heading-label-char-list
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list
  '("1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ
(define tutcode-heading-label-char-list ())

;;; ϥ⡼ɻθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (ܡɥ쥤Ȥ˽äơ夫鱦ؽ˸)
(define tutcode-table-heading-label-char-list-for-kigou-mode
  (if (null? uim-candwin-prog-layout)
    (delete "" uim-candwin-prog-layout-qwerty-jis)
    (delete "" uim-candwin-prog-layout)))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list-for-kigou-mode
  '(" "
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "-" "^" "\\" "@" "[" ";" ":" "]" "," "." "/"
    "!" "\"" "#" "$" "%" "&" "'" "(" ")"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"
    "=" "~" "|" "`" "{" "+" "*" "}" "<" ">" "?" "_"))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ
;;; (ѱѿ⡼ɤȤƻȤˤϡtutcode-kigoudicȹ碌ɬפ)
(define tutcode-heading-label-char-list-for-kigou-mode ())

;;; ҥȥϻθѥ٥ʸΥꥹ
(define tutcode-heading-label-char-list-for-history ())

;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
;;; (̾ʸϤ˱ƶʤ褦ˡ1ǸܤȤ֤ʤʸѡ
;;; ()ľϤǤ褦ˡǤϴޤʤ)
;;; QWERTY(JIS)ѡTUT-Codeѡ
(define tutcode-heading-label-char-list-for-prediction-qwerty
  '(                     "Y" "U" "I" "O" "P"
                         "H" "J" "K" "L"
    "Z" "X" "C" "V" "B"  "N" "M"))
;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
;;; DVORAKѡTUT-Codeѡ
(define tutcode-heading-label-char-list-for-prediction-dvorak
  '(                     "F" "G" "C" "R" "L"
                         "D" "H" "T" "N" "S"
        "Q" "J" "K" "X"  "B" "M" "W" "V" "Z"))
;;; 䴰/ͽ¬ϻθѥ٥ʸΥꥹȡ
(define tutcode-heading-label-char-list-for-prediction
  tutcode-heading-label-char-list-for-prediction-qwerty)

;;; ưإפǤʸǤɽκݤ˸ʸȤƻȤʸΥꥹ
(define tutcode-auto-help-cand-str-list
  ;; 1,2,3Ǹ򼨤ʸ(1, 2)
  '((("1" "2" "3") ("4" "5" "6") ("7" "8" "9")) ; 1ʸ
    (("a" "b" "c") ("d" "e" "f") ("g" "h" "i")) ; 2ʸ
    (("A" "B" "C") ("D" "E" "F") ("G" "H" "I"))
    (("" "" "") ("" "" "ϻ") ("" "Ȭ" ""))
    (("" "" "") ("" "" "") ("" "" ""))
    (("" "" "") ("" "" "") ("" "" ""))))

;;; ưإ׺־[s]
(define tutcode-auto-help-time-limit 3)

;;; ϸ쥬ѥޡ
(define tutcode-guide-mark "+")
;;; ϸ쥬ѽλޡ
(define tutcode-guide-end-mark "+")
;;; ۸פΥȥǡ
;;; ³ΥҥȤȤɽդޡ
(define tutcode-hint-mark "*")
;;; 2ȥϥ⡼ɻ˲۸ɽԤɤ
(define tutcode-use-stroke-help-window-another? #t)

;;; ַ򤼽Ѵɤ߼ˡɤߤ˴ޤʤʸΥꥹ
(define tutcode-postfix-mazegaki-terminate-char-list
  '("\n" "\t" " " "" "" "" "" "" "" "" "" ""))

;;; surrounding text APIȤʤˡʸΤcommitʸ
(define tutcode-fallback-backspace-string "\b")

;;; implementations

;;; 򤼽ѴνäƤ뤫ɤ
(define tutcode-dic #f)

;;; list of context
(define tutcode-context-list '())

(define tutcode-prepare-activation
  (lambda (tc)
    (let ((rkc (tutcode-context-rk-context tc)))
      (rk-flush rkc))))

(register-action 'action_tutcode_direct
		 (lambda (tc)
		   '(ja_halfwidth_alnum
		     "a"
		     "ľ"
		     "ľϥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (not (tutcode-context-on? tc))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (tutcode-flush tc)
                     (tutcode-context-set-state! tc 'tutcode-state-off)
                     (tutcode-update-preedit tc))));flushǥꥢɽȿ

(register-action 'action_tutcode_hiragana
		 (lambda (tc)
		   '(ja_hiragana
		     ""
		     "Ҥ餬"
		     "Ҥ餬ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (not (tutcode-context-katakana-mode? tc))
                          (not (tutcode-kigou2-mode? tc)))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (tutcode-kigou2-mode? tc)
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-context-set-katakana-mode! tc #f)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_katakana
		 (lambda (tc)
		   '(ja_katakana
		     ""
		     ""
		     "ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (tutcode-context-katakana-mode? tc)
                          (not (tutcode-kigou2-mode? tc)))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (tutcode-kigou2-mode? tc)
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-context-set-katakana-mode! tc #t)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_kigou
                 (lambda (tc)
                   '(ja_fullwidth_alnum
                     ""
                     ""
                     "ϥ⡼"))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (eq? (tutcode-context-state tc) 'tutcode-state-kigou)))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (not
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (tutcode-flush tc))
                     (tutcode-begin-kigou-mode tc)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_kigou2
                 (lambda (tc)
                   '(ja_fullwidth_alnum
                     ""
                     "2"
                     "ϥ⡼2"))
                 (lambda (c)
                   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (tutcode-kigou2-mode? tc))))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (if (not (tutcode-kigou2-mode? tc))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-toggle-kigou2-mode tc)))
                     (tutcode-update-preedit tc))))

;; Update widget definitions based on action configurations. The
;; procedure is needed for on-the-fly reconfiguration involving the
;; custom API
(define tutcode-configure-widgets
  (lambda ()
    (register-widget 'widget_tutcode_input_mode
		     (activity-indicator-new tutcode-input-mode-actions)
		     (actions-new tutcode-input-mode-actions))))

(define tutcode-context-rec-spec
  (append
   context-rec-spec
   (list
     (list 'rk-context ()) ; ȥʸؤѴΤΥƥ
     (list 'rk-context-another ()) ;⤦Ĥrk-context(2strokeϥ⡼)
     ;;; TUT-CodeϾ
     ;;; 'tutcode-state-off TUT-Code
     ;;; 'tutcode-state-on TUT-Code
     ;;; 'tutcode-state-yomi 򤼽Ѵɤ
     ;;; 'tutcode-state-code 
     ;;; 'tutcode-state-converting 򤼽Ѵθ
     ;;; 'tutcode-state-bushu ϡѴ
     ;;; 'tutcode-state-interactive-bushu ŪѴ
     ;;; 'tutcode-state-kigou ϥ⡼
     ;;; 'tutcode-state-history ҥȥϥ⡼
     (list 'state 'tutcode-state-off)
     ;;; ʥ⡼ɤɤ
     ;;; #t: ʥ⡼ɡ#f: Ҥ餬ʥ⡼ɡ
     (list 'katakana-mode #f)
     ;;; 򤼽Ѵ/Ѵоݤʸꥹ(ս)
     ;;; (: 򤼽Ѵɤߡ֤פϤ硢("" "" ""))
     (list 'head ())
     ;;; 򤼽Ѵθֹ
     (list 'nth 0)
     ;;; 򤼽Ѵθ
     (list 'nr-candidates 0)
     ;;; ַ򤼽ѴˡѴ˻ѤɤߤĹ
     ;;; (im-delete-text뤿˻)
     ;;; ַַȽˤѡ(ַξ0)
     (list 'postfix-yomi-len 0)
     ;;; 򤼽Ѵϻ˻ꤵ줿ɤߤʸ
     ;;; ַξϺѤߤɤߤʸ
     (list 'mazegaki-yomi-len-specified 0)
     ;;; 򤼽ѴѤɤΡַξϼѤߤɤ
     (list 'mazegaki-yomi-all ())
     ;;; 򤼽ѴγѸ
     ;;; (Ѥϸ򡽤ִƸΤǡ᤹˻)
     (list 'mazegaki-suffix ())
     ;;; 䥦ɥξ
     ;;; 'tutcode-candidate-window-off ɽ
     ;;; 'tutcode-candidate-window-converting 򤼽Ѵɽ
     ;;; 'tutcode-candidate-window-kigou ɽ
     ;;; 'tutcode-candidate-window-stroke-help ۸ɽ
     ;;; 'tutcode-candidate-window-auto-help ưإɽ
     ;;; 'tutcode-candidate-window-predicting 䴰/ͽ¬ϸɽ
     ;;; 'tutcode-candidate-window-interactive-bushu ŪѴɽ
     ;;; 'tutcode-candidate-window-history ҥȥϸɽ
     (list 'candidate-window 'tutcode-candidate-window-off)
     ;;; ȥɽ
     ;;; Ϥ륭ʸбΡget-candidate-handlerѷǤΥꥹ
     (list 'stroke-help ())
     ;;; ưإ
     (list 'auto-help ())
     ;;; 򤼽ѴؤκƵŪϿΤλҥƥ
     (list 'child-context ())
     ;;; ҥƥȤμ
     ;;; 'tutcode-child-type-editor ϿѤѴʸԽǥ
     ;;; 'tutcode-child-type-dialog 񤫤κǧ
     (list 'child-type ())
     ;;; ƥƥ
     (list 'parent-context ())
     ;;; ϿʸԽǥ
     (list 'editor ())
     ;;; ǧ
     (list 'dialog ())
     ;;; ѻѴ(SKK abbrev)⡼ɤɤ
     (list 'latin-conv #f)
     ;;; commitѤʸꥹ(䴰)
     (list 'commit-strs ())
     ;;; commit-strsΤ䴰˻ѤƤʸ
     (list 'commit-strs-used-len 0)
     ;;; commitʸ(ҥȥ)
     (list 'history ())
     ;;; 䴰/ͽ¬Ϥθ椫ɤ
     ;;; 'tutcode-predicting-off 䴰/ͽ¬ϤθǤʤ
     ;;; 'tutcode-predicting-completion 䴰
     ;;; 'tutcode-predicting-prediction 򤼽Ѵͽ¬ϸ
     ;;; 'tutcode-predicting-bushu Ѵͽ¬ϸ
     ;;; 'tutcode-predicting-interactive-bushu ŪѴ
     (list 'predicting 'tutcode-predicting-off)
     ;;; 䴰/ͽ¬ѥƥ
     (list 'prediction-ctx ())
     ;;; 䴰/ͽ¬ϸɤߤΥꥹ
     (list 'prediction-word ())
     ;;; 䴰/ͽ¬ϸθΥꥹ
     (list 'prediction-candidates ())
     ;;; 䴰/ͽ¬ϸappendixΥꥹ
     (list 'prediction-appendix ())
     ;;; 䴰/ͽ¬ϸ
     (list 'prediction-nr 0)
     ;;; 䴰/ͽ¬ϸθ򤵤Ƥ륤ǥå(ϸ쥬ɹ)
     (list 'prediction-index 0)
     ;;; 䴰/ͽ¬ϸ(ϸ쥬ʬޤ)
     (list 'prediction-nr-all 0)
     ;;; ڡȤ䴰/ͽ¬Ϥθɽ(ϸ쥬ʬϽ)
     (list 'prediction-nr-in-page tutcode-nr-candidate-max-for-prediction)
     ;;; ڡȤ䴰/ͽ¬Ϥθɽ(ϸ쥬ʬޤ)
     (list 'prediction-page-limit
      (+ tutcode-nr-candidate-max-for-prediction
         tutcode-nr-candidate-max-for-guide))
     ;;; Ѵͽ¬
     (list 'prediction-bushu ())
     ;;; Ѵͽ¬θߤɽڡκǽΥǥåֹ
     (list 'prediction-bushu-page-start 0)
     ;;; ϸ쥬ɡ䴰/ͽ¬ϻɽѡ
     ;;; ͽ¬뼡ϴ1ǸϴбΥꥹȡ
     ;;; : (("," "") ("u" "" ""))
     (list 'guide ())
     ;;; ϸ쥬ɺǡ۸(stroke-help)ؤΥɽѡ
     ;;; ʸȥȥΥꥹ(rk-lib-find-partial-seqsѷ)
     ;;; : (((("," "r"))("")) ((("u" "c"))("")) ((("u" "v"))("")))
     (list 'guide-chars ())
     )))
(define-record 'tutcode-context tutcode-context-rec-spec)
(define tutcode-context-new-internal tutcode-context-new)
(define tutcode-context-katakana-mode? tutcode-context-katakana-mode)
(define (tutcode-context-on? pc)
  (not (eq? (tutcode-context-state pc) 'tutcode-state-off)))
(define (tutcode-kigou2-mode? pc)
  (and tutcode-use-kigou2-mode?
       (eq? (rk-context-rule (tutcode-context-rk-context pc))
            tutcode-kigou-rule)))

;;; TUT-CodeΥƥȤ򿷤롣
;;; @return ƥ
(define (tutcode-context-new id im)
  (if (not tutcode-dic)
    (if (not (symbol-bound? 'skk-lib-dic-open))
      (begin
        (if (symbol-bound? 'uim-notify-info)
          (uim-notify-info
            (N_ "libuim-skk.so is not available. Mazegaki conversion is disabled")))
        (set! tutcode-use-recursive-learning? #f)
        (set! tutcode-enable-mazegaki-learning? #f))
      (begin
        (set! tutcode-dic (skk-lib-dic-open tutcode-dic-filename #f "localhost" 0 'unspecified))
        (if tutcode-use-recursive-learning?
          (require "tutcode-editor.scm"))
        (tutcode-read-personal-dictionary))))
  (let ((tc (tutcode-context-new-internal id im)))
    (tutcode-context-set-widgets! tc tutcode-widgets)
    (if (null? tutcode-rule)
      (begin
        (tutcode-custom-load-rule! tutcode-rule-filename)
        (if tutcode-use-dvorak?
          (begin
            (set! tutcode-rule (tutcode-rule-qwerty-to-dvorak tutcode-rule))
            (set! tutcode-heading-label-char-list-for-prediction
              tutcode-heading-label-char-list-for-prediction-dvorak)))
        ;; tutcode-mazegaki/bushu-start-sequenceϡ
        ;; tutcode-use-dvorak?ΤȤDvorakΥ󥹤Ȥߤʤȿǡ
        ;; Ĥޤꡢruleqwerty-to-dvorakѴȿǤ롣
        (tutcode-custom-set-mazegaki/bushu-start-sequence!)
        (tutcode-rule-commit-sequences! tutcode-rule-userconfig)))
    ;; ɽ䥦ɥ
    (if (null? tutcode-heading-label-char-list)
      (if tutcode-use-table-style-candidate-window?
        (set! tutcode-heading-label-char-list
          (case tutcode-candidate-window-table-layout
            ((qwerty-jis) tutcode-table-heading-label-char-list-qwerty-jis)
            ((qwerty-us) tutcode-table-heading-label-char-list-qwerty-us)
            ((dvorak) tutcode-table-heading-label-char-list-dvorak)
            (else tutcode-table-heading-label-char-list)))
        (set! tutcode-heading-label-char-list
          tutcode-uim-heading-label-char-list)))
    (if (null? tutcode-heading-label-char-list-for-history)
      (set! tutcode-heading-label-char-list-for-history
        tutcode-heading-label-char-list))
    (if (null? tutcode-heading-label-char-list-for-kigou-mode)
      (if tutcode-use-table-style-candidate-window?
        (begin
          (set! tutcode-heading-label-char-list-for-kigou-mode
            tutcode-table-heading-label-char-list-for-kigou-mode)
          ;; ϥ⡼ɤѱѿ⡼ɤȤƻȤᡢ
          ;; tutcode-heading-label-char-list-for-kigou-modeѤˤ
          ;; tutcode-kigoudicƬ
          (set! tutcode-kigoudic
            (append
              (map (lambda (lst) (list (ja-wide lst)))
                tutcode-heading-label-char-list-for-kigou-mode)
              (list-tail tutcode-kigoudic
                (length tutcode-heading-label-char-list-for-kigou-mode)))))
        (set! tutcode-heading-label-char-list-for-kigou-mode
          tutcode-uim-heading-label-char-list-for-kigou-mode)))
    (tutcode-context-set-rk-context! tc (rk-context-new tutcode-rule #t #f))
    (if tutcode-use-kigou2-mode?
      (begin
        (if (null? tutcode-kigou-rule)
          (begin
            (require "tutcode-kigou-rule.scm") ;2strokeϥ⡼ѥɽ
            (tutcode-kigou-rule-translate
              tutcode-candidate-window-table-layout)))
        (tutcode-context-set-rk-context-another!
          tc (rk-context-new tutcode-kigou-rule #t #f))))
    (if tutcode-use-recursive-learning?
      (tutcode-context-set-editor! tc (tutcode-editor-new tc)))
    (tutcode-context-set-dialog! tc (tutcode-dialog-new tc))
    (if (or tutcode-use-completion? tutcode-use-prediction?)
      (begin
        (tutcode-context-set-prediction-ctx! tc (predict-make-meta-search))
        (predict-meta-open (tutcode-context-prediction-ctx tc) "tutcode")
        (predict-meta-set-external-charset! (tutcode-context-prediction-ctx tc) "EUC-JP")))
    tc))

;;; Ҥ餬/ʥ⡼ɤڤؤԤ
;;; ξ֤Ҥ餬ʥ⡼ɤξϥʥ⡼ɤڤؤ롣
;;; ξ֤ʥ⡼ɤξϤҤ餬ʥ⡼ɤڤؤ롣
;;; @param pc ƥȥꥹ
(define (tutcode-context-kana-toggle pc)
  (let ((s (tutcode-context-katakana-mode? pc)))
    (tutcode-context-set-katakana-mode! pc (not s))))

;;; äΥƥȤ롣
(define (tutcode-find-root-context pc)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (null? ppc)
      pc
      (tutcode-find-root-context ppc))))

;;; Υƥ(򤼽ѴκƵŪϿΰֿȤ
;;; =ԽΥƥ)롣
(define (tutcode-find-descendant-context pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (if (null? cpc)
      pc
      (tutcode-find-descendant-context cpc))))

(define (tutcode-predict pc str)
  (predict-meta-search
   (tutcode-context-prediction-ctx pc)
   str))
;;; 䴰/ͽ¬ϸ򸡺
;;; @param str ʸ
;;; @param completion? 䴰ξ#t
;;; @return ʣƤɤߤΥꥹ(ϸ쥬)
(define (tutcode-lib-set-prediction-src-string pc str completion?)
  (let* ((ret      (tutcode-predict pc str))
         (word     (predict-meta-word? ret))
         (cands    (predict-meta-candidates? ret))
         (appendix (predict-meta-appendix? ret))
         (word/cand/appendix (map list word cands appendix))
         (uniq-word/cand/appendix 
          ;; ʣ
          (delete-duplicates word/cand/appendix
            (lambda (x y)
              (let ((xcand (list-ref x 1))
                    (ycand (list-ref y 1)))
                (string=? xcand ycand)))))
         (strlen (string-length str))
         (filtered-word/cand/appendix
          (if completion?
            (filter
              ;; 䴰strǻϤޤäƤʤ(strcommitѤʤΤ)
              (lambda (elem)
                (let ((cand (list-ref elem 1)))
                  (and
                    (> (string-length cand) strlen)
                    (string=? str (substring cand 0 strlen)))))
              uniq-word/cand/appendix)
            uniq-word/cand/appendix))
         (filtered-word
          (map (lambda (x) (list-ref x 0)) filtered-word/cand/appendix))
         (filtered-cands
          (map (lambda (x) (list-ref x 1)) filtered-word/cand/appendix))
         (filtered-appendix
          (map (lambda (x) (list-ref x 2)) filtered-word/cand/appendix)))
    (tutcode-context-set-prediction-word! pc filtered-word)
    (tutcode-context-set-prediction-candidates! pc
      (if completion?
        (map
          (lambda (cand)
            ;; 䴰Ƭstr:
            ;; strϳʸʤΤǡʸνʣ򤱤뤿ᡣ
            (if (string=? str (substring cand 0 strlen))
              (substring cand strlen (string-length cand))
              cand))
          filtered-cands)
        filtered-cands))
    (tutcode-context-set-prediction-appendix! pc filtered-appendix)
    (tutcode-context-set-prediction-nr! pc (length filtered-cands))
    word))

;;; Ѵͽ¬ϸ
;;; @param start-index ֹ
(define (tutcode-lib-set-bushu-prediction pc start-index)
  ;; ֹ椫Ϥޤ1ڡ֤θФƻѡ
  ;; ƻѤȡϸ쥬ɤΥ٥ʸĹʤäƲꤹ
  ;; ɥ˼ޤʤʤ礬Τ(200ʾξʤ)
  ;; (ϸ쥬ɤɽθˡ⤢뤬
  ;; ξ硢ϸ쥬ɤοڡȤѤäƤޤᡢ
  ;; θ䥦ɥ(ڡȤɽѤʤȤ)
  ;; Ǥɽ꤬ȯ)
  (let* ((ret (tutcode-context-prediction-bushu pc))
         (all-len (length ret))
         (start
          (cond
            ((>= start-index all-len)
              (tutcode-context-prediction-bushu-page-start pc))
            ((< start-index 0)
              0)
            (else
              start-index)))
         (end (+ start tutcode-nr-candidate-max-for-prediction))
         (cnt
          (if (< end all-len)
            tutcode-nr-candidate-max-for-prediction
            (- all-len start)))
         (page-word/cand (take (drop ret start) cnt))
         (page-word (map (lambda (elem) (car elem)) page-word/cand))
         (page-cands (map (lambda (elem) (cadr elem)) page-word/cand))
         (len (length page-cands))
         (appendix (make-list len "")))
    (tutcode-context-set-prediction-bushu-page-start! pc start)
    (tutcode-context-set-prediction-word! pc page-word)
    (tutcode-context-set-prediction-candidates! pc page-cands)
    (tutcode-context-set-prediction-appendix! pc appendix)
    (tutcode-context-set-prediction-nr! pc len)))

(define (tutcode-lib-get-nr-predictions pc)
  (tutcode-context-prediction-nr pc))
(define (tutcode-lib-get-nth-word pc nth)
  (let ((word (tutcode-context-prediction-word pc)))
    (list-ref word nth)))
(define (tutcode-lib-get-nth-prediction pc nth)
  (let ((cands (tutcode-context-prediction-candidates pc)))
    (list-ref cands nth)))
(define (tutcode-lib-get-nth-appendix pc nth)
  (let ((appendix (tutcode-context-prediction-appendix pc)))
    (list-ref appendix nth)))
(define (tutcode-lib-commit-nth-prediction pc nth completion?)
  (let ((cand (tutcode-lib-get-nth-prediction pc nth)))
    (predict-meta-commit
      (tutcode-context-prediction-ctx pc)
      (tutcode-lib-get-nth-word pc nth)
      (if completion?
        ;; 䴰ϡcandsϸդƤ
        ;; Ƭcommit-strsƤΤǡ
        (string-append
          (string-list-concat
            (take (tutcode-context-commit-strs pc)
                  (tutcode-context-commit-strs-used-len pc)))
          cand)
        cand)
      (tutcode-lib-get-nth-appendix pc nth))))

;;; ϸ쥬ɽѸꥹȤ䴰/ͽ¬ϸ䤫
;;; @param str 䴰/ͽ¬ϸθ˻Ѥʸ=Ϻʸ
;;; @param completion? 䴰#t
;;; @param all-yomi ͽ¬ϸ両̤˴ޤޤƤɤ
(define (tutcode-guide-set-candidates pc str completion? all-yomi)
  (let* ((cands (tutcode-context-prediction-candidates pc))
         (rule (rk-context-rule (tutcode-context-rk-context pc)))
         (word all-yomi)
         (strlen (string-length str))
         (filtered-cands
          (if (not completion?)
            (filter
              ;; ͽ¬ϻstrǻϤޤäƤʤäƤΤǽ
              (lambda (cand)
                (and
                  (> (string-length cand) strlen)
                  (string=? str (substring cand 0 strlen))))
              cands)
            cands))
         ;; ɤϡɤ(word)⸫ƼǽΤ򥬥
         ;; :""Ϥǡlook""ȤɤߤȤˡ
         ;;    ""򥬥
         (filtered-words
          (if completion?
            ()
            (filter
              (lambda (cand)
                (let ((candlen (string-length cand)))
                  (and
                    (> candlen strlen)
                    ;; strθˡѤ򼨤""ĤʤϽ
                    (not (string=?  "" (substring cand strlen candlen))))))
              word)))
         (trim-str
          (lambda (lst)
            (if (not completion?)
              (map
                (lambda (cand)
                  ;; ͽ¬ϻϺѤstrޤޤƤΤǡ
                  ;; ʸ򥬥ɽ
                  (substring cand strlen (string-length cand)))
                lst)
              lst)))
         (trim-cands (trim-str filtered-cands))
         (trim-words (trim-str filtered-words))
         (candchars ; ͽ¬ϸ1ʸܤδΥꥹ
          (delete-duplicates
            (map (lambda (cand) (last (string-to-list cand)))
              (append trim-cands trim-words))))
         (cand-stroke
          (map
            (lambda (elem)
              (list (list (tutcode-reverse-find-seq elem rule)) (list elem)))
            candchars))
         (filtered-cand-stroke
          (filter
            (lambda (elem)
              (pair? (caar elem))) ; ɽ̵Ͻ
            cand-stroke))
         (label-cands-alist
          (tutcode-guide-update-alist () filtered-cand-stroke)))
    (tutcode-context-set-guide! pc label-cands-alist)
    (tutcode-context-set-guide-chars! pc filtered-cand-stroke)))

;;; ϸ쥬ɽѸꥹȤͽ¬ϸ䤫
;;; @param str ͽ¬ϸθ˻Ѥ=ϺѴ
(define (tutcode-guide-set-candidates-for-bushu pc)
  (let* ((word (tutcode-context-prediction-word pc))
         (rule (rk-context-rule (tutcode-context-rk-context pc)))
         (cand-stroke
          (map
            (lambda (elem)
              (list (list (tutcode-reverse-find-seq elem rule)) (list elem)))
            word))
         (filtered-cand-stroke
          (filter
            (lambda (elem)
              (pair? (caar elem))) ; ɽ̵Ͻ
            cand-stroke))
         (label-cands-alist
          (tutcode-guide-update-alist () filtered-cand-stroke)))
    (tutcode-context-set-guide! pc label-cands-alist)
    (tutcode-context-set-guide-chars! pc filtered-cand-stroke)))

;;; ϸ쥬ɤɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦˥٥ʸȴΥꥹȡ
;;; : (("," "") ("u" "" ""))
;;; @param label-cands-alist alist
;;; @param kanji-list ȥȥΥꥹ
;;; : (((("," "r"))("")) ((("u" "c"))("")) ((("u" "v"))("")))
;;; @return νϸ쥬alist
(define (tutcode-guide-update-alist label-cands-alist kanji-list)
  (if (null? kanji-list)
    label-cands-alist
    (let*
      ((kanji-stroke (car kanji-list))
       (kanji (caadr kanji-stroke))
       (stroke (caar kanji-stroke)))
      (tutcode-guide-update-alist
        (tutcode-auto-help-update-stroke-alist-with-key label-cands-alist
          kanji (car stroke))
        (cdr kanji-list)))))

;;; 򤼽ѴѸĿͼɤ߹ࡣ
(define (tutcode-read-personal-dictionary)
  (if (not (setugid?))
      (skk-lib-read-personal-dictionary tutcode-dic tutcode-personal-dic-filename)))

;;; 򤼽ѴѸĿͼ񤭹ࡣ
;;; @param force? tutcode-enable-mazegaki-learning?#fǤ񤭹फɤ
(define (tutcode-save-personal-dictionary force?)
  (if (and
        (or force? tutcode-enable-mazegaki-learning?)
        (not (setugid?)))
      (skk-lib-save-personal-dictionary tutcode-dic tutcode-personal-dic-filename)))

;;; ȥʸؤѴΤrk-push-key!ƤӽФ
;;; ͤ#fǤʤС(ꥹ)car֤
;;; ʥ⡼ɤξͥꥹȤcadr֤
;;; (rk-push-key!ϥȥξ#f֤)
;;; @param pc ƥȥꥹ
;;; @param key ʸ
(define (tutcode-push-key! pc key)
  (let ((res (rk-push-key! (tutcode-context-rk-context pc) key)))
    (and res
      (begin
        (tutcode-context-set-guide-chars! pc ())
        (if
          (and
            (not (null? (cdr res)))
            (tutcode-context-katakana-mode? pc))
          (cadr res)
          (car res))))))

;;; Ѵ֤򥯥ꥢ롣
;;; @param pc ƥȥꥹ
(define (tutcode-flush pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (rk-flush (tutcode-context-rk-context pc))
    (if tutcode-use-recursive-learning?
      (tutcode-editor-flush (tutcode-context-editor pc)))
    (tutcode-dialog-flush (tutcode-context-dialog pc))
    (if (tutcode-context-on? pc) ; ջ˸ƤФ줿ϥˤ
      (tutcode-context-set-state! pc 'tutcode-state-on)) ; Ѵ֤򥯥ꥢ
    (tutcode-context-set-head! pc ())
    (tutcode-context-set-nr-candidates! pc 0)
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc 0)
    (tutcode-context-set-mazegaki-yomi-all! pc ())
    (tutcode-context-set-mazegaki-suffix! pc ())
    (tutcode-reset-candidate-window pc)
    (tutcode-context-set-latin-conv! pc #f)
    (tutcode-context-set-guide-chars! pc ())
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (if (not (null? cpc))
      (tutcode-flush cpc))))

;;; 򤼽Ѵnܤθ֤
;;; @param pc ƥȥꥹ
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate pc n)
  (let* ((head (tutcode-context-head pc))
         (cand (skk-lib-get-nth-candidate
                tutcode-dic
                n
                (cons (string-list-concat head) "")
                ""
                #f)))
    cand))

;;; ϥ⡼ɻnܤθ֤
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate-for-kigou-mode pc n)
 (car (nth n tutcode-kigoudic)))

;;; ҥȥϥ⡼ɻnܤθ֤
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate-for-history pc n)
  (list-ref (tutcode-context-history pc) n))

;;; 򤼽Ѵθθ֤
;;; @param pc ƥȥꥹ
(define (tutcode-get-current-candidate pc)
  (tutcode-get-nth-candidate pc (tutcode-context-nth pc)))

;;; ϥ⡼ɻθθ֤
(define (tutcode-get-current-candidate-for-kigou-mode pc)
  (tutcode-get-nth-candidate-for-kigou-mode pc (tutcode-context-nth pc)))

;;; ҥȥϥ⡼ɻθθ֤
(define (tutcode-get-current-candidate-for-history pc)
  (tutcode-get-nth-candidate-for-history pc (tutcode-context-nth pc)))

;;; 򤼽Ѵǳꤷʸ֤
;;; @param pc ƥȥꥹ
;;; @return ꤷʸ
(define (tutcode-prepare-commit-string pc)
  (let ((res (tutcode-get-current-candidate pc))
        (suffix (tutcode-context-mazegaki-suffix pc))
        (head (tutcode-context-head pc)))
    ;; ĤΥ٥륭θꤹȤǤ褦ˡ
    ;; tutcode-enable-mazegaki-learning?#fξϸ¤ӽѤʤ
    ;; (:֤פѴˤơdǡֲסeǡֲפ)
    (if tutcode-enable-mazegaki-learning?
      (begin
        ;; skk-lib-commit-candidateƤ֤ȳؽԤ졢礬ѹ
        (skk-lib-commit-candidate
          tutcode-dic
          (cons (string-list-concat head) "")
          ""
          (tutcode-context-nth pc)
          #f)
        (if (> (tutcode-context-nth pc) 0)
          (tutcode-save-personal-dictionary #f))))
    (tutcode-flush pc)
    (if (null? suffix)
      res
      (string-append res (string-list-concat suffix)))))

;;; ϥ⡼ɻ˳ꤷʸ֤
(define (tutcode-prepare-commit-string-for-kigou-mode pc)
  (tutcode-get-current-candidate-for-kigou-mode pc))

;;; ҥȥϥ⡼ɻ˳ꤷʸ֤
(define (tutcode-prepare-commit-string-for-history pc)
  (tutcode-get-current-candidate-for-history pc))

;;; im-commit-rawƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
(define (tutcode-commit-raw pc key key-state)
  (if (or tutcode-use-completion? tutcode-enable-fallback-surrounding-text?)
    (tutcode-append-commit-string pc (im-get-raw-key-str key key-state)))
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-editor)
        (tutcode-editor-commit-raw (tutcode-context-editor ppc) key key-state)
        (tutcode-dialog-commit-raw (tutcode-context-dialog ppc) key key-state))
      (im-commit-raw pc))))

;;; im-commitƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
;;; @param str ߥåȤʸ
;;; @param opts ץ
;;;  opt-skip-append-commit-strs? commit-strsؤɲä
;;;  åפ뤫ɤ̤#f
;;;  opt-skip-append-history? historyؤɲä
;;;  åפ뤫ɤ̤#f
(define (tutcode-commit pc str . opts)
  (let-optionals* opts ((opt-skip-append-commit-strs? #f)
                        (opt-skip-append-history? #f))
    (if (and
          (or tutcode-use-completion? tutcode-enable-fallback-surrounding-text?)
          (not opt-skip-append-commit-strs?))
      (tutcode-append-commit-string pc str))
    (if (and (> tutcode-history-size 0)
             (not opt-skip-append-history?))
      (tutcode-append-history pc str)))
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-editor)
        (tutcode-editor-commit (tutcode-context-editor ppc) str)
        (tutcode-dialog-commit (tutcode-context-dialog ppc) str))
      (im-commit pc str))))

;;; im-commitƤӽФȤȤˡưإɽΥåԤ
(define (tutcode-commit-with-auto-help pc)
  (let* ((head (tutcode-context-head pc))
         (yomi-len (tutcode-context-postfix-yomi-len pc))
         (suffix (tutcode-context-mazegaki-suffix pc))
         (res (tutcode-prepare-commit-string pc))) ; flushˤheadꥢ
    (if (> yomi-len 0)
      (tutcode-postfix-delete-text pc yomi-len))
    (tutcode-commit pc res)
    (tutcode-check-auto-help-window-begin pc
      (drop (string-to-list res) (length suffix))
      (append suffix head))))

;;; 򤼽Ѵθˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
(define (tutcode-commit-by-label-key pc ch)
  ;; ߸䥦ɥɽƤʤ٥ʸϤ硢
  ;; ߰ʹߤθˤϥ٥ʸбꤹ롣
  ;; (ؽǽ򥪥դˤƸ¤ӽˤƻѤˡ
  ;; next-page-key򲡤򸺤餷
  ;; ʤ٤ʤŪθ٤褦ˤ뤿)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (idx
          (tutcode-get-idx-by-label-key ch nth tutcode-nr-candidate-max
            tutcode-nr-candidate-max tutcode-heading-label-char-list)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit-with-auto-help pc)))))

;;; ˡꤵ줿٥ʸбֹ׻
;;; @param ch Ϥ줿٥ʸ
;;; @param nth 򤵤Ƥֹ
;;; @param page-limit 򥦥ɥǤγƥڡθ
;;;                   (䴰ξ:䴰+ϸ쥬)
;;; @param nr-in-page 򥦥ɥǤγƥڡθ
;;;                   (䴰ξ:䴰Τ)
;;; @param heading-label-char-list ٥ʸ
;;; @return ֹ
(define (tutcode-get-idx-by-label-key ch nth page-limit nr-in-page
        heading-label-char-list)
  (let*
    ((cur-page (if (= page-limit 0)
                  0
                  (quotient nth page-limit)))
     ;; ߸䥦ɥɽθꥹȤƬθֹ
     (cur-offset (* cur-page nr-in-page))
     (labellen (length heading-label-char-list))
     (cur-labels
       (list-tail heading-label-char-list (remainder cur-offset labellen)))
     (target-labels (member ch cur-labels))
     (offset (if target-labels
               (- (length cur-labels) (length target-labels))
               (+ (length cur-labels)
                  (- labellen
                     (length
                       (member ch heading-label-char-list))))))
     (idx (+ cur-offset offset)))
    idx))

;;; ϥ⡼ɻˡꤵ줿٥ʸбꤹ
(define (tutcode-commit-by-label-key-for-kigou-mode pc ch)
  ;; 򤼽ѴȰۤʤꡢߤθꤹ礢
  ;; (ѱѿϥ⡼ɤȤƻȤ褦ˤ뤿)
  ;; (ϥ⡼ɻϡٳꤷϢ³ϤǤ褦ˡ
  ;; ľθ򤷤Ƥ뤬
  ;; ΤȤ򤼽ѴƱͤθԤȡ
  ;; ٥ʸꥹȤ2ܤбꤷƤޤ礬
  ;; (:thǤä硢ѱѿϤȤƤϣˤʤäߤˤʤ)
  ;; ᡢ򤼽ѴȤϰۤʤԤ)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (labellen (length tutcode-heading-label-char-list-for-kigou-mode))
         (cur-base (quotient nth labellen))
         (offset
           (- labellen
              (length
                (member ch tutcode-heading-label-char-list-for-kigou-mode))))
         (idx (+ (* cur-base labellen) offset)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit pc
          (tutcode-prepare-commit-string-for-kigou-mode pc))))))

;;; ҥȥϤθˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
(define (tutcode-commit-by-label-key-for-history pc ch)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (idx
          (tutcode-get-idx-by-label-key ch nth
            tutcode-nr-candidate-max-for-history
            tutcode-nr-candidate-max-for-history
            tutcode-heading-label-char-list-for-history)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (let ((str (tutcode-prepare-commit-string-for-history pc)))
          (tutcode-commit pc str)
          (tutcode-flush pc)
          (tutcode-check-auto-help-window-begin pc (string-to-list str) ()))))))

;;; 䴰/ͽ¬ϸɽˡꤵ줿٥ʸбꤹ
;;; @param ch Ϥ줿٥ʸ
;;; @param mode tutcode-context-predicting
(define (tutcode-commit-by-label-key-for-prediction pc ch mode)
  (let*
    ((nth (tutcode-context-prediction-index pc))
     (page-limit (tutcode-context-prediction-page-limit pc))
     (nr-in-page (tutcode-context-prediction-nr-in-page pc))
     (idx
      (tutcode-get-idx-by-label-key ch nth page-limit nr-in-page
        tutcode-heading-label-char-list-for-prediction))
     (nr (tutcode-lib-get-nr-predictions pc))
     (i (remainder idx nr)))
    (if (>= i 0)
      (begin
        (tutcode-context-set-prediction-index! pc i)
        (case mode
          ((tutcode-predicting-bushu)
            (tutcode-do-commit-prediction-for-bushu pc))
          ((tutcode-predicting-interactive-bushu)
            (tutcode-do-commit-prediction-for-interactive-bushu pc))
          ((tutcode-predicting-completion)
            (tutcode-do-commit-prediction pc #t))
          (else
            (tutcode-do-commit-prediction pc #f)))))))

(define (tutcode-get-prediction-string pc)
  (tutcode-lib-get-nth-prediction
   pc
   (tutcode-context-prediction-index pc)))

(define (tutcode-learn-prediction-string pc completion?)
  (tutcode-lib-commit-nth-prediction
   pc
   (tutcode-context-prediction-index pc)
   completion?))

;;; 䴰/ͽ¬ϸꤹ
;;; @param completion? 䴰ɤ
(define (tutcode-do-commit-prediction pc completion?)
  (let ((str (tutcode-get-prediction-string pc)))
    (tutcode-learn-prediction-string pc completion?)
    (tutcode-reset-candidate-window pc)
    (tutcode-commit pc str)
    (tutcode-flush pc)
    (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))

;;; Ѵͽ¬ϸꤹ
(define (tutcode-do-commit-prediction-for-bushu pc)
  (let ((str (tutcode-get-prediction-string pc)))
    (tutcode-reset-candidate-window pc)
    (tutcode-bushu-commit pc str)))

;;; ŪѴθꤹ
(define (tutcode-do-commit-prediction-for-interactive-bushu pc)
  (let ((str (tutcode-get-prediction-string pc)))
    (tutcode-reset-candidate-window pc)
    (tutcode-commit pc str)
    (tutcode-flush pc)
    (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))

;;; 򤼽Ѵ񤫤顢򤵤Ƥ롣
(define (tutcode-purge-candidate pc)
  (let ((res (skk-lib-purge-candidate
               tutcode-dic
               (cons (string-list-concat (tutcode-context-head pc)) "")
               ""
               (tutcode-context-nth pc)
               #f)))
    (if res
      (tutcode-save-personal-dictionary #t))
    (tutcode-reset-candidate-window pc)
    (tutcode-flush pc)
    res))

;;; 򤼽Ѵɤ/Ѵ(ʸꥹhead)ʸɲä롣
;;; @param pc ƥȥꥹ
;;; @param str ɲäʸ
(define (tutcode-append-string pc str)
  (if (and str (string? str))
    (tutcode-context-set-head! pc
      (cons str
        (tutcode-context-head pc)))))

;;; commitѤʸꥹcommit-strsʸɲä롣
;;; @param str ɲäʸ
(define (tutcode-append-commit-string pc str)
  (if (and str (string? str))
    (let* ((strlist (string-to-list str)) ; strʣʸξ礢
           (commit-strs (tutcode-context-commit-strs pc))
           (new-strs (append strlist commit-strs)))
      (tutcode-context-set-commit-strs! pc
        (if (> (length new-strs) tutcode-completion-chars-max)
          (take new-strs tutcode-completion-chars-max)
          new-strs)))))

;;; commitʸꥹhistoryʸɲä롣
;;; @param str ɲäʸ
(define (tutcode-append-history pc str)
  (let* ((history (tutcode-context-history pc))
         (new-history (cons str (delete str history))))
    (tutcode-context-set-history! pc
      (if (> (length new-history) tutcode-history-size)
        (take new-history tutcode-history-size)
        new-history))))

;;; 򤼽Ѵ򳫻Ϥ
;;; @param yomi Ѵоݤɤ(ʸεսꥹ)
;;; @param suffix ѤѴԤγѸ(ʸεսꥹ)
;;; @param autocommit? 䤬1Ĥξ˼ưŪ˳ꤹ뤫ɤ
;;; @param recursive-learning? 䤬̵˺ƵϿ⡼ɤ뤫ɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-conversion pc yomi suffix autocommit?
          recursive-learning?)
  (let*
    ((yomi-str (string-list-concat yomi))
     (res (and (symbol-bound? 'skk-lib-get-entry)
               (skk-lib-get-entry tutcode-dic yomi-str "" "" #f)
               (skk-lib-get-nr-candidates tutcode-dic yomi-str "" "" #f))))
    (if res
      (begin
        (tutcode-context-set-head! pc yomi)
        (tutcode-context-set-mazegaki-suffix! pc suffix)
        (tutcode-context-set-nth! pc 0)
        (tutcode-context-set-nr-candidates! pc res)
        (tutcode-context-set-state! pc 'tutcode-state-converting)
        (if (and autocommit? (= res 1))
          ;; 䤬1ĤʤϼưŪ˳ꤹ롣
          ;; (Ͽtutcode-register-candidate-key򲡤Ū˳Ϥ)
          (tutcode-commit-with-auto-help pc)
          (begin
            (tutcode-check-candidate-window-begin pc)
            (if (eq? (tutcode-context-candidate-window pc)
                     'tutcode-candidate-window-converting)
              (im-select-candidate pc 0))))
        #t)
      ;; ̵
      (begin
        (if recursive-learning?
          (begin
            (tutcode-context-set-head! pc yomi)
            (tutcode-context-set-mazegaki-suffix! pc suffix)
            (tutcode-context-set-state! pc 'tutcode-state-converting)
            (tutcode-setup-child-context pc 'tutcode-child-type-editor)))
          ;(tutcode-flush pc) ; flushϤʸ󤬾äƤä
        #f))))

;;; ַ򤼽Ѵ򳫻Ϥ(Ѥˤб)
;;; @param inflection? ѤθԤɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-conversion-with-inflection pc inflection?)
  (let*
    ((yomi (tutcode-context-head pc))
     (yomi-len (length yomi)))
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc yomi-len)
    (tutcode-context-set-mazegaki-yomi-all! pc yomi)
    (if (or (not inflection?)
            (not tutcode-mazegaki-enable-inflection?)
            (tutcode-mazegaki-inflection? yomi)) ; Ū""դϤ줿
      (tutcode-begin-conversion pc yomi () #t tutcode-use-recursive-learning?)
      (or
        (tutcode-begin-conversion pc yomi () #f #f)
        ;; ѤȤƺƸ
          (or
            (tutcode-mazegaki-inflection-relimit-right pc yomi-len yomi-len #f)
            ;; ѤʤȤƺƵؽ
            (and tutcode-use-recursive-learning?
              (begin
                (tutcode-begin-conversion pc yomi () #t
                  tutcode-use-recursive-learning?))))))))

;;; Ѥַ򤼽Ѵ򳫻Ϥ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-mazegaki-inflection-conversion pc)
  (let*
    ((yomi (tutcode-context-head pc))
     (yomi-len (length yomi)))
    (tutcode-context-set-postfix-yomi-len! pc 0)
    (tutcode-context-set-mazegaki-yomi-len-specified! pc yomi-len)
    (tutcode-context-set-mazegaki-yomi-all! pc yomi)
    (if (tutcode-mazegaki-inflection? yomi) ; Ū""դϤ줿
      (tutcode-begin-conversion pc yomi () #t tutcode-use-recursive-learning?)
      (tutcode-mazegaki-inflection-relimit-right pc yomi-len yomi-len #f))))

;;; Ϥ줿ɤбꤹ
;;; @param str-list ɡϤ줿ʸΥꥹ(ս)
(define (tutcode-begin-kanji-code-input pc str-list)
  (let
    ((kanji
      (cond
        ((string-ci=? (last str-list) "u")
          (tutcode-kanji-code-input-ucs str-list))
        ((member "-" str-list)
          (tutcode-kanji-code-input-kuten str-list))
        (else
          (tutcode-kanji-code-input-jis str-list)))))
    (if (and kanji (> (string-length kanji) 0))
      (begin
        (tutcode-commit pc kanji)
        (tutcode-flush pc)
        (tutcode-check-auto-help-window-begin pc (list kanji) ())))))

;;; Ϥ줿UCSбꤹ
;;; @param str-list UCS(16ʿ)Ϥ줿ʸΥꥹ(ս)
;;; @return EUC-JPʸʤɤξ#f
(define (tutcode-kanji-code-input-ucs str-list)
  (and-let*
    ((str-list-1 (drop-right str-list 1)) ; drop last "U"
     (not-only-u? (not (null? str-list-1)))
     (ucs-str (if (string=? (last str-list-1) "+")
                (drop-right str-list-1 1)
                str-list-1))
     (ucs (string->number (string-list-concat ucs-str) 16))
     ;; 顼Τϰϥå
     (valid? ; sigscheme/src/sigschemeinternal.h:ICHAR_VALID_UNICODEP()
      (or
        (<= 0 ucs #xd7ff)
        (<= #xe000 ucs #x10ffff)))
     (utf8-str (ucs->utf8-string ucs))
     (ic (iconv-open "EUC-JP" "UTF-8")))
    (let ((eucj-str (iconv-code-conv ic utf8-str)))
      (iconv-release ic)
      eucj-str)))

;;; Ϥ줿JIS X 0213()ֹбꤹ
;;; @param str-list ()ֹ档Ϥ줿ʸΥꥹ(ս)
;;; @return EUC-JPʸʤֹξ#f
(define (tutcode-kanji-code-input-kuten str-list)
  (let*
    ((numlist (string-split (string-list-concat str-list) "-"))
     (men-exists? (>= (length numlist) 3))
     (men (if men-exists? (string->number (list-ref numlist 0)) 1))
     (ku (string->number (list-ref numlist (if men-exists? 1 0))))
     (ten (string->number (list-ref numlist (if men-exists? 2 1)))))
    (and men ku ten (<= 1 men 2)
      (tutcode-jis-code->euc-jp-string
        (if (= men 2) 'jisx0213-plane2 'jisx0213-plane1)
        (+ ku #x20) (+ ten #x20)))))

;;; Ϥ줿JIS(ISO-2022-JP)бꤹ
;;; @param str-list JISɡϤ줿ʸΥꥹ(ս)
;;; @return EUC-JPʸʤɤξ#f
(define (tutcode-kanji-code-input-jis str-list)
  (and-let*
    ((length=4? (= (length str-list) 4))
     (str1 (string-list-concat (take-right str-list 2)))
     (str2 (string-list-concat (take str-list 2)))
     (jis1 (string->number str1 16))
     (jis2 (string->number str2 16)))
    (tutcode-jis-code->euc-jp-string 'jisx0213-plane1 jis1 jis2)))

;;; JIS(ISO-2022-JP)EUC-JPʸѴ
;;; @param state 'jisx0213-plane1'jisx0213-plane2
;;; @param jis1 JISɤ1Х
;;; @param jis2 JISɤ2Х
;;; @return EUC-JPʸʤɤξ#f
(define (tutcode-jis-code->euc-jp-string state jis1 jis2)
  (let
    ((ej0 (if (eq? state 'jisx0213-plane2) #x8f 0))
     (ej1 (+ jis1 #x80))
     (ej2 (+ jis2 #x80)))
    (and
      ;; sigscheme/src/encoding.c:eucjp_int2str()
      (<= #xa1 ej1 #xfe) ; IN_GR94()
      (if (= ej0 #x8f) ; SS3?
        (<= #xa1 ej2 #xfe) ; IN_GR94()
        (<= #xa0 ej2 #xff)) ; IN_GR96()
      (tutcode-euc-jp-code->euc-jp-string
        (+ (* ej0 #x10000) (* ej1 #x100) ej2)))))

;;; EUC-JPɤEUC-JPʸѴ (cf. ucs->utf8-string in ichar.scm)
;;; @param code EUC-JP
;;; @return EUC-JPʸ
(define (tutcode-euc-jp-code->euc-jp-string code)
  (with-char-codec "EUC-JP"
    (lambda ()
      (let ((str (list->string (list (integer->char code)))))
        (with-char-codec "ISO-8859-1"
          (lambda ()
            (%%string-reconstruct! str)))))))

;;; ҥƥȤ롣
;;; @param type 'tutcode-child-type-editor'tutcode-child-type-dialog
(define (tutcode-setup-child-context pc type)
  (let ((cpc (tutcode-context-new (tutcode-context-uc pc)
              (tutcode-context-im pc))))
    (tutcode-context-set-child-context! pc cpc)
    (tutcode-context-set-child-type! pc type)
    (tutcode-context-set-parent-context! cpc pc)
    (if (eq? type 'tutcode-child-type-editor)
      (tutcode-context-set-state! cpc 'tutcode-state-on)
      (tutcode-context-set-state! cpc 'tutcode-state-off))))

;;; ϥ⡼ɤ򳫻Ϥ롣
;;; @param pc ƥȥꥹ
(define (tutcode-begin-kigou-mode pc)
  (tutcode-context-set-nth! pc 0)
  (tutcode-context-set-nr-candidates! pc (length tutcode-kigoudic))
  (tutcode-context-set-state! pc 'tutcode-state-kigou)
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-kigou)
    (im-select-candidate pc 0)))

;;; ҥȥϤθɽ򳫻Ϥ
(define (tutcode-begin-history pc)
  (if (and (> tutcode-history-size 0)
           (pair? (tutcode-context-history pc)))
    (begin
      (tutcode-context-set-nth! pc 0)
      (tutcode-context-set-nr-candidates! pc
        (length (tutcode-context-history pc)))
      (tutcode-context-set-state! pc 'tutcode-state-history)
      (tutcode-check-candidate-window-begin pc)
      (if (eq? (tutcode-context-candidate-window pc)
               'tutcode-candidate-window-hisory)
        (im-select-candidate pc 0)))))

;;; 2ȥϥ⡼(tutcode-kigou-rule)tutcode-ruleڤؤԤ
;;; @param pc ƥȥꥹ
(define (tutcode-toggle-kigou2-mode pc)
  (if tutcode-use-kigou2-mode?
    (let ((tmp-rkc (tutcode-context-rk-context pc))
          (tmp-stroke-help? tutcode-use-stroke-help-window?))
      (tutcode-context-set-rk-context! pc
        (tutcode-context-rk-context-another pc))
      (tutcode-context-set-rk-context-another! pc tmp-rkc)
      (set! tutcode-use-stroke-help-window?
        tutcode-use-stroke-help-window-another?)
      (set! tutcode-use-stroke-help-window-another? tmp-stroke-help?)
      (tutcode-context-set-guide-chars! pc ()))))

;;; 䥦ɥɽ򳫻Ϥ
(define (tutcode-check-candidate-window-begin pc)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-candidate-window?
           (>= (tutcode-context-nth pc) (- tutcode-candidate-op-count 1)))
    (let ((state (tutcode-context-state pc)))
      (tutcode-context-set-candidate-window! pc
        (case state
          ((tutcode-state-kigou) 'tutcode-candidate-window-kigou)
          ((tutcode-state-history) 'tutcode-candidate-window-history)
          (else 'tutcode-candidate-window-converting)))
      (im-activate-candidate-selector
        pc
        (tutcode-context-nr-candidates pc)
        (case state
          ((tutcode-state-kigou) tutcode-nr-candidate-max-for-kigou-mode)
          ((tutcode-state-history) tutcode-nr-candidate-max-for-history)
          (else tutcode-nr-candidate-max))))))

;;; ۸פɽ򳫻Ϥ
(define (tutcode-check-stroke-help-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc) 'tutcode-candidate-window-off)
    (let*
      ((rkc (tutcode-context-rk-context pc))
       (seq (rk-context-seq rkc))
       (seqlen (length seq))
       (seq-rev (reverse seq))
       (guide-seqs
        (and
          (pair? seq)
          (pair? (tutcode-context-guide-chars pc))
          (rk-lib-find-partial-seqs seq-rev (tutcode-context-guide-chars pc))))
       (guide-alist (tutcode-stroke-help-guide-update-alist () seqlen
                      (if (pair? guide-seqs) guide-seqs ())))
       ;; :(("v" "+") ("a" "+") ("r" "+"))
       (guide-candcombined
        (map
          (lambda (elem)
            (list (car elem) (string-list-concat (cdr elem))))
          guide-alist))
       ;; stroke-help. :(("k" "") ("i" "") ("g" "*£"))
       (label-cand-alist
        (if (or tutcode-use-stroke-help-window?
                (and
                  (pair? guide-seqs)
                  (eq? tutcode-stroke-help-with-kanji-combination-guide 'full)))
          (let*
            ((rule (rk-context-rule rkc))
             (ret (rk-lib-find-partial-seqs seq-rev rule))
             (katakana? (tutcode-context-katakana-mode? pc))
             (label-cand-alist
              (if (null? seq) ; tutcode-ruleʤƺ٤Τǥå
                (cond
                  ((tutcode-kigou2-mode? pc)
                    tutcode-kigou-rule-stroke-help-top-page-alist)
                  (katakana?
                    (if (null? tutcode-stroke-help-top-page-katakana-alist)
                      (set! tutcode-stroke-help-top-page-katakana-alist
                        (tutcode-stroke-help-update-alist
                          () seqlen katakana? ret)))
                    tutcode-stroke-help-top-page-katakana-alist)
                  (else
                    (if (null? tutcode-stroke-help-top-page-alist)
                      (set! tutcode-stroke-help-top-page-alist
                        (tutcode-stroke-help-update-alist
                          () seqlen katakana? ret)))
                    tutcode-stroke-help-top-page-alist))
                (tutcode-stroke-help-update-alist () seqlen katakana? ret))))
            ;; ɽʸ򡢽ϸ쥬(+)դʸ֤
            (for-each
              (lambda (elem)
                (let*
                  ((label (car elem))
                   (label-cand (assoc label label-cand-alist)))
                  (if label-cand
                    (set-cdr! label-cand (cdr elem)))))
              guide-candcombined)
            label-cand-alist)
          (if (eq? tutcode-stroke-help-with-kanji-combination-guide 'guide-only)
            guide-candcombined
            ()))))
      (if (not (null? label-cand-alist))
        (let
          ((stroke-help
            (map
              (lambda (elem)
                (list (cadr elem) (car elem) ""))
              (reverse label-cand-alist))))
          (tutcode-context-set-stroke-help! pc stroke-help)
          (tutcode-context-set-candidate-window! pc
            'tutcode-candidate-window-stroke-help)
          (im-activate-candidate-selector pc
            (length stroke-help) tutcode-nr-candidate-max-for-kigou-mode))))))

;;; ۸פɽԤɤŪڤؤ(ȥ)
;;; (ɽܤʤΤǡǤ¤äȤɽ
;;;  XXX: tc2ȡְ˼Ǹ̵ä鲾۸פ
;;;  ɽ褦ˤʤäƤ뤬uimƱȤ򤹤Τ񤷤)
(define (tutcode-toggle-stroke-help pc)
  (if tutcode-use-stroke-help-window?
    (begin
      (set! tutcode-use-stroke-help-window? #f)
      (tutcode-reset-candidate-window pc))
    (set! tutcode-use-stroke-help-window? #t)))

;;; ۸ɽѥǡ
;;; @param label-cand-alist ɽѥǡ
;;;  :(("k" "") ("i" "") ("g" "*£"))
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param katakana? ʥ⡼ɤɤ
;;; @param rule-list rk-rule
;;; @return label-cand-alist
(define (tutcode-stroke-help-update-alist
         label-cand-alist seqlen katakana? rule-list)
  (if (null? rule-list)
    label-cand-alist
    (tutcode-stroke-help-update-alist
      (tutcode-stroke-help-update-alist-with-rule
        label-cand-alist seqlen katakana? (car rule-list))
      seqlen katakana? (cdr rule-list))))

;;; ۸ɽѥǡ:Ĥruleȿǡ
;;; @param label-cand-alist ɽѥǡ
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param katakana? ʥ⡼ɤɤ
;;; @param rule rk-ruleΰĤrule
;;; @return label-cand-alist
(define (tutcode-stroke-help-update-alist-with-rule
         label-cand-alist seqlen katakana? rule)
  (let* ((label (list-ref (caar rule) seqlen))
         (label-cand (assoc label label-cand-alist)))
    ;; ˳ƤƤ鲿⤷ʤruleǺǽ˽иʸ
    (if label-cand
      label-cand-alist
      (let*
        ((candlist (cadr rule))
         ;; ?
         (has-next? (> (length (caar rule)) (+ seqlen 1)))
         (cand
          (or
            (and (not (null? (cdr candlist)))
                 katakana?
                 (cadr candlist))
            (car candlist)))
         (candstr
          (case cand
            ((tutcode-mazegaki-start) "")
            ((tutcode-latin-conv-start) "/")
            ((tutcode-kanji-code-input-start) "")
            ((tutcode-history-start) "")
            ((tutcode-bushu-start) "")
            ((tutcode-interactive-bushu-start) "")
            ((tutcode-postfix-bushu-start) "")
            ((tutcode-postfix-mazegaki-start) "")
            ((tutcode-postfix-mazegaki-1-start) "1")
            ((tutcode-postfix-mazegaki-2-start) "2")
            ((tutcode-postfix-mazegaki-3-start) "3")
            ((tutcode-postfix-mazegaki-4-start) "4")
            ((tutcode-postfix-mazegaki-5-start) "5")
            ((tutcode-postfix-mazegaki-6-start) "6")
            ((tutcode-postfix-mazegaki-7-start) "7")
            ((tutcode-postfix-mazegaki-8-start) "8")
            ((tutcode-postfix-mazegaki-9-start) "9")
            ((tutcode-postfix-mazegaki-inflection-start) "")
            ((tutcode-postfix-mazegaki-inflection-1-start) "1")
            ((tutcode-postfix-mazegaki-inflection-2-start) "2")
            ((tutcode-postfix-mazegaki-inflection-3-start) "3")
            ((tutcode-postfix-mazegaki-inflection-4-start) "4")
            ((tutcode-postfix-mazegaki-inflection-5-start) "5")
            ((tutcode-postfix-mazegaki-inflection-6-start) "6")
            ((tutcode-postfix-mazegaki-inflection-7-start) "7")
            ((tutcode-postfix-mazegaki-inflection-8-start) "8")
            ((tutcode-postfix-mazegaki-inflection-9-start) "9")
            ((tutcode-auto-help-redisplay) "")
            (else cand)))
         (cand-hint
          (or
            ;; ξhint-mark(*)դ
            (and has-next? (string-append tutcode-hint-mark candstr))
            candstr)))
        (cons (list label cand-hint) label-cand-alist)))))

;;; ۸׾νϸ쥬ɤɽ˻Ȥalist˴ɲä롣
;;; @param kanji-stroke ɲäȥȥΥꥹȡ
;;; : ((("," "r"))(""))
(define (tutcode-stroke-help-guide-add-kanji pc kanji-stroke)
  (let ((chars (tutcode-context-guide-chars pc)))
    (if (not (member kanji-stroke chars))
      (tutcode-context-set-guide-chars! pc (cons kanji-stroke chars)))))

;;; ۸׾νϸ쥬ɤɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦˥٥ʸɽʸΥꥹ(ս)
;;; : (("v" "+" "") ("a" "+" "") ("r" "+" ""))
;;; @param label-cands-alist alist
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param rule-list rk-rule
;;; @return νϸ쥬alist
(define (tutcode-stroke-help-guide-update-alist
         label-cands-alist seqlen rule-list)
  (if (null? rule-list)
    label-cands-alist
    (tutcode-stroke-help-guide-update-alist
      (tutcode-stroke-help-guide-update-alist-with-rule
        label-cands-alist seqlen (car rule-list))
      seqlen (cdr rule-list))))

;;; ۸׾νϸ쥬:оݤ1ʸ򡢽ϸ쥬alistɲä롣
;;; @param label-cands-alist alist
;;; @param seqlen ܤΥȥоݤȤ뤫
;;; @param rule rk-ruleΰĤrule
;;; @return νϸ쥬alist
(define (tutcode-stroke-help-guide-update-alist-with-rule
         label-cands-alist seqlen rule)
  (let* ((label (list-ref (caar rule) seqlen))
         (label-cand (assoc label label-cands-alist))
         (has-next? (> (length (caar rule)) (+ seqlen 1))) ; ?
         (cand (car (cadr rule))))
    (if label-cand
      (begin
        ;; ˳ƤƤ
        (set-cdr! label-cand (cons cand (cdr label-cand)))
        label-cands-alist)
      (cons
        (if has-next?
          (list label cand tutcode-guide-mark)
          (list label tutcode-guide-end-mark cand))
        label-cands-alist))))

;;; Ѵ򤼽ѴǳꤷʸǤɽ롣
;;; ɽθ䥦ɥξϡʲΤ褦ɽ롣
;;; 11Ǹ22Ǹַȡ
;;;          
;;;          3 
;;;  1()   
;;;  2         
;;; 򤼽ѴʣʸַӡפѴϡʲΤ褦ɽ롣
;;;              
;;;  a()         3 
;;;      1()b  c 
;;;      2         
;;; ꤷʸľϤǤʤ硢ñѴϤǤС
;;; ʲΤ褦Ѵˡɽ롣ͫݵ
;;;    
;;;                                        
;;;      
;;;            b                   f       
;;;      
;;;      3                         1(ͫ)   
;;;      
;;;        d   e   2a(ݵӴ)            
;;;    
;;;
;;; tutcode-auto-help-with-real-keys?#tξ(̾θ䥦ɥ)ϡ
;;; ʲΤ褦ɽ롣
;;;   ͫ lns
;;;   ݵ Ӵ nt cbo
;;;
;;; @param strlist ꤷʸΥꥹ(ս)
;;; @param yomilist ѴɤߤʸΥꥹ(ս)
(define (tutcode-check-auto-help-window-begin pc strlist yomilist)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-auto-help-window?)
    (begin
      (tutcode-context-set-guide-chars! pc ())
      (let*
        ((helpstrlist (lset-difference string=? (reverse strlist) yomilist))
         (label-cands-alist
          (if (not tutcode-auto-help-with-real-keys?)
            ;; ɽξ:(("y" "2" "1") ("t" "3"))
            (tutcode-auto-help-update-stroke-alist
              pc () tutcode-auto-help-cand-str-list helpstrlist)
            ;; ̾ξ:(("" "t" "y" "y"))
            (reverse
              (tutcode-auto-help-update-stroke-alist-normal pc () helpstrlist)))))
        (if (not (null? label-cands-alist))
          (let
            ((auto-help
              (map
                (lambda (elem)
                  (list (string-list-concat (cdr elem)) (car elem) ""))
                label-cands-alist)))
            (tutcode-context-set-auto-help! pc auto-help)
            (tutcode-context-set-candidate-window! pc
              'tutcode-candidate-window-auto-help)
            (im-activate-candidate-selector pc
              (length auto-help) tutcode-nr-candidate-max-for-kigou-mode)))))))

;;; ưإפɽɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦Ǹ򼨤٥ʸȡɽʸΥꥹ
;;;  :(("y" "2" "1") ("t" "3")) ; ("y" "y" "t")Ȥȥɽ
;;;      
;;;  3 12
;;;      
;;;      
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist pc label-cands-alist
         cand-list kanji-list)
  (if (or (null? cand-list) (null? kanji-list))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist
      pc
      (tutcode-auto-help-update-stroke-alist-with-kanji
        pc label-cands-alist (car cand-list) (car kanji-list))
      (cdr cand-list) (cdr kanji-list))))

;;; ưإפ̾ɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦ʸȡʸϤ뤿ΥΥꥹ(ս)
;;;  :(("" "t" "y" "y"))
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal pc label-cands-alist
         kanji-list)
  (if (null? kanji-list)
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-normal
      pc
      (tutcode-auto-help-update-stroke-alist-normal-with-kanji
        pc label-cands-alist (car kanji-list))
      (cdr kanji-list))))

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-kanji pc label-cands-alist
         cand-list kanji)
  (let*
    ((stime (time))
     (rule (rk-context-rule (tutcode-context-rk-context pc)))
     (stroke (tutcode-reverse-find-seq kanji rule)))
    (if stroke
      (begin
        (tutcode-stroke-help-guide-add-kanji
          pc (list (list stroke) (list kanji)))
        (tutcode-auto-help-update-stroke-alist-with-stroke
          label-cands-alist
          (cons (string-append (caar cand-list) "(" kanji ")") (cdar cand-list))
          stroke))
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji rule stime)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (let*
            ((bushu-strs (tutcode-auto-help-bushu-composition-strs decomposed))
             (helpstrlist (append (list "(" kanji "") bushu-strs '(")")))
             (helpstr (apply string-append helpstrlist))
             (alist
              (letrec
                ((update-stroke
                  (lambda (lst alist cand-list)
                    (if (or (null? lst) (null? cand-list))
                      (list alist cand-list)
                      (let
                        ((res
                          (if (tutcode-rule-element? (car lst))
                            (list
                              (tutcode-auto-help-update-stroke-alist-with-stroke
                                alist (car cand-list) (caar (car lst)))
                              (cdr cand-list))
                            (update-stroke (car lst) alist cand-list))))
                        (update-stroke (cdr lst) (car res) (cadr res)))))))
                (update-stroke decomposed label-cands-alist
                  (cons
                    (cons
                      (string-append (caar cand-list) helpstr)
                      (cdar cand-list))
                    (cdr cand-list))))))
            (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
            (car alist)))))))

;;; tutcode-ruleǤη((("," "o"))(""))ɤ֤
(define (tutcode-rule-element? x)
  (and
    (pair? x)
    (pair? (car x))
    (pair? (caar x))
    (pair? (cdr x))
    (pair? (cadr x))
    (every string? (caar x))
    (every string? (cadr x))))

;;; ưإ:tutcode-auto-help-bushu-decomposeǸ
;;; ˡǻȤ򡢥оʸɲä롣
;;; @param decomposed tutcode-auto-help-bushu-decompose
(define (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
  (if (not (null? decomposed))
    (begin
      (if (tutcode-rule-element? (car decomposed))
        (tutcode-stroke-help-guide-add-kanji pc (car decomposed))
        (tutcode-auto-help-bushu-composition-add-guide pc (car decomposed)))
      (tutcode-auto-help-bushu-composition-add-guide pc (cdr decomposed)))))

;;; ưإ:tutcode-auto-help-bushu-decomposeǸ
;;; ȥޤˡ顢
;;; ʸΤߤȴФˡ
;;; @param decomposed tutcode-auto-help-bushu-decompose
;;; @return ˡʸꥹ
(define (tutcode-auto-help-bushu-composition-strs decomposed)
  (tutcode-auto-help-bushu-composition-traverse decomposed ()
    (lambda (ele) (list (caadr ele))) "" ""))

;;; ưإ:tutcode-auto-help-bushu-decomposeθ̤Υĥ꡼¤顢
;;; ȴФեåȤʥꥹȤ
;;; @param decomposed tutcode-auto-help-bushu-decompose
;;; @param lst Υꥹ
;;; @param picker decomposed(tutcode-rule-element)
;;;   оǤȴФδؿ
;;; @param branch-str ޤ狼򼨤˷̥ꥹȤɲäʸ
;;; @param delim-str ζڤ򼨤˷̥ꥹȤɲäʸ
;;; @return Υꥹ
(define (tutcode-auto-help-bushu-composition-traverse decomposed lst picker
          branch-str delim-str)
  (if (null? decomposed)
    lst
    (let
      ((add
        (if (tutcode-rule-element? (car decomposed))
          (cons delim-str (picker (car decomposed)))
          (tutcode-auto-help-bushu-composition-traverse (car decomposed)
            (list branch-str) picker branch-str delim-str))))
      (tutcode-auto-help-bushu-composition-traverse (cdr decomposed)
        (append lst add) picker branch-str delim-str))))

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-kanji
          pc label-cands-alist kanji)
  (let*
    ((stime (time))
     (rule (rk-context-rule (tutcode-context-rk-context pc)))
     (stroke (tutcode-reverse-find-seq kanji rule)))
    (if stroke
      (begin
        (tutcode-stroke-help-guide-add-kanji
          pc (list (list stroke) (list kanji)))
        (tutcode-auto-help-update-stroke-alist-normal-with-stroke
          label-cands-alist
          (cons (string-append kanji " ") stroke)
          kanji))
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji rule stime)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (let*
            ((bushu-strs (tutcode-auto-help-bushu-composition-strs decomposed))
             (helpstrlist (append (list kanji "") bushu-strs))
             (helpstr (apply string-append helpstrlist))
             (bushu-stroke
              (tutcode-auto-help-bushu-composition-traverse decomposed ()
                caar "" " ")))
            (tutcode-auto-help-bushu-composition-add-guide pc decomposed)
            (tutcode-auto-help-update-stroke-alist-normal-with-stroke
              label-cands-alist
              (cons helpstr bushu-stroke)
              kanji)))))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param stroke оݥȥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-stroke label-cands-alist
         cand-list stroke)
  (if (or (null? cand-list) (null? stroke))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-with-stroke
      (tutcode-auto-help-update-stroke-alist-with-key
        label-cands-alist
        (if (pair? cand-list) (car cand-list) "")
        (car stroke))
      (cdr cand-list) (cdr stroke))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param stroke оݥȥ
;;; @param label ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-stroke
          label-cands-alist stroke label)
  (let ((label-cand (assoc label label-cands-alist)))
    (if (not label-cand)
      (cons (cons label (reverse stroke)) label-cands-alist))))

;;; ưإ:оݤΥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand إɽ˻Ȥоݥ򼨤ʸ
;;; @param key оݥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-key label-cands-alist
         cand key)
  (let*
    ((label key)
     (label-cand (assoc label label-cands-alist)))
    (if label-cand
      (begin
        (set-cdr! label-cand (cons cand (cdr label-cand)))
        label-cands-alist)
      (cons (list label cand) label-cands-alist))))

;;; ưإ:ľμưإפɽ
(define (tutcode-auto-help-redisplay pc)
  (let ((help (tutcode-context-auto-help pc)))
    (if (and help (> (length help) 0))
      (begin
        (tutcode-context-set-candidate-window! pc
          'tutcode-candidate-window-auto-help)
        (im-activate-candidate-selector pc
          (length help)
          tutcode-nr-candidate-max-for-kigou-mode)))))

;;; preeditɽ򹹿롣
(define (tutcode-do-update-preedit pc)
  (let ((stat (tutcode-context-state pc))
        (cpc (tutcode-context-child-context pc))
        (cursor-shown? #f))
    (case stat
      ((tutcode-state-yomi)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-code)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-converting)
        (im-pushback-preedit pc preedit-none "")
        (if (null? cpc)
          (begin
            (im-pushback-preedit pc preedit-none
              (tutcode-get-current-candidate pc))
            (let ((suffix (tutcode-context-mazegaki-suffix pc))) ; Ѹ
              (if (pair? suffix)
                (begin
                  (im-pushback-preedit pc preedit-cursor "")
                  (set! cursor-shown? #t)
                  (im-pushback-preedit pc preedit-none
                    (string-list-concat suffix))))))
          ;; child context's preedit
          (let ((h (string-list-concat (tutcode-context-head pc)))
                (editor (tutcode-context-editor pc))
                (dialog (tutcode-context-dialog pc)))
            (if (string? h)
              (im-pushback-preedit pc preedit-none h))
            (im-pushback-preedit pc preedit-none "")
            (im-pushback-preedit pc preedit-none
              (if (eq? (tutcode-context-child-type pc)
                    'tutcode-child-type-editor)
                (tutcode-editor-get-left-string editor)
                (tutcode-dialog-get-left-string dialog)))
            (tutcode-do-update-preedit cpc)
            (set! cursor-shown? #t)
            (im-pushback-preedit pc preedit-none
              (if (eq? (tutcode-context-child-type pc)
                    'tutcode-child-type-editor)
                (tutcode-editor-get-right-string editor)
                (tutcode-dialog-get-right-string dialog)))
            (im-pushback-preedit pc preedit-none ""))))
      ;; ѴΥޡʸȤheadǴ(ƵŪΤ)
      ((tutcode-state-bushu)
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-interactive-bushu)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (string-list-concat (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h)))
        (im-pushback-preedit pc preedit-cursor "")
        (set! cursor-shown? #t)
        (if (> (tutcode-lib-get-nr-predictions pc) 0)
          (begin
            (im-pushback-preedit pc preedit-underline "=>")
            (im-pushback-preedit pc preedit-underline
              (tutcode-get-prediction-string pc)))))
      ((tutcode-state-kigou)
        ;; 䥦ɥɽǤǤ褦preeditɽ
        (im-pushback-preedit pc preedit-reverse
          (tutcode-get-current-candidate-for-kigou-mode pc)))
      ((tutcode-state-history)
        (im-pushback-preedit pc preedit-none "")
        (im-pushback-preedit pc preedit-none
          (tutcode-get-current-candidate-for-history pc))))
    (if (not cursor-shown?)
      (im-pushback-preedit pc preedit-cursor ""))))

;;; preeditɽ򹹿롣
(define (tutcode-update-preedit pc)
  (im-clear-preedit pc)
  (tutcode-do-update-preedit (tutcode-find-root-context pc))
  (im-update-preedit pc))

;; called from tutcode-editor
;;; tutcode-editor¦ǤԽλ˸ƤФ롣
;;; @param str ǥ¦ǳꤵ줿ʸ
(define (tutcode-commit-editor-context pc str)
  (let ((yomi-len (tutcode-context-postfix-yomi-len pc))
        (suffix (tutcode-context-mazegaki-suffix pc)))
    (if (> yomi-len 0)
      (tutcode-postfix-delete-text pc yomi-len))
    (tutcode-flush pc)
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (tutcode-commit pc
      (if (null? suffix)
        str
        (string-append str (string-list-concat suffix))))
    (tutcode-update-preedit pc)))

;;; 䴰򸡺Ƹ䥦ɥɽ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
;;; @param num commit-strs鸡оݤˤʸ0ξơ
(define (tutcode-check-completion pc force-check? num)
  (tutcode-context-set-commit-strs-used-len! pc 0)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((commit-strs-all (tutcode-context-commit-strs pc))
           (commit-strs
            (if (> num 0)
              (take commit-strs-all num)
              commit-strs-all))
           (len (length commit-strs)))
      (if
        (or (>= len tutcode-completion-chars-min)
            (and force-check?
                 (> len 0)))
        (let ((str (string-list-concat commit-strs)))
          (tutcode-lib-set-prediction-src-string pc str #t)
          (let ((nr (tutcode-lib-get-nr-predictions pc)))
            (if (and nr (> nr 0))
              (let*
                ((nr-guide
                  (if tutcode-use-kanji-combination-guide?
                    (begin
                      (tutcode-guide-set-candidates pc str #t ())
                      (length (tutcode-context-guide pc)))
                    0))
                 (res (tutcode-prediction-calc-window-param nr nr-guide))
                 (nr-all (list-ref res 0)) ; (䴰+ϸ쥬)
                 (page-limit (list-ref res 1)) ; ڡ(䴰+ϸ)
                 (nr-in-page (list-ref res 2))) ; ڡ(䴰Τ)
                (if (> page-limit 0)
                  (begin
                    (tutcode-context-set-commit-strs-used-len! pc len)
                    (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                    (tutcode-context-set-prediction-page-limit! pc page-limit)
                    (tutcode-context-set-prediction-nr-all! pc nr-all)
                    (tutcode-context-set-prediction-index! pc 0)
                    (tutcode-context-set-candidate-window! pc
                      'tutcode-candidate-window-predicting)
                    (tutcode-context-set-predicting! pc
                      'tutcode-predicting-completion)
                    (im-activate-candidate-selector pc nr-all page-limit))))
              ;; 䴰䤬Ĥʤ硢1ʸäʸȤäƺƸ
              ;; (ľtutcode-context-set-commit-strs!ʸȡ
              ;;  ְäʸϤBackspaceǾäȤˡ
              ;;  Ϥʸ󤬺Ƥ뤿ᡢԤ䴰ˤʤʤ
              ;;  줢ꡣ®Ūˤϡľܺ®)
              (if (> len 1)
                (tutcode-check-completion pc force-check? (- len 1))))))))))

;;; 򤼽Ѵͽ¬ϸ򸡺Ƹ䥦ɥɽ
;;; @param force-check? ɬԤɤ
;;;  #fξʸ̤ξϸʤ
(define (tutcode-check-prediction pc force-check?)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((head (tutcode-context-head pc))
           (preedit-len (length head)))
      (if
        (or (>= preedit-len tutcode-prediction-start-char-count)
            force-check?)
        (let*
          ((preconv-str (string-list-concat head))
           (all-yomi (tutcode-lib-set-prediction-src-string pc preconv-str #f))
           (nr (tutcode-lib-get-nr-predictions pc)))
          (if (and nr (> nr 0))
            (let*
              ((nr-guide
                (if tutcode-use-kanji-combination-guide?
                  (begin
                    (tutcode-guide-set-candidates pc preconv-str #f all-yomi)
                    (length (tutcode-context-guide pc)))
                  0))
               (res (tutcode-prediction-calc-window-param nr nr-guide))
               (nr-all (list-ref res 0)) ; (ͽ¬+ϸ쥬)
               (page-limit (list-ref res 1)) ; ڡ(ͽ¬+ϸ)
               (nr-in-page (list-ref res 2))) ; ڡ(ͽ¬Τ)
              (if (> page-limit 0)
                (begin
                  (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                  (tutcode-context-set-prediction-page-limit! pc page-limit)
                  (tutcode-context-set-prediction-nr-all! pc nr-all)
                  (tutcode-context-set-prediction-index! pc 0)
                  (tutcode-context-set-candidate-window! pc
                    'tutcode-candidate-window-predicting)
                  (tutcode-context-set-predicting! pc
                    'tutcode-predicting-prediction)
                  (im-activate-candidate-selector pc nr-all page-limit))))))
        (tutcode-reset-candidate-window pc)))))

;;; Ѵͽ¬ϸ򸡺Ƹ䥦ɥɽ
;;; @param char Ϥ줿1
(define (tutcode-check-bushu-prediction pc char)
  (if (eq? (tutcode-context-predicting pc) 'tutcode-predicting-off)
    (let* ((res (tutcode-bushu-predict char tutcode-bushudic))
           (alt (assoc char tutcode-bushudic-altchar))
           (altres
            (if alt
              (tutcode-bushu-predict (cadr alt) tutcode-bushudic)
              ()))
           (resall (append res altres)))
      (tutcode-context-set-prediction-bushu! pc resall)
      (tutcode-bushu-prediction-show-page pc 0))))

;;; Ѵͽ¬ϸΤꤵ줿ֹ椫Ϥޤɽ롣
;;; @param start-index ֹ
(define (tutcode-bushu-prediction-show-page pc start-index)
  (tutcode-lib-set-bushu-prediction pc start-index)
  (let ((nr (tutcode-lib-get-nr-predictions pc)))
    (if (and nr (> nr 0))
      (let*
        ((nr-guide
          (if tutcode-use-kanji-combination-guide?
            (begin
              (tutcode-guide-set-candidates-for-bushu pc)
              (length (tutcode-context-guide pc)))
            0))
         (res (tutcode-prediction-calc-window-param nr nr-guide))
         (nr-all (list-ref res 0)) ; (ͽ¬+ϸ쥬)
         (page-limit (list-ref res 1)) ; ڡ(ͽ¬+ϸ)
         (nr-in-page (list-ref res 2))) ; ڡ(ͽ¬Τ)
        (if (> page-limit 0)
          (begin
            (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
            (tutcode-context-set-prediction-page-limit! pc page-limit)
            (tutcode-context-set-prediction-nr-all! pc nr-all)
            (tutcode-context-set-prediction-index! pc 0)
            (tutcode-context-set-candidate-window! pc
              'tutcode-candidate-window-predicting)
            (tutcode-context-set-predicting! pc 'tutcode-predicting-bushu)
            (im-activate-candidate-selector pc nr-all page-limit)))))))

;;; 䴰Ƚϸ쥬ɽΤcandwinѥѥ᡼׻
;;; @param nr 䴰
;;; @param nr-guide ϸ쥬ɸ
;;; @return (<> <ڡȤθ> <ڡȤ䴰>)
(define (tutcode-prediction-calc-window-param nr nr-guide)
  ;; XXX:ɽ䥦ɥdisplay_limitĴȡ׻˻Ȥ
  ;;     tutcode-nr-candidate-max-for-guideŬڤͤˤʤäƤʤ줢ꡣ
  (cond
    ;; 1ڡ˼ޤ
    ((and (<= nr-guide tutcode-nr-candidate-max-for-guide)
          (<= nr tutcode-nr-candidate-max-for-prediction))
      (list (+ nr-guide nr) (+ nr-guide nr) nr))
    ;; 䴰䤬1ڡ˼ޤʤ
    ((and (<= nr-guide tutcode-nr-candidate-max-for-guide)
          (> nr tutcode-nr-candidate-max-for-prediction))
      (if (= 0 tutcode-nr-candidate-max-for-prediction)
        (list nr-guide nr-guide 0) ; 䴰ɽʤ
        (let*
          ((nr-page
            ;; ڡϰˤʤݤʤΤǡ
            ;; ƥڡƱϸ쥬ɤɽ
            ;; ;Υڡˤɽʤ
            ;; (ƥڡǤindexnr-candidate-max-for-prediction̤
            ;;  䴰/ͽ¬ϸ䡢ʾθϸ쥬ɤȤưΤ
            ;;  ʤ䴰ʤ;ΥڡǤɽ)
            (quotient nr tutcode-nr-candidate-max-for-prediction))
           (page-limit (+ nr-guide tutcode-nr-candidate-max-for-prediction))
           (nr-all (+ nr (* nr-guide nr-page))))
          (list nr-all page-limit tutcode-nr-candidate-max-for-prediction))))
    ;; ϸ쥬ɤ1ڡ˼ޤʤ
    ((and (> nr-guide tutcode-nr-candidate-max-for-guide)
          (<= nr tutcode-nr-candidate-max-for-prediction))
      (if (= 0 tutcode-nr-candidate-max-for-guide)
        (list nr nr nr) ; ϸ쥬ɤɽʤ
        (let*
          ((nr-page
            (+ 
              (quotient nr-guide tutcode-nr-candidate-max-for-guide)
              (if (= 0 (remainder nr-guide tutcode-nr-candidate-max-for-guide))
                0
                1)))
           (page-limit (+ nr tutcode-nr-candidate-max-for-guide))
           (nr-all (+ nr-guide (* nr nr-page))))
          (list nr-all page-limit nr))))
    ;; 䴰Ƚϸ쥬ξȤ1ڡ˼ޤʤ
    (else
      (cond
        ;; ϸ쥬ɤΤɽ
        ((= 0 tutcode-nr-candidate-max-for-prediction)
          (list nr-guide tutcode-nr-candidate-max-for-guide 0))
        ;; 䴰Τɽ
        ((= 0 tutcode-nr-candidate-max-for-guide)
          (list nr tutcode-nr-candidate-max-for-prediction
            tutcode-nr-candidate-max-for-prediction))
        (else
          (let*
            ((nr-page-prediction
              (quotient nr tutcode-nr-candidate-max-for-prediction))
             (nr-page-guide
              (+
                (quotient nr-guide tutcode-nr-candidate-max-for-guide)
                (if (= 0 (remainder nr-guide tutcode-nr-candidate-max-for-guide))
                  0
                  1)))
             (nr-page (max nr-page-prediction nr-page-guide))
             (page-limit (+ tutcode-nr-candidate-max-for-guide
              tutcode-nr-candidate-max-for-prediction))
             (nr-all 
              (if (> nr-page-prediction nr-page-guide)
                (+ nr (* nr-page tutcode-nr-candidate-max-for-guide))
                (+ nr-guide (* nr-page tutcode-nr-candidate-max-for-prediction)))))
            (list nr-all page-limit tutcode-nr-candidate-max-for-prediction)))))))

;;; TUT-CodeϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-on c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     ;; reset-candidate-windowǥꥻåȤΤ¸Ƥ
     (completing?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-completion))
     ;; 䴰ɽΥڡưϡreset-candidate-window
     (prediction-keys-handled?
      (if completing?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          (else
            #f))
        #f)))
    (if (not prediction-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((and
            (tutcode-vi-escape-key? key key-state)
            tutcode-use-with-vi?)
           (rk-flush rkc)
           (tutcode-context-set-commit-strs! pc ())
           (tutcode-context-set-state! pc 'tutcode-state-off)
           (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
          ((tutcode-off-key? key key-state)
           (rk-flush rkc)
           (tutcode-context-set-commit-strs! pc ())
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((tutcode-on-key? key key-state) ; off-keyon-key̥ξ
           ;; onǤoffǤ⡢on-keyonˤʤΤcommit-raw
           (rk-flush rkc))
          ((tutcode-kigou-toggle-key? key key-state)
           (rk-flush rkc)
           (tutcode-begin-kigou-mode pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-flush rkc)
           (tutcode-toggle-kigou2-mode pc))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-kigou2-mode? pc)))
           (rk-flush rkc)
           (tutcode-context-kana-toggle pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
             (rk-flush rkc)
             (begin
               (tutcode-commit-raw pc key key-state)
               (if (and (or tutcode-use-completion?
                            tutcode-enable-fallback-surrounding-text?)
                        (pair? (tutcode-context-commit-strs pc)))
                 (tutcode-context-set-commit-strs! pc
                     (cdr (tutcode-context-commit-strs pc))))
               (if (and tutcode-use-completion?
                        completing?
                        (> tutcode-completion-chars-min 0))
                 (tutcode-check-completion pc #f 0)))))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((and tutcode-use-completion?
                (tutcode-begin-completion-key? key key-state))
           (rk-flush rkc)
           (if completing?
             ;; 䴰begin-completin-key줿оʸ1餷ƺ䴰
             ;; (տޤʤʸ䴰줿ˡ䴰ľǤ褦)
             ;; оݤ1ʸ̤ˤʤ䴰ɥĤ(ɽʤ)
             (let ((len (tutcode-context-commit-strs-used-len pc)))
               (if (> len 1)
                 (tutcode-check-completion pc #t (- len 1))))
             (tutcode-check-completion pc #t 0)))
          ((or
            (symbol? key)
            (and
              (modifier-key-mask key-state)
              (not (shift-key-mask key-state))))
           (rk-flush rkc)
           (tutcode-commit-raw pc key key-state))
          ;; 䴰ѥ٥륭?
          ((and completing? (tutcode-heading-label-char-for-prediction? key))
            (tutcode-commit-by-label-key-for-prediction pc
              (charcode->string key) 'tutcode-predicting-completion))
          ;; ʤ󥹤ƼΤƤ(tc2˹碌ư)
          ;; (rk-push-key!ȡޤǤΥ󥹤ϼΤƤ뤬
          ;; ְäϻĤäƤޤΤǡrk-push-key!ϻȤʤ)
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (rk-flush rkc) ; ʤ󥹤ϼΤƤ
             ;; ñȤΥ(TUT-CodeϤǤʤ)
             (tutcode-commit-raw pc key key-state)))
          (else
           (let ((res (tutcode-push-key! pc (charcode->string key))))
            (cond
              ((string? res)
                (tutcode-commit pc res #f (not (tutcode-kigou2-mode? pc)))
                (if (and tutcode-use-completion?
                         (> tutcode-completion-chars-min 0))
                  (tutcode-check-completion pc #f 0)))
              ((eq? res 'tutcode-mazegaki-start)
                (tutcode-context-set-latin-conv! pc #f)
                (tutcode-context-set-postfix-yomi-len! pc 0)
                (tutcode-context-set-state! pc 'tutcode-state-yomi))
              ((eq? res 'tutcode-latin-conv-start)
                (tutcode-context-set-latin-conv! pc #t)
                (tutcode-context-set-postfix-yomi-len! pc 0)
                (tutcode-context-set-state! pc 'tutcode-state-yomi))
              ((eq? res 'tutcode-kanji-code-input-start)
                (tutcode-context-set-state! pc 'tutcode-state-code))
              ((eq? res 'tutcode-bushu-start)
                (tutcode-context-set-state! pc 'tutcode-state-bushu)
                (tutcode-append-string pc ""))
              ((eq? res 'tutcode-interactive-bushu-start)
                (tutcode-context-set-prediction-nr! pc 0)
                (tutcode-context-set-state! pc
                  'tutcode-state-interactive-bushu))
              ((eq? res 'tutcode-postfix-bushu-start)
                (tutcode-begin-postfix-bushu-conversion pc))
              ((eq? res 'tutcode-postfix-mazegaki-start)
                (tutcode-begin-postfix-mazegaki-conversion pc #f #f #f))
              ((eq? res 'tutcode-postfix-mazegaki-1-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 1 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-2-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 2 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-3-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 3 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-4-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 4 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-5-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 5 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-6-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 6 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-7-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 7 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-8-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 8 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-9-start)
                (tutcode-begin-postfix-mazegaki-conversion pc 9 #t
                  tutcode-use-recursive-learning?))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc #f))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-1-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 1))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-2-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 2))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-3-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 3))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-4-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 4))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-5-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 5))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-6-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 6))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-7-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 7))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-8-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 8))
              ((eq? res 'tutcode-postfix-mazegaki-inflection-9-start)
                (tutcode-begin-postfix-mazegaki-inflection-conversion pc 9))
              ((eq? res 'tutcode-history-start)
                (tutcode-begin-history pc))
              ((eq? res 'tutcode-auto-help-redisplay)
                (tutcode-auto-help-redisplay pc))))))))))

;;; ַѴԤ
(define (tutcode-begin-postfix-bushu-conversion pc)
  (and-let*
    ((former-seq (tutcode-postfix-acquire-text pc 2))
     (res (and (>= (length former-seq) 2)
               (tutcode-bushu-convert (cadr former-seq) (car former-seq)))))
    (tutcode-postfix-delete-text pc 2)
    (tutcode-commit pc res)
    (tutcode-check-auto-help-window-begin pc (list res) ())))

;;; ַ򤼽Ѵ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @param autocommit? 䤬1Ĥξ˼ưŪ˳ꤹ뤫ɤ
;;;  (yomi-len#fǤʤͭ)
;;; @param recursive-learning? 䤬̵˺ƵϿ⡼ɤ뤫ɤ
;;;  (yomi-len#fǤʤͭ)
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-postfix-mazegaki-conversion pc yomi-len autocommit?
          recursive-learning?)
  (tutcode-context-set-mazegaki-yomi-len-specified! pc (or yomi-len 0))
  (let*
    ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len))
     (former-len (length former-seq)))
    (if yomi-len
      (and
        (>= former-len yomi-len)
        (let ((yomi (take former-seq yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (if (> yomi-len (length (tutcode-context-mazegaki-yomi-all pc)))
            (tutcode-context-set-mazegaki-yomi-all! pc yomi))
          (tutcode-begin-conversion pc yomi () autocommit? recursive-learning?)))
      ;; ɤߤʸꤵƤʤɤߤ̤ʤѴ
      (and
        (> former-len 0)
        (begin
          (tutcode-context-set-postfix-yomi-len! pc former-len)
          (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
          (tutcode-mazegaki-relimit-right pc former-seq #f))))))

;;; ɤߤ̤ʤ򤼽ѴԤ
;;; ѤʤȤƸƤ䤬Ĥʤϡ
;;; ѤȤƸߤ롣
;;; @param yomi Ѵоݤɤ(ʸεսꥹ)
;;; @param relimit-first? (ǽμ񸡺)ɤߤ̤
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-relimit-right pc yomi relimit-first?)
  (or
    (and
      (not relimit-first?)
      (tutcode-begin-conversion pc yomi () #f #f))
    ;; 䤬Ĥʤä
    (or
      (and
        (> (length yomi) 1)
        (> (tutcode-context-postfix-yomi-len pc) 0) ;ַξϲ⤷ʤ
        (begin ; ɤߤ1ʸ餷ƺƸ
          (tutcode-context-set-postfix-yomi-len! pc (- (length yomi) 1))
          (tutcode-mazegaki-relimit-right pc (drop-right yomi 1) #f)))
      (and tutcode-mazegaki-enable-inflection? ; Ѥθ˰ܹ
        (not (tutcode-mazegaki-inflection? yomi)) ; ŪϽʣʤ
        (let*
          ((len-specified (tutcode-context-mazegaki-yomi-len-specified pc))
           (len
            (if (> len-specified 0)
              len-specified
              (length (tutcode-context-mazegaki-yomi-all pc)))))
          (tutcode-mazegaki-inflection-relimit-right pc len len #f))))))

;;; ɤߤ򿭤Фʤַ򤼽ѴԤ
;;; @param yomi-len ɤߤĹ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-postfix-mazegaki-relimit-left pc yomi-len)
  (and
    (<= yomi-len tutcode-mazegaki-yomi-max)
    (let*
      ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
       (yomi-all-len (length yomi-all)))
      (if (<= yomi-len yomi-all-len)
        (let ((yomi (take yomi-all yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (or
            (tutcode-begin-conversion pc yomi () #f #f)
            (tutcode-postfix-mazegaki-relimit-left pc (+ yomi-len 1))))
        ;; Ѥɤߤ­ʤʤä硢¤yomi-maxĹɤߤ
        (and
          (< yomi-all-len tutcode-mazegaki-yomi-max)
          (let ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc
                             tutcode-mazegaki-yomi-max)))
            (and
              (> (length former-seq) yomi-all-len)
              (begin
                (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
                (tutcode-postfix-mazegaki-relimit-left pc yomi-len)))))))))

;;; ꤵ줿ɤߤѤ줫ɤ֤
;;; @param head оݤɤ
;;; @return #t:Ѥξ硣#f:ʳξ硣
(define (tutcode-mazegaki-inflection? head)
  (and
    (pair? head)
    (string=? "" (car head))))

;;; ѤȤƸַ򤼽Ѵ򳫻Ϥ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-begin-postfix-mazegaki-inflection-conversion pc yomi-len)
  (tutcode-context-set-mazegaki-yomi-len-specified! pc (or yomi-len 0))
  (let*
    ((former-seq (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len))
     (former-len (length former-seq)))
    (if yomi-len
      (and
        (>= former-len yomi-len)
        (let ((yomi (take former-seq yomi-len)))
          (tutcode-context-set-postfix-yomi-len! pc yomi-len)
          (tutcode-context-set-mazegaki-yomi-all! pc yomi)
          (if (tutcode-mazegaki-inflection? yomi)
            ;; Ū""դϤ줿硢ѤʤȤƸ
            ;; (ѤȤƼ갷ϡ""ΰ֤Ĵʤ
            ;;  ˤʤ뤬Ū˻ꤵƤϰĴ)
            (tutcode-begin-conversion pc yomi () #t
              tutcode-use-recursive-learning?)
            (tutcode-mazegaki-inflection-relimit-right pc
              yomi-len yomi-len #f))))
      ;; ɤߤʸꤵƤʤɤ/촴̤ʤѴ
      (and
        (> former-len 0)
        ;; 촴ĹΤͥ褷Ѵ
        (begin
          (tutcode-context-set-postfix-yomi-len! pc former-len)
          (tutcode-context-set-mazegaki-yomi-all! pc former-seq)
          (if (tutcode-mazegaki-inflection? former-seq) ; Ū""
            (tutcode-mazegaki-relimit-right pc former-seq #f)
            (tutcode-mazegaki-inflection-relimit-right pc
              former-len former-len #f)))))))

;;; Ѥθ򤼽ѴΤᡢ
;;; ɤ/촴̤ʤ顢촴ĹȤʤɤߤ򸫤ĤѴԤ
;;; @param yomi-cur-len yomi-allΤǸѴоݤȤʤäƤɤߤĹ
;;; @param len оݤȤ촴Ĺ
;;; @param relimit-first? (ǽμ񸡺)ɤߤ̤뤫ɤ
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-inflection-relimit-right pc yomi-cur-len len
          relimit-first?)
  (and
    (> len 0)
    (let*
      ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
       (len-specified (tutcode-context-mazegaki-yomi-len-specified pc)))
      (or
        ;; 촴Ĺ(len=length head)ݻޤޡɤߤ̤ʤ鸡
        (let loop
          ((yomi-cur (take yomi-all yomi-cur-len))
           (skip-search? relimit-first?))
          (let* ((yomi-len (length yomi-cur))
                 (suffix-len (- yomi-len len)))
            (and
              (>= suffix-len 0)
              (or
                (and
                  (not skip-search?)
                  (<= suffix-len tutcode-mazegaki-suffix-max)
                  (receive (suffix head) (split-at yomi-cur suffix-len)
                    (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
                      (tutcode-context-set-postfix-yomi-len! pc yomi-len))
                    (tutcode-begin-conversion pc (cons "" head) suffix #f #f)))
                (and
                  (= len-specified 0)
                  ;; ɤߤ1ʸ̤Ƹ
                  (loop (drop-right yomi-cur 1) #f))))))
        ;; 촴1ʸ̤Ƹ
        (tutcode-mazegaki-inflection-relimit-right pc
          (if (> len-specified 0)
            len-specified
            (length yomi-all))
          (- len 1) #f)))))

;;; Ѥθ򤼽ѴΤᡢ
;;; ɤ/촴򿭤Фʤ顢촴ĹȤʤɤߤ򸫤ĤѴԤ
;;; @param yomi-cur-len yomi-allΤǸѴоݤȤʤäƤɤߤĹ
;;; @param len оݤȤ촴Ĺ
;;; @param relimit-first? (ǽμ񸡺)ɤߤ򿭤Ф
;;; @return #t:䤬ͭä硣#f:䤬̵ä硣
(define (tutcode-mazegaki-inflection-relimit-left pc yomi-cur-len len
          relimit-first?)
  (let*
    ((yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (yomi-all-len (length yomi-all))
     (len-specified (tutcode-context-mazegaki-yomi-len-specified pc)))
    (or
      (and
        (<= len yomi-all-len)
        (or
          (let loop
            ((yomi-len yomi-cur-len)
             (skip-search? relimit-first?))
            ;; 촴Ĺ(len=length head)ݻޤɤߤ򿭤Фʤ鸡
            (and
              (<= len yomi-len yomi-all-len)
              (or
                (and
                  (not skip-search?)
                  (<= (- yomi-len len) tutcode-mazegaki-suffix-max)
                  (receive (suffix head)
                           (split-at (take yomi-all yomi-len) (- yomi-len len))
                    (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
                      (tutcode-context-set-postfix-yomi-len! pc yomi-len))
                    (tutcode-begin-conversion pc
                      (cons "" head) suffix #f #f)))
                ;; ɤߤ1ʸФƸ
                (and
                  (= len-specified 0)
                  (loop (+ yomi-len 1) #f)))))
          ;; 촴1ʸФƸ
          (tutcode-mazegaki-inflection-relimit-left pc
            (if (> len-specified 0)
              yomi-cur-len
              (+ len 1)) ; Ĺθ촴ƤɤߤκûĹ
            (+ len 1) #f)))
      ;; ˿ФϡѤʤθ˰ܹ
      (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
        (let ((len-new (if (> len-specified 0) len-specified 1)))
          (tutcode-postfix-mazegaki-relimit-left pc len-new))
        ;; ַ
        (tutcode-begin-conversion pc yomi-all () #f #f)))))

;;; 򤼽Ѵrelimit-rightϻνԤ:
;;; ɤ/촴̤ƺƸ
(define (tutcode-mazegaki-proc-relimit-right pc)
  (tutcode-reset-candidate-window pc)
  (let*
    ((head (tutcode-context-head pc))
     (head-len (length head))
     (postfix-yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (inflection?
      (and (tutcode-mazegaki-inflection? head)
           (not (tutcode-mazegaki-inflection? yomi-all)))) ; Ū""
     (found?
      (if (not inflection?)
        (tutcode-mazegaki-relimit-right pc head #t)
        (tutcode-mazegaki-inflection-relimit-right pc
          (+ (- head-len 1)
             (length (tutcode-context-mazegaki-suffix pc)))
          (- head-len 1) #t)))) ; (car head)""
    (if (not found?) ; ̵ɤ/촴̤Τ
      (tutcode-context-set-postfix-yomi-len! pc postfix-yomi-len))))

;;; 򤼽Ѵrelimit-leftϻνԤ:
;;; ɤ/촴򿭤ФƺƸ
(define (tutcode-mazegaki-proc-relimit-left pc)
  (tutcode-reset-candidate-window pc)
  (let*
    ((head (tutcode-context-head pc))
     (head-len (length head))
     (postfix-yomi-len (tutcode-context-postfix-yomi-len pc))
     (yomi-all (tutcode-context-mazegaki-yomi-all pc))
     (inflection?
      (and (tutcode-mazegaki-inflection? head)
           (not (tutcode-mazegaki-inflection? yomi-all)))) ; Ū""
     (found?
      (if (not inflection?)
        (and (> postfix-yomi-len 0) ; ַξɤߤ򿭤Ф
             (tutcode-postfix-mazegaki-relimit-left pc (+ head-len 1)))
        (tutcode-mazegaki-inflection-relimit-left pc
          (+ (- head-len 1)
             (length (tutcode-context-mazegaki-suffix pc)))
          (- head-len 1) #t)))) ; (car head)""
    (if (not found?) ; ̵ɤ/촴򿭤ФΤ
      (tutcode-context-set-postfix-yomi-len! pc postfix-yomi-len))))

;;; ַ򤼽ѴѤɤߤ
;;; @param yomi-len ꤵ줿ɤߤʸꤵƤʤ#f
;;; @return ɤ(ʸεսꥹ)
(define (tutcode-postfix-mazegaki-acquire-yomi pc yomi-len)
  (let ((former-seq (tutcode-postfix-acquire-text pc
                     (or yomi-len tutcode-mazegaki-yomi-max))))
    (if yomi-len
      ;; XXX:ɤߤʸꤵƤ""ޤ롣relimit-left
      ;;     ͳξ桼Ū˻ꤷΤȤߤʤƱͤ˴ޤ롣
      former-seq
      ;; ɤߤʸꤵƤʤǤʸ(yomi-max)
      (let*
        ;; ܸʸASCIIʸζܤСޤǤ
        ((ascii?
          (lambda (str)
            (let ((ch (string->ichar str)))
              (and ch (<= ch 127)))))
         (last-ascii? (and (pair? former-seq) (ascii? (car former-seq)))))
        (take-while
          (lambda (elem)
            (and
              (eq? (ascii? elem) last-ascii?)
              ;; """"ʸɤߤ˴ޤʤ
              (not (member elem tutcode-postfix-mazegaki-terminate-char-list))))
          former-seq)))))

;;; ʸ
;;; @param len ʸ
;;; @return ʸΥꥹ(ս)
(define (tutcode-postfix-acquire-text pc len)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-dialog)
        ()
        (let*
          ((ec (tutcode-context-editor ppc))
           (left-string (tutcode-editor-left-string ec)))
          (if (> (length left-string) len)
            (take left-string len)
            left-string)))
      (let*
        ((ustr (im-acquire-text pc 'primary 'cursor len 0))
         (former (and ustr (ustr-former-seq ustr)))
         (former-seq (and (pair? former) (string-to-list (car former)))))
        (if ustr
          (or former-seq ())
          ;; im-acquire-text̤бĶξ硢γʸХåե
          (if tutcode-enable-fallback-surrounding-text?
            (let ((commit-strs (tutcode-context-commit-strs pc)))
              (if (> (length commit-strs) len)
                (take commit-strs len)
                commit-strs))
            ()))))))

;;; ʸ
;;; @param len ʸ
(define (tutcode-postfix-delete-text pc len)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-editor)
        (let*
          ((ec (tutcode-context-editor ppc))
           (left-string (tutcode-editor-left-string ec)))
          (tutcode-editor-set-left-string! ec
            (if (> (length left-string) len)
              (drop left-string len)
              ()))))
      (or
        (im-delete-text pc 'primary 'cursor len 0)
        ;; im-delete-text̤бĶξ硢"\b"롣
        ;; XXX:"\b"ǧʸ륢ץǤʤưʤ
        ;; (tutcode-commit-rawϺѥ򤽤ΤޤޥץϤȤꤹ
        ;;  ΤʤΤǡʲΤ褦backspaceǸˤϻȤʤ
        ;;  (tutcode-commit-raw pc 'backspace 0))
        (and tutcode-enable-fallback-surrounding-text?
          (begin
            (let ((commit-strs (tutcode-context-commit-strs pc)))
              (tutcode-context-set-commit-strs! pc
                (if (> (length commit-strs) len)
                  (drop commit-strs len)
                  ())))
            (if (> (string-length tutcode-fallback-backspace-string) 0)
              (tutcode-commit pc
                (apply string-append
                  (make-list len tutcode-fallback-backspace-string))
                #t #t))))))))

;;; ľϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-off c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-on-key? key key-state)
        (tutcode-context-set-state! pc 'tutcode-state-on))
      ((tutcode-off-key? key key-state) ; on-keyoff-key̥ξ
        ) ; onǤoffǤ⡢off-keyoffˤʤΤcommit-raw
      (else
        (tutcode-commit-raw pc key key-state)))))

;;; ϥ⡼ɻΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-kigou c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((and
        (tutcode-vi-escape-key? key key-state)
        tutcode-use-with-vi?)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off)
       (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-on))
      ((tutcode-kigou2-toggle-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (if (not (tutcode-kigou2-mode? pc))
         (tutcode-toggle-kigou2-mode pc))
       (tutcode-context-set-state! pc 'tutcode-state-on))
      ;; ڡѥڡϲǽȤ뤿ᡢ
      ;; next-candidate-key?Υåheading-label-char?å
      ((and (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (tutcode-heading-label-char-for-kigou-mode? key))
        (tutcode-commit-by-label-key-for-kigou-mode pc (charcode->string key))
        (if (eq? (tutcode-context-candidate-window pc)
                 'tutcode-candidate-window-kigou)
          (im-select-candidate pc (tutcode-context-nth pc))))
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-begin-kigou-mode pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc
          tutcode-nr-candidate-max-for-kigou-mode))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc
          (- tutcode-nr-candidate-max-for-kigou-mode)))
      ((tutcode-commit-key? key key-state) ; return-keyϥץϤ
        (tutcode-commit pc (tutcode-prepare-commit-string-for-kigou-mode pc)))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
        (tutcode-commit-raw pc key key-state))
      (else
        (tutcode-commit-raw pc key key-state)))))

;;; ҥȥϥ⡼ɻΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-history c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc
          tutcode-nr-candidate-max-for-history))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc
          (- tutcode-nr-candidate-max-for-history)))
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((and (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (tutcode-heading-label-char-for-history? key))
        (tutcode-commit-by-label-key-for-history pc (charcode->string key)))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (let ((str (tutcode-prepare-commit-string-for-history pc)))
          (tutcode-commit pc str)
          (tutcode-flush pc)
          (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))
      (else
        (tutcode-commit pc (tutcode-prepare-commit-string-for-history pc))
        (tutcode-flush pc)
        (tutcode-proc-state-on pc key key-state)))))

;;; 򤼽ѴɤϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-yomi c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (head (tutcode-context-head pc))
     (kigou2-mode? (tutcode-kigou2-mode? pc))
     (res #f)
     ;; reset-candidate-windowǥꥻåȤΤ¸Ƥ
     (predicting?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-prediction))
     ;; ͽ¬ϸɽΥڡưϡreset-candidate-window
     (prediction-keys-handled?
      (if predicting?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          (else
            #f))
        #f)))
    (if (not prediction-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((tutcode-off-key? key key-state)
           (tutcode-flush pc)
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-context-latin-conv pc))
                (not kigou2-mode?))
           (rk-flush rkc)
           (tutcode-context-kana-toggle pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-flush rkc)
           (tutcode-toggle-kigou2-mode pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
            (rk-flush rkc)
            (if (> (length head) 0)
              (begin
                (tutcode-context-set-head! pc (cdr head))
                (if (and predicting? (> tutcode-prediction-start-char-count 0))
                  (tutcode-check-prediction pc #f))))))
          ((or
            (tutcode-commit-key? key key-state)
            (tutcode-return-key? key key-state))
           (tutcode-commit pc (string-list-concat head))
           (tutcode-flush pc))
          ((tutcode-cancel-key? key key-state)
           (tutcode-flush pc))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((and tutcode-use-prediction?
                (tutcode-begin-completion-key? key key-state))
           (rk-flush rkc)
           (if (not predicting?)
             (tutcode-check-prediction pc #t)))
          ;; 1Ĥξ硢Ѵ弫ưꤵconverting⡼ɤʤ
          ;; ΤǡξǤpurgeǤ褦ˡǥå
          ((and (tutcode-purge-candidate-key? key key-state)
                (not (null? head))
                (not kigou2-mode?))
           ;; converting⡼ɤ˰ܹԤƤpurge
           (tutcode-begin-conversion pc head () #f #f)
           (if (eq? (tutcode-context-state pc) 'tutcode-state-converting)
             (tutcode-proc-state-converting pc key key-state)))
          ((and (tutcode-register-candidate-key? key key-state)
                tutcode-use-recursive-learning?
                (not kigou2-mode?))
           (tutcode-context-set-state! pc 'tutcode-state-converting)
           (tutcode-setup-child-context pc 'tutcode-child-type-editor))
          ((tutcode-katakana-commit-key? key key-state)
            (tutcode-commit pc
              ;;XXX:ʥʺ߻ȿž(ʤ)䡢֤פ̤б
              (ja-make-kana-str (ja-make-kana-str-list head)
                (if (tutcode-context-katakana-mode? pc)
                  ja-type-hiragana
                  ja-type-katakana)))
            (tutcode-flush pc))
          ((symbol? key)
           (tutcode-flush pc)
           (tutcode-proc-state-on pc key key-state))
          ((and
            (modifier-key-mask key-state)
            (not (shift-key-mask key-state)))
           ;; <Control>nǤѴ?
           (if (tutcode-begin-conv-key? key key-state)
             (if (not (null? head))
               (tutcode-begin-conversion-with-inflection pc #t)
               (tutcode-flush pc))
             (begin
               (tutcode-flush pc)
               (tutcode-proc-state-on pc key key-state))))
          ;; ͽ¬ϸѥ٥륭?
          ((and predicting? (tutcode-heading-label-char-for-prediction? key))
            (tutcode-commit-by-label-key-for-prediction pc
              (charcode->string key) 'tutcode-predicting-prediction))
          ((tutcode-context-latin-conv pc)
           (if (tutcode-begin-conv-key? key key-state) ; spaceǤѴ?
             (if (not (null? head))
               (tutcode-begin-conversion-with-inflection pc #t)
               (tutcode-flush pc))
             (set! res (charcode->string key))))
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (rk-flush rkc)
             ;; spaceǤѴ?
             ;; (spaceϥ󥹤˴ޤޤ礬Τǡ
             ;;  rk-expectspace̵Ȥ)
             ;; (trycodespaceǻϤޤ륭󥹤ȤäƤ硢
             ;;  spaceѴϤϤǤʤΤǡ<Control>nȤɬפ)
             (if (tutcode-begin-conv-key? key key-state)
               (if (not (null? head))
                 (tutcode-begin-conversion-with-inflection pc #t)
                 (tutcode-flush pc))
               (set! res (charcode->string key)))))
          (else
           (set! res (tutcode-push-key! pc (charcode->string key)))
           (cond
            ((eq? res 'tutcode-auto-help-redisplay)
              (tutcode-auto-help-redisplay pc)
              (set! res #f))
            ((eq? res 'tutcode-postfix-bushu-start)
              (set! res
                (and (>= (length head) 2)
                     (tutcode-bushu-convert (cadr head) (car head))))
              (if res
                (begin
                  (tutcode-context-set-head! pc (cddr head))
                  (tutcode-check-auto-help-window-begin pc (list res) ()))))
            ;; ѤʤȤѴϡ䤬1Ĥξϼư
            ((eq? res 'tutcode-postfix-mazegaki-start)
              (set! res #f)
              (if (not (null? head))
                (tutcode-begin-conversion-with-inflection pc #f)
                (begin
                  (tutcode-flush pc)
                  (tutcode-begin-postfix-mazegaki-conversion pc #f #f #f))))
            ;; ѤȤѴ(postfixѥ󥹤ή)
            ((eq? res 'tutcode-postfix-mazegaki-inflection-start)
              (set! res #f)
              (if (not (null? head))
                (tutcode-begin-mazegaki-inflection-conversion pc)
                (begin
                  (tutcode-flush pc)
                  (tutcode-begin-postfix-mazegaki-inflection-conversion pc #f))))
            ((symbol? res)
              (set! res #f)))))
        (if res
          (begin
            (tutcode-append-string pc res)
            (if (and tutcode-use-prediction?
                     (> tutcode-prediction-start-char-count 0)
                     ;; ַѴˤauto-helpɽѻϲ⤷ʤ
                     (eq? (tutcode-context-candidate-window pc)
                          'tutcode-candidate-window-off))
              (tutcode-check-prediction pc #f))))))))

;;; Ͼ֤ΤȤΥϤ롣
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-code c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (head (tutcode-context-head pc))
     (res #f))
    (cond
      ((and tutcode-use-with-vi?
            (tutcode-vi-escape-key? key key-state))
        (tutcode-flush pc)
        (tutcode-context-set-state! pc 'tutcode-state-off)
        (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
        (tutcode-flush pc)
        (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
        (tutcode-flush pc)
        (tutcode-begin-kigou-mode pc))
      ((tutcode-kigou2-toggle-key? key key-state)
        (tutcode-flush pc)
        (if (not (tutcode-kigou2-mode? pc))
          (tutcode-toggle-kigou2-mode pc)))
      ((tutcode-backspace-key? key key-state)
        (if (pair? head)
          (tutcode-context-set-head! pc (cdr head))))
      ((tutcode-cancel-key? key key-state)
        (tutcode-flush pc))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (tutcode-commit pc (string-list-concat head))
        (tutcode-flush pc))
      ((symbol? key)
        (tutcode-flush pc)
        (tutcode-proc-state-on pc key key-state))
      ((and (modifier-key-mask key-state)
            (not (shift-key-mask key-state)))
        (if (tutcode-begin-conv-key? key key-state) ; <Control>nǤѴ?
          (if (pair? head)
            (tutcode-begin-kanji-code-input pc head)
            (tutcode-flush pc))
          (begin
            (tutcode-flush pc)
            (tutcode-proc-state-on pc key key-state))))
      ((tutcode-begin-conv-key? key key-state) ; spaceǤѴ?
        (if (pair? head)
          (tutcode-begin-kanji-code-input pc head)
          (tutcode-flush pc)))
      (else
        (tutcode-append-string pc (charcode->string key))))))

;;; ѴϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-bushu c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (res #f)
     (predicting?
      (eq? (tutcode-context-predicting pc) 'tutcode-predicting-bushu)))
    (tutcode-reset-candidate-window pc)
    (cond
      ((tutcode-off-key? key key-state)
       (tutcode-flush pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((and (tutcode-kana-toggle-key? key key-state)
            (not (tutcode-kigou2-mode? pc)))
       (rk-flush rkc)
       (tutcode-context-kana-toggle pc))
      ((tutcode-kigou2-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-toggle-kigou2-mode pc))
      ((tutcode-backspace-key? key key-state)
       (if (> (length (rk-context-seq rkc)) 0)
        (rk-flush rkc)
        ;; head1ʸܤѴΥޡbackspaceǤϾäʤ褦
        ;; 롣ְäƳѤʸäʤ褦ˤ뤿ᡣ
        (if (> (length (tutcode-context-head pc)) 1)
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
        ;; ƵŪѴ(ꤷ)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
          (set! res #f))
        (if (= (length (tutcode-context-head pc)) 0)
          (begin
            ;; Ǿ̤Ѵξ硢Ѵ󤬤commit
            (if res
              (tutcode-commit pc res))
            (tutcode-flush pc)
            (if res (tutcode-check-auto-help-window-begin pc (list res) ()))
            (set! res #f))))
      ((tutcode-cancel-key? key key-state)
        ;; ƵŪѴ(󥻥뤷)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))
        (set! res #f)
        (if (= (length (tutcode-context-head pc)) 0)
          (tutcode-flush pc)))
      ((tutcode-stroke-help-toggle-key? key key-state)
       (tutcode-toggle-stroke-help pc))
      ((and predicting? (tutcode-next-page-key? key key-state))
       (tutcode-change-bushu-prediction-page pc #t))
      ((and predicting? (tutcode-prev-page-key? key key-state))
       (tutcode-change-bushu-prediction-page pc #f))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
       (tutcode-flush pc)
       (tutcode-proc-state-on pc key key-state))
      ;; ͽ¬ϸѥ٥륭?
      ((and predicting? (tutcode-heading-label-char-for-prediction? key))
        (tutcode-commit-by-label-key-for-prediction pc
          (charcode->string key) 'tutcode-predicting-bushu))
      ((not (rk-expect-key? rkc (charcode->string key)))
       (if (> (length (rk-context-seq rkc)) 0)
         (rk-flush rkc)
         (set! res (charcode->string key))))
      (else
       (set! res (tutcode-push-key! pc (charcode->string key)))
       (cond
        ((eq? res 'tutcode-bushu-start) ; ƵŪѴ
          (tutcode-append-string pc "")
          (set! res #f))
        ((eq? res 'tutcode-auto-help-redisplay)
          (tutcode-auto-help-redisplay pc)
          (set! res #f))
        ((symbol? res) ;XXX Ѵϸ򤼽Ѵ̵ˤ
          (set! res #f)))))
    (if res
      (tutcode-begin-bushu-conversion pc res))))

;;; Ѵ
;;; @param char Ϥ줿ʸ(2ܤ)
(define (tutcode-begin-bushu-conversion pc char)
  (let ((prevchar (car (tutcode-context-head pc))))
    (if (string=? prevchar "")
      (begin
        (tutcode-append-string pc char)
        (if tutcode-use-bushu-prediction?
          (tutcode-check-bushu-prediction pc char)))
      ;; ľʸޡǤʤ2ʸܤϤ줿Ѵ
      (let ((convchar (tutcode-bushu-convert prevchar char)))
        (if (string? convchar)
          ;; 
          (tutcode-bushu-commit pc convchar)
          ;; ԻϤľԤ
          )))))

;;; ѴѴʸꤹ
;;; @param convchar Ѵʸ
(define (tutcode-bushu-commit pc convchar)
  ;; 1ܤȢä
  (tutcode-context-set-head! pc (cddr (tutcode-context-head pc)))
  (if (null? (tutcode-context-head pc))
    ;; ѴԤ󤬻ĤäƤʤСꤷƽλ
    (begin
      (tutcode-commit pc convchar)
      (tutcode-flush pc)
      (tutcode-check-auto-help-window-begin pc (list convchar) ()))
    ;; 󤬤ޤĤäƤСƳǧ
    ;; (ʸ2ʸܤʤСϢ³Ѵ)
    (tutcode-begin-bushu-conversion pc convchar)))

;;; ŪѴΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-interactive-bushu c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc))
     (head (tutcode-context-head pc))
     (res #f)
     (has-candidate? (> (tutcode-context-prediction-nr pc) 0))
     ;; ɽΥڡưϡreset-candidate-window
     (candidate-selection-keys-handled?
      (if has-candidate?
        (cond
          ((tutcode-next-page-key? key key-state)
            (tutcode-change-prediction-page pc #t)
            #t)
          ((tutcode-prev-page-key? key key-state)
            (tutcode-change-prediction-page pc #f)
            #t)
          ((and (tutcode-next-candidate-key? key key-state)
                ;; 2ǸܤΥڡξϸǤϤʤ
                (= (length (rk-context-seq rkc)) 0))
            (tutcode-change-prediction-index pc 1)
            #t)
          ((tutcode-prev-candidate-key? key key-state)
            (tutcode-change-prediction-index pc -1)
            #t)
          (else
            #f))
        #f)))
    (if (not candidate-selection-keys-handled?)
      (begin
        (tutcode-reset-candidate-window pc)
        (cond
          ((tutcode-off-key? key key-state)
           (tutcode-flush pc)
           (tutcode-context-set-state! pc 'tutcode-state-off))
          ((and (tutcode-kana-toggle-key? key key-state)
                (not (tutcode-kigou2-mode? pc)))
           (rk-flush rkc)
           (tutcode-context-kana-toggle pc))
          ((tutcode-kigou2-toggle-key? key key-state)
           (rk-flush rkc)
           (tutcode-toggle-kigou2-mode pc))
          ((tutcode-backspace-key? key key-state)
           (if (> (length (rk-context-seq rkc)) 0)
            (rk-flush rkc)
            (if (> (length head) 0)
              (begin
                (tutcode-context-set-head! pc (cdr head))
                (if has-candidate?
                  (tutcode-begin-interactive-bushu-conversion pc))))))
          ((or
            (tutcode-commit-key? key key-state)
            (tutcode-return-key? key key-state))
           (let ((str
                  (cond
                    (has-candidate?
                      (tutcode-get-prediction-string pc))
                    ((> (length head) 0)
                      (string-list-concat (tutcode-context-head pc)))
                    (else
                      #f))))
             (if str (tutcode-commit pc str))
             (tutcode-flush pc)
             (if str (tutcode-check-auto-help-window-begin pc (list str) ()))))
          ((tutcode-cancel-key? key key-state)
           (tutcode-flush pc))
          ((tutcode-stroke-help-toggle-key? key key-state)
           (tutcode-toggle-stroke-help pc))
          ((or
            (symbol? key)
            (and
              (modifier-key-mask key-state)
              (not (shift-key-mask key-state))))
           (tutcode-flush pc)
           (tutcode-proc-state-on pc key key-state))
          ((and (tutcode-heading-label-char-for-prediction? key)
                (= (length (rk-context-seq rkc)) 0))
            (tutcode-commit-by-label-key-for-prediction pc
              (charcode->string key) 'tutcode-predicting-interactive-bushu))
          ((not (rk-expect-key? rkc (charcode->string key)))
           (if (> (length (rk-context-seq rkc)) 0)
             (rk-flush rkc)
             (set! res (charcode->string key))))
          (else
           (set! res (tutcode-push-key! pc (charcode->string key)))
           (cond
            ((eq? res 'tutcode-auto-help-redisplay)
              (tutcode-auto-help-redisplay pc)
              (set! res #f))
            ((symbol? res) ;XXX Ѵϸ򤼽Ѵ̵ˤ
              (set! res #f)))))
        (if res
          (begin
            (tutcode-append-string pc res)
            (tutcode-begin-interactive-bushu-conversion pc)))))))

;;; ŪѴ
(define (tutcode-begin-interactive-bushu-conversion pc)
  (let*
    ((head (tutcode-context-head pc))
     (res
      (if (null? head)
        ()
        (tutcode-bushu-compose-interactively (reverse head)))))
    (cond
      ;; BSʸä줿硢preeditθänr0
      ((null? head)
        (tutcode-context-set-prediction-nr! pc 0)
        (tutcode-context-set-prediction-candidates! pc ()))
      ;; ʸäǽʸ
      ((null? res)
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (> (tutcode-context-prediction-nr pc) 0)
          (begin
            (tutcode-context-set-candidate-window! pc
              'tutcode-candidate-window-interactive-bushu)
            (im-activate-candidate-selector pc
              (tutcode-context-prediction-nr-all pc)
              (tutcode-context-prediction-page-limit pc)))))
      (else
        (let ((nr (length res)))
          (tutcode-context-set-prediction-word! pc ())
          (tutcode-context-set-prediction-candidates! pc res)
          (tutcode-context-set-prediction-appendix! pc ())
          (tutcode-context-set-prediction-nr! pc nr)
          (tutcode-context-set-prediction-index! pc 0)
          (let*
            ((params (tutcode-prediction-calc-window-param nr 0))
             (nr-all (list-ref params 0)) ; 
             (page-limit (list-ref params 1)) ; ڡ
             (nr-in-page (list-ref params 2))) ; ڡ
            (if (> page-limit 0)
              (begin
                ;; ͽ¬ϸѿή
                (tutcode-context-set-prediction-nr-in-page! pc nr-in-page)
                (tutcode-context-set-prediction-page-limit! pc page-limit)
                (tutcode-context-set-prediction-nr-all! pc nr-all)
                (tutcode-context-set-candidate-window! pc
                  'tutcode-candidate-window-interactive-bushu)
                (im-activate-candidate-selector pc nr-all page-limit)))))))))

;;; 򤹤
;;; @param pc ƥȥꥹ
;;; @param num ߤθֹ椫鿷ֹޤǤΥեå
(define (tutcode-change-candidate-index pc num)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (new-nth (+ nth num)))
    (cond
      ((< new-nth 0)
       (set! new-nth 0))
      ((and tutcode-use-recursive-learning?
            (eq? (tutcode-context-state pc) 'tutcode-state-converting)
            (= nth (- nr 1))
            (>= new-nth nr))
       (tutcode-reset-candidate-window pc)
       (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((>= new-nth nr)
       (set! new-nth (- nr 1))))
    (tutcode-context-set-nth! pc new-nth))
  (if (null? (tutcode-context-child-context pc))
    (begin
      (tutcode-check-candidate-window-begin pc)
      (if (not (eq? (tutcode-context-candidate-window pc)
                    'tutcode-candidate-window-off))
        (im-select-candidate pc (tutcode-context-nth pc))))))

;;; 䴰/ͽ¬ϸ򤹤
;;; @param num ߤθֹ椫鿷ֹޤǤΥեå
(define (tutcode-change-prediction-index pc num)
  (let* ((nr-all (tutcode-context-prediction-nr-all pc))
         (idx (tutcode-context-prediction-index pc))
         (n (+ idx num))
         (compensated-n
          (cond
           ((>= n nr-all) (- nr-all 1))
           ((< n 0) 0)
           (else n))))
    (tutcode-context-set-prediction-index! pc compensated-n)
    (im-select-candidate pc compensated-n)))

;;; /ڡ䴰/ͽ¬ϸɽ
;;; @param next? #t:ڡ, #f:ڡ
(define (tutcode-change-prediction-page pc next?)
  (let ((page-limit (tutcode-context-prediction-page-limit pc)))
    (tutcode-change-prediction-index pc (if next? page-limit (- page-limit)))))

;;; /ڡѴͽ¬ϸɽ
;;; @param next? #t:ڡ, #f:ڡ
(define (tutcode-change-bushu-prediction-page pc next?)
  (let* ((idx (tutcode-context-prediction-bushu-page-start pc))
         (n (+ idx
              (if next?
                tutcode-nr-candidate-max-for-prediction
                (- tutcode-nr-candidate-max-for-prediction)))))
    (tutcode-bushu-prediction-show-page pc n)))

;;; 䥦ɥĤ
(define (tutcode-reset-candidate-window pc)
  (if (not (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off))
    (begin
      (im-deactivate-candidate-selector pc)
      (tutcode-context-set-candidate-window! pc 'tutcode-candidate-window-off)
      (tutcode-context-set-predicting! pc 'tutcode-predicting-off))))

;;; 򤼽Ѵθ֤顢ɤϾ֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-yomi-state pc)
  (if (> (tutcode-context-postfix-yomi-len pc) 0) ; ַ?
    (tutcode-flush pc)
    (begin
      (tutcode-reset-candidate-window pc)
      (tutcode-context-set-state! pc 'tutcode-state-yomi)
      (tutcode-context-set-head! pc (tutcode-context-mazegaki-yomi-all pc))
      (tutcode-context-set-nr-candidates! pc 0))))

;;; 򤼽ѴμϿ֤顢֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-converting-state pc)
  (tutcode-context-set-nth! pc (- (tutcode-context-nr-candidates pc) 1))
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-converting)
    (im-select-candidate pc (tutcode-context-nth pc)))
  (tutcode-context-set-state! pc 'tutcode-state-converting))

;;; Ϥ줿٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char? key)
  (member (charcode->string key) tutcode-heading-label-char-list))

;;; Ϥ줿ϥ⡼ɻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-kigou-mode? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-kigou-mode))

;;; Ϥ줿ҥȥϥ⡼ɻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-history? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-history))

;;; Ϥ줿䴰/ͽ¬ϻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-prediction? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-prediction))

;;; 򤼽Ѵθ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-converting c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-back-to-yomi-state pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc tutcode-nr-candidate-max))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc (- tutcode-nr-candidate-max)))
      ((or (tutcode-commit-key? key key-state)
           (tutcode-return-key? key key-state))
        (tutcode-commit-with-auto-help pc))
      ((tutcode-purge-candidate-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-dialog))
      ((and (tutcode-register-candidate-key? key key-state)
            tutcode-use-recursive-learning?)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((tutcode-mazegaki-relimit-right-key? key key-state)
        (tutcode-mazegaki-proc-relimit-right pc))
      ((tutcode-mazegaki-relimit-left-key? key key-state)
        (tutcode-mazegaki-proc-relimit-left pc))
      ((and tutcode-commit-candidate-by-label-key?
            (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (> (tutcode-context-nr-candidates pc) 1)
            (tutcode-heading-label-char? key))
        (tutcode-commit-by-label-key pc (charcode->string key)))
      (else
        (let ((postfix-yomi-len (tutcode-context-postfix-yomi-len pc)))
          (if (> postfix-yomi-len 0)
            (tutcode-postfix-delete-text pc postfix-yomi-len)))
        (tutcode-commit pc (tutcode-prepare-commit-string pc))
        (tutcode-proc-state-on pc key key-state)))))

;;; ѴԤ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-convert c1 c2)
  (if (null? tutcode-bushu-help)
    (set! tutcode-bushu-help (tutcode-bushu-help-load)))
  ;; tc-2.1+[tcode-ml:1925]르ꥺ
  (and c1 c2
    (or
      (and tutcode-bushu-help (tutcode-bushu-compose c1 c2 tutcode-bushu-help))
      (tutcode-bushu-compose-sub c1 c2)
      (let ((a1 (tutcode-bushu-alternative c1))
            (a2 (tutcode-bushu-alternative c2)))
        (and
          (or
            (not (string=? a1 c1))
            (not (string=? a2 c2)))
          (begin
            (set! c1 a1)
            (set! c2 a2)
            #t)
          (tutcode-bushu-compose-sub c1 c2)))
      (let* ((decomposed1 (tutcode-bushu-decompose c1))
             (decomposed2 (tutcode-bushu-decompose c2))
             (tc11 (and decomposed1 (car decomposed1)))
             (tc12 (and decomposed1 (cadr decomposed1)))
             (tc21 (and decomposed2 (car decomposed2)))
             (tc22 (and decomposed2 (cadr decomposed2)))
             ;; ʸ2ĤȤϰۤʤ
             ;; ʸǤ뤳Ȥǧ롣
             ;; (string=?#fäȤ˥顼ˤʤΤequal?)
             (newchar
                (lambda (new)
                  (and
                    (not (equal? new c1))
                    (not (equal? new c2))
                    new))))
        (or
          ;; 
          (and
            (equal? tc11 c2)
            (newchar tc12))
          (and
            (equal? tc12 c2)
            (newchar tc11))
          (and
            (equal? tc21 c1)
            (newchar tc22))
          (and
            (equal? tc22 c1)
            (newchar tc21))
          ;; ʤˤ­
          (let ((compose-newchar
                  (lambda (i1 i2)
                    (let ((res (tutcode-bushu-compose-sub i1 i2)))
                      (and res
                        (newchar res))))))
            (or
              (compose-newchar c1 tc22) (compose-newchar tc11 c2)
              (compose-newchar c1 tc21) (compose-newchar tc12 c2)
              (compose-newchar tc11 tc22) (compose-newchar tc11 tc21)
              (compose-newchar tc12 tc22) (compose-newchar tc12 tc21)))
          ;; ʤˤ
          (and tc11
            (equal? tc11 tc21)
            (newchar tc12))
          (and tc11
            (equal? tc11 tc22)
            (newchar tc12))
          (and tc12
            (equal? tc12 tc21)
            (newchar tc11))
          (and tc12
            (equal? tc12 tc22)
            (newchar tc11)))))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; ꤵ줿֤ǸĤʤäϡ֤줫õ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose-sub c1 c2)
  (and c1 c2
    (or
      (tutcode-bushu-compose c1 c2 tutcode-bushudic)
      (tutcode-bushu-compose c2 c1 tutcode-bushudic))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose c1 c2 bushudic)
  (let ((seq (rk-lib-find-seq (list c1 c2) bushudic)))
    (and seq
      (car (cadr seq)))))

;;; Ѵ:ʸõ֤
;;; @param c оݤʸ
;;; @return ʸʸĤʤäȤϸʸ
(define (tutcode-bushu-alternative c)
  (let ((alt (assoc c tutcode-bushudic-altchar)))
    (or
      (and alt (cadr alt))
      c)))

;;; Ѵ:ʸ2Ĥʬ򤹤롣
;;; @param c ʬоݤʸ
;;; @return ʬ򤷤ƤǤ2ĤΥꥹȡʬǤʤäȤ#f
(define (tutcode-bushu-decompose c)
  (if (null? tutcode-reverse-bushudic-alist)
    (set! tutcode-reverse-bushudic-alist
      (map
        (lambda (elem)
          (cons (caadr elem) (caar elem)))
        tutcode-bushudic)))
  (let ((res (assoc c tutcode-reverse-bushudic-alist)))
    (and res
      (cdr res))))

;;; ưإ:bushu.helpե򸡺оʸΥإ(2Ĥ)
;;; @param c оʸ
;;; @return إפɽ(2ĤΥꥹ)Ĥʤä#f
(define (tutcode-bushu-help-lookup c)
  (and (not (string=? tutcode-bushu-help-filename "")) ; ǥեȤ""
    (let*
      ((looked (tutcode-bushu-search c tutcode-bushu-help-filename))
       (lst (and looked (tutcode-bushu-parse-entry looked))))
      (and lst
        (>= (length lst) 2)
        (take lst 2)))))

;;; ưإ:оʸΤɬפȤʤ롢
;;; Ǥʤ2ĤʸΥꥹȤ֤
;;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @param stime 
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose c rule stime)
  (if (> (string->number (difftime (time) stime)) tutcode-auto-help-time-limit)
    #f
    (let*
      ((bushu (or (tutcode-bushu-help-lookup c)
                  (tutcode-bushu-decompose c)))
       (b1 (and bushu (car bushu)))
       (b2 (and bushu (cadr bushu)))
       (seq1 (and b1 (tutcode-auto-help-get-stroke b1 rule)))
       (seq2 (and b2 (tutcode-auto-help-get-stroke b2 rule))))
      (or
        ;; ­ˤ
        (and seq1 seq2
          (list seq1 seq2))
        ;; ñʰˤ
        (tutcode-auto-help-bushu-decompose-by-subtraction c rule)
        ;; ʤˤ
        (or
          ;; 1ľϲǽ
          ;; (1)(2ʤȤƻĴ)ˤǽ?
          (and seq1 b2
            (or
              (tutcode-auto-help-bushu-decompose-looking-bushudic
                tutcode-bushudic () 99
                (lambda (elem)
                  (tutcode-auto-help-get-stroke-list-with-right-part
                    c b1 b2 seq1 rule elem)))
              ;; 2ǤϹǽ2򤵤ʬ
              (let ((b2dec (tutcode-auto-help-bushu-decompose b2 rule stime)))
                (and b2dec
                  (list seq1 b2dec)))))
          ;; 2ľϲǽ
          ;; (2)(1ʤȤƻĴ)ˤǽ?
          (and seq2 b1
            (or
              (tutcode-auto-help-bushu-decompose-looking-bushudic
                tutcode-bushudic () 99
                (lambda (elem)
                  (tutcode-auto-help-get-stroke-list-with-left-part
                    c b1 b2 seq2 rule elem)))
              ;; 1ǤϹǽ1򤵤ʬ
              (let ((b1dec (tutcode-auto-help-bushu-decompose b1 rule stime)))
                (and b1dec
                  (list b1dec seq2)))))
          ;; 12ľԲĢʬ
          (and b1 b2
            (let
              ((b1dec (tutcode-auto-help-bushu-decompose b1 rule stime))
               (b2dec (tutcode-auto-help-bushu-decompose b2 rule stime)))
              (and b1dec b2dec
                (list b1dec b2dec))))
          ;; XXX: ʤɤι̤б
          )))))

;;; ưإ:оʸϤݤǸΥꥹȤ롣
;;; : "" => ((("," "o")) (""))
;;; @param b оʸ
;;; @param rule tutcode-rule
;;; @return ǸꥹȡԲǽʾ#f
(define (tutcode-auto-help-get-stroke b rule)
  (let
    ((seq
      (or (tutcode-reverse-find-seq b rule)
          ;; ǻȤ"3"Τ褦ľϲǽб뤿ᡢ
          ;; ٥ʸ˴ޤޤƤСľϲǽȤߤʤ
          (and
            (member b tutcode-heading-label-char-list-for-kigou-mode)
            (list b)))))
    (and seq
      (list (list seq) (list b)))))

;;; ưإ:Ǥ˸
;;; ǽ˸Ĥä2ǸȤ߹碌֤
;;; (filtermapȤäơǾΥȥΤΤõȻ֤Τǡ)
;;; ξȤ2ǸȤ߹碌Ĥʤä顢
;;; 3ǸȤȤ߹碌֤
;;; @param long-stroke-result 3Ǹʾʸޤ
;;; @param min-stroke long-stroke-resultθߤκǾǸ
;;; @param get-stroke-list Ѥ2ĤʸȥȥΥꥹȤ֤ؿ
;;; @return Ѥ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-looking-bushudic bushudic
          long-stroke-result min-stroke get-stroke-list)
  (if (null? bushudic)
    (and
      (not (null? long-stroke-result))
      long-stroke-result)
    (let*
      ((res
        (get-stroke-list (list min-stroke (car bushudic))))
       (len (if (not res) 99 (tutcode-auto-help-count-stroke-length res)))
       (min (if (< len min-stroke) len min-stroke)))
      (if (<= len 4) ; "5"Ȥ4Ǹ̤⤢뤬ޤǤϸʤ
        res
        (tutcode-auto-help-bushu-decompose-looking-bushudic (cdr bushudic)
          (if (< len min-stroke) res long-stroke-result)
          min get-stroke-list)))))

;;; ưإ:оʸˤΤɬפȤʤ롢
;;; ǤʤʸΥꥹȤ֤
;;; : "" => (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;;    (Ȥʤtutcode-bushudicǤ((("" "")) ("")))
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-by-subtraction c rule)
  (tutcode-auto-help-bushu-decompose-looking-bushudic tutcode-bushudic
    () 99
    (lambda (elem)
      (tutcode-auto-help-get-stroke-list-by-subtraction c rule elem))))

;;; ưإ:ɬפǸ
;;; @param bushu-compose-list ˻Ȥ2ʸȥȥΥꥹȡ
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;; @return bushu-compose-list˴ޤޤǸ(ξ5)
(define (tutcode-auto-help-count-stroke-length bushu-compose-list)
  (+ (length (caaar bushu-compose-list))
     (length (caaadr bushu-compose-list))))

;;; ưإ:оʸˤǤϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
(define (tutcode-auto-help-get-stroke-list-by-subtraction
          c rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member c (caar bushu-list)))
     (b1 (caadr bushu-list))
     ;; 2ĤΤcʳ
     (b2 (if (= 2 (length mem)) (cadr mem) (car (caar bushu-list))))
     (seq1 (tutcode-auto-help-get-stroke b1 rule))
     (seq2 (tutcode-auto-help-get-stroke b2 rule))
     (ret (list seq1 seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 b2))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1פȡ2ʤȤƻĴפˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param b1 1(ľϲǽ)
;;; @param b2 2(ľԲǽ)
;;; @param seq1 b1ϥ󥹤Υꥹ
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
(define (tutcode-auto-help-get-stroke-list-with-right-part
         c b1 b2 seq1 rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b2 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 2ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji rule))
     (ret (list seq1 seq))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 kanji))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1ʤȤƻĴפȡ2פˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ (: "")
;;; @param b1 1(ľԲǽ) (: "")
;;; @param b2 2(ľϲǽ) (: "")
;;; @param seq2 b2ϥ󥹤Υꥹȡ
;;;  : ((("b" ",")) (""))
;;; @param rule tutcode-rule
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("e" "v" ".")) ("")) ((("b" ",")) ("")))
(define (tutcode-auto-help-get-stroke-list-with-left-part
         c b1 b2 seq2 rule min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b1 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 1ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji rule))
     (ret (list seq seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert kanji b2))
     (c-composed? (string=? composed c)))
    ret))

;;; Ѵͽ¬ϸ򸡺
;;; @param str 1
;;; @param bushudic ꥹ
;;; @return (<2> <ʸ>)Υꥹ
(define (tutcode-bushu-predict str bushudic)
  (if (null? tutcode-bushu-help)
    (set! tutcode-bushu-help (tutcode-bushu-help-load)))
  (let*
    ((rules-help
      (if tutcode-bushu-help
        (rk-lib-find-partial-seqs (list str) tutcode-bushu-help)
        ()))
     (rules-dic (rk-lib-find-partial-seqs (list str) bushudic))
     (rules (append rules-help rules-dic)) ; ʣbushu.help¦ǲǽ
     (words1 (map (lambda (elem) (cadaar elem)) rules))
     ;; (((str 2))(ʸ)) -> (2 ʸ)
     (word/cand1 (map (lambda (elem) (list (cadaar elem) (caadr elem))) rules))
     (more-cands
      (filter-map
        (lambda (elem)
          (let
            ;; (((1 2))(ʸ))
            ((bushu1 (caaar elem))
             (bushu2 (cadaar elem))
             (gosei (caadr elem)))
            (or
              ;; str1ʸܤξrk-lib-find-partial-seqsǸ
              ;(string=? str bushu1) ; (((str 2))(ʸ))
              (and (string=? str bushu2) ; (((1 str))(ʸ))
                    ;; ˾ǽиѤξϽ
                    ;; : ((("" ""))(""))""иѤξ硢
                    ;;     ((("" ""))(""))""Ͻ
                   (not (member bushu1 words1))
                   (list bushu1 gosei))
              (and (string=? str gosei) ; (((1 2))(str))
                   ;; XXX:ξ硢strbushu1bushu2Ǥ뤳Ȥ
                   ;;     ǧ٤tutcode-bushu-convert٤ΤǾά
                   (list bushu1 bushu2)))))
          bushudic)))
    (append word/cand1 more-cands)))

;;; tutcode-ruleհơѴʸ顢ϥ롣
;;; : (tutcode-reverse-find-seq "" tutcode-rule) => ("r" "k")
;;; @param c Ѵʸ
;;; @param rule tutcode-rule
;;; @return ϥΥꥹȡtutcode-rulecĤʤä#f
(define (tutcode-reverse-find-seq c rule)
  (let*
    ((make-reverse-rule-alist
      (lambda (r)
        (map
          (lambda (elem)
            (cons (caadr elem) (caar elem)))
          r)))
     (alist
      (if (eq? rule tutcode-kigou-rule)
        (begin
          (if (null? tutcode-reverse-kigou-rule-alist)
            (set! tutcode-reverse-kigou-rule-alist
              (make-reverse-rule-alist rule)))
          tutcode-reverse-kigou-rule-alist)
        (begin
          (if (null? tutcode-reverse-rule-alist)
            (set! tutcode-reverse-rule-alist
              (make-reverse-rule-alist rule)))
          tutcode-reverse-rule-alist)))
     (res (assoc c alist)))
    (and res
      (cdr res))))

;;; ߤstatepreeditĤɤ֤
;;; @param pc ƥȥꥹ
(define (tutcode-state-has-preedit? pc)
  (or
    (not (null? (tutcode-context-child-context pc)))
    (memq (tutcode-context-state pc)
      '(tutcode-state-yomi tutcode-state-bushu tutcode-state-converting
        tutcode-state-interactive-bushu tutcode-state-kigou
        tutcode-state-code tutcode-state-history))))

;;; 줿ȤνοʬԤ
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-press-handler c key key-state)
  (if (ichar-control? key)
      (im-commit-raw c)
      (let ((pc (tutcode-find-descendant-context c)))
        (case (tutcode-context-state pc)
          ((tutcode-state-on)
           (tutcode-proc-state-on pc key key-state)
           (if (or
                 ;; 򤼽ѴѴϡ䢥ɽ
                 (tutcode-state-has-preedit? c)
                 ;; ʸַ򤼽ѴκƵؽ󥻥
                 (not (eq? (tutcode-find-descendant-context c) pc)))
             (tutcode-update-preedit pc)))
          ((tutcode-state-kigou)
           (tutcode-proc-state-kigou pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-yomi)
           (tutcode-proc-state-yomi pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-converting)
           (tutcode-proc-state-converting pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-bushu)
           (tutcode-proc-state-bushu pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-interactive-bushu)
           (tutcode-proc-state-interactive-bushu pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-code)
           (tutcode-proc-state-code pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-history)
           (tutcode-proc-state-history pc key key-state)
           (tutcode-update-preedit pc))
          (else
           (tutcode-proc-state-off pc key key-state)
           (if (tutcode-state-has-preedit? c) ; Ƶؽ
             (tutcode-update-preedit pc))))
        (if (or tutcode-use-stroke-help-window?
                (not (eq? tutcode-stroke-help-with-kanji-combination-guide
                          'disable)))
          ;; editorκβǽΤdescendant-contextľ
          (let ((newpc (tutcode-find-descendant-context c)))
            (if
              (and
                (memq (tutcode-context-state newpc)
                  '(tutcode-state-on tutcode-state-yomi tutcode-state-bushu
                    tutcode-state-interactive-bushu))
                (not (tutcode-context-latin-conv newpc)))
              (tutcode-check-stroke-help-window-begin newpc)))))))

;;; Υ줿ȤνԤ
;;; @param pc ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-release-handler pc key key-state)
  (if (or (ichar-control? key)
	  (not (tutcode-context-on? pc)))
      ;; don't discard key release event for apps
      (im-commit-raw pc)))

;;; TUT-Code IMνԤ
(define (tutcode-init-handler id im arg)
  (let ((tc (tutcode-context-new id im)))
    (set! tutcode-context-list (cons tc tutcode-context-list))
    tc))

(define (tutcode-release-handler tc)
  (tutcode-save-personal-dictionary #f)
  (set! tutcode-context-list (delete! tc tutcode-context-list))
  (if (null? tutcode-context-list)
    (begin
      (skk-lib-free-dic tutcode-dic)
      (set! tutcode-dic #f))))

(define (tutcode-reset-handler tc)
  (tutcode-flush tc))

(define (tutcode-focus-in-handler tc) #f)

(define (tutcode-focus-out-handler c)
  (let* ((tc (tutcode-find-descendant-context c))
         (rkc (tutcode-context-rk-context tc)))
    (rk-flush rkc)))

(define tutcode-place-handler tutcode-focus-in-handler)
(define tutcode-displace-handler tutcode-focus-out-handler)

;;; 䥦ɥʸ뤿˸Ƥִؿ
(define (tutcode-get-candidate-handler c idx accel-enum-hint)
  (let ((tc (tutcode-find-descendant-context c)))
    (cond
      ((= accel-enum-hint 9999) ;XXX ɽ䥦ɥdisplay_limitĴ
        (set! tutcode-nr-candidate-max (length tutcode-heading-label-char-list))
        (set! tutcode-nr-candidate-max-for-kigou-mode
          (length tutcode-heading-label-char-list-for-kigou-mode))
        (set! tutcode-nr-candidate-max-for-history
          (length tutcode-heading-label-char-list-for-history))
        (set! tutcode-nr-candidate-max-for-prediction
          (length tutcode-heading-label-char-list-for-prediction))
        (set! tutcode-nr-candidate-max-for-guide
          (- tutcode-nr-candidate-max-for-kigou-mode
             tutcode-nr-candidate-max-for-prediction))
        (list "" ""
          (string-append "display_limit="
            (number->string
              (cond
                ((eq? (tutcode-context-state tc) 'tutcode-state-kigou)
                  tutcode-nr-candidate-max-for-kigou-mode)
                ((eq? (tutcode-context-state tc) 'tutcode-state-history)
                  tutcode-nr-candidate-max-for-history)
                ((eq? (tutcode-context-state tc)
                      'tutcode-state-interactive-bushu)
                  (tutcode-context-prediction-page-limit tc))
                ((not (eq? (tutcode-context-predicting tc)
                           'tutcode-predicting-off))
                  (tutcode-context-prediction-page-limit tc))
                (else
                  tutcode-nr-candidate-max))))))
      ;; 
      ((eq? (tutcode-context-state tc) 'tutcode-state-kigou)
        (let* ((cand (tutcode-get-nth-candidate-for-kigou-mode tc idx))
               (n (remainder idx
                    (length tutcode-heading-label-char-list-for-kigou-mode)))
               (label (nth n tutcode-heading-label-char-list-for-kigou-mode)))
          ;; XXX:annotationɽϸ̵ƤΤǡ""֤Ƥ
          (list cand label "")))
      ;; ҥȥ
      ((eq? (tutcode-context-state tc) 'tutcode-state-history)
        (let* ((cand (tutcode-get-nth-candidate-for-history tc idx))
               (n (remainder idx
                    (length tutcode-heading-label-char-list-for-history)))
               (label (nth n tutcode-heading-label-char-list-for-history)))
          (list cand label "")))
      ;; 䴰/ͽ¬ϸ
      ((not (eq? (tutcode-context-predicting tc) 'tutcode-predicting-off))
        (let*
          ((nr-in-page (tutcode-context-prediction-nr-in-page tc))
           (page-limit (tutcode-context-prediction-page-limit tc))
           (pages (quotient idx page-limit))
           (idx-in-page (remainder idx page-limit)))
          ;; ƥڡˤϡnr-in-pageĤ䴰/ͽ¬ϸȡϸ쥬ɤɽ
          (if (< idx-in-page nr-in-page)
            ;; 䴰/ͽ¬ϸʸ
            (let*
              ((nr-predictions (tutcode-lib-get-nr-predictions tc))
               (p-idx (+ idx-in-page (* pages nr-in-page)))
               (i (remainder p-idx nr-predictions))
               (cand (tutcode-lib-get-nth-prediction tc i))
               (cand-guide
                (if (eq? (tutcode-context-predicting tc)
                          'tutcode-predicting-bushu)
                  (string-append
                    cand "(" (tutcode-lib-get-nth-word tc i) ")")
                  cand))
               (n (remainder p-idx
                    (length tutcode-heading-label-char-list-for-prediction)))
               (label (nth n tutcode-heading-label-char-list-for-prediction)))
              (list cand-guide label ""))
            ;; ϸ쥬
            (let*
              ((guide (tutcode-context-guide tc))
               (guide-len (length guide)))
              (if (= guide-len 0)
                (list "" "" "")
                (let*
                  ((guide-idx-in-page (- idx-in-page nr-in-page))
                   (nr-guide-in-page (- page-limit nr-in-page))
                   (guide-idx (+ guide-idx-in-page (* pages nr-guide-in-page)))
                   (n (remainder guide-idx guide-len))
                   (label-cands-alist (nth n guide))
                   (label (car label-cands-alist))
                   (cands (cdr label-cands-alist))
                   (cand
                    (string-list-concat
                      (append cands (list tutcode-guide-mark)))))
                  (list cand label "")))))))
      ;; ۸
      ((eq? (tutcode-context-candidate-window tc)
            'tutcode-candidate-window-stroke-help)
        (nth idx (tutcode-context-stroke-help tc)))
      ;; ưإ
      ((eq? (tutcode-context-candidate-window tc)
            'tutcode-candidate-window-auto-help)
        (nth idx (tutcode-context-auto-help tc)))
      ;; ŪѴ
      ((eq? (tutcode-context-state tc) 'tutcode-state-interactive-bushu)
        (let*
          ;; ͽ¬ϸѿή
          ((nr-in-page (tutcode-context-prediction-nr-in-page tc))
           (page-limit (tutcode-context-prediction-page-limit tc))
           (pages (quotient idx page-limit))
           (idx-in-page (remainder idx page-limit))
           (nr-predictions (tutcode-lib-get-nr-predictions tc))
           (p-idx (+ idx-in-page (* pages nr-in-page)))
           (i (remainder p-idx nr-predictions))
           (cand (tutcode-lib-get-nth-prediction tc i))
           (n (remainder p-idx
                (length tutcode-heading-label-char-list-for-prediction)))
           (label (nth n tutcode-heading-label-char-list-for-prediction)))
          (list cand label "")))
      ;; 򤼽Ѵ
      (else
        (let* ((cand (tutcode-get-nth-candidate tc idx))
               (n (remainder idx (length tutcode-heading-label-char-list)))
               (label (nth n tutcode-heading-label-char-list)))
          (list cand label ""))))))

;;; 䥦ɥ򤷤Ȥ˸Ƥִؿ
;;; 򤵤줿ꤹ롣
(define (tutcode-set-candidate-index-handler c idx)
  (let* ((pc (tutcode-find-descendant-context c))
         (candwin (tutcode-context-candidate-window pc)))
    (cond
      ((and (memq candwin '(tutcode-candidate-window-converting
                            tutcode-candidate-window-kigou
                            tutcode-candidate-window-history))
          (>= idx 0)
          (< idx (tutcode-context-nr-candidates pc)))
        (tutcode-context-set-nth! pc idx)
        (case (tutcode-context-state pc)
          ((tutcode-state-kigou)
            (tutcode-commit pc (tutcode-prepare-commit-string-for-kigou-mode pc)))
          ((tutcode-state-history)
            (let ((str (tutcode-prepare-commit-string-for-history pc)))
              (tutcode-commit pc str)
              (tutcode-flush pc)
              (tutcode-check-auto-help-window-begin pc (string-to-list str) ())))
          (else
            (tutcode-commit-with-auto-help pc)))
        (tutcode-update-preedit pc))
      ((and (or (eq? candwin 'tutcode-candidate-window-predicting)
                (eq? candwin 'tutcode-candidate-window-interactive-bushu))
            (>= idx 0))
        (let*
          ((nr-in-page (tutcode-context-prediction-nr-in-page pc))
           (page-limit (tutcode-context-prediction-page-limit pc))
           (idx-in-page (remainder idx page-limit)))
          (if (< idx-in-page nr-in-page)
            (let*
              ((nr-predictions (tutcode-lib-get-nr-predictions pc))
               (pages (quotient idx page-limit))
               (p-idx (+ idx-in-page (* pages nr-in-page)))
               (i (remainder p-idx nr-predictions))
               (mode (tutcode-context-predicting pc)))
              (tutcode-context-set-prediction-index! pc i)
              (if (eq? candwin 'tutcode-candidate-window-interactive-bushu)
                (tutcode-do-commit-prediction-for-interactive-bushu pc)
                (if (eq? mode 'tutcode-predicting-bushu)
                  (tutcode-do-commit-prediction-for-bushu pc)
                  (tutcode-do-commit-prediction pc
                    (eq? mode 'tutcode-predicting-completion))))
              (tutcode-update-preedit pc))))))))

(tutcode-configure-widgets)

;;; TUT-Code IMϿ롣
(register-im
 'tutcode
 "ja"
 "EUC-JP"
 tutcode-im-name-label
 tutcode-im-short-desc
 #f
 tutcode-init-handler
 tutcode-release-handler
 context-mode-handler
 tutcode-key-press-handler
 tutcode-key-release-handler
 tutcode-reset-handler
 tutcode-get-candidate-handler
 tutcode-set-candidate-index-handler
 context-prop-activate-handler
 #f
 tutcode-focus-in-handler
 tutcode-focus-out-handler
 tutcode-place-handler
 tutcode-displace-handler
 )

;;; ɽѴ롣
;;; @param from Ѵоݥɽ
;;; @param translate-alist Ѵɽ
;;; @return Ѵɽ
(define (tutcode-rule-translate from translate-alist)
  (map
    (lambda (elem)
      (cons
        (list
          (map
            (lambda (key)
              (let ((res (assoc key translate-alist)))
                (if res
                  (cadr res)
                  key)))
            (caar elem)))
        (cdr elem)))
    from))

;;; ɽQwertyDvorakѤѴ롣
;;; @param qwerty QwertyΥɽ
;;; @return DvorakѴɽ
(define (tutcode-rule-qwerty-to-dvorak qwerty)
  (tutcode-rule-translate qwerty tutcode-rule-qwerty-to-dvorak-alist))

;;; ɽQwerty-jisQwerty-usѤѴ롣
;;; @param jis Qwerty-jisΥɽ
;;; @return Qwerty-usѴɽ
(define (tutcode-rule-qwerty-jis-to-qwerty-us jis)
  (tutcode-rule-translate jis tutcode-rule-qwerty-jis-to-qwerty-us-alist))

;;; kigou-rule򥭡ܡɥ쥤Ȥ˹碌Ѵ
;;; @param layout tutcode-candidate-window-table-layout
(define (tutcode-kigou-rule-translate layout)
  (let
    ((translate-stroke-help-alist
      (lambda (lis translate-alist)
        (map
          (lambda (elem)
            (cons
              (let ((res (assoc (car elem) translate-alist)))
                (if res
                  (cadr res)
                  (car elem)))
              (cdr elem)))
          lis))))
    (case layout
      ((qwerty-us)
        (set! tutcode-kigou-rule
          (tutcode-rule-qwerty-jis-to-qwerty-us
            (tutcode-kigou-rule-pre-translate
              tutcode-rule-qwerty-jis-to-qwerty-us-alist)))
        (set! tutcode-kigou-rule-stroke-help-top-page-alist
          (translate-stroke-help-alist 
            tutcode-kigou-rule-stroke-help-top-page-alist
            tutcode-rule-qwerty-jis-to-qwerty-us-alist)))
      ((dvorak)
        (set! tutcode-kigou-rule
          (tutcode-rule-qwerty-to-dvorak
            (tutcode-kigou-rule-pre-translate
              tutcode-rule-qwerty-to-dvorak-alist)))
        (set! tutcode-kigou-rule-stroke-help-top-page-alist
          (translate-stroke-help-alist 
            tutcode-kigou-rule-stroke-help-top-page-alist
            tutcode-rule-qwerty-to-dvorak-alist))))))

;;; Qwerty-jisQwerty-usؤѴơ֥롣
(define tutcode-rule-qwerty-jis-to-qwerty-us-alist
  '(
    ("^" "=")
    ("@" "[")
    ("[" "]")
    (":" "'")
    ("]" "`")
    ("\"" "@")
    ("'" "&")
    ("&" "^")
    ("(" "*")
    (")" "(")
    ("|" ")") ;tutcode-kigou-ruleѡ<Shift>0qwerty-jisǤ|ѤƤΤ
    ("=" "_")
    ("~" "+")
    ("_" "|") ;XXX
    ("`" "{")
    ("{" "}")
    ("+" ":")
    ("*" "\"")
    ("}" "~")))

;;; QwertyDvorakؤѴơ֥롣
(define tutcode-rule-qwerty-to-dvorak-alist
  '(
    ;("1" "1")
    ;("2" "2")
    ;("3" "3")
    ;("4" "4")
    ;("5" "5")
    ;("6" "6")
    ;("7" "7")
    ;("8" "8")
    ;("9" "9")
    ;("0" "0")
    ("-" "[")
    ("^" "]") ;106
    ("q" "'")
    ("w" ",")
    ("e" ".")
    ("r" "p")
    ("t" "y")
    ("y" "f")
    ("u" "g")
    ("i" "c")
    ("o" "r")
    ("p" "l")
    ("@" "/") ;106
    ("[" "=") ;106
    ;("a" "a")
    ("s" "o")
    ("d" "e")
    ("f" "u")
    ("g" "i")
    ("h" "d")
    ("j" "h")
    ("k" "t")
    ("l" "n")
    (";" "s")
    (":" "-") ;106
    ("]" "`")
    ("z" ";")
    ("x" "q")
    ("c" "j")
    ("v" "k")
    ("b" "x")
    ("n" "b")
    ;("m" "m")
    ("," "w")
    ("." "v")
    ("/" "z")
    ;(" " " ")
    ;; shift
    ;("!" "!")
    ("\"" "@") ;106
    ;("#" "#")
    ;("$" "$")
    ;("%" "%")
    ("&" "^") ;106
    ("'" "&") ;106
    ("(" "*") ;106
    (")" "(") ;106
    ("=" "{") ;106
    ("~" "}") ;106
    ("|" ")") ;tutcode-kigou-ruleѡ<Shift>0qwerty-jisǤ|ѤƤΤ
    ("_" "|") ;XXX
    ("Q" "\"")
    ("W" "<")
    ("E" ">")
    ("R" "P")
    ("T" "Y")
    ("Y" "F")
    ("U" "G")
    ("I" "C")
    ("O" "R")
    ("P" "L")
    ("`" "?") ;106
    ("{" "+") ;106
    ;("A" "A")
    ("S" "O")
    ("D" "E")
    ("F" "U")
    ("G" "I")
    ("H" "D")
    ("J" "H")
    ("K" "T")
    ("L" "N")
    ("+" "S") ;106
    ("*" "_") ;106
    ("}" "~")
    ("Z" ":")
    ("X" "Q")
    ("C" "J")
    ("V" "K")
    ("B" "X")
    ("N" "B")
    ;("M" "M")
    ("<" "W")
    (">" "V")
    ("?" "Z")
    ))

;;; tutcode-customꤵ줿ɽΥե̾饳ɽ̾äơ
;;; Ѥ륳ɽȤꤹ롣
;;; 륳ɽ̾ϡե̾".scm"򤱤äơ
;;; "-rule"ĤƤʤäɲäΡ
;;; : "tutcode-rule.scm"tutcode-rule
;;;     "tcode.scm"tcode-rule
;;; @param filename tutcode-rule-filename
(define (tutcode-custom-load-rule! filename)
  (and
    (try-load filename)
    (let*
      ((basename (last (string-split filename "/")))
       ;; ե̾".scm"򤱤
       (bnlist (string-to-list basename))
       (codename
        (or
          (and
            (> (length bnlist) 4)
            (string=? (string-list-concat (list-head bnlist 4)) ".scm")
            (string-list-concat (list-tail bnlist 4)))
          basename))
       ;; "-rule"ĤƤʤäɲ
       (rulename
        (or
          (and
            (not (string=? (last (string-split codename "-")) "rule"))
            (string-append codename "-rule"))
          codename)))
      (and rulename
        (symbol-bound? (string->symbol rulename))
        (set! tutcode-rule
          (eval (string->symbol rulename) (interaction-environment)))))))

;;; tutcode-key-customꤵ줿򤼽/ѴϤΥ󥹤
;;; ɽȿǤ
(define (tutcode-custom-set-mazegaki/bushu-start-sequence!)
  (let
    ((make-subrule
      (lambda (keyseq cmd)
        (and keyseq
             (> (string-length keyseq) 0))
          (let ((keys (reverse (string-to-list keyseq))))
            (list (list keys) cmd)))))
    (tutcode-rule-set-sequences!
      (filter
        pair?
        (list
          (make-subrule tutcode-mazegaki-start-sequence
            '(tutcode-mazegaki-start))
          (make-subrule tutcode-latin-conv-start-sequence
            '(tutcode-latin-conv-start))
          (make-subrule tutcode-kanji-code-input-start-sequence
            '(tutcode-kanji-code-input-start))
          (make-subrule tutcode-history-start-sequence
            '(tutcode-history-start))
          (make-subrule tutcode-bushu-start-sequence
            '(tutcode-bushu-start))
          (and
            tutcode-use-interactive-bushu-conversion?
            (make-subrule tutcode-interactive-bushu-start-sequence
              '(tutcode-interactive-bushu-start)))
          (make-subrule tutcode-postfix-bushu-start-sequence
            '(tutcode-postfix-bushu-start))
          (make-subrule tutcode-postfix-mazegaki-start-sequence
            '(tutcode-postfix-mazegaki-start))
          (make-subrule tutcode-postfix-mazegaki-1-start-sequence
            '(tutcode-postfix-mazegaki-1-start))
          (make-subrule tutcode-postfix-mazegaki-2-start-sequence
            '(tutcode-postfix-mazegaki-2-start))
          (make-subrule tutcode-postfix-mazegaki-3-start-sequence
            '(tutcode-postfix-mazegaki-3-start))
          (make-subrule tutcode-postfix-mazegaki-4-start-sequence
            '(tutcode-postfix-mazegaki-4-start))
          (make-subrule tutcode-postfix-mazegaki-5-start-sequence
            '(tutcode-postfix-mazegaki-5-start))
          (make-subrule tutcode-postfix-mazegaki-6-start-sequence
            '(tutcode-postfix-mazegaki-6-start))
          (make-subrule tutcode-postfix-mazegaki-7-start-sequence
            '(tutcode-postfix-mazegaki-7-start))
          (make-subrule tutcode-postfix-mazegaki-8-start-sequence
            '(tutcode-postfix-mazegaki-8-start))
          (make-subrule tutcode-postfix-mazegaki-9-start-sequence
            '(tutcode-postfix-mazegaki-9-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-start-sequence
            '(tutcode-postfix-mazegaki-inflection-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-1-start-sequence
            '(tutcode-postfix-mazegaki-inflection-1-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-2-start-sequence
            '(tutcode-postfix-mazegaki-inflection-2-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-3-start-sequence
            '(tutcode-postfix-mazegaki-inflection-3-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-4-start-sequence
            '(tutcode-postfix-mazegaki-inflection-4-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-5-start-sequence
            '(tutcode-postfix-mazegaki-inflection-5-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-6-start-sequence
            '(tutcode-postfix-mazegaki-inflection-6-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-7-start-sequence
            '(tutcode-postfix-mazegaki-inflection-7-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-8-start-sequence
            '(tutcode-postfix-mazegaki-inflection-8-start))
          (make-subrule tutcode-postfix-mazegaki-inflection-9-start-sequence
            '(tutcode-postfix-mazegaki-inflection-9-start))
          (make-subrule tutcode-auto-help-redisplay-sequence
            '(tutcode-auto-help-redisplay)))))))

;;; ɽΰѹ/ɲä롣~/.uimλѤꡣ
;;; ƤӽФˤtutcode-rule-userconfigϿƤǡ
;;; ºݤ˥ɽȿǤΤϡtutcode-context-new
;;;
;;; (tutcode-rule-filename꤬uim-pref~/.uimΤɤǹԤ줿Ǥ
;;;  ~/.uimǤΥɽΰѹƱҤǤǤ褦ˤ뤿ᡣ
;;;  ɽɸhookѰդ)
;;;
;;; ƤӽФ:
;;;   (tutcode-rule-set-sequences!
;;;     '(((("d" "l" "u")) ("" ""))
;;;       ((("d" "l" "d" "u")) ("" ""))))
;;; @param rules 󥹤ϤʸΥꥹ
(define (tutcode-rule-set-sequences! rules)
  (set! tutcode-rule-userconfig
    (append rules tutcode-rule-userconfig)))

;;; ɽξѹ/ɲäΤtutcode-rule-userconfig
;;; ɽȿǤ롣
(define (tutcode-rule-commit-sequences! rules)
  (let* ((newseqs ()) ;ɲä륭
         ;; ɽλꥷ󥹤Ϥʸѹ롣
         ;; seq 
         ;; kanji ϤʸcarҤ餬ʥ⡼ѡcadrʥ⡼
         (setseq1!
          (lambda (elem)
            (let* ((seq (caar elem))
                   (kanji (cadr elem))
                   (curseq (rk-lib-find-seq seq tutcode-rule))
                   (pair (and curseq (cadr curseq))))
              (if (and pair (pair? pair))
                (begin
                  (set-car! pair (car kanji))
                  (if (not (null? (cdr kanji)))
                    (if (< (length pair) 2)
                      (set-cdr! pair (list (cadr kanji)))
                      (set-car! (cdr pair) (cadr kanji)))))
                (begin
                  ;; ɽ˻ꤵ줿󥹤̵
                  (set! newseqs (append newseqs (list elem)))))))))
    (for-each setseq1! rules)
    ;; ɲå
    (if (not (null? newseqs))
      (set! tutcode-rule (append tutcode-rule newseqs)))))
