/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UGET_CMD_H
#define UGET_CMD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <uglib.h>
#include <UgCategory-cmd.h>

#ifdef __cplusplus
extern "C" {
#endif

#define UGET_CMD_DIR				"Uget"		// "UgetCmd"
#define UGET_CMD_CATEGORY_FILE		"CategoryList-cmd.xml"
#define UGET_CMD_DOWNLOAD_FILE		"DownloadList-cmd.xml"

typedef struct	UgetCmd_			UgetCmd;

const gchar*	ug_get_data_dir (void);		// implemented in uget-cmd/main.c

// ----------------------------------------------------------------------------
// UgetCmd: Uget command-line version
//
struct UgetCmd_
{
	UG_DATA_MEMBERS;

	UgOption		option;
	UgIpc			ipc;

	UgCategoryCmd*	primary;	// this category has ALL of download

	GList*			category_list;

	gboolean		quit_loop;
	GMainLoop*		main_loop;
};

void	uget_cmd_class_init (void);

void	uget_cmd_run  (UgetCmd* ugcmd);
void	uget_cmd_save (UgetCmd* ugcmd);
void	uget_cmd_load (UgetCmd* ugcmd);

#ifdef __cplusplus
}
#endif

#endif  // UGET_CMD_H

