#!/usr/bin/env python
"""Run all tests"""

__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2008-03-12 -- 2009-03-25"

# Modified by Martin Alnes 2009

import unittest
import sys
from os import system
from glob import glob

# Set log output level
import logging
logging.basicConfig(level=logging.WARNING)

# Tests to run
#tests = ["elements", "indices", "forms", "illegal", "algorithms"]
tests = [f.replace(".py", "") for f in glob("*.py")]
tests = [f for f in tests if not "debug" in f]

skip = set(("test", "testrunner", "makemanualtestcase", "analyse_demos"))
tests = sorted(list(set(tests) - skip))
if not "skipdemos" in sys.argv:
    tests.append("analyse_demos")

using_testrunner = True

template = """
#
# This code is auto-generated by test.py, don't modify manually!
#

import logging
import ufl

# Emit all messages, show nothing on screen,
# but write everything to log file
logger = ufl.get_logger()
sh = ufl.get_handler()
fh = ufl.add_logfile()

logger.setLevel(logging.DEBUG)
sh.setLevel(logging.CRITICAL)
fh.setLevel(logging.DEBUG)

# Autogenerated imports
%s

if __name__ == "__main__":
    unittest.main()
"""

if using_testrunner:
    # Write a script that has all TestCase classes in the global namespace
    # and invoke unittest.main(), probably an easier way to do this though.
    imports = "\n".join("from %s import *" % name for name in tests)
    testrunnercode = template % imports

    f = open("testrunner.py", "w")
    f.write(testrunnercode)
    f.close()

    failure = system("python testrunner.py")

else:
    # Run test files one by one
    failed_tests = []
    for test in tests:
       print "Running tests: %s" % test
       failure = system("python %s.py" % test)
       if failure:
           failed_tests.append(test)
       print ""
    print "Failed test files:"
    print "\n".join(failed_tests)
    failure = len(failed_tests)

# Run tests TODO: Make this work, to speed up test suite and get more compact output. Currently fails when instantiating testcases.
#all_tests = []
#for test in tests:
#    print "Adding tests from: %s" % test
#    module = __import__(test)
#    tests = [c() for c in vars(module).values() if isinstance(c, type) and issubclass(c, unittest.TestCase)]
#    all_tests.extend(tests)
#suite = unittest.TestSuite(all_tests)
#runner = unittest.TextTestRunner(suite)
#runner.run()

# Exit with error message
sys.exit(failure)
