/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <unistd.h>
#include <QSplitter>
#include <QToolBar>
#include <QInputDialog>
#include <QMessageBox>
#include <QApplication>
#include <QSettings>
#include <QAction>
#include <QFile>
#include <QFileDialog>
#include <QStatusBar>
#include <QMenuBar>
#include <QTextEdit>
#include <QPushButton>
#include <QLayout>
#include <QTextStream>
#include <QDockWidget>
#include <QMdiArea>
#include <mgl/mgl_parse.h>
//-----------------------------------------------------------------------------
#include "scriptwindow.h"
#include "qmglsyntax.h"
#include "qmglcanvas.h"
#include "finddialog.h"
#include "graphwindow.h"
#include "helpwindow.h"
#include "optiondialog.h"
#include "newcmddialog.h"
//-----------------------------------------------------------------------------
#include "xpm/option.xpm"
#include "xpm/style.xpm"
//-----------------------------------------------------------------------------
QStringList recentFiles;
int MaxRecentFiles=5;
bool mglAutoExecute = true;
bool editPosBottom = false;
bool mglAutoSave = false;
bool showHint=true;
extern HintDialog *hintDialog;
extern mglParse parser;
extern ArgsDialog *args_dlg;
extern QColor mglColorScheme[9];
extern QString defFontFamily;
extern int defFontSize;
extern QString pathHelp;
extern QString pathFont;
bool loadInNewWnd = false;
extern int defWidth, defHeight;
//-----------------------------------------------------------------------------
void ScriptWindow::about()
{
	QString s = tr("UDAV v. 0.")+QString::number(UDAV_VERSION)+
				tr("\n(c) Alexey Balakin, 2008\nhttp://udav.sf.net/");
	QMessageBox::about(this, tr("UDAV - about"), s);
}
//-----------------------------------------------------------------------------
void ScriptWindow::aboutQt()
{	QMessageBox::aboutQt(this, tr("About Qt"));	}
//-----------------------------------------------------------------------------
void ScriptWindow::makeMenu()
{
	QAction *a;
	QMenu *o, *oo;
	QToolBar *bb;

	// file menu
	{
	bb = new QToolBar(tr("File/Edit Operations"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = menuBar()->addMenu(tr("&File"));
	a = new QAction(QPixmap(":/xpm/document-new.png"), tr("&New script"), this);
	connect(a, SIGNAL(activated()), this, SLOT(newDoc()));
	a->setToolTip(tr("Create new empty script window (Ctrl+N)."));
	a->setShortcut(Qt::CTRL+Qt::Key_N);	o->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-open.png"), tr("&Open file"), this);
	connect(a, SIGNAL(activated()), this, SLOT(choose()));
	a->setToolTip(tr("Open and execute/show script or data from file (Ctrl+O).\nYou may switch off automatic exection in UDAV properties."));
	a->setShortcut(Qt::CTRL+Qt::Key_O);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-save.png"), tr("&Save script"), this);
	connect(a, SIGNAL(activated()), this, SLOT(save()));
	a->setToolTip(tr("Save script to a file (Ctrl+S)"));
	a->setShortcut(Qt::CTRL+Qt::Key_S);	o->addAction(a);	bb->addAction(a);
	a = new QAction(tr("Save &As ..."), this);
	connect(a, SIGNAL(activated()), this, SLOT(saveAs()));
	o->addAction(a);

	o->addSeparator();
	o->addAction(tr("&Print script"), this, SLOT(printText()));
	a = new QAction(QPixmap(":/xpm/document-print.png"), tr("Print &graphics"), this);
	connect(a, SIGNAL(activated()), graph, SLOT(printPlot()));
	a->setToolTip(tr("Open printer dialog and print graphics\t(Ctrl+P)"));
	a->setShortcut(Qt::CTRL+Qt::Key_P);	o->addAction(a);
	o->addSeparator();
	fileMenu = o->addMenu(tr("Recent files"));
	o->addSeparator();
	o->addAction(tr("&Quit"), qApp, SLOT(closeAllWindows()), Qt::CTRL+Qt::Key_Q);
	bb->addSeparator();
	}
	// edit menu
	{
	o = menuBar()->addMenu(tr("&Edit"));
	a = new QAction(QPixmap(":/xpm/edit-undo.png"), tr("&Undo"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(undo()));
	a->setToolTip(tr("Undo editor change (Ctrl+Z)."));
	a->setShortcut(Qt::CTRL+Qt::Key_Z);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-redo.png"), tr("&Redo"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(redo()));
	a->setToolTip(tr("Redo editor change (Ctrl+Shift+Z)."));
	a->setShortcut(Qt::CTRL+Qt::SHIFT+Qt::Key_Z);	o->addAction(a);	bb->addAction(a);
	bb->addSeparator();	o->addSeparator();
	o->addAction(tr("Clear all"), edit, SLOT(clear()));
	a = new QAction(QPixmap(":/xpm/edit-cut.png"), tr("Cu&t text"), this);
	connect(a, SIGNAL(activated()), edit, SLOT(cut()));
	a->setToolTip(tr("Cut selected text to clipboard (Ctrl+X)."));
	a->setShortcut(Qt::CTRL+Qt::Key_X);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-copy.png"), tr("&Copy"), this);
	connect(a, SIGNAL(activated()), this, SLOT(copy()));
	a->setToolTip(tr("Copy selected text or data to clipboard (Ctrl+C)."));
	a->setShortcut(Qt::CTRL+Qt::Key_C);	o->addAction(a);		bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/edit-paste.png"), tr("&Paste"), this);
	connect(a, SIGNAL(activated()), this, SLOT(paste()));
	a->setToolTip(tr("Paste text or data from clipboard (Ctrl+V)."));
	a->setShortcut(Qt::CTRL+Qt::Key_V);	o->addAction(a);		bb->addAction(a);
	o->addAction(QPixmap(":/xpm/edit-select-all.png"), tr("Select &all"), edit, SLOT(selectAll()), Qt::CTRL+Qt::Key_A);
	bb->addSeparator();	o->addSeparator();
	a = new QAction(QPixmap(":/xpm/edit-find.png"), tr("&Find/Replace"), this);
	connect(a, SIGNAL(activated()), this, SLOT(find()));
	a->setToolTip(tr("Show dialog for text finding (Ctrl+F)."));
	a->setShortcut(Qt::CTRL+Qt::Key_F);	o->addAction(a);		bb->addAction(a);
	a = new QAction(tr("Find next"), this);
	connect(a, SIGNAL(activated()), this, SLOT(findText()));
	a->setShortcut(Qt::Key_F3);	o->addAction(a);
	bb->addSeparator();	o->addSeparator();

	// insert menu
	{
	oo = o->addMenu(tr("Insert"));
	a = new QAction(QPixmap(":/xpm/format-indent-more.png"), tr("New command"), this);
	a->setShortcut(Qt::META+Qt::Key_C);	connect(a, SIGNAL(activated()), this, SLOT(newCmd()));
	a->setToolTip(tr("Show dialog for new command and put it into the script."));
	oo->addAction(a);		bb->addAction(a);
	a = new QAction(tr("Fitted formula"), this);	a->setShortcut(Qt::META+Qt::Key_N);
	connect(a, SIGNAL(activated()), this, SLOT(insFitF()));
	a->setToolTip(tr("Insert last fitted formula with found coefficients."));
	oo->addAction(a);
	a = new QAction(QPixmap(style_xpm), tr("Plot style"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addStyle()));
	a->setToolTip(tr("Show dialog for styles and put it into the script.\nStyles define the plot view (color scheme, marks, dashing and so on)."));
	oo->addAction(a);//		bb->addAction(a);
	a = new QAction(QPixmap(option_xpm), tr("Command options"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addOptions()));
	a->setToolTip(tr("Show dialog for options and put it into the script.\nOptions are used for additional setup the plot."));
	oo->addAction(a);//		bb->addAction(a);
	a = new QAction(tr("Numeric value"), this);
	connect(a, SIGNAL(activated()), this, SLOT(insNVal()));
	a->setToolTip(tr("Replace expression by its numerical value."));
	oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/x-office-spreadsheet.png"), tr("File path"), this);
	a->setShortcut(Qt::META+Qt::Key_P);	connect(a, SIGNAL(activated()), this, SLOT(insFile()));
	a->setToolTip(tr("Select and insert file name."));
	oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/folder.png"), tr("Folder path"), this);
	connect(a, SIGNAL(activated()), this, SLOT(insPath()));
	a->setToolTip(tr("Select and insert folder name."));
	oo->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-properties.png"), tr("Graphics setup"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addSetup()));
	a->setToolTip(tr("Show dialog for plot setup and put code into the script.\nThis dialog setup axis, labels, lighting and other general things."));
	oo->addAction(a);//		bb->addAction(a);
	}

	o->addSeparator();
	a = new QAction(QPixmap(":/xpm/preferences-system.png"), tr("Properties"), this);
	connect(a, SIGNAL(activated()), this, SLOT(properties()));
	a->setToolTip(tr("Show dialog for UDAV properties."));	o->addAction(a);
	o->addAction(tr("Set ar&guments"), args_dlg, SLOT(exec()));

	acalc = a = new QAction(QPixmap(":/xpm/accessories-calculator.png"), tr("Calculator"), this);
	a->setShortcut(Qt::Key_F4);	a->setCheckable(true);	bb->addAction(a);
	connect(a, SIGNAL(toggled(bool)), calcWnd, SLOT(setVisible(bool)));
	connect(calcWnd, SIGNAL(visibilityChanged(bool)), a, SLOT(setChecked(bool)));
	a->setToolTip(tr("Show calculator which evaluate and help to type textual formulas.\nTextual formulas may contain data variables too."));
	o->addAction(a);	a->setChecked(false);	calcWnd->setVisible(false);

	ainfo = a = new QAction(tr("Show info"), this);
	a->setShortcut(Qt::Key_F2);	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), messWnd, SLOT(setVisible(bool)));
	connect(messWnd, SIGNAL(visibilityChanged(bool)), a, SLOT(setChecked(bool)));
	o->addAction(a);	a->setChecked(false);	messWnd->setVisible(false);
	}

	graph->makeMenu(this);
	makeDataMenu();

	o = menuBar()->addMenu(tr("&Window"));
	a = new QAction(tr("Tile"), this);	o->addAction(a);
	connect(a, SIGNAL(activated()), mdi, SLOT(tileSubWindows()));
	a = new QAction(tr("Cascade"), this);	o->addAction(a);
	connect(a, SIGNAL(activated()), mdi, SLOT(cascadeSubWindows()));
	a = new QAction(tr("Close all"), this);	o->addAction(a);
	connect(a, SIGNAL(activated()), mdi, SLOT(closeAllSubWindows()));

	menuBar()->addSeparator();
	bb = new QToolBar(tr("UDAV Help"), this);
	addToolBar(Qt::RightToolBarArea, bb);
	o = menuBar()->addMenu(tr("&Help"));
	a = new QAction(QPixmap(":/xpm/help-contents.png"), tr("MGL &help"), this);
	connect(a, SIGNAL(activated()), this, SLOT(showHelp()));
	a->setToolTip(tr("Show help on MGL commands (F1)."));
	a->setShortcut(Qt::Key_F1);	bb->addAction(a);		o->addAction(a);
	a = new QAction(QPixmap(":/xpm/help-faq.png"), tr("&Examples"), this);
	connect(a, SIGNAL(activated()), hlp, SLOT(showExamples()));
	a->setToolTip(tr("Show examples of MGL usage (Shift+F1)."));
	a->setShortcut(Qt::SHIFT+Qt::Key_F1);	bb->addAction(a);	o->addAction(a);
	a = new QAction(QPixmap(":/xpm/help-faq.png"), tr("H&ints"), this);
	connect(a, SIGNAL(activated()), hintDialog, SLOT(exec()));
	a->setToolTip(tr("Show hints of MGL usage."));	o->addAction(a);
	o->addAction(tr("&About"), this, SLOT(about()));
	o->addAction(tr("About &Qt"), this, SLOT(aboutQt()));
}
//-----------------------------------------------------------------------------
void ScriptWindow::writeSettings()
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/animDelay", animDelay);
	settings.setValue("/geometry/size", size());
//	settings.setValue("/geometry/dock", messWnd->size());
	settings.setValue("/geometry/split_e/w1", split->sizes().at(0));
	settings.setValue("/geometry/split_e/w2", split->sizes().at(1));

	settings.setValue("/recentFiles", recentFiles);
	settings.setValue("/recentFilesMax", MaxRecentFiles);
	settings.setValue("/helpPath", pathHelp);
	settings.setValue("/userFont", pathFont);
	settings.setValue("/colComment",mglColorScheme[0].name());
	settings.setValue("/colString", mglColorScheme[1].name());
	settings.setValue("/colKeyword",mglColorScheme[2].name());
	settings.setValue("/colOption", mglColorScheme[3].name());
	settings.setValue("/colSuffix", mglColorScheme[4].name());
	settings.setValue("/colNumber", mglColorScheme[5].name());
	settings.setValue("/colACKeyword", mglColorScheme[6].name());
	settings.setValue("/colFCKeyword", mglColorScheme[7].name());
	settings.setValue("/colReserved", mglColorScheme[8].name());
	settings.setValue("/autoExec",  mglAutoExecute);
	settings.setValue("/autoSave",  mglAutoSave);
	settings.setValue("/editAtTop", editPosBottom);
	settings.setValue("/fontFamily", defFontFamily);
	settings.setValue("/fontSize", defFontSize);
	settings.setValue("/loadInNewWnd", loadInNewWnd);

//	settings.writeEntry("/geometry/posMess", width());
//	settings.writeEntry("/geometry/posEdit", split->);
	settings.endGroup();
}
//-----------------------------------------------------------------------------
void ScriptWindow::readSettings()
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	pathHelp = settings.value("/helpPath", MGL_DOC_DIR).toString();
	MaxRecentFiles = settings.value("/recentFilesMax", 5).toInt();
	animDelay = settings.value("/animDelay", 500).toInt();
	resize(settings.value("/geometry/size", QSize(880,720)).toSize());
//	messWnd->resize(settings.value("/geometry/dock", QSize(880,720)).toSize());
	QList<int> le;
	le.append(settings.value("/geometry/split_e/w1", 230).toInt());
	le.append(settings.value("/geometry/split_e/w2", 604).toInt());
	split->setSizes(le);

	pathFont = settings.value("/userFont", "").toString();
	mglColorScheme[0] = QColor(settings.value("/colComment","#007F00").toString());
	mglColorScheme[1] = QColor(settings.value("/colString", "#FF0000").toString());
	mglColorScheme[2] = QColor(settings.value("/colKeyword","#00007F").toString());
	mglColorScheme[3] = QColor(settings.value("/colOption", "#7F0000").toString());
	mglColorScheme[4] = QColor(settings.value("/colSuffix", "#7F0000").toString());
	mglColorScheme[5] = QColor(settings.value("/colNumber", "#0000FF").toString());
	mglColorScheme[6] = QColor(settings.value("/colACKeyword","#7F007F").toString());
	mglColorScheme[7] = QColor(settings.value("/colFCKeyword","#007F7F").toString());
	mglColorScheme[8] = QColor(settings.value("/colReserved", "#0000FF").toString());
	showHint = settings.value("/showHint",  true).toBool();
	mglAutoSave = settings.value("/autoSave",  false).toBool();
	mglAutoExecute = settings.value("/autoExec",  true).toBool();
	editPosBottom = settings.value("/editAtTop", false).toBool();
	loadInNewWnd = settings.value("/loadInNewWnd", false).toBool();
	defFontFamily = settings.value("/fontFamily", "Georgia").toString();
	defFontSize = settings.value("/fontSize", 10).toInt();
	setEditorFont();	setEditPos(editPosBottom);	graph->setMGLFont(pathFont);

	defWidth = settings.value("/defWidth", 640).toInt();
	defHeight = settings.value("/defHeight", 480).toInt();
	graph->mgl->imgSize(defWidth, defHeight);

	recentFiles = settings.value("/recentFiles").toStringList();
	settings.endGroup();
	updateRecentFileItems();
}
//-----------------------------------------------------------------------------
void ScriptWindow::setCurrentFile(const QString &fileName)
{
	filename = fileName;
	graph->mgl->scriptName = filename;
	edit->document()->setModified(false);
	if(filename.isEmpty())
		setWindowTitle(tr("untitled - UDAV"));
	else
	{
		setWindowTitle(QFileInfo(filename).fileName()+tr(" - UDAV"));
//		recentFiles.removeOne(filename);
		int i = recentFiles.indexOf(filename);
		if(i>=0)	recentFiles.removeAt(i);
		recentFiles.push_front(filename);
		updateRecentFileItems();
		chdir(qPrintable(QFileInfo(filename).path()));
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::openRecentFile()
{
	QAction *a = qobject_cast<QAction *>(sender());
	if(!a)	return;
	if(edit->document()->isModified())
		switch(QMessageBox::information(this, tr("UDAV - save current"),
				tr("Do you want to save the changes to the document?"),
				QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel))
		{
			case QMessageBox::Yes:	save();	break;
			case QMessageBox::No:	break;
			default:	return;
		}
	QString fn = recentFiles[a->data().toInt()];
	if(!fn.isEmpty())	load(fn);
}
//-----------------------------------------------------------------------------
void ScriptWindow::updateRecentFileItems()
{
	foreach(QWidget *w, QApplication::topLevelWidgets())
	{
		ScriptWindow *wnd = qobject_cast<ScriptWindow *>(w);
		if(wnd)	wnd->updateRecent();
//		if(w->inherits("ScriptWindow"))	((ScriptWindow *)w)->updateRecent();
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::updateRecent()
{
	QAction *a;
	fileMenu->clear();	qApp->processEvents();
	for(int i=0; i<recentFiles.size() && i<MaxRecentFiles; i++)
	{
		QString text="&"+QString::number(i+1)+" "+QFileInfo(recentFiles[i]).fileName();
		a = fileMenu->addAction(text, this, SLOT(openRecentFile()));
		a->setData(i);
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::newDoc()
{
	ScriptWindow *ed = new ScriptWindow;
	ed->show();	ed->activateWindow();
}
//-----------------------------------------------------------------------------
void ScriptWindow::choose()
{
	if(edit->document()->isModified())
		switch(QMessageBox::information(this, tr("UDAV - save current"),
				tr("Do you want to save the changes to the document?"),
				QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel))
		{
			case QMessageBox::Yes:	save();	break;
			case QMessageBox::No:	break;
			default:	return;
		}
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	QString fn = QFileDialog::getOpenFileName(this,
			tr("UDAV - Open file"),
			settings.value("/filePath", MGL_DOC_DIR).toString(),
			tr("MGL scripts (*.mgl)\nHDF5 files (*.hdf *.h5)\nText files (*.txt)\nData files (*.dat)\nAll files (*.*)"));
	settings.endGroup();
	if(!fn.isEmpty())	load(fn);
	else	statusBar()->showMessage(tr("Loading aborted"), 2000);
}
//-----------------------------------------------------------------------------
void ScriptWindow::load(const QString &fileName, bool noNewWnd)
{
	// save current path
	QFileInfo fi(fileName);
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/filePath", fi.absolutePath());
	settings.endGroup();
	// open new window if it is required
	if(loadInNewWnd && !noNewWnd)
	{
		ScriptWindow *mw = new ScriptWindow;
		mw->load(fileName, true);
		mw->show();	//ed->activateWindow();
		return;
	}

	if(fileName.right(4)==".dat")
	{
		dataOpenDlg->setFile(fileName);
		if(dataOpenDlg->exec())
		{
			edit->setText(dataOpenDlg->getCode());
			setCurrentFile(fileName.left(fileName.length()-3)+"mgl");
		}
	}
	else if(fileName.right(4)==".hdf" || fileName.right(3)==".h5")
		loadHDF5(fileName);
	else
	{
		QFile f(fileName);
		if(!f.open(QIODevice::ReadOnly))
		{
			QMessageBox::warning(this,tr("UDAV - open file"),
								 tr("Couldn't open file"),QMessageBox::Ok,0,0);
			return;
		}

		QTextStream ts(&f);
		ts.setAutoDetectUnicode(true);
//		ts.setCodec(QTextCodec::codecForLocale());
		edit->setText(ts.readAll());
		graph->animParseText(edit->toPlainText());
		setCurrentFile(fileName);
	}
	statusBar()->showMessage(tr("Loaded document ")+fileName, 2000);
	if(mglAutoExecute)	graph->mgl->execute();
}
//-----------------------------------------------------------------------------
void ScriptWindow::save()
{
	if(filename.isEmpty())	{	saveAs();	return;	}
	if(filename.right(4)==".hdf" || filename.right(3)==".h5")
	{	saveHDF5(filename);	return;	}
	QString text = edit->toPlainText();
	QFile f(filename);
	if(!f.open(QIODevice::WriteOnly))
	{
		statusBar()->showMessage(tr("Could not write to %1").arg(filename), 2000);
		return;
	}
	QTextStream t(&f);
	t.setAutoDetectUnicode(true);
	t << text;	f.close();
	setCurrentFile(filename);
	statusBar()->showMessage(tr("File %1 saved").arg(filename), 2000);
}
//-----------------------------------------------------------------------------
void ScriptWindow::saveAs()
{
	QString fn;
//	while(1)
	{
		fn = QFileDialog::getSaveFileName(this, tr("UDAV - save file"), "",
				tr("MGL scripts (*.mgl)\nHDF5 files (*.hdf *.h5)\nAll files (*.*)"));
		if(fn.isEmpty())
		{	statusBar()->showMessage(tr("Saving aborted"), 2000);	return;	}
		else
		{
			int nn=fn.length();
			if(fn[nn-4]!='.' && fn[nn-3]!='.')	fn = fn + ".mgl";
			filename = fn;		save();		return;
		}
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::messClicked()
{
	QString m = mess->toPlainText(), q;
	int p = mess->textCursor().blockNumber();
	for(;p>=0;p--)
	{
		q = m.section('\n',p,p);
		if(q.contains("In line "))
		{
			QString s = q.mid(8).section(' ',0,0);
			setCursorPosition(s.toInt());
		}
	}
	edit->setFocus();
}
//-----------------------------------------------------------------------------
void updateDataItems()
{
	foreach (QWidget *w, QApplication::topLevelWidgets())
	{
		if(w->inherits("ScriptWindow"))
			((ScriptWindow *)w)->info->refresh();
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::setAsterix()
{
	if(edit->document()->isModified())
	{
		if(filename.isEmpty())
			setWindowTitle(tr("untitled* - UDAV"));
		else
			setWindowTitle(QFileInfo(filename).fileName()+tr("* - UDAV"));
	}
	else
	{
		if(filename.isEmpty())
			setWindowTitle(tr("untitled - UDAV"));
		else
			setWindowTitle(QFileInfo(filename).fileName()+tr(" - UDAV"));
	}
}
//-----------------------------------------------------------------------------
void ScriptWindow::insFitF()
{
	QString str(graph->mgl->graph->GetFit());
	if(str.isEmpty())	return;
	edit->textCursor().insertText("'"+str+"'");
}
//-----------------------------------------------------------------------------
void ScriptWindow::insFile()
{
	QString str = QFileDialog::getOpenFileName(this, tr("UDAV - Insert filename"));
	if(str.isEmpty())	return;
	edit->textCursor().insertText("'"+str+"'");
}
//-----------------------------------------------------------------------------
void ScriptWindow::insPath()
{
	QString str = QFileDialog::getExistingDirectory(this, tr("UDAV - Insert filename"));
	if(str.isEmpty())	return;
	edit->textCursor().insertText("'"+str+"'");
}
//-----------------------------------------------------------------------------
mglData mglFormulaCalc(const wchar_t *string, mglParse *arg);
void ScriptWindow::insNVal()
{
	QString sel=edit->textCursor().selectedText();
	if(sel.isEmpty())	return;
	wchar_t *txt=new wchar_t[sel.length()+1];
	sel.toWCharArray(txt);	txt[sel.length()]=0;
	mglData res=mglFormulaCalc(txt, &parser);
	delete []txt;
	edit->textCursor().insertText(QString::number(res.a[0]));
}
//-----------------------------------------------------------------------------
void ScriptWindow::newCmd()
{
	if(newCmdDlg->exec())
	{
		edit->moveCursor(QTextCursor::StartOfLine);
		edit->textCursor().insertText(newCmdDlg->getCommand()+"\n");
	}
}
//-----------------------------------------------------------------------------
